# A - Zpráva o výjezdu (cz) - HL7 Czech EMS Implementation Guide v0.0.2

* [**Table of Contents**](toc.md)
* [**Artifacts**](artifacts.md)
* **A - Zpráva o výjezdu (cz)**

## Logical Model: A - Zpráva o výjezdu (cz) 

| | |
| :--- | :--- |
| *Official URL*:https://hl7.cz/fhir/cz-ems/StructureDefinition/LogEmsReportCz | *Version*:0.0.2 |
| Draft as of 2025-10-14 | *Computable Name*:LogCzEmsReportCz |

 
Zpráva o výjezdu CZ 

**Usages:**

* This Logical Model is not used by any profiles in this Implementation Guide

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.fhir.cz.ems|current/StructureDefinition/LogEmsReportCz)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-LogEmsReportCz.csv), [Excel](StructureDefinition-LogEmsReportCz.xlsx) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "LogEmsReportCz",
  "url" : "https://hl7.cz/fhir/cz-ems/StructureDefinition/LogEmsReportCz",
  "version" : "0.0.2",
  "name" : "LogCzEmsReportCz",
  "title" : "A - Zpráva o výjezdu (cz)",
  "status" : "draft",
  "date" : "2025-10-14T13:52:10+00:00",
  "publisher" : "HL7 Czech Republic",
  "contact" : [
    {
      "name" : "HL7 Czech Republic",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.hl7.cz/"
        }
      ]
    }
  ],
  "description" : "Zpráva o výjezdu CZ",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "CZ",
          "display" : "Czechia"
        }
      ]
    }
  ],
  "fhirVersion" : "4.0.1",
  "kind" : "logical",
  "abstract" : false,
  "type" : "https://hl7.cz/fhir/cz-ems/StructureDefinition/LogEmsReportCz",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/Base",
  "derivation" : "specialization",
  "differential" : {
    "element" : [
      {
        "id" : "LogEmsReportCz",
        "path" : "LogEmsReportCz",
        "short" : "A - Zpráva o výjezdu (cz)",
        "definition" : "Zpráva o výjezdu CZ"
      },
      {
        "id" : "LogEmsReportCz.hlavicka",
        "path" : "LogEmsReportCz.hlavicka",
        "short" : "A.1 - Hlavička dokumentu",
        "definition" : "Hlavička zprávy o výjezdu – podle české specifikace",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "https://hl7.cz/fhir/cz-ems/StructureDefinition/LogHeaderEmsCz"
          }
        ]
      },
      {
        "id" : "LogEmsReportCz.telo",
        "path" : "LogEmsReportCz.telo",
        "short" : "A.2 - Tělo zprávy o výjezdu",
        "definition" : "Hlavní klinické části zprávy o výjezdu",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "Base"
          }
        ]
      },
      {
        "id" : "LogEmsReportCz.telo.udajeOVyjezdu",
        "path" : "LogEmsReportCz.telo.udajeOVyjezdu",
        "short" : "A.2.1 - Údaje o výjezdu",
        "definition" : "Údaje o výjezdu.",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "https://hl7.cz/fhir/cz-ems/StructureDefinition/LogDispatchDataCz"
          }
        ]
      },
      {
        "id" : "LogEmsReportCz.telo.casovaOsaVyjezdu",
        "path" : "LogEmsReportCz.telo.casovaOsaVyjezdu",
        "short" : "A.2.2 - Časová osa výjezdu",
        "definition" : "Časová osa výjezdu",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "https://hl7.cz/fhir/cz-ems/StructureDefinition/LogDispatchTimelineCz"
          }
        ]
      },
      {
        "id" : "LogEmsReportCz.telo.anamneza",
        "path" : "LogEmsReportCz.telo.anamneza",
        "short" : "A.2.3 - Anamnéza pacienta",
        "definition" : "Stručná anamnéza, včetně původu informací.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "https://hl7.cz/fhir/cz-ems/StructureDefinition/LogPatientHistoryCz"
          }
        ]
      },
      {
        "id" : "LogEmsReportCz.telo.urgentniInformace",
        "path" : "LogEmsReportCz.telo.urgentniInformace",
        "short" : "A.2.4 Urgentní informace",
        "definition" : "Závažné alergie, interakce nebo jiná rizika.",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "https://hl7.cz/fhir/cz-ems/StructureDefinition/LogAlertsCz"
          }
        ]
      },
      {
        "id" : "LogEmsReportCz.telo.nynejsiOnemocneni",
        "path" : "LogEmsReportCz.telo.nynejsiOnemocneni",
        "short" : "A.2.5 Nynější onemocnění",
        "definition" : "Nynější onemocnění",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "https://hl7.cz/fhir/cz-ems/StructureDefinition/LogPresentingIllnessEmsCz"
          }
        ]
      },
      {
        "id" : "LogEmsReportCz.telo.objektivniNalez",
        "path" : "LogEmsReportCz.telo.objektivniNalez",
        "short" : "A.2.6 Objektivní nález",
        "definition" : "Objektivní nález",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "https://hl7.cz/fhir/cz-ems/StructureDefinition/LogObjectiveFindingsEmsCz"
          }
        ]
      },
      {
        "id" : "LogEmsReportCz.telo.terapie",
        "path" : "LogEmsReportCz.telo.terapie",
        "short" : "A.2.7 Terapie",
        "definition" : "Terapie",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "https://hl7.cz/fhir/cz-ems/StructureDefinition/LogTherapyEmsCz"
          }
        ]
      },
      {
        "id" : "LogEmsReportCz.telo.diagnostickySouhrn",
        "path" : "LogEmsReportCz.telo.diagnostickySouhrn",
        "short" : "A.2.8 Diagnostický souhrn",
        "definition" : "Diagnostický souhrn",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "https://hl7.cz/fhir/cz-ems/StructureDefinition/LogDiagnostickySouhrnCz"
          }
        ]
      },
      {
        "id" : "LogEmsReportCz.telo.prubehDoporuceni",
        "path" : "LogEmsReportCz.telo.prubehDoporuceni",
        "short" : "A.2.9 Průběh, Doporučení",
        "definition" : "Průběh, Doporučení",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "https://hl7.cz/fhir/cz-ems/StructureDefinition/LogRecommendationsCz"
          }
        ]
      },
      {
        "id" : "LogEmsReportCz.telo.ukonceni",
        "path" : "LogEmsReportCz.telo.ukonceni",
        "short" : "A.2.10 Ukončení",
        "definition" : "Ukončení",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "https://hl7.cz/fhir/cz-ems/StructureDefinition/LogEndOfCareCz"
          }
        ]
      },
      {
        "id" : "LogEmsReportCz.telo.prilohyEms",
        "path" : "LogEmsReportCz.telo.prilohyEms",
        "short" : "A.2.11 Přílohy výjezdu",
        "definition" : "Přílohy výjezdu",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "https://hl7.cz/fhir/cz-ems/StructureDefinition/LogAttachmentsEmsCz"
          }
        ]
      },
      {
        "id" : "LogEmsReportCz.zobrazitelnaForma",
        "path" : "LogEmsReportCz.zobrazitelnaForma",
        "short" : "A.3 - Zobrazitelná forma dokumentu",
        "definition" : "Zobrazená verze dokumentu, doporučeno PDF.",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "https://hl7.cz/fhir/cz-ems/StructureDefinition/LogPresentedFormCz"
          }
        ]
      },
      {
        "id" : "LogEmsReportCz.prilohy",
        "path" : "LogEmsReportCz.prilohy",
        "short" : "A.4 - Přílohy",
        "definition" : "Přiložené obrázky, dokumenty nebo jiná média.",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "https://hl7.cz/fhir/cz-ems/StructureDefinition/LogAttachmentsCz"
          }
        ]
      }
    ]
  }
}

```
