# A.2.8 - Diagnostic Summary (en) - HL7 Czech EMS Implementation Guide v0.0.2

* [**Table of Contents**](toc.md)
* [**Artifacts**](artifacts.md)
* **A.2.8 - Diagnostic Summary (en)**

## Logical Model: A.2.8 - Diagnostic Summary (en) 

| | |
| :--- | :--- |
| *Official URL*:https://hl7.cz/fhir/cz-ems/StructureDefinition/LogDiagnosticSummary | *Version*:0.0.2 |
| Draft as of 2025-10-14 | *Computable Name*:LogEnDiagnosticSummary |

 
Emergency Medical Service Report – Diagnostic Summary – A.2.8 EN 

**Usages:**

* Use this Logical Model: [A - EMS Report (en)](StructureDefinition-EmsReportCz.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.fhir.cz.ems|current/StructureDefinition/LogDiagnosticSummary)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-LogDiagnosticSummary.csv), [Excel](StructureDefinition-LogDiagnosticSummary.xlsx) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "LogDiagnosticSummary",
  "url" : "https://hl7.cz/fhir/cz-ems/StructureDefinition/LogDiagnosticSummary",
  "version" : "0.0.2",
  "name" : "LogEnDiagnosticSummary",
  "title" : "A.2.8 - Diagnostic Summary (en)",
  "status" : "draft",
  "date" : "2025-10-14T13:52:10+00:00",
  "publisher" : "HL7 Czech Republic",
  "contact" : [
    {
      "name" : "HL7 Czech Republic",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.hl7.cz/"
        }
      ]
    }
  ],
  "description" : "Emergency Medical Service Report – Diagnostic Summary – A.2.8 EN",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "CZ",
          "display" : "Czechia"
        }
      ]
    }
  ],
  "fhirVersion" : "4.0.1",
  "kind" : "logical",
  "abstract" : false,
  "type" : "https://hl7.cz/fhir/cz-ems/StructureDefinition/LogDiagnosticSummary",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/Base",
  "derivation" : "specialization",
  "differential" : {
    "element" : [
      {
        "id" : "LogDiagnosticSummary",
        "path" : "LogDiagnosticSummary",
        "short" : "A.2.8 - Diagnostic Summary (en)",
        "definition" : "Emergency Medical Service Report – Diagnostic Summary – A.2.8 EN"
      },
      {
        "id" : "LogDiagnosticSummary.diagnosticSummary",
        "path" : "LogDiagnosticSummary.diagnosticSummary",
        "short" : "A.2.8 Diagnostic summary",
        "definition" : "All problems/diagnoses that affect care during EMS.",
        "min" : 1,
        "max" : "*",
        "type" : [
          {
            "code" : "Base"
          }
        ]
      },
      {
        "id" : "LogDiagnosticSummary.SpecificationDiagnoses",
        "path" : "LogDiagnosticSummary.SpecificationDiagnoses",
        "short" : "A.2.8.1 - Specification of diagnoses in free text",
        "definition" : "Specification of diagnoses or problems in free text",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "string"
          }
        ]
      },
      {
        "id" : "LogDiagnosticSummary.SpecificationDiagnoses.diagnosisFormalized",
        "path" : "LogDiagnosticSummary.SpecificationDiagnoses.diagnosisFormalized",
        "short" : "A.2.8.2 - Formalized diagnosis",
        "definition" : "Summary of diagnoses addressed by EMS dispatch in a formalized manner",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Base"
          }
        ]
      },
      {
        "id" : "LogDiagnosticSummary.SpecificationDiagnoses.code",
        "path" : "LogDiagnosticSummary.SpecificationDiagnoses.code",
        "short" : "A.2.8.2.1 - Diagnosis by code",
        "definition" : "Formalized expression of a health problem by code (classification).",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ]
      },
      {
        "id" : "LogDiagnosticSummary.SpecificationDiagnoses.text",
        "path" : "LogDiagnosticSummary.SpecificationDiagnoses.text",
        "short" : "A.2.8.4 - Dg. text representation",
        "definition" : "Meaning of the code according to the code system used.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "string"
          }
        ]
      }
    ]
  }
}

```
