# A.1 - EMS report header data element (en) - HL7 Czech EMS Implementation Guide v0.0.2

* [**Table of Contents**](toc.md)
* [**Artifacts**](artifacts.md)
* **A.1 - EMS report header data element (en)**

## Logical Model: A.1 - EMS report header data element (en) 

| | |
| :--- | :--- |
| *Official URL*:https://hl7.cz/fhir/cz-ems/StructureDefinition/HeaderEmsCz | *Version*:0.0.2 |
| Draft as of 2025-10-14 | *Computable Name*:LogEnHeaderEmsCz |

 
EMS report - EMS report header data element - A.1 EN 

**Usages:**

* Use this Logical Model: [A - EMS Report (en)](StructureDefinition-EmsReportCz.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.fhir.cz.ems|current/StructureDefinition/HeaderEmsCz)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-HeaderEmsCz.csv), [Excel](StructureDefinition-HeaderEmsCz.xlsx) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "HeaderEmsCz",
  "url" : "https://hl7.cz/fhir/cz-ems/StructureDefinition/HeaderEmsCz",
  "version" : "0.0.2",
  "name" : "LogEnHeaderEmsCz",
  "title" : "A.1 - EMS report header data element (en)",
  "status" : "draft",
  "date" : "2025-10-14T13:52:10+00:00",
  "publisher" : "HL7 Czech Republic",
  "contact" : [
    {
      "name" : "HL7 Czech Republic",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.hl7.cz/"
        }
      ]
    }
  ],
  "description" : "EMS report - EMS report header data element - A.1 EN",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "CZ",
          "display" : "Czechia"
        }
      ]
    }
  ],
  "fhirVersion" : "4.0.1",
  "kind" : "logical",
  "abstract" : false,
  "type" : "https://hl7.cz/fhir/cz-ems/StructureDefinition/HeaderEmsCz",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/Base",
  "derivation" : "specialization",
  "differential" : {
    "element" : [
      {
        "id" : "HeaderEmsCz",
        "path" : "HeaderEmsCz",
        "short" : "A.1 - EMS report header data element (en)",
        "definition" : "EMS report - EMS report header data element - A.1 EN"
      },
      {
        "id" : "HeaderEmsCz.subject",
        "path" : "HeaderEmsCz.subject",
        "short" : "A.1.1 - Identification and A.1.2 - related contact information of the Patient/subject",
        "definition" : "Identification of the patient/subject and Patient/subject related contact information",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "Base"
          }
        ]
      },
      {
        "id" : "HeaderEmsCz.payer",
        "path" : "HeaderEmsCz.payer",
        "short" : "A.1.3 - Health insurance and payment information - Health insurance information is not always required, however, in some jurisdictions, the insurance number is also used as the patient identifier. It is necessary not just for identification but also forms access to funding for care.",
        "definition" : "Health insurance and payment information - Health insurance information is not always required, however, in some jurisdictions, the insurance number is also used as the patient identifier. It is necessary not just for identification but also forms access to funding for care.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Base"
          }
        ]
      },
      {
        "id" : "HeaderEmsCz.payer.insuranceCode",
        "path" : "HeaderEmsCz.payer.insuranceCode",
        "short" : "A.1.3.1 - Health insurance code",
        "definition" : "Unique health insurance company identification code.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Identifier"
          }
        ]
      },
      {
        "id" : "HeaderEmsCz.payer.insuranceName",
        "path" : "HeaderEmsCz.payer.insuranceName",
        "short" : "A.1.3.2 - Health insurance name",
        "definition" : "Full, official name of the healthcare insurance provider.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "string"
          }
        ]
      },
      {
        "id" : "HeaderEmsCz.payer.insuranceNumber",
        "path" : "HeaderEmsCz.payer.insuranceNumber",
        "short" : "A.1.3.3 - Health insurance number",
        "definition" : "Number or code under which the insured person is registered at the insurance provider.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Identifier"
          }
        ]
      },
      {
        "id" : "HeaderEmsCz.informationRecipient",
        "path" : "HeaderEmsCz.informationRecipient",
        "short" : "A.1.4 - Information recipient - (intended recipient or recipients of the report), if applicable",
        "definition" : "Information recipient - (intended recipient or recipients of the report), if applicable",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "Base"
          }
        ]
      },
      {
        "id" : "HeaderEmsCz.informationRecipient.identifier",
        "path" : "HeaderEmsCz.informationRecipient.identifier",
        "short" : "A.1.4.1 - Recipient identifier",
        "definition" : "The health professional or patient identifier. Either an internal identifier assigned by a healthcare provider institution or (preferably) a national health professional ID such as the licence or registration number. In case when the recipient is not a health professional, e.g. patient, appropriate personal identifier could be used.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Identifier"
          }
        ]
      },
      {
        "id" : "HeaderEmsCz.informationRecipient.name",
        "path" : "HeaderEmsCz.informationRecipient.name",
        "short" : "A.1.4.2 - Recipient name",
        "definition" : "Person name [the structure of the name will be the same as for the patient (given name, family name / surname)].",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "HumanName"
          }
        ]
      },
      {
        "id" : "HeaderEmsCz.informationRecipient.organizationID",
        "path" : "HeaderEmsCz.informationRecipient.organizationID",
        "short" : "A.1.4.3 - Recipient organisation ID",
        "definition" : "The healthcare provider organisation identifier. Identifier that is unique within a defined scope. Example: National healthcare provider ID. Multiple identifiers could be provided.",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "Identifier"
          }
        ]
      },
      {
        "id" : "HeaderEmsCz.informationRecipient.organization",
        "path" : "HeaderEmsCz.informationRecipient.organization",
        "short" : "A.1.4.4 - Recipient organisation",
        "definition" : "The healthcare provider organisation information.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Base"
          }
        ]
      },
      {
        "id" : "HeaderEmsCz.informationRecipient.address",
        "path" : "HeaderEmsCz.informationRecipient.address",
        "short" : "A.1.4.5 - Address",
        "definition" : "Mailing and home or office addresses. The addresses are always sequences of address parts (e.g. street address line, country, postcode, city) even if postal address formats may vary depending on the country. An address may or may not include a specific use code; if this attribute is not present it is assumed to be the default address useful for any purpose.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Address"
          }
        ]
      },
      {
        "id" : "HeaderEmsCz.informationRecipient.country",
        "path" : "HeaderEmsCz.informationRecipient.country",
        "short" : "A.1.4.6 - Country",
        "definition" : "Country of the intended recipient as part of the address.",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ]
      },
      {
        "id" : "HeaderEmsCz.informationRecipient.telecom",
        "path" : "HeaderEmsCz.informationRecipient.telecom",
        "short" : "A.1.4.7 - Telecom",
        "definition" : "Telecommunication contact information (addresses) associated to a person, such as phone number, email, or messaging service. Multiple telecommunication addresses might be provided.",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "ContactPoint"
          }
        ]
      },
      {
        "id" : "HeaderEmsCz.author",
        "path" : "HeaderEmsCz.author",
        "short" : "A.1.5 - Author (by whom the EMS report was/were authored). Multiple authors could be provided.",
        "definition" : "Author (by whom the EMS report was/were authored). Multiple authors could be provided.",
        "min" : 1,
        "max" : "*",
        "type" : [
          {
            "code" : "Base"
          }
        ]
      },
      {
        "id" : "HeaderEmsCz.author.identifier",
        "path" : "HeaderEmsCz.author.identifier",
        "short" : "A.1.5.1 - Author identifier",
        "definition" : "The health professional identifier that will allow addressing recipients within a national or international data exchange infrastructure, such as the licence or registration number. In case when the recipient is not a health professional, e.g. patient, appropriate personal identifier should be used.",
        "min" : 1,
        "max" : "*",
        "type" : [
          {
            "code" : "Identifier"
          }
        ]
      },
      {
        "id" : "HeaderEmsCz.author.name",
        "path" : "HeaderEmsCz.author.name",
        "short" : "A.1.5.2 - Author name",
        "definition" : "Person name [the structure of the name will be the same as for the patient (given name, family name / surname)].",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "HumanName"
          }
        ]
      },
      {
        "id" : "HeaderEmsCz.author.organizationID",
        "path" : "HeaderEmsCz.author.organizationID",
        "short" : "A.1.5.3 - Author organisation ID",
        "definition" : "The healthcare provider organisation identifier. Identifier that is unique within a defined scope. Example: National healthcare provider ID. Multiple identifiers could be provided.",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "Identifier"
          }
        ]
      },
      {
        "id" : "HeaderEmsCz.author.organization",
        "path" : "HeaderEmsCz.author.organization",
        "short" : "A.1.5.4 - Author organisation",
        "definition" : "The healthcare provider organisation information.",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "Base"
          }
        ]
      },
      {
        "id" : "HeaderEmsCz.author.dateTime",
        "path" : "HeaderEmsCz.author.dateTime",
        "short" : "A.1.5.5 - Date Time",
        "definition" : "Date and time of the last modification of the document by its Author.",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "dateTime"
          }
        ]
      },
      {
        "id" : "HeaderEmsCz.documentMetadata",
        "path" : "HeaderEmsCz.documentMetadata",
        "short" : "A.1.6 - Document metadata",
        "definition" : "Document metadata",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "Base"
          }
        ]
      },
      {
        "id" : "HeaderEmsCz.documentMetadata.identifier",
        "path" : "HeaderEmsCz.documentMetadata.identifier",
        "short" : "A.1.6.1 - Document ID",
        "definition" : "Unique identifier of the document",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "Identifier"
          }
        ]
      },
      {
        "id" : "HeaderEmsCz.documentMetadata.type",
        "path" : "HeaderEmsCz.documentMetadata.type",
        "short" : "A.1.6.2 - Document type",
        "definition" : "Identifies the type of document at hand, e.g. EMS report.",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ]
      },
      {
        "id" : "HeaderEmsCz.documentMetadata.status",
        "path" : "HeaderEmsCz.documentMetadata.status",
        "short" : "A.1.6.3 - Document status",
        "definition" : "The status of the EMS report report. E.g., preliminary, final.",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ]
      },
      {
        "id" : "HeaderEmsCz.documentMetadata.dateTime",
        "path" : "HeaderEmsCz.documentMetadata.dateTime",
        "short" : "A.1.6.4 - Report date and time",
        "definition" : "Date and time of the EMS report creation.",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "dateTime"
          }
        ]
      },
      {
        "id" : "HeaderEmsCz.documentMetadata.title",
        "path" : "HeaderEmsCz.documentMetadata.title",
        "short" : "A.1.6.5 - Document title",
        "definition" : "Document title, fix value \"EMS report\".",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "string"
          }
        ]
      },
      {
        "id" : "HeaderEmsCz.documentMetadata.custodian",
        "path" : "HeaderEmsCz.documentMetadata.custodian",
        "short" : "A.1.6.6 - Report custodian",
        "definition" : "Organisation that is in charge of maintaining the report [this element will include organisation ID, name, address etc., as other elements describing organisations].",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "Base"
          }
        ]
      },
      {
        "id" : "HeaderEmsCz.documentMetadata.confidentiality",
        "path" : "HeaderEmsCz.documentMetadata.confidentiality",
        "short" : "A.1.6.7 - Confidentiality",
        "definition" : "Level of confidentiality of the document. Implicit value is normal.",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ]
      },
      {
        "id" : "HeaderEmsCz.documentMetadata.language",
        "path" : "HeaderEmsCz.documentMetadata.language",
        "short" : "A.1.6.8 - Language",
        "definition" : "Language in which the document is written. Language is expressed by the ISO language code.",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ]
      },
      {
        "id" : "HeaderEmsCz.documentMetadata.version",
        "path" : "HeaderEmsCz.documentMetadata.version",
        "short" : "A.1.6.9 - Version",
        "definition" : "Version of the document",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "string"
          }
        ]
      },
      {
        "id" : "HeaderEmsCz.digitalSignature",
        "path" : "HeaderEmsCz.digitalSignature",
        "short" : "A.1.7 - Digital signature",
        "definition" : "Digital signature",
        "min" : 1,
        "max" : "*",
        "type" : [
          {
            "code" : "Base"
          }
        ]
      }
    ]
  }
}

```
