# A.2.1 - Dispatch Data (en) - HL7 Czech EMS Implementation Guide v0.0.2

* [**Table of Contents**](toc.md)
* [**Artifacts**](artifacts.md)
* **A.2.1 - Dispatch Data (en)**

## Logical Model: A.2.1 - Dispatch Data (en) 

| | |
| :--- | :--- |
| *Official URL*:https://hl7.cz/fhir/cz-ems/StructureDefinition/DispatchDataCz | *Version*:0.0.2 |
| Draft as of 2025-10-14 | *Computable Name*:LogEnDispatchDataCz |

 
EMS report – Dispatch Data – A.2.1 EN 

**Usages:**

* Use this Logical Model: [A - EMS Report (en)](StructureDefinition-EmsReportCz.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.fhir.cz.ems|current/StructureDefinition/DispatchDataCz)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-DispatchDataCz.csv), [Excel](StructureDefinition-DispatchDataCz.xlsx) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "DispatchDataCz",
  "url" : "https://hl7.cz/fhir/cz-ems/StructureDefinition/DispatchDataCz",
  "version" : "0.0.2",
  "name" : "LogEnDispatchDataCz",
  "title" : "A.2.1 - Dispatch Data (en)",
  "status" : "draft",
  "date" : "2025-10-14T13:52:10+00:00",
  "publisher" : "HL7 Czech Republic",
  "contact" : [
    {
      "name" : "HL7 Czech Republic",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.hl7.cz/"
        }
      ]
    }
  ],
  "description" : "EMS report – Dispatch Data – A.2.1 EN",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "CZ",
          "display" : "Czechia"
        }
      ]
    }
  ],
  "fhirVersion" : "4.0.1",
  "kind" : "logical",
  "abstract" : false,
  "type" : "https://hl7.cz/fhir/cz-ems/StructureDefinition/DispatchDataCz",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/Base",
  "derivation" : "specialization",
  "differential" : {
    "element" : [
      {
        "id" : "DispatchDataCz",
        "path" : "DispatchDataCz",
        "short" : "A.2.1 - Dispatch Data (en)",
        "definition" : "EMS report – Dispatch Data – A.2.1 EN"
      },
      {
        "id" : "DispatchDataCz.dispatchIdentification",
        "path" : "DispatchDataCz.dispatchIdentification",
        "short" : "A.2.1.1 - Dispatch Identification",
        "definition" : "Identification of the dispatch",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "Base"
          }
        ]
      },
      {
        "id" : "DispatchDataCz.dispatchIdentification.dispatchNumber",
        "path" : "DispatchDataCz.dispatchIdentification.dispatchNumber",
        "short" : "A.2.1.1.1 - Dispatch Identifier",
        "definition" : "Dispatch Identifier",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "Identifier"
          }
        ]
      },
      {
        "id" : "DispatchDataCz.dispatchIdentification.additionalDispatchIdentifier",
        "path" : "DispatchDataCz.dispatchIdentification.additionalDispatchIdentifier",
        "short" : "A.2.1.1.2 - Additional Dispatch Identifier",
        "definition" : "Additional identifier(s) of the dispatch",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "Identifier"
          }
        ]
      },
      {
        "id" : "DispatchDataCz.vehicleIdentification",
        "path" : "DispatchDataCz.vehicleIdentification",
        "short" : "A.2.1.2 - Vehicle Identification",
        "definition" : "Identification of the vehicle",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "Base"
          }
        ]
      },
      {
        "id" : "DispatchDataCz.vehicleIdentification.licensePlate",
        "path" : "DispatchDataCz.vehicleIdentification.licensePlate",
        "short" : "A.2.1.2.1 - License Plate",
        "definition" : "License plate or call sign of the vehicle (incl. helicopter registration if applicable)",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "Identifier"
          }
        ]
      },
      {
        "id" : "DispatchDataCz.crewMemberIdentification",
        "path" : "DispatchDataCz.crewMemberIdentification",
        "short" : "A.2.1.3 - Crew Member Identification",
        "definition" : "Identification of members of the responding crew",
        "min" : 1,
        "max" : "*",
        "type" : [
          {
            "code" : "Base"
          }
        ]
      },
      {
        "id" : "DispatchDataCz.crewMemberIdentification.crewMemberIdentifier",
        "path" : "DispatchDataCz.crewMemberIdentification.crewMemberIdentifier",
        "short" : "A.2.1.3.1 - Crew Member Identifier",
        "definition" : "Identifier of the crew member",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "Identifier"
          }
        ]
      },
      {
        "id" : "DispatchDataCz.crewMemberIdentification.firstName",
        "path" : "DispatchDataCz.crewMemberIdentification.firstName",
        "short" : "A.2.1.3.2 - First Name",
        "definition" : "First name of the crew member",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "string"
          }
        ]
      },
      {
        "id" : "DispatchDataCz.crewMemberIdentification.lastName",
        "path" : "DispatchDataCz.crewMemberIdentification.lastName",
        "short" : "A.2.1.3.3 - Last Name",
        "definition" : "Last name of the crew member",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "string"
          }
        ]
      },
      {
        "id" : "DispatchDataCz.crewMemberIdentification.role",
        "path" : "DispatchDataCz.crewMemberIdentification.role",
        "short" : "A.2.1.3.4 - Role",
        "definition" : "Role of the crew member",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ]
      },
      {
        "id" : "DispatchDataCz.dispatchCenterOperator",
        "path" : "DispatchDataCz.dispatchCenterOperator",
        "short" : "A.2.1.4 - Dispatch Center Operator Identification",
        "definition" : "Identification of the dispatch center operator (ZOS operator)",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "Base"
          }
        ]
      },
      {
        "id" : "DispatchDataCz.dispatchCenterOperator.operatorIdentifier",
        "path" : "DispatchDataCz.dispatchCenterOperator.operatorIdentifier",
        "short" : "A.2.1.4.1 - Operator Identifier",
        "definition" : "Identifier of the dispatch center operator",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "Identifier"
          }
        ]
      },
      {
        "id" : "DispatchDataCz.dispatchCenterOperator.firstName",
        "path" : "DispatchDataCz.dispatchCenterOperator.firstName",
        "short" : "A.2.1.4.2 - First Name",
        "definition" : "First name of the operator",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "string"
          }
        ]
      },
      {
        "id" : "DispatchDataCz.dispatchCenterOperator.lastName",
        "path" : "DispatchDataCz.dispatchCenterOperator.lastName",
        "short" : "A.2.1.4.3 - Last Name",
        "definition" : "Last name of the operator",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "string"
          }
        ]
      },
      {
        "id" : "DispatchDataCz.dispatchCenterOperator.role",
        "path" : "DispatchDataCz.dispatchCenterOperator.role",
        "short" : "A.2.1.4.4 - Role",
        "definition" : "Role of the dispatch center operator",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ]
      },
      {
        "id" : "DispatchDataCz.dispatchStartLocation",
        "path" : "DispatchDataCz.dispatchStartLocation",
        "short" : "A.2.1.5 - Dispatch Start Location",
        "definition" : "Location from where the dispatch is initiated",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "Base"
          }
        ]
      },
      {
        "id" : "DispatchDataCz.dispatchStartLocation.address",
        "path" : "DispatchDataCz.dispatchStartLocation.address",
        "short" : "A.2.1.5.1 - Address",
        "definition" : "Address or GPS coordinates of the dispatch start location",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "Address"
          }
        ]
      },
      {
        "id" : "DispatchDataCz.incidentLocation",
        "path" : "DispatchDataCz.incidentLocation",
        "short" : "A.2.1.6 - Incident Location",
        "definition" : "Location of the incident",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "Base"
          }
        ]
      },
      {
        "id" : "DispatchDataCz.incidentLocation.gpsAddress",
        "path" : "DispatchDataCz.incidentLocation.gpsAddress",
        "short" : "A.2.1.6.1 - GPS Address",
        "definition" : "GPS coordinates of the incident location",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "Address"
          }
        ]
      },
      {
        "id" : "DispatchDataCz.incidentLocation.address",
        "path" : "DispatchDataCz.incidentLocation.address",
        "short" : "A.2.1.6.2 - Address",
        "definition" : "Address of the incident location",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Address"
          }
        ]
      },
      {
        "id" : "DispatchDataCz.dispatchClassification",
        "path" : "DispatchDataCz.dispatchClassification",
        "short" : "A.2.1.7 - Dispatch Classification",
        "definition" : "Classification of the dispatch",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "Base"
          }
        ]
      },
      {
        "id" : "DispatchDataCz.dispatchClassification.dispatchUrgency",
        "path" : "DispatchDataCz.dispatchClassification.dispatchUrgency",
        "short" : "A.2.1.7.1 - Dispatch Urgency",
        "definition" : "Urgency level of the dispatch (1 to 4)",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ]
      },
      {
        "id" : "DispatchDataCz.dispatchClassification.callClassification",
        "path" : "DispatchDataCz.dispatchClassification.callClassification",
        "short" : "A.2.1.7.2 - Call Classification",
        "definition" : "Classification of the call – preliminary information about the patient’s problem / reason for dispatch",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ]
      },
      {
        "id" : "DispatchDataCz.callerContact",
        "path" : "DispatchDataCz.callerContact",
        "short" : "A.2.1.8 - Caller Contact",
        "definition" : "Contact details of the caller",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Base"
          }
        ]
      },
      {
        "id" : "DispatchDataCz.callerContact.phone",
        "path" : "DispatchDataCz.callerContact.phone",
        "short" : "A.2.1.8.1 - Phone",
        "definition" : "Phone number of the caller",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "ContactPoint"
          }
        ]
      }
    ]
  }
}

```
