# A.2.4 - Alerts (en) - HL7 Czech EMS Implementation Guide v0.0.2

* [**Table of Contents**](toc.md)
* [**Artifacts**](artifacts.md)
* **A.2.4 - Alerts (en)**

## Logical Model: A.2.4 - Alerts (en) 

| | |
| :--- | :--- |
| *Official URL*:https://hl7.cz/fhir/cz-ems/StructureDefinition/AlertsCz | *Version*:0.0.2 |
| Draft as of 2025-10-14 | *Computable Name*:LogEnAlertsCz |

 
EMS Report - Alerts - A.2.4 EN 

**Usages:**

* Use this Logical Model: [A - EMS Report (en)](StructureDefinition-EmsReportCz.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.fhir.cz.ems|current/StructureDefinition/AlertsCz)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-AlertsCz.csv), [Excel](StructureDefinition-AlertsCz.xlsx) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "AlertsCz",
  "url" : "https://hl7.cz/fhir/cz-ems/StructureDefinition/AlertsCz",
  "version" : "0.0.2",
  "name" : "LogEnAlertsCz",
  "title" : "A.2.4 - Alerts (en)",
  "status" : "draft",
  "date" : "2025-10-14T13:52:10+00:00",
  "publisher" : "HL7 Czech Republic",
  "contact" : [
    {
      "name" : "HL7 Czech Republic",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.hl7.cz/"
        }
      ]
    }
  ],
  "description" : "EMS Report - Alerts - A.2.4 EN",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "CZ",
          "display" : "Czechia"
        }
      ]
    }
  ],
  "fhirVersion" : "4.0.1",
  "kind" : "logical",
  "abstract" : false,
  "type" : "https://hl7.cz/fhir/cz-ems/StructureDefinition/AlertsCz",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/Base",
  "derivation" : "specialization",
  "differential" : {
    "element" : [
      {
        "id" : "AlertsCz",
        "path" : "AlertsCz",
        "short" : "A.2.4 - Alerts (en)",
        "definition" : "EMS Report - Alerts - A.2.4 EN"
      },
      {
        "id" : "AlertsCz.allergy",
        "path" : "AlertsCz.allergy",
        "short" : "A.2.4.1 - Allergy and Intolerance",
        "definition" : "A record of allergies and intolerances (primarily to be used for new allergies or intolerances that occurred during the hospital stay).",
        "min" : 1,
        "max" : "*",
        "type" : [
          {
            "code" : "Base"
          }
        ]
      },
      {
        "id" : "AlertsCz.allergy.description",
        "path" : "AlertsCz.allergy.description",
        "short" : "A.2.4.1.1 - Allergy description",
        "definition" : "Textual description of the allergy or intolerance",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "string"
          }
        ]
      },
      {
        "id" : "AlertsCz.allergy.agent",
        "path" : "AlertsCz.allergy.agent",
        "short" : "A.2.4.1.2 - Agent or Allergen",
        "definition" : "A specific allergen or other agent/substance (drug, food, chemical agent, etc.) to which the patient has an adverse reaction propensity.",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ]
      },
      {
        "id" : "AlertsCz.allergy.typeOfPropensity",
        "path" : "AlertsCz.allergy.typeOfPropensity",
        "short" : "A.2.4.1.3 - Type of propensity",
        "definition" : "This element describes whether this condition refers to an allergy, non-allergy intolerance, or unknown class of intolerance (not known to be allergy or intolerance)",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ]
      },
      {
        "id" : "AlertsCz.allergy.manifestation",
        "path" : "AlertsCz.allergy.manifestation",
        "short" : "A.2.4.1.4 - Allergy manifestation",
        "definition" : "Description of the clinical manifestation of the allergic reaction including date of manifestation and severity. Example: anaphylactic shock, angioedema (the clinical manifestation also gives information about the severity of the observed reaction). Multiple manifestations could be provided.",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ]
      },
      {
        "id" : "AlertsCz.allergy.criticality",
        "path" : "AlertsCz.allergy.criticality",
        "short" : "A.2.4.1.5 - Criticality",
        "definition" : "Potential risk for future life-threatening adverse reactions when exposed to a substance known to cause an adverse reaction.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ]
      },
      {
        "id" : "AlertsCz.allergy.onsetDate",
        "path" : "AlertsCz.allergy.onsetDate",
        "short" : "A.2.4.1.6 - Onset date",
        "definition" : "Date of onset of allergy, e.g., date of the first observation of the reaction. Could be also expressed using a date, partial date or life period (childhood, adolescence).",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Base"
          }
        ]
      },
      {
        "id" : "AlertsCz.allergy.onsetDate.date",
        "path" : "AlertsCz.allergy.onsetDate.date",
        "short" : "Onset date",
        "definition" : "Date of onset of allergy, e.g., date of the first observation of the reaction. Could be also expressed using a date or partial date.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "dateTime"
          }
        ]
      },
      {
        "id" : "AlertsCz.allergy.onsetDate.code",
        "path" : "AlertsCz.allergy.onsetDate.code",
        "short" : "Onset date (code)",
        "definition" : "Date of onset of allergy, e.g., date of the first observation of the reaction expressed using code for life period (childhood, adolescence).",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ]
      },
      {
        "id" : "AlertsCz.allergy.endDate",
        "path" : "AlertsCz.allergy.endDate",
        "short" : "A.2.4.1.7 - End date",
        "definition" : "Date of resolution of the allergy (e.g. when the clinician deemed there is no longer any need to track the underlying condition)",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Base"
          }
        ]
      },
      {
        "id" : "AlertsCz.allergy.endDate.date",
        "path" : "AlertsCz.allergy.endDate.date",
        "short" : "End date",
        "definition" : "Date of resolution of the allergy (e.g. when the clinician deemed there is no longer any need to track the underlying condition)",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "dateTime"
          }
        ]
      },
      {
        "id" : "AlertsCz.allergy.endDate.code",
        "path" : "AlertsCz.allergy.endDate.code",
        "short" : "End date (code)",
        "definition" : "Date of resolution of the allergy expressed by code (e.g. age group)",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ]
      },
      {
        "id" : "AlertsCz.allergy.status",
        "path" : "AlertsCz.allergy.status",
        "short" : "A.2.4.1.8 - Status",
        "definition" : "Current status of the allergy or intolerance, for example, whether it is active, in remission, resolved, and so on …",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ]
      },
      {
        "id" : "AlertsCz.allergy.certainty",
        "path" : "AlertsCz.allergy.certainty",
        "short" : "A.2.4.1.9 - Certainty",
        "definition" : "Assertion about the certainty associated with a propensity, or potential risk, of a reaction to the identified substance. Diagnostic and/or clinical evidence of condition.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ]
      },
      {
        "id" : "AlertsCz.allergy.lastOccurrence",
        "path" : "AlertsCz.allergy.lastOccurrence",
        "short" : "A.2.4.1.10 - Last Occurrence",
        "definition" : "A.2.4.1.10 - Last Occurrence",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "dateTime"
          }
        ]
      },
      {
        "id" : "AlertsCz.medicalAlerts",
        "path" : "AlertsCz.medicalAlerts",
        "short" : "A.2.4.2 - Medical alerts (relevant for the respective hospital stay)",
        "definition" : "Medical alerts (relevant for the respective hospital stay)",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "Base"
          }
        ]
      },
      {
        "id" : "AlertsCz.medicalAlerts.description",
        "path" : "AlertsCz.medicalAlerts.description",
        "short" : "A.2.4.2.1 - Healthcare alert description",
        "definition" : "A warning, other than included in allergies.\nThe warning can be entered in code (there are codes for frequently used alerts) but seeing the dynamic nature of the warnings, these alerts will often be entered as free text.\nAny clinical information that is imperative to know so that the life or health of the patient does not come under threat.\nExample 1: the patient has a rare disease that requires special treatment\nExample 2: Airway Alert / Difficult Intubation\nExample 3: Diagnoses such as malignant hyperthermia, porphyria, and bleeding disorders; special treatments like anticoagulants or immunosuppressants; implanted devices.\nExample 4: transplanted organs illustrate other information that has to be taken into account in a healthcare contact.\nExample 5: participation in a clinical trial that has to be taken into account in a healthcare contact.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ]
      },
      {
        "id" : "AlertsCz.medicalAlerts.code",
        "path" : "AlertsCz.medicalAlerts.code",
        "short" : "A.2.4.2.3 - Code",
        "definition" : "A.2.4.2.3 - Code",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ]
      },
      {
        "id" : "AlertsCz.medicalAlerts.specialistPhysician",
        "path" : "AlertsCz.medicalAlerts.specialistPhysician",
        "short" : "A.2.4.2.4 - Specialist physician",
        "definition" : "A.2.4.2.4 - Specialist physician",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Base"
          }
        ]
      },
      {
        "id" : "AlertsCz.medicalAlerts.comment",
        "path" : "AlertsCz.medicalAlerts.comment",
        "short" : "A.2.4.2.5 - Comment",
        "definition" : "A.2.4.2.5 - Comment",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "string"
          }
        ]
      },
      {
        "id" : "AlertsCz.medicalAlerts.priority",
        "path" : "AlertsCz.medicalAlerts.priority",
        "short" : "A.2.4.2.6 - Priority",
        "definition" : "A.2.4.2.6 - Priority",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ]
      },
      {
        "id" : "AlertsCz.medicalAlerts.period",
        "path" : "AlertsCz.medicalAlerts.period",
        "short" : "A.2.4.2.7 - Period",
        "definition" : "A.2.4.2.7 - Period",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Base"
          }
        ]
      }
    ]
  }
}

```
