# Patient Mracena - HL7 Czech EMS Implementation Guide v0.0.2

* [**Table of Contents**](toc.md)
* [**Artifacts**](artifacts.md)
* **Patient Mracena**

## Example Patient: Patient Mracena

Profile: [Patient (CZ core)](https://build.fhir.org/ig/HL7-cz/cz-core/StructureDefinition-cz-patient-core.html)

Mračena Mrakomorová Female, DoB: 1971-11-26 ( https://ncez.mzcr.cz/fhir/sid/rcis#2716126452 (use: official, ))

-------

| | |
| :--- | :--- |
| Other Id: | `https://ncez.mzcr.cz/fhir/sid/rid`/2066425387 |
| Contact Detail | * [+420 603 853 227](tel:+420603853227)
* Malé náměstí 13a, 150 00, Praha 5(home)
 |
| Languages: | * Czech (preferred)
* English
* German
 |
| Links: | * General Practitioner: MUDr. Josef Švejk (Identifier: `https://ncez.mzcr.cz/fhir/sid/krzp`/123456789)
 |



## Resource Content

```json
{
  "resourceType" : "Patient",
  "id" : "3b46c18c-7e07-4232-af3e-f710dec8e766",
  "meta" : {
    "profile" : [
      "https://fhir.hl7cr.eu/core/StructureDefinition/cz-patient-core"
    ]
  },
  "identifier" : [
    {
      "system" : "https://ncez.mzcr.cz/fhir/sid/rid",
      "value" : "2066425387"
    },
    {
      "use" : "official",
      "system" : "https://ncez.mzcr.cz/fhir/sid/rcis",
      "value" : "2716126452"
    }
  ],
  "name" : [
    {
      "use" : "usual",
      "family" : "Mrakomorová",
      "given" : ["Mračena"]
    }
  ],
  "telecom" : [
    {
      "system" : "phone",
      "value" : "+420 603 853 227",
      "use" : "home"
    }
  ],
  "gender" : "female",
  "birthDate" : "1971-11-26",
  "address" : [
    {
      "use" : "home",
      "type" : "physical",
      "text" : "Malé náměstí 13a, 150 00, Praha 5",
      "line" : ["Malé náměstí 13a"],
      "_line" : [
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/iso21090-ADXP-streetName",
              "valueString" : "Malé náměstí"
            },
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/iso21090-ADXP-houseNumber",
              "valueString" : "13a"
            }
          ]
        }
      ],
      "city" : "Praha",
      "postalCode" : "15000",
      "country" : "Česko",
      "_country" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/iso21090-SC-coding",
            "valueCoding" : {
              "system" : "urn:iso:std:iso:3166",
              "code" : "CZ",
              "display" : "Czechia"
            }
          }
        ]
      }
    }
  ],
  "communication" : [
    {
      "language" : {
        "coding" : [
          {
            "system" : "urn:ietf:bcp:47",
            "code" : "cs"
          }
        ]
      },
      "preferred" : true
    },
    {
      "language" : {
        "coding" : [
          {
            "system" : "urn:ietf:bcp:47",
            "code" : "en"
          }
        ]
      }
    },
    {
      "language" : {
        "coding" : [
          {
            "system" : "urn:ietf:bcp:47",
            "code" : "de"
          }
        ]
      }
    }
  ],
  "generalPractitioner" : [
    {
      "identifier" : {
        "system" : "https://ncez.mzcr.cz/fhir/sid/krzp",
        "value" : "123456789"
      },
      "display" : "MUDr. Josef Švejk"
    }
  ]
}

```
