# Body height of patient - HL7 Czech EMS Implementation Guide v0.0.2

* [**Table of Contents**](toc.md)
* [**Artifacts**](artifacts.md)
* **Body height of patient**

## Example Observation: Body height of patient

Profile: [Observation: Anthropometric Data - Height (EMS CZ)](StructureDefinition-cz-observation-height-ems.md)

**status**: Final

**category**: Vital Signs

**code**: Estimated body height (observable entity)

**subject**: [Mračena Mrakomorová Female, DoB: 1971-11-26 ( https://ncez.mzcr.cz/fhir/sid/rcis#2716126452 (use: official, ))](Patient-3b46c18c-7e07-4232-af3e-f710dec8e766.md)

**effective**: 2020-06-01

**performer**: [Practitioner Testovací Jan](Practitioner-practitionerEms.md)

**value**: 165 cm(Details: UCUM codecm = 'cm')



## Resource Content

```json
{
  "resourceType" : "Observation",
  "id" : "ExampleBodyHeightEms",
  "meta" : {
    "profile" : [
      "https://hl7.cz/fhir/cz-ems/StructureDefinition/cz-observation-height-ems"
    ]
  },
  "status" : "final",
  "category" : [
    {
      "coding" : [
        {
          "system" : "http://terminology.hl7.org/CodeSystem/observation-category",
          "code" : "vital-signs"
        }
      ]
    }
  ],
  "code" : {
    "coding" : [
      {
        "system" : "http://snomed.info/sct",
        "code" : "1162418000"
      }
    ]
  },
  "subject" : {
    "reference" : "Patient/3b46c18c-7e07-4232-af3e-f710dec8e766"
  },
  "effectiveDateTime" : "2020-06-01",
  "performer" : [
    {
      "reference" : "Practitioner/practitionerEms"
    }
  ],
  "valueQuantity" : {
    "value" : 165,
    "unit" : "cm",
    "system" : "http://unitsofmeasure.org",
    "code" : "cm"
  }
}

```
