# BMI of patient - HL7 Czech EMS Implementation Guide v0.0.2

* [**Table of Contents**](toc.md)
* [**Artifacts**](artifacts.md)
* **BMI of patient**

## Example Observation: BMI of patient

Profile: [Observation: Anthropometric Data - BMI (EMS CZ)](StructureDefinition-cz-observation-BMI-ems.md)

**status**: Final

**category**: Vital Signs

**code**: Body mass index

**subject**: [Mračena Mrakomorová Female, DoB: 1971-11-26 ( https://ncez.mzcr.cz/fhir/sid/rcis#2716126452 (use: official, ))](Patient-3b46c18c-7e07-4232-af3e-f710dec8e766.md)

**effective**: 2020-06-01

**performer**: [Practitioner Testovací Jan](Practitioner-practitionerEms.md)

**value**: 22.5 kg/m2(Details: UCUM codekg/m2 = 'kg/m2')



## Resource Content

```json
{
  "resourceType" : "Observation",
  "id" : "ExampleBMIEms",
  "meta" : {
    "profile" : [
      "https://hl7.cz/fhir/cz-ems/StructureDefinition/cz-observation-BMI-ems"
    ]
  },
  "status" : "final",
  "category" : [
    {
      "coding" : [
        {
          "system" : "http://terminology.hl7.org/CodeSystem/observation-category",
          "code" : "vital-signs"
        }
      ]
    }
  ],
  "code" : {
    "coding" : [
      {
        "system" : "http://snomed.info/sct",
        "code" : "60621009"
      }
    ]
  },
  "subject" : {
    "reference" : "Patient/3b46c18c-7e07-4232-af3e-f710dec8e766"
  },
  "effectiveDateTime" : "2020-06-01",
  "performer" : [
    {
      "reference" : "Practitioner/practitionerEms"
    }
  ],
  "valueQuantity" : {
    "value" : 22.5,
    "unit" : "kg/m2",
    "system" : "http://unitsofmeasure.org",
    "code" : "kg/m2"
  }
}

```
