# cz-encounter-example - HL7 Czech EMS Implementation Guide v0.0.2

* [**Table of Contents**](toc.md)
* [**Artifacts**](artifacts.md)
* **cz-encounter-example**

## Example Encounter: cz-encounter-example

Profile: [Encounter (CZ)](https://build.fhir.org/ig/HL7-cz/cz-core/StructureDefinition-cz-encounter.html)

**identifier**: `http://example.org/hospital`/ku-123456789

**status**: In Progress

**class**: [ActCode AMB](http://terminology.hl7.org/6.5.0/CodeSystem-v3-ActCode.html#v3-ActCode-AMB): ambulatory

**type**: EMS pacientky Mrakomorové

**serviceProvider**: [Organization Fakultní nemocnice Motol](Bundle-cz-example-bundle.md#urn-uuid-821077d6-ce17-4602-b3ad-d4bef845a950)



## Resource Content

```json
{
  "resourceType" : "Encounter",
  "id" : "cd343afa-039d-4576-b5e4-e89598aeb628",
  "meta" : {
    "profile" : [
      "https://fhir.hl7cr.eu/core/StructureDefinition/cz-encounter"
    ]
  },
  "identifier" : [
    {
      "system" : "http://example.org/hospital",
      "value" : "ku-123456789"
    }
  ],
  "status" : "in-progress",
  "class" : {
    "system" : "http://terminology.hl7.org/CodeSystem/v3-ActCode",
    "code" : "AMB"
  },
  "type" : [
    {
      "text" : "EMS pacientky Mrakomorové"
    }
  ],
  "serviceProvider" : {
    "reference" : "urn:uuid:821077d6-ce17-4602-b3ad-d4bef845a950"
  }
}

```
