# CZ Patient History to this guide Map - HL7 Czech EMS Implementation Guide v0.0.2

* [**Table of Contents**](toc.md)
* [**Artifacts**](artifacts.md)
* **CZ Patient History to this guide Map**

## ConceptMap: CZ Patient History to this guide Map (Experimental) 

| | |
| :--- | :--- |
| *Official URL*:https://hl7.cz/fhir/cz-ems/ConceptMap/patientHistory2FHIR-cz | *Version*:0.0.2 |
| Draft as of 2025-10-14 | *Computable Name*:PatientHistory2FHIRCzEms |

 
CZ EMS Patient History Model to this guide Map 

Mapping from (not specified) to (not specified)

**Group 1**Mapping from [A.2.3 - Patient history (en)](StructureDefinition-PatientHistoryCz.md) to [Immunization Recommendation: (EMS CZ)](StructureDefinition-cz-immunizationRecommendation-ems.md)

* **Source Code**: PatientHistory.medicalHistory.vaccination.nextVaccinationDate (A.2.6.1.4.8 - Next vaccination date)
  * **Relationship**: [is related to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#relatedto)
  * **Target Code**: ImmunizationRecommendation.recommendation.dateCriterion[nextDose].value

-------

**Group 2**Mapping from [A.2.3 - Patient history (en)](StructureDefinition-PatientHistoryCz.md) to [Composition (EMS CZ)](StructureDefinition-cz-composition-ems.md)

* **Source Code**: PatientHistory.medicalHistory (A.2.6.1 - Medical history)
  * **Relationship**: [is related to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#relatedto)
  * **Target Code**: Composiiton.section
  * **Comment**: several sections
* **Source Code**: PatientHistory.medicalHistory.historyOfConditions (A.2.6.1.1 - History of problems)
  * **Relationship**: [is related to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#relatedto)
  * **Target Code**: Composiiton.section:sectionDiagnosticSummary
  * **Comment**: The same section used by the hospital stay ?
* **Source Code**: PatientHistory.medicalHistory.historyOfConditions.resolution (A.2.6.1.1.6 - Resolution circumstances)
  * **Relationship**: [is related to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#relatedto)
  * **Target Code**: Composition.section:sectionDiagnosticSummary.text
  * **Comment**: The resolution circumstances may be described as resource or composiiton.section text ; or indirectly determined by the resource (e.g. Procedure) that has been perfomed in reason of this Condition no more active
* **Source Code**: PatientHistory.medicalHistory.medicalDevices (A.2.6.1.2 - Devices and Implants)
  * **Relationship**: [is related to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#relatedto)
  * **Target Code**: Composition.section:sectionMedicalDevices
  * **Comment**: 
* **Source Code**: PatientHistory.medicalHistory.vaccination (A.2.6.1.4 - Vaccination)
  * **Relationship**: [is equivalent to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#equivalent)
  * **Target Code**: Composition.section:sectionImmunizations
  * **Comment**: 
* **Source Code**: PatientHistory.medicalHistory.epidemiologicalHistory (A.2.6.1.5 - Epidemiological history)
  * **Relationship**: (not mapped)
  * **Target Code**: decison not to have as distict section
* **Source Code**: PatientHistory.medicalHistory.epidemiologicalHistory.infectiousContacts (A.2.6.1.5.1 - Infectious contacts)
  * **Relationship**: [is related to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#relatedto)
  * **Target Code**: Composition.section::infectiousContacts
  * **Comment**: 
* **Source Code**: PatientHistory.medicalHistory.epidemiologicalHistory.travelHistory (A.2.6.1.5.2 - Travel history)
  * **Relationship**: [is related to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#relatedto)
  * **Target Code**: Composition.section:sectionTravelHx
  * **Comment**: 
* **Source Code**: PatientHistory.medicalHistory.epidemiologicalHistory.travelHistory.period (A.2.6.1.5.2.1 - Time period)
  * **Relationship**: [is related to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#relatedto)
  * **Target Code**: Composition.section:sectionTravelHx
  * **Comment**: To be specified
* **Source Code**: PatientHistory.medicalHistory.epidemiologicalHistory.travelHistory.country (A.2.6.1.5.2.2 - Country visited)
  * **Relationship**: [is related to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#relatedto)
  * **Target Code**: Composition.section:sectionTravelHx
  * **Comment**: To be specified
* **Source Code**: PatientHistory.medicalHistory.epidemiologicalHistory.travelHistory.comment (A.2.6.1.5.2.3 - Comment)
  * **Relationship**: [is related to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#relatedto)
  * **Target Code**: Composition.section:sectionTravelHx
  * **Comment**: To be specified
* **Source Code**: PatientHistory.familyHistory (A.2.6.2 - Family history)
  * **Relationship**: [is related to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#relatedto)
  * **Target Code**: Composition.section:sectionFamilyMemberHistory
  * **Comment**: 
* **Source Code**: PatientHistory.socialDeterminants (A.2.6.3 - Social determinants of health)
  * **Relationship**: [is related to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#relatedto)
  * **Target Code**: Composition.section:sectionSocialHistory
  * **Comment**: 
* **Source Code**: PatientHistory.useOfSubstances (A.2.6.4 - Use of substances)
  * **Relationship**: [is related to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#relatedto)
  * **Target Code**: Composition.section:sectionSocialHistory
  * **Comment**: To be specified

-------

**Group 3**Mapping from [A.2.3 - Patient history (en)](StructureDefinition-PatientHistoryCz.md) to [Condition (EMS CZ)](StructureDefinition-cz-condition-ems.md)

* **Source Code**: PatientHistory.medicalHistory.historyOfConditions.conditionSpecification (A.2.6.1.1.1 - Problem description)
  * **Relationship**: [is related to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#relatedto)
  * **Target Code**: Condition.text
  * **Comment**: 
* **Source Code**: PatientHistory.medicalHistory.historyOfConditions.conditionDetails (A.2.6.1.1.2 - Problem details)
  * **Relationship**: [is related to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#relatedto)
  * **Target Code**: Condition
  * **Comment**: 
* **Source Code**: PatientHistory.medicalHistory.historyOfConditions.onsetDate (A.2.6.1.1.3 - Onset date)
  * **Relationship**: [is equal to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#equal)
  * **Target Code**: Condition.onSetDateTime
  * **Comment**: 
* **Source Code**: PatientHistory.medicalHistory.historyOfConditions.endDate (A.2.6.1.1.4 - End date)
  * **Relationship**: [is equal to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#equal)
  * **Target Code**: Condition.abatementDateTime
  * **Comment**: 
* **Source Code**: PatientHistory.medicalHistory.historyOfConditions.clinicalStatus (A.2.6.1.1.5 - Clinical status)
  * **Relationship**: [is equivalent to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#equivalent)
  * **Target Code**: Composition.clinicalStatus
  * **Comment**: 
* **Source Code**: PatientHistory.medicalHistory.historyOfConditions.resolution (A.2.6.1.1.6 - Resolution circumstances)
  * **Relationship**: [is related to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#relatedto)
  * **Target Code**: Condition.text
  * **Comment**: The resolution circumstances may be described as resource or composiiton.section text ; or indirectly determined by the resource (e.g. Procedure) that has been perfomed in reason of this Condition no more active
* **Source Code**: PatientHistory.medicalHistory.historyOfConditions.severity (A.2.6.1.1.7 - Severity)
  * **Relationship**: [is related to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#relatedto)
  * **Target Code**: Composition.severity
  * **Comment**: 
* **Source Code**: PatientHistory.medicalHistory.historyOfConditions.stage (A.2.6.1.1.8 - Stage)
  * **Relationship**: [is equivalent to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#equivalent)
  * **Target Code**: Composition.stage
  * **Comment**: 

-------

**Group 4**Mapping from [A.2.3 - Patient history (en)](StructureDefinition-PatientHistoryCz.md) to `https://hl7.cz/fhir/core/StructureDefinition/cz-medical-device`

* **Source Code**: PatientHistory.medicalHistory.medicalDevices.description (A.2.6.1.2.1 - Device and implant description)
  * **Relationship**: [is related to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#relatedto)
  * **Target Code**: Device.text
  * **Comment**: if referring to the description of the device
* **Source Code**: PatientHistory.medicalHistory.medicalDevices.identifier (A.2.6.1.2.2 - Device ID)
  * **Relationship**: [is related to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#relatedto)
  * **Target Code**: Device.identifier
  * **Comment**: if generic identifier
* **Source Code**: PatientHistory.medicalHistory.medicalDevices.identifier (A.2.6.1.2.2 - Device ID)
  * **Relationship**: [is related to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#relatedto)
  * **Target Code**: Device.udiCarrier
  * **Comment**: if it is the udiCarrier

-------

**Group 5**Mapping from [A.2.3 - Patient history (en)](StructureDefinition-PatientHistoryCz.md) to [DeviceUseStatement](http://hl7.org/fhir/R4/deviceusestatement.html)

* **Source Code**: PatientHistory.medicalHistory.medicalDevices.description (A.2.6.1.2.1 - Device and implant description)
  * **Relationship**: [is related to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#relatedto)
  * **Target Code**: DeviceUseStatement.text
  * **Comment**: if referring to the description of the usage of the device
* **Source Code**: PatientHistory.medicalHistory.medicalDevices.implantDate (A.2.6.1.2.3 - Implant date)
  * **Relationship**: [is related to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#relatedto)
  * **Target Code**: DeviceUseStatement.timing[x]
  * **Comment**: If the usage period is highlighted
* **Source Code**: PatientHistory.medicalHistory.medicalDevices.endDate (A.2.6.1.2.4 - End date)
  * **Relationship**: [is related to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#relatedto)
  * **Target Code**: DeviceUseStatement.timingPeriod.end
  * **Comment**: 
* **Source Code**: PatientHistory.medicalHistory.medicalDevices.reason (A.2.6.1.2.5 - Reason)
  * **Relationship**: [is related to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#relatedto)
  * **Target Code**: DeviceUseStatement.reasonCode
  * **Comment**: if details about the body structure have to be provided
* **Source Code**: PatientHistory.medicalHistory.medicalDevices.reason (A.2.6.1.2.5 - Reason)
  * **Relationship**: [is related to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#relatedto)
  * **Target Code**: DeviceUseStatement.reasonReference
  * **Comment**: 
* **Source Code**: PatientHistory.medicalHistory.historyOfProcedures (A.2.6.1.3 - History of procedures)
  * **Relationship**: [is related to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#relatedto)
  * **Target Code**: Composition.section:sectionSignificantProcedures
  * **Comment**: The same section usd by the hospital stay ?

-------

**Group 6**Mapping from [A.2.3 - Patient history (en)](StructureDefinition-PatientHistoryCz.md) to [CZ Immunization EMS](StructureDefinition-cz-immunization-ems.md)

* **Source Code**: PatientHistory.medicalHistory.vaccination.diseaseOrAgent (A.2.6.1.4.1 - Disease or agent targeted)
  * **Relationship**: [is equivalent to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#equivalent)
  * **Target Code**: Immunization.protocolApplied.targetDisease
* **Source Code**: PatientHistory.medicalHistory.vaccination.vaccine (A.2.6.1.4.2 - Vaccine/prophylaxis)
  * **Relationship**: [is related to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#relatedto)
  * **Target Code**: Immunization.vaccineCode
* **Source Code**: PatientHistory.medicalHistory.vaccination.productName (A.2.6.1.4.4 - Vaccine medicinal product)
  * **Relationship**: [is related to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#relatedto)
  * **Target Code**: Immunization.extension:administeredProduct
* **Source Code**: PatientHistory.medicalHistory.vaccination.manufacturerOrMAH (A.2.6.1.4.5 - Marketing Authorisation Holder)
  * **Relationship**: [is related to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#relatedto)
  * **Target Code**: Immunization.manufacturer
* **Source Code**: PatientHistory.medicalHistory.vaccination.orderNumber (A.2.6.1.4.6 - Number in a series of vaccinations / doses)
  * **Relationship**: [is related to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#relatedto)
  * **Target Code**: Immunization.protocolApplied.doseNumberPositiveInt
* **Source Code**: PatientHistory.medicalHistory.vaccination.vaccinationDate (A.2.6.1.4.7 - Date of vaccination)
  * **Relationship**: [is related to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#relatedto)
  * **Target Code**: Immunization.occurenceDateTime

-------

**Group 7**Mapping from [A.2.3 - Patient history (en)](StructureDefinition-PatientHistoryCz.md) to [CZ Observation SDOH: (EMS)](StructureDefinition-cz-observation-sdoh-ems.md)

* **Source Code**: PatientHistory.socialDeterminants.participationInSociety (A.2.6.3.1 - Participation in society)
  * **Relationship**: [is related to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#relatedto)
  * **Target Code**: Observation
  * **Comment**: category to be defined
* **Source Code**: PatientHistory.socialDeterminants.participationInSociety.workSituation (A.2.6.3.1.1 - Work situation)
  * **Relationship**: [is related to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#relatedto)
  * **Target Code**: Observation.value[x]
  * **Comment**: category and code to be defined
* **Source Code**: PatientHistory.socialDeterminants.participationInSociety.hobby (A.2.6.3.1.2 - Hobby)
  * **Relationship**: [is related to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#relatedto)
  * **Target Code**: Observation.value[x]
  * **Comment**: category and code to be defined
* **Source Code**: PatientHistory.socialDeterminants.participationInSociety.socailNetwork (A.2.6.3.1.3 - Social network)
  * **Relationship**: [is related to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#relatedto)
  * **Target Code**: Observation.value[x]
  * **Comment**: category and code to be defined
* **Source Code**: PatientHistory.socialDeterminants.education (A.2.6.3.2 - Education)
  * **Relationship**: [is related to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#relatedto)
  * **Target Code**: Observation
  * **Comment**: category to be defined
* **Source Code**: PatientHistory.socialDeterminants.education.level (A.2.6.3.2.1 - Education level)
  * **Relationship**: [is related to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#relatedto)
  * **Target Code**: Observation.value[x]
  * **Comment**: category and code to be defined
* **Source Code**: PatientHistory.socialDeterminants.education.comment (A.2.6.3.2.2 - Comment)
  * **Relationship**: [is related to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#relatedto)
  * **Target Code**: Observation.note
  * **Comment**: category and code to be defined
* **Source Code**: PatientHistory.socialDeterminants.livingSituation (A.2.6.3.3 - Living situation)
  * **Relationship**: [is related to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#relatedto)
  * **Target Code**: Observation
  * **Comment**: category to be defined
* **Source Code**: PatientHistory.socialDeterminants.livingSituation.houseType (A.2.6.3.3.1 - House type)
  * **Relationship**: [is related to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#relatedto)
  * **Target Code**: Observation.value[x]
  * **Comment**: category and code to be defined
* **Source Code**: PatientHistory.socialDeterminants.livingSituation.homeAdaption (A.2.6.3.3.2 - Home adaption)
  * **Relationship**: [is related to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#relatedto)
  * **Target Code**: Observation.value[x]
  * **Comment**: category and code to be defined
* **Source Code**: PatientHistory.socialDeterminants.livingSituation.livingConditions (A.2.6.3.3.3 - Living conditions)
  * **Relationship**: [is related to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#relatedto)
  * **Target Code**: Observation.value[x]
  * **Comment**: category and code to be defined
* **Source Code**: PatientHistory.socialDeterminants.familySituation (A.2.6.3.4 - Family situation)
  * **Relationship**: [is related to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#relatedto)
  * **Target Code**: Observation
  * **Comment**: category to be defined
* **Source Code**: PatientHistory.socialDeterminants.familySituation.comment (A.2.6.3.4.1 - Comment)
  * **Relationship**: [is related to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#relatedto)
  * **Target Code**: Observation.value[x]
  * **Comment**: category and code to be defined
* **Source Code**: PatientHistory.socialDeterminants.familySituation.familyComposition (A.2.6.3.4.2 - Family composition)
  * **Relationship**: [is related to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#relatedto)
  * **Target Code**: Observation.value[x]
  * **Comment**: category and code to be defined
* **Source Code**: PatientHistory.socialDeterminants.familySituation.maritalStatus (A.2.6.3.4.3 - Marital status)
  * **Relationship**: [is related to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#relatedto)
  * **Target Code**: Observation.value[x]
  * **Comment**: category and code to be defined
* **Source Code**: PatientHistory.socialDeterminants.familySituation.numberOfChildren (A.2.6.3.4.4 - Number of children)
  * **Relationship**: [is related to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#relatedto)
  * **Target Code**: Observation.value[x]
  * **Comment**: category and code to be defined
* **Source Code**: PatientHistory.socialDeterminants.familySituation.numberOfChildrenAtHome (A.2.6.3.4.5 - Number of children at home)
  * **Relationship**: [is related to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#relatedto)
  * **Target Code**: Observation.value[x]
  * **Comment**: category and code to be defined
* **Source Code**: PatientHistory.socialDeterminants.familySituation.childDetails (A.2.6.3.4.6 - Child details)
  * **Relationship**: [is related to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#relatedto)
  * **Target Code**: Observation.value[x]
  * **Comment**: category and code to be defined
* **Source Code**: PatientHistory.socialDeterminants.familySituation.careResponsibility (A.2.6.3.4.7 - Care responsibility)
  * **Relationship**: [is related to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#relatedto)
  * **Target Code**: Observation.value[x]
  * **Comment**: category and code to be defined

-------

**Group 8**Mapping from [A.2.3 - Patient history (en)](StructureDefinition-PatientHistoryCz.md) to [Procedure: EMS Report (CZ)](StructureDefinition-cz-procedure-ems.md)

* **Source Code**: PatientHistory.medicalHistory.historyOfProcedures.procedureCode (A.2.6.1.3.1 - Procedure code)
  * **Relationship**: [is related to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#relatedto)
  * **Target Code**: Procedure.code
  * **Comment**: 
* **Source Code**: PatientHistory.medicalHistory.historyOfProcedures.description (A.2.6.1.3.2 - Procedure description)
  * **Relationship**: [is related to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#relatedto)
  * **Target Code**: Procedure.text
  * **Comment**: 
* **Source Code**: PatientHistory.medicalHistory.historyOfProcedures.bodySite (A.2.6.1.3.3 - Body site)
  * **Relationship**: [is related to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#relatedto)
  * **Target Code**: Procedure.bodySite
  * **Comment**: 
* **Source Code**: PatientHistory.medicalHistory.historyOfProcedures.bodySite (A.2.6.1.3.3 - Body site)
  * **Relationship**: [is related to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#relatedto)
  * **Target Code**: Procedure.extension:bodySite
  * **Comment**: if details about the body structure have to be provided
* **Source Code**: PatientHistory.medicalHistory.historyOfProcedures.date (A.2.6.1.3.4 - Procedure date)
  * **Relationship**: [is related to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#relatedto)
  * **Target Code**: Procedure.perfomedDateTime
  * **Comment**: 
* **Source Code**: PatientHistory.medicalHistory.historyOfProcedures.reason (A.2.6.1.3.5 - Procedure reason)
  * **Relationship**: [is equivalent to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#equivalent)
  * **Target Code**: Procedure.reasonCode
  * **Comment**: 
* **Source Code**: PatientHistory.medicalHistory.historyOfProcedures.reason (A.2.6.1.3.5 - Procedure reason)
  * **Relationship**: [is equivalent to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#equivalent)
  * **Target Code**: Procedure.reasonReference
  * **Comment**: 
* **Source Code**: PatientHistory.medicalHistory.historyOfProcedures.outcome (A.2.6.1.3.6 - Outcome)
  * **Relationship**: [is equivalent to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#equivalent)
  * **Target Code**: Procedure.outcome
  * **Comment**: 
* **Source Code**: PatientHistory.medicalHistory.historyOfProcedures.focalDevice (A.2.6.1.3.7 - Focal device)
  * **Relationship**: [is equivalent to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#equivalent)
  * **Target Code**: Procedure.focalDevice
  * **Comment**: 

-------

**Group 9**Mapping from [A.2.3 - Patient history (en)](StructureDefinition-PatientHistoryCz.md) to [Observation](http://hl7.org/fhir/R4/observation.html)

* **Source Code**: PatientHistory.useOfSubstances.alcohol (A.2.6.4.1 - Alcohol use)
  * **Relationship**: [is related to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#relatedto)
  * **Target Code**: Observation
  * **Comment**: category and code to be defined
* **Source Code**: PatientHistory.useOfSubstances.alcohol.currentStatus (A.2.6.4.1.1 - Status)
  * **Relationship**: [is related to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#relatedto)
  * **Target Code**: Observation.value[x]
  * **Comment**: category and code to be defined
* **Source Code**: PatientHistory.useOfSubstances.alcohol.periodAndQuantity (A.2.6.4.1.2 - Period and quantity)
  * **Relationship**: [is related to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#relatedto)
  * **Target Code**: Observation.value[x]
  * **Comment**: category and code to be defined
* **Source Code**: PatientHistory.useOfSubstances.alcohol.comment (A.2.6.4.1.3 - Comment)
  * **Relationship**: [is related to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#relatedto)
  * **Target Code**: Observation.note
  * **Comment**: category and code to be defined
* **Source Code**: PatientHistory.useOfSubstances.tobacco (A.2.6.4.2 - Tobacco use)
  * **Relationship**: [is related to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#relatedto)
  * **Target Code**: Observation
  * **Comment**: category and code to be defined
* **Source Code**: PatientHistory.useOfSubstances.tobacco.currentStatus (A.2.6.4.2.1 - Status)
  * **Relationship**: [is related to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#relatedto)
  * **Target Code**: Observation.value[x]
  * **Comment**: category and code to be defined
* **Source Code**: PatientHistory.useOfSubstances.tobacco.periodAndQuantity (A.2.6.4.2.2 - Period and quantity)
  * **Relationship**: [is related to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#relatedto)
  * **Target Code**: Observation.value[x]
  * **Comment**: category and code to be defined
* **Source Code**: PatientHistory.useOfSubstances.tobacco.comment (A.2.6.4.2.3 - Comment)
  * **Relationship**: [is related to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#relatedto)
  * **Target Code**: Observation.note
  * **Comment**: category and code to be defined
* **Source Code**: PatientHistory.useOfSubstances.drugConsumption (A.2.6.4.3 - Drug consumption)
  * **Relationship**: [is related to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#relatedto)
  * **Target Code**: Observation
  * **Comment**: category and code to be defined
* **Source Code**: PatientHistory.useOfSubstances.drugConsumption.currentStatus (A.2.6.4.3.1 - Status)
  * **Relationship**: [is related to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#relatedto)
  * **Target Code**: Observation.value[x]
  * **Comment**: category and code to be defined
* **Source Code**: PatientHistory.useOfSubstances.drugConsumption.periodAndQuantity (A.2.6.4.3.2 - Period and quantity)
  * **Relationship**: [is related to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#relatedto)
  * **Target Code**: Observation.value[x]
  * **Comment**: category and code to be defined
* **Source Code**: PatientHistory.useOfSubstances.drugConsumption.drugType (A.2.6.4.3.3 - Drug or medication type)
  * **Relationship**: [is related to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#relatedto)
  * **Target Code**: Observation
  * **Comment**: category and code to be defined
* **Source Code**: PatientHistory.useOfSubstances.drugConsumption.route (A.2.6.4.3.4 - Route of administration)
  * **Relationship**: [is related to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#relatedto)
  * **Target Code**: Observation.value[x]
  * **Comment**: category and code to be defined
* **Source Code**: PatientHistory.useOfSubstances.drugConsumption.comment (A.2.6.4.3.5 - Comment)
  * **Relationship**: [is related to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#relatedto)
  * **Target Code**: Observation.note
  * **Comment**: category and code to be defined

-------

**Group 10**Mapping from [A.2.3 - Patient history (en)](StructureDefinition-PatientHistoryCz.md) to [FamilyMemberHistory](http://hl7.org/fhir/R4/familymemberhistory.html)

* **Source Code**: PatientHistory.familyHistory.relationship (A.2.6.2.1 - Patient relationship)
  * **Relationship**: [is equivalent to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#equivalent)
  * **Target Code**: FamilyMemberHistory.relationship
  * **Comment**: 
* **Source Code**: PatientHistory.familyHistory.birthDate (A.2.6.2.2 - Date of birth)
  * **Relationship**: [is equivalent to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#equivalent)
  * **Target Code**: FamilyMemberHistory.bornDate
  * **Comment**: 
* **Source Code**: PatientHistory.familyHistory.deathDateOrAge (A.2.6.2.3 - Age or date of death)
  * **Relationship**: [is equivalent to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#equivalent)
  * **Target Code**: FamilyMemberHistory.deceased[x]
  * **Comment**: 
* **Source Code**: PatientHistory.familyHistory.conditions (A.2.6.2.5 - Condition)
  * **Relationship**: [is equivalent to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#equivalent)
  * **Target Code**: FamilyMemberHistory.condition.code
  * **Comment**: 
* **Source Code**: PatientHistory.familyHistory.causeOfDeath (A.2.6.2.6 - Cause of death)
  * **Relationship**: [is equivalent to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#equivalent)
  * **Target Code**: FamilyMemberHistory.condition.code
  * **Comment**: If FamilyMemberHistory.condition.contributedToDeath is true

-------

**Group 11**Mapping from [A.2.3 - Patient history (en)](StructureDefinition-PatientHistoryCz.md) to [Infectious Contact: (EMS CZ)](StructureDefinition-cz-observation-infectious-contact-ems.md)

* **Source Code**: PatientHistory.medicalHistory.epidemiologicalHistory.infectiousContacts.period (A.2.6.1.5.1.1 - Time period)
  * **Relationship**: [is equivalent to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#equivalent)
  * **Target Code**: Observation.effective[x]
  * **Comment**: 
* **Source Code**: PatientHistory.medicalHistory.epidemiologicalHistory.infectiousContacts.infectiousAgent (A.2.6.1.5.1.2 - Infectious agent)
  * **Relationship**: [is equivalent to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#equivalent)
  * **Target Code**: Observation.valueCodeableConcept
  * **Comment**: In the current value set the disease is indicated
* **Source Code**: PatientHistory.medicalHistory.epidemiologicalHistory.infectiousContacts.proximity (A.2.6.1.5.1.3 - Proximity)
  * **Relationship**: [is related to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#relatedto)
  * **Target Code**: Composition.section:infectiousContacts
  * **Comment**: in this version as textual description
* **Source Code**: PatientHistory.medicalHistory.epidemiologicalHistory.infectiousContacts.country (A.2.6.1.5.1.4 - Country)
  * **Relationship**: [is related to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#relatedto)
  * **Target Code**: Composition.section:infectiousContacts
  * **Comment**: in this version as textual description
* **Source Code**: PatientHistory.medicalHistory.epidemiologicalHistory.infectiousContacts.note (A.2.6.1.5.1.5 - Additional information)
  * **Relationship**: [is equivalent to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#equivalent)
  * **Target Code**: Observation.note
  * **Comment**: 



## Resource Content

```json
{
  "resourceType" : "ConceptMap",
  "id" : "patientHistory2FHIR-cz",
  "url" : "https://hl7.cz/fhir/cz-ems/ConceptMap/patientHistory2FHIR-cz",
  "version" : "0.0.2",
  "name" : "PatientHistory2FHIRCzEms",
  "title" : "CZ Patient History to this guide Map",
  "status" : "draft",
  "experimental" : true,
  "date" : "2025-10-14T13:52:10+00:00",
  "publisher" : "HL7 Czech Republic",
  "contact" : [
    {
      "name" : "HL7 Czech Republic",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.hl7.cz/"
        }
      ]
    }
  ],
  "description" : "CZ EMS Patient History Model to this guide Map",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "CZ",
          "display" : "Czechia"
        }
      ]
    }
  ],
  "group" : [
    {
      "source" : "https://hl7.cz/fhir/cz-ems/StructureDefinition/PatientHistoryCz",
      "target" : "https://hl7.cz/fhir/cz-ems/StructureDefinition/cz-immunizationRecommendation-ems",
      "element" : [
        {
          "code" : "PatientHistory.medicalHistory.vaccination.nextVaccinationDate",
          "display" : "A.2.6.1.4.8 - Next vaccination date",
          "target" : [
            {
              "code" : "ImmunizationRecommendation.recommendation.dateCriterion[nextDose].value",
              "equivalence" : "relatedto"
            }
          ]
        }
      ]
    },
    {
      "source" : "https://hl7.cz/fhir/cz-ems/StructureDefinition/PatientHistoryCz",
      "target" : "https://hl7.cz/fhir/cz-ems/StructureDefinition/cz-composition-ems",
      "element" : [
        {
          "code" : "PatientHistory.medicalHistory",
          "display" : "A.2.6.1 - Medical history",
          "target" : [
            {
              "code" : "Composiiton.section",
              "equivalence" : "relatedto",
              "comment" : "several sections"
            }
          ]
        },
        {
          "code" : "PatientHistory.medicalHistory.historyOfConditions",
          "display" : "A.2.6.1.1 - History of problems",
          "target" : [
            {
              "code" : "Composiiton.section:sectionDiagnosticSummary",
              "equivalence" : "relatedto",
              "comment" : "The same section used by the hospital stay ?"
            }
          ]
        },
        {
          "code" : "PatientHistory.medicalHistory.historyOfConditions.resolution",
          "display" : "A.2.6.1.1.6 - Resolution circumstances",
          "target" : [
            {
              "code" : "Composition.section:sectionDiagnosticSummary.text",
              "equivalence" : "relatedto",
              "comment" : "The resolution circumstances may be described as resource or composiiton.section text ; or indirectly determined by the resource (e.g. Procedure) that has been perfomed in reason of this Condition no more active"
            }
          ]
        },
        {
          "code" : "PatientHistory.medicalHistory.medicalDevices",
          "display" : "A.2.6.1.2 - Devices and Implants",
          "target" : [
            {
              "code" : "Composition.section:sectionMedicalDevices",
              "equivalence" : "relatedto"
            }
          ]
        },
        {
          "code" : "PatientHistory.medicalHistory.vaccination",
          "display" : "A.2.6.1.4 - Vaccination",
          "target" : [
            {
              "code" : "Composition.section:sectionImmunizations",
              "equivalence" : "equivalent"
            }
          ]
        },
        {
          "code" : "PatientHistory.medicalHistory.epidemiologicalHistory",
          "display" : "A.2.6.1.5 - Epidemiological history",
          "target" : [
            {
              "equivalence" : "unmatched",
              "comment" : "decison not to have as distict section"
            }
          ]
        },
        {
          "code" : "PatientHistory.medicalHistory.epidemiologicalHistory.infectiousContacts",
          "display" : "A.2.6.1.5.1 - Infectious contacts",
          "target" : [
            {
              "code" : "Composition.section::infectiousContacts",
              "equivalence" : "relatedto"
            }
          ]
        },
        {
          "code" : "PatientHistory.medicalHistory.epidemiologicalHistory.travelHistory",
          "display" : "A.2.6.1.5.2 - Travel history",
          "target" : [
            {
              "code" : "Composition.section:sectionTravelHx",
              "equivalence" : "relatedto"
            }
          ]
        },
        {
          "code" : "PatientHistory.medicalHistory.epidemiologicalHistory.travelHistory.period",
          "display" : "A.2.6.1.5.2.1 - Time period",
          "target" : [
            {
              "code" : "Composition.section:sectionTravelHx",
              "equivalence" : "relatedto",
              "comment" : "To be specified"
            }
          ]
        },
        {
          "code" : "PatientHistory.medicalHistory.epidemiologicalHistory.travelHistory.country",
          "display" : "A.2.6.1.5.2.2 - Country visited",
          "target" : [
            {
              "code" : "Composition.section:sectionTravelHx",
              "equivalence" : "relatedto",
              "comment" : "To be specified"
            }
          ]
        },
        {
          "code" : "PatientHistory.medicalHistory.epidemiologicalHistory.travelHistory.comment",
          "display" : "A.2.6.1.5.2.3 - Comment",
          "target" : [
            {
              "code" : "Composition.section:sectionTravelHx",
              "equivalence" : "relatedto",
              "comment" : "To be specified"
            }
          ]
        },
        {
          "code" : "PatientHistory.familyHistory",
          "display" : "A.2.6.2 - Family history",
          "target" : [
            {
              "code" : "Composition.section:sectionFamilyMemberHistory",
              "equivalence" : "relatedto"
            }
          ]
        },
        {
          "code" : "PatientHistory.socialDeterminants",
          "display" : "A.2.6.3 - Social determinants of health",
          "target" : [
            {
              "code" : "Composition.section:sectionSocialHistory",
              "equivalence" : "relatedto"
            }
          ]
        },
        {
          "code" : "PatientHistory.useOfSubstances",
          "display" : "A.2.6.4 - Use of substances",
          "target" : [
            {
              "code" : "Composition.section:sectionSocialHistory",
              "equivalence" : "relatedto",
              "comment" : "To be specified"
            }
          ]
        }
      ]
    },
    {
      "source" : "https://hl7.cz/fhir/cz-ems/StructureDefinition/PatientHistoryCz",
      "target" : "https://hl7.cz/fhir/cz-ems/StructureDefinition/cz-condition-ems",
      "element" : [
        {
          "code" : "PatientHistory.medicalHistory.historyOfConditions.conditionSpecification",
          "display" : "A.2.6.1.1.1 - Problem description",
          "target" : [
            {
              "code" : "Condition.text",
              "equivalence" : "relatedto"
            }
          ]
        },
        {
          "code" : "PatientHistory.medicalHistory.historyOfConditions.conditionDetails",
          "display" : "A.2.6.1.1.2 - Problem details",
          "target" : [
            {
              "code" : "Condition",
              "equivalence" : "relatedto"
            }
          ]
        },
        {
          "code" : "PatientHistory.medicalHistory.historyOfConditions.onsetDate",
          "display" : "A.2.6.1.1.3 - Onset date",
          "target" : [
            {
              "code" : "Condition.onSetDateTime",
              "equivalence" : "equal"
            }
          ]
        },
        {
          "code" : "PatientHistory.medicalHistory.historyOfConditions.endDate",
          "display" : "A.2.6.1.1.4 - End date",
          "target" : [
            {
              "code" : "Condition.abatementDateTime",
              "equivalence" : "equal"
            }
          ]
        },
        {
          "code" : "PatientHistory.medicalHistory.historyOfConditions.clinicalStatus",
          "display" : "A.2.6.1.1.5 - Clinical status",
          "target" : [
            {
              "code" : "Composition.clinicalStatus",
              "equivalence" : "equivalent"
            }
          ]
        },
        {
          "code" : "PatientHistory.medicalHistory.historyOfConditions.resolution",
          "display" : "A.2.6.1.1.6 - Resolution circumstances",
          "target" : [
            {
              "code" : "Condition.text",
              "equivalence" : "relatedto",
              "comment" : "The resolution circumstances may be described as resource or composiiton.section text ; or indirectly determined by the resource (e.g. Procedure) that has been perfomed in reason of this Condition no more active"
            }
          ]
        },
        {
          "code" : "PatientHistory.medicalHistory.historyOfConditions.severity",
          "display" : "A.2.6.1.1.7 - Severity",
          "target" : [
            {
              "code" : "Composition.severity",
              "equivalence" : "relatedto"
            }
          ]
        },
        {
          "code" : "PatientHistory.medicalHistory.historyOfConditions.stage",
          "display" : "A.2.6.1.1.8 - Stage",
          "target" : [
            {
              "code" : "Composition.stage",
              "equivalence" : "equivalent"
            }
          ]
        }
      ]
    },
    {
      "source" : "https://hl7.cz/fhir/cz-ems/StructureDefinition/PatientHistoryCz",
      "target" : "https://hl7.cz/fhir/core/StructureDefinition/cz-medical-device",
      "element" : [
        {
          "code" : "PatientHistory.medicalHistory.medicalDevices.description",
          "display" : "A.2.6.1.2.1 - Device and implant description",
          "target" : [
            {
              "code" : "Device.text",
              "equivalence" : "relatedto",
              "comment" : "if referring to the description of the device"
            }
          ]
        },
        {
          "code" : "PatientHistory.medicalHistory.medicalDevices.identifier",
          "display" : "A.2.6.1.2.2 - Device ID",
          "target" : [
            {
              "code" : "Device.identifier",
              "equivalence" : "relatedto",
              "comment" : "if generic identifier"
            }
          ]
        },
        {
          "code" : "PatientHistory.medicalHistory.medicalDevices.identifier",
          "display" : "A.2.6.1.2.2 - Device ID",
          "target" : [
            {
              "code" : "Device.udiCarrier",
              "equivalence" : "relatedto",
              "comment" : "if it is the udiCarrier"
            }
          ]
        }
      ]
    },
    {
      "source" : "https://hl7.cz/fhir/cz-ems/StructureDefinition/PatientHistoryCz",
      "target" : "http://hl7.org/fhir/StructureDefinition/DeviceUseStatement",
      "element" : [
        {
          "code" : "PatientHistory.medicalHistory.medicalDevices.description",
          "display" : "A.2.6.1.2.1 - Device and implant description",
          "target" : [
            {
              "code" : "DeviceUseStatement.text",
              "equivalence" : "relatedto",
              "comment" : "if referring to the description of the usage of the device"
            }
          ]
        },
        {
          "code" : "PatientHistory.medicalHistory.medicalDevices.implantDate",
          "display" : "A.2.6.1.2.3 - Implant date",
          "target" : [
            {
              "code" : "DeviceUseStatement.timing[x]",
              "equivalence" : "relatedto",
              "comment" : "If the usage period is highlighted"
            }
          ]
        },
        {
          "code" : "PatientHistory.medicalHistory.medicalDevices.endDate",
          "display" : "A.2.6.1.2.4 - End date",
          "target" : [
            {
              "code" : "DeviceUseStatement.timingPeriod.end",
              "equivalence" : "relatedto"
            }
          ]
        },
        {
          "code" : "PatientHistory.medicalHistory.medicalDevices.reason",
          "display" : "A.2.6.1.2.5 - Reason",
          "target" : [
            {
              "code" : "DeviceUseStatement.reasonCode",
              "equivalence" : "relatedto",
              "comment" : "if details about the body structure have to be provided"
            }
          ]
        },
        {
          "code" : "PatientHistory.medicalHistory.medicalDevices.reason",
          "display" : "A.2.6.1.2.5 - Reason",
          "target" : [
            {
              "code" : "DeviceUseStatement.reasonReference",
              "equivalence" : "relatedto"
            }
          ]
        },
        {
          "code" : "PatientHistory.medicalHistory.historyOfProcedures",
          "display" : "A.2.6.1.3 - History of procedures",
          "target" : [
            {
              "code" : "Composition.section:sectionSignificantProcedures",
              "equivalence" : "relatedto",
              "comment" : "The same section usd by the hospital stay ?"
            }
          ]
        }
      ]
    },
    {
      "source" : "https://hl7.cz/fhir/cz-ems/StructureDefinition/PatientHistoryCz",
      "target" : "https://hl7.cz/fhir/cz-ems/StructureDefinition/cz-immunization-ems",
      "element" : [
        {
          "code" : "PatientHistory.medicalHistory.vaccination.diseaseOrAgent",
          "display" : "A.2.6.1.4.1 - Disease or agent targeted",
          "target" : [
            {
              "code" : "Immunization.protocolApplied.targetDisease",
              "equivalence" : "equivalent"
            }
          ]
        },
        {
          "code" : "PatientHistory.medicalHistory.vaccination.vaccine",
          "display" : "A.2.6.1.4.2 - Vaccine/prophylaxis",
          "target" : [
            {
              "code" : "Immunization.vaccineCode",
              "equivalence" : "relatedto"
            }
          ]
        },
        {
          "code" : "PatientHistory.medicalHistory.vaccination.productName",
          "display" : "A.2.6.1.4.4 - Vaccine medicinal product",
          "target" : [
            {
              "code" : "Immunization.extension:administeredProduct",
              "equivalence" : "relatedto"
            }
          ]
        },
        {
          "code" : "PatientHistory.medicalHistory.vaccination.manufacturerOrMAH",
          "display" : "A.2.6.1.4.5 - Marketing Authorisation Holder",
          "target" : [
            {
              "code" : "Immunization.manufacturer",
              "equivalence" : "relatedto"
            }
          ]
        },
        {
          "code" : "PatientHistory.medicalHistory.vaccination.orderNumber",
          "display" : "A.2.6.1.4.6 - Number in a series of vaccinations / doses",
          "target" : [
            {
              "code" : "Immunization.protocolApplied.doseNumberPositiveInt",
              "equivalence" : "relatedto"
            }
          ]
        },
        {
          "code" : "PatientHistory.medicalHistory.vaccination.vaccinationDate",
          "display" : "A.2.6.1.4.7 - Date of vaccination",
          "target" : [
            {
              "code" : "Immunization.occurenceDateTime",
              "equivalence" : "relatedto"
            }
          ]
        }
      ]
    },
    {
      "source" : "https://hl7.cz/fhir/cz-ems/StructureDefinition/PatientHistoryCz",
      "target" : "https://hl7.cz/fhir/cz-ems/StructureDefinition/cz-observation-sdoh-ems",
      "element" : [
        {
          "code" : "PatientHistory.socialDeterminants.participationInSociety",
          "display" : "A.2.6.3.1 - Participation in society",
          "target" : [
            {
              "code" : "Observation",
              "equivalence" : "relatedto",
              "comment" : "category to be defined"
            }
          ]
        },
        {
          "code" : "PatientHistory.socialDeterminants.participationInSociety.workSituation",
          "display" : "A.2.6.3.1.1 - Work situation",
          "target" : [
            {
              "code" : "Observation.value[x]",
              "equivalence" : "relatedto",
              "comment" : "category and code to be defined"
            }
          ]
        },
        {
          "code" : "PatientHistory.socialDeterminants.participationInSociety.hobby",
          "display" : "A.2.6.3.1.2 - Hobby",
          "target" : [
            {
              "code" : "Observation.value[x]",
              "equivalence" : "relatedto",
              "comment" : "category and code to be defined"
            }
          ]
        },
        {
          "code" : "PatientHistory.socialDeterminants.participationInSociety.socailNetwork",
          "display" : "A.2.6.3.1.3 - Social network",
          "target" : [
            {
              "code" : "Observation.value[x]",
              "equivalence" : "relatedto",
              "comment" : "category and code to be defined"
            }
          ]
        },
        {
          "code" : "PatientHistory.socialDeterminants.education",
          "display" : "A.2.6.3.2 - Education",
          "target" : [
            {
              "code" : "Observation",
              "equivalence" : "relatedto",
              "comment" : "category to be defined"
            }
          ]
        },
        {
          "code" : "PatientHistory.socialDeterminants.education.level",
          "display" : "A.2.6.3.2.1 - Education level",
          "target" : [
            {
              "code" : "Observation.value[x]",
              "equivalence" : "relatedto",
              "comment" : "category and code to be defined"
            }
          ]
        },
        {
          "code" : "PatientHistory.socialDeterminants.education.comment",
          "display" : "A.2.6.3.2.2 - Comment",
          "target" : [
            {
              "code" : "Observation.note",
              "equivalence" : "relatedto",
              "comment" : "category and code to be defined"
            }
          ]
        },
        {
          "code" : "PatientHistory.socialDeterminants.livingSituation",
          "display" : "A.2.6.3.3 - Living situation",
          "target" : [
            {
              "code" : "Observation",
              "equivalence" : "relatedto",
              "comment" : "category to be defined"
            }
          ]
        },
        {
          "code" : "PatientHistory.socialDeterminants.livingSituation.houseType",
          "display" : "A.2.6.3.3.1 - House type",
          "target" : [
            {
              "code" : "Observation.value[x]",
              "equivalence" : "relatedto",
              "comment" : "category and code to be defined"
            }
          ]
        },
        {
          "code" : "PatientHistory.socialDeterminants.livingSituation.homeAdaption",
          "display" : "A.2.6.3.3.2 - Home adaption",
          "target" : [
            {
              "code" : "Observation.value[x]",
              "equivalence" : "relatedto",
              "comment" : "category and code to be defined"
            }
          ]
        },
        {
          "code" : "PatientHistory.socialDeterminants.livingSituation.livingConditions",
          "display" : "A.2.6.3.3.3 - Living conditions",
          "target" : [
            {
              "code" : "Observation.value[x]",
              "equivalence" : "relatedto",
              "comment" : "category and code to be defined"
            }
          ]
        },
        {
          "code" : "PatientHistory.socialDeterminants.familySituation",
          "display" : "A.2.6.3.4 - Family situation",
          "target" : [
            {
              "code" : "Observation",
              "equivalence" : "relatedto",
              "comment" : "category to be defined"
            }
          ]
        },
        {
          "code" : "PatientHistory.socialDeterminants.familySituation.comment",
          "display" : "A.2.6.3.4.1 - Comment",
          "target" : [
            {
              "code" : "Observation.value[x]",
              "equivalence" : "relatedto",
              "comment" : "category and code to be defined"
            }
          ]
        },
        {
          "code" : "PatientHistory.socialDeterminants.familySituation.familyComposition",
          "display" : "A.2.6.3.4.2 - Family composition",
          "target" : [
            {
              "code" : "Observation.value[x]",
              "equivalence" : "relatedto",
              "comment" : "category and code to be defined"
            }
          ]
        },
        {
          "code" : "PatientHistory.socialDeterminants.familySituation.maritalStatus",
          "display" : "A.2.6.3.4.3 - Marital status",
          "target" : [
            {
              "code" : "Observation.value[x]",
              "equivalence" : "relatedto",
              "comment" : "category and code to be defined"
            }
          ]
        },
        {
          "code" : "PatientHistory.socialDeterminants.familySituation.numberOfChildren",
          "display" : "A.2.6.3.4.4 - Number of children",
          "target" : [
            {
              "code" : "Observation.value[x]",
              "equivalence" : "relatedto",
              "comment" : "category and code to be defined"
            }
          ]
        },
        {
          "code" : "PatientHistory.socialDeterminants.familySituation.numberOfChildrenAtHome",
          "display" : "A.2.6.3.4.5 - Number of children at home",
          "target" : [
            {
              "code" : "Observation.value[x]",
              "equivalence" : "relatedto",
              "comment" : "category and code to be defined"
            }
          ]
        },
        {
          "code" : "PatientHistory.socialDeterminants.familySituation.childDetails",
          "display" : "A.2.6.3.4.6 - Child details",
          "target" : [
            {
              "code" : "Observation.value[x]",
              "equivalence" : "relatedto",
              "comment" : "category and code to be defined"
            }
          ]
        },
        {
          "code" : "PatientHistory.socialDeterminants.familySituation.careResponsibility",
          "display" : "A.2.6.3.4.7 - Care responsibility",
          "target" : [
            {
              "code" : "Observation.value[x]",
              "equivalence" : "relatedto",
              "comment" : "category and code to be defined"
            }
          ]
        }
      ]
    },
    {
      "source" : "https://hl7.cz/fhir/cz-ems/StructureDefinition/PatientHistoryCz",
      "target" : "https://hl7.cz/fhir/cz-ems/StructureDefinition/cz-procedure-ems",
      "element" : [
        {
          "code" : "PatientHistory.medicalHistory.historyOfProcedures.procedureCode",
          "display" : "A.2.6.1.3.1 - Procedure code",
          "target" : [
            {
              "code" : "Procedure.code",
              "equivalence" : "relatedto"
            }
          ]
        },
        {
          "code" : "PatientHistory.medicalHistory.historyOfProcedures.description",
          "display" : "A.2.6.1.3.2 - Procedure description",
          "target" : [
            {
              "code" : "Procedure.text",
              "equivalence" : "relatedto"
            }
          ]
        },
        {
          "code" : "PatientHistory.medicalHistory.historyOfProcedures.bodySite",
          "display" : "A.2.6.1.3.3 - Body site",
          "target" : [
            {
              "code" : "Procedure.bodySite",
              "equivalence" : "relatedto"
            }
          ]
        },
        {
          "code" : "PatientHistory.medicalHistory.historyOfProcedures.bodySite",
          "display" : "A.2.6.1.3.3 - Body site",
          "target" : [
            {
              "code" : "Procedure.extension:bodySite",
              "equivalence" : "relatedto",
              "comment" : "if details about the body structure have to be provided"
            }
          ]
        },
        {
          "code" : "PatientHistory.medicalHistory.historyOfProcedures.date",
          "display" : "A.2.6.1.3.4 - Procedure date",
          "target" : [
            {
              "code" : "Procedure.perfomedDateTime",
              "equivalence" : "relatedto"
            }
          ]
        },
        {
          "code" : "PatientHistory.medicalHistory.historyOfProcedures.reason",
          "display" : "A.2.6.1.3.5 - Procedure reason",
          "target" : [
            {
              "code" : "Procedure.reasonCode",
              "equivalence" : "equivalent"
            }
          ]
        },
        {
          "code" : "PatientHistory.medicalHistory.historyOfProcedures.reason",
          "display" : "A.2.6.1.3.5 - Procedure reason",
          "target" : [
            {
              "code" : "Procedure.reasonReference",
              "equivalence" : "equivalent"
            }
          ]
        },
        {
          "code" : "PatientHistory.medicalHistory.historyOfProcedures.outcome",
          "display" : "A.2.6.1.3.6 - Outcome",
          "target" : [
            {
              "code" : "Procedure.outcome",
              "equivalence" : "equivalent"
            }
          ]
        },
        {
          "code" : "PatientHistory.medicalHistory.historyOfProcedures.focalDevice",
          "display" : "A.2.6.1.3.7 - Focal device",
          "target" : [
            {
              "code" : "Procedure.focalDevice",
              "equivalence" : "equivalent"
            }
          ]
        }
      ]
    },
    {
      "source" : "https://hl7.cz/fhir/cz-ems/StructureDefinition/PatientHistoryCz",
      "target" : "http://hl7.org/fhir/StructureDefinition/Observation",
      "element" : [
        {
          "code" : "PatientHistory.useOfSubstances.alcohol",
          "display" : "A.2.6.4.1 - Alcohol use",
          "target" : [
            {
              "code" : "Observation",
              "equivalence" : "relatedto",
              "comment" : "category and code to be defined"
            }
          ]
        },
        {
          "code" : "PatientHistory.useOfSubstances.alcohol.currentStatus",
          "display" : "A.2.6.4.1.1 - Status",
          "target" : [
            {
              "code" : "Observation.value[x]",
              "equivalence" : "relatedto",
              "comment" : "category and code to be defined"
            }
          ]
        },
        {
          "code" : "PatientHistory.useOfSubstances.alcohol.periodAndQuantity",
          "display" : "A.2.6.4.1.2 - Period and quantity",
          "target" : [
            {
              "code" : "Observation.value[x]",
              "equivalence" : "relatedto",
              "comment" : "category and code to be defined"
            }
          ]
        },
        {
          "code" : "PatientHistory.useOfSubstances.alcohol.comment",
          "display" : "A.2.6.4.1.3 - Comment",
          "target" : [
            {
              "code" : "Observation.note",
              "equivalence" : "relatedto",
              "comment" : "category and code to be defined"
            }
          ]
        },
        {
          "code" : "PatientHistory.useOfSubstances.tobacco",
          "display" : "A.2.6.4.2 - Tobacco use",
          "target" : [
            {
              "code" : "Observation",
              "equivalence" : "relatedto",
              "comment" : "category and code to be defined"
            }
          ]
        },
        {
          "code" : "PatientHistory.useOfSubstances.tobacco.currentStatus",
          "display" : "A.2.6.4.2.1 - Status",
          "target" : [
            {
              "code" : "Observation.value[x]",
              "equivalence" : "relatedto",
              "comment" : "category and code to be defined"
            }
          ]
        },
        {
          "code" : "PatientHistory.useOfSubstances.tobacco.periodAndQuantity",
          "display" : "A.2.6.4.2.2 - Period and quantity",
          "target" : [
            {
              "code" : "Observation.value[x]",
              "equivalence" : "relatedto",
              "comment" : "category and code to be defined"
            }
          ]
        },
        {
          "code" : "PatientHistory.useOfSubstances.tobacco.comment",
          "display" : "A.2.6.4.2.3 - Comment",
          "target" : [
            {
              "code" : "Observation.note",
              "equivalence" : "relatedto",
              "comment" : "category and code to be defined"
            }
          ]
        },
        {
          "code" : "PatientHistory.useOfSubstances.drugConsumption",
          "display" : "A.2.6.4.3 - Drug consumption",
          "target" : [
            {
              "code" : "Observation",
              "equivalence" : "relatedto",
              "comment" : "category and code to be defined"
            }
          ]
        },
        {
          "code" : "PatientHistory.useOfSubstances.drugConsumption.currentStatus",
          "display" : "A.2.6.4.3.1 - Status",
          "target" : [
            {
              "code" : "Observation.value[x]",
              "equivalence" : "relatedto",
              "comment" : "category and code to be defined"
            }
          ]
        },
        {
          "code" : "PatientHistory.useOfSubstances.drugConsumption.periodAndQuantity",
          "display" : "A.2.6.4.3.2 - Period and quantity",
          "target" : [
            {
              "code" : "Observation.value[x]",
              "equivalence" : "relatedto",
              "comment" : "category and code to be defined"
            }
          ]
        },
        {
          "code" : "PatientHistory.useOfSubstances.drugConsumption.drugType",
          "display" : "A.2.6.4.3.3 - Drug or medication type",
          "target" : [
            {
              "code" : "Observation",
              "equivalence" : "relatedto",
              "comment" : "category and code to be defined"
            }
          ]
        },
        {
          "code" : "PatientHistory.useOfSubstances.drugConsumption.route",
          "display" : "A.2.6.4.3.4 - Route of administration",
          "target" : [
            {
              "code" : "Observation.value[x]",
              "equivalence" : "relatedto",
              "comment" : "category and code to be defined"
            }
          ]
        },
        {
          "code" : "PatientHistory.useOfSubstances.drugConsumption.comment",
          "display" : "A.2.6.4.3.5 - Comment",
          "target" : [
            {
              "code" : "Observation.note",
              "equivalence" : "relatedto",
              "comment" : "category and code to be defined"
            }
          ]
        }
      ]
    },
    {
      "source" : "https://hl7.cz/fhir/cz-ems/StructureDefinition/PatientHistoryCz",
      "target" : "http://hl7.org/fhir/StructureDefinition/FamilyMemberHistory",
      "element" : [
        {
          "code" : "PatientHistory.familyHistory.relationship",
          "display" : "A.2.6.2.1 - Patient relationship",
          "target" : [
            {
              "code" : "FamilyMemberHistory.relationship",
              "equivalence" : "equivalent"
            }
          ]
        },
        {
          "code" : "PatientHistory.familyHistory.birthDate",
          "display" : "A.2.6.2.2 - Date of birth",
          "target" : [
            {
              "code" : "FamilyMemberHistory.bornDate",
              "equivalence" : "equivalent"
            }
          ]
        },
        {
          "code" : "PatientHistory.familyHistory.deathDateOrAge",
          "display" : "A.2.6.2.3 - Age or date of death",
          "target" : [
            {
              "code" : "FamilyMemberHistory.deceased[x]",
              "equivalence" : "equivalent"
            }
          ]
        },
        {
          "code" : "PatientHistory.familyHistory.conditions",
          "display" : "A.2.6.2.5 - Condition",
          "target" : [
            {
              "code" : "FamilyMemberHistory.condition.code",
              "equivalence" : "equivalent"
            }
          ]
        },
        {
          "code" : "PatientHistory.familyHistory.causeOfDeath",
          "display" : "A.2.6.2.6 - Cause of death",
          "target" : [
            {
              "code" : "FamilyMemberHistory.condition.code",
              "equivalence" : "equivalent",
              "comment" : "If FamilyMemberHistory.condition.contributedToDeath is true"
            }
          ]
        }
      ]
    },
    {
      "source" : "https://hl7.cz/fhir/cz-ems/StructureDefinition/PatientHistoryCz",
      "target" : "https://hl7.cz/fhir/cz-ems/StructureDefinition/cz-observation-infectious-contact-ems",
      "element" : [
        {
          "code" : "PatientHistory.medicalHistory.epidemiologicalHistory.infectiousContacts.period",
          "display" : "A.2.6.1.5.1.1 - Time period",
          "target" : [
            {
              "code" : "Observation.effective[x]",
              "equivalence" : "equivalent"
            }
          ]
        },
        {
          "code" : "PatientHistory.medicalHistory.epidemiologicalHistory.infectiousContacts.infectiousAgent",
          "display" : "A.2.6.1.5.1.2 - Infectious agent",
          "target" : [
            {
              "code" : "Observation.valueCodeableConcept",
              "equivalence" : "equivalent",
              "comment" : "In the current value set the disease is indicated"
            }
          ]
        },
        {
          "code" : "PatientHistory.medicalHistory.epidemiologicalHistory.infectiousContacts.proximity",
          "display" : "A.2.6.1.5.1.3 - Proximity",
          "target" : [
            {
              "code" : "Composition.section:infectiousContacts",
              "equivalence" : "relatedto",
              "comment" : "in this version as textual description"
            }
          ]
        },
        {
          "code" : "PatientHistory.medicalHistory.epidemiologicalHistory.infectiousContacts.country",
          "display" : "A.2.6.1.5.1.4 - Country",
          "target" : [
            {
              "code" : "Composition.section:infectiousContacts",
              "equivalence" : "relatedto",
              "comment" : "in this version as textual description"
            }
          ]
        },
        {
          "code" : "PatientHistory.medicalHistory.epidemiologicalHistory.infectiousContacts.note",
          "display" : "A.2.6.1.5.1.5 - Additional information",
          "target" : [
            {
              "code" : "Observation.note",
              "equivalence" : "equivalent"
            }
          ]
        }
      ]
    }
  ]
}

```
