# CZ Therapy Model to this guide Map - HL7 Czech EMS Implementation Guide v0.0.2

* [**Table of Contents**](toc.md)
* [**Artifacts**](artifacts.md)
* **CZ Therapy Model to this guide Map**

## ConceptMap: CZ Therapy Model to this guide Map (Experimental) 

| | |
| :--- | :--- |
| *Official URL*:https://hl7.cz/fhir/cz-ems/ConceptMap/Therapy2FHIR-cz | *Version*:0.0.2 |
| Draft as of 2025-10-14 | *Computable Name*:Therapy2FHIRcz |

 
CZ EMS Report Therapy Model to this guide mapping 

Mapping from (not specified) to (not specified)

**Group 1**Mapping from [A.2.7 - Therapy](StructureDefinition-TherapyEmsCz.md) to [Procedure: EMS Report (CZ)](StructureDefinition-cz-procedure-ems.md)

* **Source Code**: TherapyEmsCz.Procedure (A.2.7.1 Procedures)
  * **Relationship**: [is related to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#relatedto)
  * **Target Code**: Composition.section:procedure
  * **Comment**: Composition.section:procedure.entry.ofType(CZ_ProcedureEms)
* **Source Code**: Procedure.name (A.2.7.1.1 Procedure name)
  * **Relationship**: [is equivalent to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#equivalent)
  * **Target Code**: CZ_ProcedureEms.code.text
  * **Comment**: 
* **Source Code**: Procedure.date (A.2.7.1.2 Date and time of performance)
  * **Relationship**: [is equivalent to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#equivalent)
  * **Target Code**: CZ_ProcedureEms.performedDateTime
  * **Comment**: 
* **Source Code**: Procedure.medicalDevices (A.2.7.2 Medical devices)
  * **Relationship**: [is equivalent to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#equivalent)
  * **Target Code**: CZ_ProcedureEms.usedReference (CZ_ProcedureEms.usedReference.ofType(CZ_MedicalDevice))
  * **Comment**: 
* **Source Code**: Procedure.medication (A.2.7.3 Medication)
  * **Relationship**: [is equivalent to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#equivalent)
  * **Target Code**: CZ_ProcedureEms.usedReference (CZ_ProcedureEms.usedReference.ofType(CZ_MedicationAdministration))
  * **Comment**: 

-------

**Group 2**Mapping from [A.2.7 - Therapy](StructureDefinition-TherapyEmsCz.md) to `https://hl7.cz/fhir/core/StructureDefinition/cz-medical-device`

* **Source Code**: TherapyEmsCz.MedicalDevices (A.2.7.2 Medical devices)
  * **Relationship**: [is related to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#relatedto)
  * **Target Code**: CZ_ProcedureEms.usedReference
  * **Comment**: CZ_ProcedureEms.usedReference.ofType(CZ_MedicationDevice)
* **Source Code**: MedicalDevices.description (A.2.7.2.1 Description of the medical device)
  * **Relationship**: [is equivalent to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#equivalent)
  * **Target Code**: Device.text
  * **Comment**: 
* **Source Code**: MedicalDevices.id (A.2.7.2.2 Device identifier)
  * **Relationship**: [is equivalent to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#equivalent)
  * **Target Code**: Device.id
  * **Comment**: 

-------

**Group 3**Mapping from `https://hl7.cz/fhir/cz-ems/StructureDefinition/ReportOfImagingMethod` to [Medication Administration: EMS Report (CZ)](StructureDefinition-cz-MedicationAdministration.md)

* **Source Code**: TherapyEmsCz.Medication (A.2.7.3 Medication)
  * **Relationship**: [is related to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#relatedto)
  * **Target Code**: CZ_ProcedureEms.usedReference
  * **Comment**: CZ_ProcedureEms.usedReference.ofType(CZ_MedicationAdministration)
* **Source Code**: Medication.codeSUKL (A.2.7.3.1 SUKL Code)
  * **Relationship**: [is equivalent to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#equivalent)
  * **Target Code**: CZ_MedicationAdministration.medication.code
  * **Comment**: 
* **Source Code**: Medication.medicinalProductName (AA.2.7.3.2 Name of the medicinal product)
  * **Relationship**: [is equivalent to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#equivalent)
  * **Target Code**: CZ_MedicationAdministration.medication.code.text
  * **Comment**: 
* **Source Code**: Medication.groupATC (A.2.7.3.3 ATC group)
  * **Relationship**: [is equivalent to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#equivalent)
  * **Target Code**: CZ_MedicationAdministration.Medication[x].code (Additional Bindings to DLP ATC)
  * **Comment**: 
* **Source Code**: Medication.activeSubstances (A.2.7.3.4 Active substances)
  * **Relationship**: [is equivalent to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#equivalent)
  * **Target Code**: CZ_MedicationAdministration.Medication[x].item[x]:itemCodeableConcept
  * **Comment**: 
* **Source Code**: Medication.strength (A.2.7.3.5 Strength)
  * **Relationship**: [is equivalent to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#equivalent)
  * **Target Code**: CZ_MedicationAdministration.Medication[x].ingredient.strength
  * **Comment**: 
* **Source Code**: Medication.medicinalForm (A.2.7.3.6 Form of the medicinal product)
  * **Relationship**: [is equivalent to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#equivalent)
  * **Target Code**: CZ_MedicationAdministration.Medication[x].form
  * **Comment**: 
* **Source Code**: Medication.administeredQuantity (A.2.7.3.7 Dosage)
  * **Relationship**: [is equivalent to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#equivalent)
  * **Target Code**: CZ_MedicationAdministration.dosage.dose
  * **Comment**: 
* **Source Code**: Medication.routeOfAdministration (A.2.7.3.8 Route of administration)
  * **Relationship**: [is equivalent to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#equivalent)
  * **Target Code**: CZ_MedicationAdministration.dosage.route
  * **Comment**: 
* **Source Code**: Medication.dateOfAdministration (A.2.4.7.6 - Start date and time)
  * **Relationship**: [is equivalent to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#equivalent)
  * **Target Code**: CZ_MedicationAdministration.effectiveDateTime
  * **Comment**: 



## Resource Content

```json
{
  "resourceType" : "ConceptMap",
  "id" : "Therapy2FHIR-cz",
  "url" : "https://hl7.cz/fhir/cz-ems/ConceptMap/Therapy2FHIR-cz",
  "version" : "0.0.2",
  "name" : "Therapy2FHIRcz",
  "title" : "CZ Therapy Model to this guide Map",
  "status" : "draft",
  "experimental" : true,
  "date" : "2025-10-14T13:52:10+00:00",
  "publisher" : "HL7 Czech Republic",
  "contact" : [
    {
      "name" : "HL7 Czech Republic",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.hl7.cz/"
        }
      ]
    }
  ],
  "description" : "CZ EMS Report Therapy Model to this guide mapping",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "CZ",
          "display" : "Czechia"
        }
      ]
    }
  ],
  "group" : [
    {
      "source" : "https://hl7.cz/fhir/cz-ems/StructureDefinition/TherapyEmsCz",
      "target" : "https://hl7.cz/fhir/cz-ems/StructureDefinition/cz-procedure-ems",
      "element" : [
        {
          "code" : "TherapyEmsCz.Procedure",
          "display" : "A.2.7.1 Procedures",
          "target" : [
            {
              "code" : "Composition.section:procedure",
              "equivalence" : "relatedto",
              "comment" : "Composition.section:procedure.entry.ofType(CZ_ProcedureEms)"
            }
          ]
        },
        {
          "code" : "Procedure.name",
          "display" : "A.2.7.1.1 Procedure name",
          "target" : [
            {
              "code" : "CZ_ProcedureEms.code.text",
              "equivalence" : "equivalent"
            }
          ]
        },
        {
          "code" : "Procedure.date",
          "display" : "A.2.7.1.2 Date and time of performance",
          "target" : [
            {
              "code" : "CZ_ProcedureEms.performedDateTime",
              "equivalence" : "equivalent"
            }
          ]
        },
        {
          "code" : "Procedure.medicalDevices",
          "display" : "A.2.7.2 Medical devices",
          "target" : [
            {
              "code" : "CZ_ProcedureEms.usedReference",
              "display" : "CZ_ProcedureEms.usedReference.ofType(CZ_MedicalDevice)",
              "equivalence" : "equivalent"
            }
          ]
        },
        {
          "code" : "Procedure.medication",
          "display" : "A.2.7.3 Medication",
          "target" : [
            {
              "code" : "CZ_ProcedureEms.usedReference",
              "display" : "CZ_ProcedureEms.usedReference.ofType(CZ_MedicationAdministration)",
              "equivalence" : "equivalent"
            }
          ]
        }
      ]
    },
    {
      "source" : "https://hl7.cz/fhir/cz-ems/StructureDefinition/TherapyEmsCz",
      "target" : "https://hl7.cz/fhir/core/StructureDefinition/cz-medical-device",
      "element" : [
        {
          "code" : "TherapyEmsCz.MedicalDevices",
          "display" : "A.2.7.2 Medical devices",
          "target" : [
            {
              "code" : "CZ_ProcedureEms.usedReference",
              "equivalence" : "relatedto",
              "comment" : "CZ_ProcedureEms.usedReference.ofType(CZ_MedicationDevice)"
            }
          ]
        },
        {
          "code" : "MedicalDevices.description",
          "display" : "A.2.7.2.1 Description of the medical device",
          "target" : [
            {
              "code" : "Device.text",
              "equivalence" : "equivalent"
            }
          ]
        },
        {
          "code" : "MedicalDevices.id",
          "display" : "A.2.7.2.2 Device identifier",
          "target" : [
            {
              "code" : "Device.id",
              "equivalence" : "equivalent"
            }
          ]
        }
      ]
    },
    {
      "source" : "https://hl7.cz/fhir/cz-ems/StructureDefinition/ReportOfImagingMethod",
      "target" : "https://hl7.cz/fhir/cz-ems/StructureDefinition/cz-MedicationAdministration",
      "element" : [
        {
          "code" : "TherapyEmsCz.Medication",
          "display" : "A.2.7.3 Medication",
          "target" : [
            {
              "code" : "CZ_ProcedureEms.usedReference",
              "equivalence" : "relatedto",
              "comment" : "CZ_ProcedureEms.usedReference.ofType(CZ_MedicationAdministration)"
            }
          ]
        },
        {
          "code" : "Medication.codeSUKL",
          "display" : "A.2.7.3.1 SUKL Code",
          "target" : [
            {
              "code" : "CZ_MedicationAdministration.medication.code",
              "equivalence" : "equivalent"
            }
          ]
        },
        {
          "code" : "Medication.medicinalProductName",
          "display" : "AA.2.7.3.2 Name of the medicinal product",
          "target" : [
            {
              "code" : "CZ_MedicationAdministration.medication.code.text",
              "equivalence" : "equivalent"
            }
          ]
        },
        {
          "code" : "Medication.groupATC",
          "display" : "A.2.7.3.3 ATC group",
          "target" : [
            {
              "code" : "CZ_MedicationAdministration.Medication[x].code",
              "display" : "Additional Bindings to DLP ATC",
              "equivalence" : "equivalent"
            }
          ]
        },
        {
          "code" : "Medication.activeSubstances",
          "display" : "A.2.7.3.4 Active substances",
          "target" : [
            {
              "code" : "CZ_MedicationAdministration.Medication[x].item[x]:itemCodeableConcept",
              "equivalence" : "equivalent"
            }
          ]
        },
        {
          "code" : "Medication.strength",
          "display" : "A.2.7.3.5 Strength",
          "target" : [
            {
              "code" : "CZ_MedicationAdministration.Medication[x].ingredient.strength",
              "equivalence" : "equivalent"
            }
          ]
        },
        {
          "code" : "Medication.medicinalForm",
          "display" : "A.2.7.3.6 Form of the medicinal product",
          "target" : [
            {
              "code" : "CZ_MedicationAdministration.Medication[x].form",
              "equivalence" : "equivalent"
            }
          ]
        },
        {
          "code" : "Medication.administeredQuantity",
          "display" : "A.2.7.3.7 Dosage",
          "target" : [
            {
              "code" : "CZ_MedicationAdministration.dosage.dose",
              "equivalence" : "equivalent"
            }
          ]
        },
        {
          "code" : "Medication.routeOfAdministration",
          "display" : "A.2.7.3.8 Route of administration",
          "target" : [
            {
              "code" : "CZ_MedicationAdministration.dosage.route",
              "equivalence" : "equivalent"
            }
          ]
        },
        {
          "code" : "Medication.dateOfAdministration",
          "display" : "A.2.4.7.6 - Start date and time",
          "target" : [
            {
              "code" : "CZ_MedicationAdministration.effectiveDateTime",
              "equivalence" : "equivalent"
            }
          ]
        }
      ]
    }
  ]
}

```
