# CZ DispatchData Model to this guide Map - HL7 Czech EMS Implementation Guide v0.0.2

* [**Table of Contents**](toc.md)
* [**Artifacts**](artifacts.md)
* **CZ DispatchData Model to this guide Map**

## ConceptMap: CZ DispatchData Model to this guide Map (Experimental) 

| | |
| :--- | :--- |
| *Official URL*:https://hl7.cz/fhir/cz-ems/ConceptMap/DispatchDataEMS2FHIR-cz | *Version*:0.0.2 |
| Draft as of 2025-10-14 | *Computable Name*:A.2.1 DispatchDataEMS2FHIRcz |

 
CZ Emergency Medical Service Report DispatchData Model to this guide mapping 

Mapping from (not specified) to (not specified)

**Group 1**Mapping from [A.2.1 - Dispatch Data (en)](StructureDefinition-DispatchDataCz.md) to [Composition (EMS CZ)](StructureDefinition-cz-composition-ems.md)

* **Source Code**: DispatchDataCz.Section (A.2.1 Dispatch Data (section))
  * **Relationship**: [is related to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#relatedto)
  * **Target Code**: Composition.section:dispatchData (Composition.section slice 'dispatchData')
  * **Comment**: Composition.section:dispatchData.entry agreguje níže uvedené zdroje (Task, Location, CareTeam, Practitioner/Role, Communication)

-------

**Group 2**Mapping from [A.2.1 - Dispatch Data (en)](StructureDefinition-DispatchDataCz.md) to [Task: (EMS CZ)](StructureDefinition-cz-task-ems.md)

* **Source Code**: DispatchDataCz.DispatchIdentification (A.2.1.1 Dispatch Identification)
  * **Relationship**: [is related to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#relatedto)
  * **Target Code**: Composition.section:dispatchData
  * **Comment**: Composition.section:dispatchData.entry.ofType(CZ_TaskEms)
* **Source Code**: dispatchNumber (A.2.1.1.1 - Dispatch Identifieraaa)
  * **Relationship**: [is related to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#relatedto)
  * **Target Code**: Task.identifier[dispatchNumber].value (identifier (slice: dispatchNumber).value)
  * **Comment**: 
* **Source Code**: additionalDispatchIdentifier (A.2.1.1.2 - Additional Dispatch Identifier)
  * **Relationship**: [is related to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#relatedto)
  * **Target Code**: Task.identifier[otherId].value (identifier (slice: otherId).value)
  * **Comment**: 
* **Source Code**: dispatchUrgency (A.2.1.7.1 - Dispatch Urgency)
  * **Relationship**: [is related to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#relatedto)
  * **Target Code**: Task.extension[urgencyLevel].valueCodeableConcept (extension (slice: urgencyLevel).valueCodeableConcept)
  * **Comment**: 
* **Source Code**: callClassification (A.2.1.7.2 - Call Classification)
  * **Relationship**: [is related to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#relatedto)
  * **Target Code**: Task.reasonCode (reasonCode)
  * **Comment**: 

-------

**Group 3**Mapping from [A.2.1 - Dispatch Data (en)](StructureDefinition-DispatchDataCz.md) to [Location - Vehicle: (EMS CZ)](StructureDefinition-cz-vehicle-location-ems.md)

* **Source Code**: vehicleIdentification (A.2.1.2 Vehicle Identification)
  * **Relationship**: [is related to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#relatedto)
  * **Target Code**: Composition.section:dispatchData
  * **Comment**: Composition.section:dispatchData.entry.ofType(CZ_VehicleLocationEms)
* **Source Code**: licensePlate (A.2.1.2.1 - License Plate)
  * **Relationship**: [is related to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#relatedto)
  * **Target Code**: Location.identifier (License Plate)
  * **Comment**: 

-------

**Group 4**Mapping from [A.2.1 - Dispatch Data (en)](StructureDefinition-DispatchDataCz.md) to [Location: (EMS CZ)](StructureDefinition-cz-location-ems.md)

* **Source Code**: dispatchStartLocation (A.2.1.5 Dispatch Start Location)
  * **Relationship**: [is related to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#relatedto)
  * **Target Code**: Composition.section:dispatchData
  * **Comment**: Composition.section:dispatchData.entry.ofType(CZ_LocationEms)
* **Source Code**: address (A.2.1.5.1 - Address)
  * **Relationship**: [is related to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#relatedto)
  * **Target Code**: Location.address (Address)
  * **Comment**: 

-------

**Group 5**Mapping from [A.2.1 - Dispatch Data (en)](StructureDefinition-DispatchDataCz.md) to [Location: (EMS CZ)](StructureDefinition-cz-location-ems.md)

* **Source Code**: incidentLocation (A.2.1.6 Incident Location)
  * **Relationship**: [is related to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#relatedto)
  * **Target Code**: Composition.section:dispatchData
  * **Comment**: Composition.section:dispatchData.entry.ofType(CZ_LocationEms)
* **Source Code**: gpsAddress (A.2.1.6.1 - GPS Address)
  * **Relationship**: [is related to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#relatedto)
  * **Target Code**: Location.position (GPS Address)
  * **Comment**: 
* **Source Code**: address (A.2.1.6.2 - Address)
  * **Relationship**: [is related to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#relatedto)
  * **Target Code**: Location.address (Address)
  * **Comment**: 

-------

**Group 6**Mapping from [A.2.1 - Dispatch Data (en)](StructureDefinition-DispatchDataCz.md) to [CareTeam: (EMS CZ)](StructureDefinition-cz-careteam-ems.md)

* **Source Code**: crewMemberIdentification (A.2.1.3 Crew Member Identification)
  * **Relationship**: [is related to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#relatedto)
  * **Target Code**: Composition.section:dispatchData
  * **Comment**: Composition.section:dispatchData.entry.ofType(CZ_CareTeamEms)
* **Source Code**: crewMemberIdentifier (A.2.1.3.1 - Crew Member Identifier)
  * **Relationship**: [is related to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#relatedto)
  * **Target Code**: CareTeam.participant.member.identifier (Crew Member Identifier)
  * **Comment**: 

-------

**Group 7**Mapping from [A.2.1 - Dispatch Data (en)](StructureDefinition-DispatchDataCz.md) to `https://hl7.cz/fhir/core/StructureDefinition/cz-practitioner-core`

* **Source Code**: crewMemberIdentification (A.2.1.3 - Crew Member Identification)
  * **Relationship**: [is related to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#relatedto)
  * **Target Code**: Composition.section:dispatchData
  * **Comment**: Composition.section:dispatchData.entry.ofType(CZ_PractitionerCore)
* **Source Code**: crewMemberIdentifier (A.2.1.3.1 - Crew Member Identifier)
  * **Relationship**: [is related to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#relatedto)
  * **Target Code**: Practitioner.identifier (Crew Member Identifier)
  * **Comment**: 
* **Source Code**: firstName (A.2.1.3.2 - First Name)
  * **Relationship**: [is related to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#relatedto)
  * **Target Code**: Practitioner.name.given (First Name)
  * **Comment**: 
* **Source Code**: lastName (A.2.1.3.3 - Last Name)
  * **Relationship**: [is related to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#relatedto)
  * **Target Code**: Practitioner.name.family (Last Name)
  * **Comment**: 

-------

**Group 8**Mapping from [A.2.1 - Dispatch Data (en)](StructureDefinition-DispatchDataCz.md) to `https://hl7.cz/fhir/core/StructureDefinition/cz-practitionerrole-core`

* **Source Code**: role (A.2.1.3.4 Role)
  * **Relationship**: [is related to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#relatedto)
  * **Target Code**: Composition.section:dispatchData
  * **Comment**: Composition.section:dispatchData.entry.ofType(CZ_PractitionerRoleCore)
* **Source Code**: role (A.2.1.3.4 - Role)
  * **Relationship**: [is related to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#relatedto)
  * **Target Code**: PractitionerRole.code (Role)
  * **Comment**: 

-------

**Group 9**Mapping from [A.2.1 - Dispatch Data (en)](StructureDefinition-DispatchDataCz.md) to [Communication: (EMS CZ)](StructureDefinition-cz-communication-ems.md)

* **Source Code**: dispatchCenterOperator (A.2.1.4 Dispatch Center Operator Identification)
  * **Relationship**: [is related to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#relatedto)
  * **Target Code**: Composition.section:dispatchData
  * **Comment**: Composition.section:dispatchData.entry.ofType(CZ_CommunicationEms)
* **Source Code**: dispatchCenterOperator (A.2.1.4 - Dispatch Center Operator Identification)
  * **Relationship**: [is related to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#relatedto)
  * **Target Code**: Communication.recipient (Dispatch Center Operator Identification)
  * **Comment**: 
* **Source Code**: callerContact (A.2.1.8 - Caller Contact)
  * **Relationship**: [is related to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#relatedto)
  * **Target Code**: Communication.sender (sender (RelatedPerson))
  * **Comment**: Communication.sender should reference RelatedPerson

-------

**Group 10**Mapping from [A.2.1 - Dispatch Data (en)](StructureDefinition-DispatchDataCz.md) to `https://hl7.cz/fhir/core/StructureDefinition/cz-practitioner-core`

* **Source Code**: operatorIdentifier (A.2.1.4.1 Operator Identifier)
  * **Relationship**: [is related to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#relatedto)
  * **Target Code**: Composition.section:dispatchData
  * **Comment**: Composition.section:dispatchData.entry.ofType(CZ_PractitionerCore)
* **Source Code**: operatorIdentifier (A.2.1.4.1 - Operator Identifier)
  * **Relationship**: [is related to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#relatedto)
  * **Target Code**: Practitioner.identifier (Operator Identifier)
  * **Comment**: 
* **Source Code**: firstName (A.2.1.4.2 - First Name)
  * **Relationship**: [is related to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#relatedto)
  * **Target Code**: Practitioner.name.given (First Name)
  * **Comment**: 
* **Source Code**: lastName (A.2.1.4.3 - Last Name)
  * **Relationship**: [is related to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#relatedto)
  * **Target Code**: Practitioner.name.family (Last Name)
  * **Comment**: 

-------

**Group 11**Mapping from [A.2.1 - Dispatch Data (en)](StructureDefinition-DispatchDataCz.md) to `https://hl7.cz/fhir/core/StructureDefinition/cz-practitionerrole-core`

* **Source Code**: role (A.2.1.4.4 Role)
  * **Relationship**: [is related to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#relatedto)
  * **Target Code**: Composition.section:dispatchData
  * **Comment**: Composition.section:dispatchData.entry.ofType(CZ_PractitionerRoleCore)
* **Source Code**: role (A.2.1.4.4 - Role)
  * **Relationship**: [is related to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#relatedto)
  * **Target Code**: PractitionerRole.code (Role)
  * **Comment**: 

-------

**Group 12**Mapping from [A.2.1 - Dispatch Data (en)](StructureDefinition-DispatchDataCz.md) to [RelatedPerson](http://hl7.org/fhir/R4/relatedperson.html)

* **Source Code**: callerContact (A.2.1.8 - Caller Contact)
  * **Relationship**: [is related to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#relatedto)
  * **Target Code**: Composition.section:dispatchData (Composition.section:dispatchData.entry.ofType(RelatedPerson))
  * **Comment**: Composition.section:dispatchData.entry should reference RelatedPerson
* **Source Code**: phone (A.2.1.8.1 - Phone)
  * **Relationship**: [is related to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#relatedto)
  * **Target Code**: RelatedPerson.telecom (Phone number of the caller)
  * **Comment**: 



## Resource Content

```json
{
  "resourceType" : "ConceptMap",
  "id" : "DispatchDataEMS2FHIR-cz",
  "url" : "https://hl7.cz/fhir/cz-ems/ConceptMap/DispatchDataEMS2FHIR-cz",
  "version" : "0.0.2",
  "name" : "A.2.1 DispatchDataEMS2FHIRcz",
  "title" : "CZ DispatchData Model to this guide Map",
  "status" : "draft",
  "experimental" : true,
  "date" : "2025-10-14T13:52:10+00:00",
  "publisher" : "HL7 Czech Republic",
  "contact" : [
    {
      "name" : "HL7 Czech Republic",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.hl7.cz/"
        }
      ]
    }
  ],
  "description" : "CZ Emergency Medical Service Report DispatchData Model to this guide mapping",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "CZ",
          "display" : "Czechia"
        }
      ]
    }
  ],
  "group" : [
    {
      "source" : "https://hl7.cz/fhir/cz-ems/StructureDefinition/DispatchDataCz",
      "target" : "https://hl7.cz/fhir/cz-ems/StructureDefinition/cz-composition-ems",
      "element" : [
        {
          "code" : "DispatchDataCz.Section",
          "display" : "A.2.1 Dispatch Data (section)",
          "target" : [
            {
              "code" : "Composition.section:dispatchData",
              "display" : "Composition.section slice 'dispatchData'",
              "equivalence" : "relatedto",
              "comment" : "Composition.section:dispatchData.entry agreguje níže uvedené zdroje (Task, Location, CareTeam, Practitioner/Role, Communication)"
            }
          ]
        }
      ]
    },
    {
      "source" : "https://hl7.cz/fhir/cz-ems/StructureDefinition/DispatchDataCz",
      "target" : "https://hl7.cz/fhir/cz-ems/StructureDefinition/cz-task-ems",
      "element" : [
        {
          "code" : "DispatchDataCz.DispatchIdentification",
          "display" : "A.2.1.1 Dispatch Identification",
          "target" : [
            {
              "code" : "Composition.section:dispatchData",
              "equivalence" : "relatedto",
              "comment" : "Composition.section:dispatchData.entry.ofType(CZ_TaskEms)"
            }
          ]
        },
        {
          "code" : "dispatchNumber",
          "display" : "A.2.1.1.1 - Dispatch Identifieraaa",
          "target" : [
            {
              "code" : "Task.identifier[dispatchNumber].value",
              "display" : "identifier (slice: dispatchNumber).value",
              "equivalence" : "relatedto"
            }
          ]
        },
        {
          "code" : "additionalDispatchIdentifier",
          "display" : "A.2.1.1.2 - Additional Dispatch Identifier",
          "target" : [
            {
              "code" : "Task.identifier[otherId].value",
              "display" : "identifier (slice: otherId).value",
              "equivalence" : "relatedto"
            }
          ]
        },
        {
          "code" : "dispatchUrgency",
          "display" : "A.2.1.7.1 - Dispatch Urgency",
          "target" : [
            {
              "code" : "Task.extension[urgencyLevel].valueCodeableConcept",
              "display" : "extension (slice: urgencyLevel).valueCodeableConcept",
              "equivalence" : "relatedto"
            }
          ]
        },
        {
          "code" : "callClassification",
          "display" : "A.2.1.7.2 - Call Classification",
          "target" : [
            {
              "code" : "Task.reasonCode",
              "display" : "reasonCode",
              "equivalence" : "relatedto"
            }
          ]
        }
      ]
    },
    {
      "source" : "https://hl7.cz/fhir/cz-ems/StructureDefinition/DispatchDataCz",
      "target" : "https://hl7.cz/fhir/cz-ems/StructureDefinition/cz-vehicle-location-ems",
      "element" : [
        {
          "code" : "vehicleIdentification",
          "display" : "A.2.1.2 Vehicle Identification",
          "target" : [
            {
              "code" : "Composition.section:dispatchData",
              "equivalence" : "relatedto",
              "comment" : "Composition.section:dispatchData.entry.ofType(CZ_VehicleLocationEms)"
            }
          ]
        },
        {
          "code" : "licensePlate",
          "display" : "A.2.1.2.1 - License Plate",
          "target" : [
            {
              "code" : "Location.identifier",
              "display" : "License Plate",
              "equivalence" : "relatedto"
            }
          ]
        }
      ]
    },
    {
      "source" : "https://hl7.cz/fhir/cz-ems/StructureDefinition/DispatchDataCz",
      "target" : "https://hl7.cz/fhir/cz-ems/StructureDefinition/cz-location-ems",
      "element" : [
        {
          "code" : "dispatchStartLocation",
          "display" : "A.2.1.5 Dispatch Start Location",
          "target" : [
            {
              "code" : "Composition.section:dispatchData",
              "equivalence" : "relatedto",
              "comment" : "Composition.section:dispatchData.entry.ofType(CZ_LocationEms)"
            }
          ]
        },
        {
          "code" : "address",
          "display" : "A.2.1.5.1 - Address",
          "target" : [
            {
              "code" : "Location.address",
              "display" : "Address",
              "equivalence" : "relatedto"
            }
          ]
        }
      ]
    },
    {
      "source" : "https://hl7.cz/fhir/cz-ems/StructureDefinition/DispatchDataCz",
      "target" : "https://hl7.cz/fhir/cz-ems/StructureDefinition/cz-location-ems",
      "element" : [
        {
          "code" : "incidentLocation",
          "display" : "A.2.1.6 Incident Location",
          "target" : [
            {
              "code" : "Composition.section:dispatchData",
              "equivalence" : "relatedto",
              "comment" : "Composition.section:dispatchData.entry.ofType(CZ_LocationEms)"
            }
          ]
        },
        {
          "code" : "gpsAddress",
          "display" : "A.2.1.6.1 - GPS Address",
          "target" : [
            {
              "code" : "Location.position",
              "display" : "GPS Address",
              "equivalence" : "relatedto"
            }
          ]
        },
        {
          "code" : "address",
          "display" : "A.2.1.6.2 - Address",
          "target" : [
            {
              "code" : "Location.address",
              "display" : "Address",
              "equivalence" : "relatedto"
            }
          ]
        }
      ]
    },
    {
      "source" : "https://hl7.cz/fhir/cz-ems/StructureDefinition/DispatchDataCz",
      "target" : "https://hl7.cz/fhir/cz-ems/StructureDefinition/cz-careteam-ems",
      "element" : [
        {
          "code" : "crewMemberIdentification",
          "display" : "A.2.1.3 Crew Member Identification",
          "target" : [
            {
              "code" : "Composition.section:dispatchData",
              "equivalence" : "relatedto",
              "comment" : "Composition.section:dispatchData.entry.ofType(CZ_CareTeamEms)"
            }
          ]
        },
        {
          "code" : "crewMemberIdentifier",
          "display" : "A.2.1.3.1 - Crew Member Identifier",
          "target" : [
            {
              "code" : "CareTeam.participant.member.identifier",
              "display" : "Crew Member Identifier",
              "equivalence" : "relatedto"
            }
          ]
        }
      ]
    },
    {
      "source" : "https://hl7.cz/fhir/cz-ems/StructureDefinition/DispatchDataCz",
      "target" : "https://hl7.cz/fhir/core/StructureDefinition/cz-practitioner-core",
      "element" : [
        {
          "code" : "crewMemberIdentification",
          "display" : "A.2.1.3 - Crew Member Identification",
          "target" : [
            {
              "code" : "Composition.section:dispatchData",
              "equivalence" : "relatedto",
              "comment" : "Composition.section:dispatchData.entry.ofType(CZ_PractitionerCore)"
            }
          ]
        },
        {
          "code" : "crewMemberIdentifier",
          "display" : "A.2.1.3.1 - Crew Member Identifier",
          "target" : [
            {
              "code" : "Practitioner.identifier",
              "display" : "Crew Member Identifier",
              "equivalence" : "relatedto"
            }
          ]
        },
        {
          "code" : "firstName",
          "display" : "A.2.1.3.2 - First Name",
          "target" : [
            {
              "code" : "Practitioner.name.given",
              "display" : "First Name",
              "equivalence" : "relatedto"
            }
          ]
        },
        {
          "code" : "lastName",
          "display" : "A.2.1.3.3 - Last Name",
          "target" : [
            {
              "code" : "Practitioner.name.family",
              "display" : "Last Name",
              "equivalence" : "relatedto"
            }
          ]
        }
      ]
    },
    {
      "source" : "https://hl7.cz/fhir/cz-ems/StructureDefinition/DispatchDataCz",
      "target" : "https://hl7.cz/fhir/core/StructureDefinition/cz-practitionerrole-core",
      "element" : [
        {
          "code" : "role",
          "display" : "A.2.1.3.4 Role",
          "target" : [
            {
              "code" : "Composition.section:dispatchData",
              "equivalence" : "relatedto",
              "comment" : "Composition.section:dispatchData.entry.ofType(CZ_PractitionerRoleCore)"
            }
          ]
        },
        {
          "code" : "role",
          "display" : "A.2.1.3.4 - Role",
          "target" : [
            {
              "code" : "PractitionerRole.code",
              "display" : "Role",
              "equivalence" : "relatedto"
            }
          ]
        }
      ]
    },
    {
      "source" : "https://hl7.cz/fhir/cz-ems/StructureDefinition/DispatchDataCz",
      "target" : "https://hl7.cz/fhir/cz-ems/StructureDefinition/cz-communication-ems",
      "element" : [
        {
          "code" : "dispatchCenterOperator",
          "display" : "A.2.1.4 Dispatch Center Operator Identification",
          "target" : [
            {
              "code" : "Composition.section:dispatchData",
              "equivalence" : "relatedto",
              "comment" : "Composition.section:dispatchData.entry.ofType(CZ_CommunicationEms)"
            }
          ]
        },
        {
          "code" : "dispatchCenterOperator",
          "display" : "A.2.1.4 - Dispatch Center Operator Identification",
          "target" : [
            {
              "code" : "Communication.recipient",
              "display" : "Dispatch Center Operator Identification",
              "equivalence" : "relatedto"
            }
          ]
        },
        {
          "code" : "callerContact",
          "display" : "A.2.1.8 - Caller Contact",
          "target" : [
            {
              "code" : "Communication.sender",
              "display" : "sender (RelatedPerson)",
              "equivalence" : "relatedto",
              "comment" : "Communication.sender should reference RelatedPerson"
            }
          ]
        }
      ]
    },
    {
      "source" : "https://hl7.cz/fhir/cz-ems/StructureDefinition/DispatchDataCz",
      "target" : "https://hl7.cz/fhir/core/StructureDefinition/cz-practitioner-core",
      "element" : [
        {
          "code" : "operatorIdentifier",
          "display" : "A.2.1.4.1 Operator Identifier",
          "target" : [
            {
              "code" : "Composition.section:dispatchData",
              "equivalence" : "relatedto",
              "comment" : "Composition.section:dispatchData.entry.ofType(CZ_PractitionerCore)"
            }
          ]
        },
        {
          "code" : "operatorIdentifier",
          "display" : "A.2.1.4.1 - Operator Identifier",
          "target" : [
            {
              "code" : "Practitioner.identifier",
              "display" : "Operator Identifier",
              "equivalence" : "relatedto"
            }
          ]
        },
        {
          "code" : "firstName",
          "display" : "A.2.1.4.2 - First Name",
          "target" : [
            {
              "code" : "Practitioner.name.given",
              "display" : "First Name",
              "equivalence" : "relatedto"
            }
          ]
        },
        {
          "code" : "lastName",
          "display" : "A.2.1.4.3 - Last Name",
          "target" : [
            {
              "code" : "Practitioner.name.family",
              "display" : "Last Name",
              "equivalence" : "relatedto"
            }
          ]
        }
      ]
    },
    {
      "source" : "https://hl7.cz/fhir/cz-ems/StructureDefinition/DispatchDataCz",
      "target" : "https://hl7.cz/fhir/core/StructureDefinition/cz-practitionerrole-core",
      "element" : [
        {
          "code" : "role",
          "display" : "A.2.1.4.4 Role",
          "target" : [
            {
              "code" : "Composition.section:dispatchData",
              "equivalence" : "relatedto",
              "comment" : "Composition.section:dispatchData.entry.ofType(CZ_PractitionerRoleCore)"
            }
          ]
        },
        {
          "code" : "role",
          "display" : "A.2.1.4.4  - Role",
          "target" : [
            {
              "code" : "PractitionerRole.code",
              "display" : "Role",
              "equivalence" : "relatedto"
            }
          ]
        }
      ]
    },
    {
      "source" : "https://hl7.cz/fhir/cz-ems/StructureDefinition/DispatchDataCz",
      "target" : "http://hl7.org/fhir/StructureDefinition/RelatedPerson",
      "element" : [
        {
          "code" : "callerContact",
          "display" : "A.2.1.8 - Caller Contact",
          "target" : [
            {
              "code" : "Composition.section:dispatchData",
              "display" : "Composition.section:dispatchData.entry.ofType(RelatedPerson)",
              "equivalence" : "relatedto",
              "comment" : "Composition.section:dispatchData.entry should reference RelatedPerson"
            }
          ]
        },
        {
          "code" : "phone",
          "display" : "A.2.1.8.1 - Phone",
          "target" : [
            {
              "code" : "RelatedPerson.telecom",
              "display" : "Phone number of the caller",
              "equivalence" : "relatedto"
            }
          ]
        }
      ]
    }
  ]
}

```
