# CZ ClinicalCourseAndRecommendations Model to this guide Map - HL7 Czech EMS Implementation Guide v0.0.2

* [**Table of Contents**](toc.md)
* [**Artifacts**](artifacts.md)
* **CZ ClinicalCourseAndRecommendations Model to this guide Map**

## ConceptMap: CZ ClinicalCourseAndRecommendations Model to this guide Map (Experimental) 

| | |
| :--- | :--- |
| *Official URL*:https://hl7.cz/fhir/cz-ems/ConceptMap/ClinicalCourseAndRecommendationsEMS2FHIR-cz | *Version*:0.0.2 |
| Draft as of 2025-10-14 | *Computable Name*:A.2.1 ClinicalCourseAndRecommendations2FHIRcz |

 
CZ Emergency Medical Service Report ClinicalCourseAndRecommendations Model to this guide mapping 

Mapping from (not specified) to (not specified)

**Group 1**Mapping from [A.2.9 - Course of Treatment and Recommendations (en)](StructureDefinition-LogRecommendations.md) to [Procedure: EMS Report (CZ)](StructureDefinition-cz-procedure-ems.md)

* **Source Code**: LogRecommendations.courseOfTreatment (A.2.9.1 - Course of Treatment)
  * **Relationship**: [is related to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#relatedto)
  * **Target Code**: Composition.section:clinicalCourseAndRecommendations
  * **Comment**: Composition.section:clinicalCourseAndRecommendations.entry.ofType(CZ_ProcedureEms)
* **Source Code**: courseOfTreatment.description (A.2.9.1.1 - Course Description)
  * **Relationship**: [is equivalent to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#equivalent)
  * **Target Code**: CZ_ProcedureEms.code.text
  * **Comment**: 
* **Source Code**: courseOfTreatment.timestamp (A.2.9.1.2 - Timestamp)
  * **Relationship**: [is equivalent to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#equivalent)
  * **Target Code**: CZ_ProcedureEms.performedDateTime
  * **Comment**: 
* **Source Code**: LogRecommendations.recommendations (A.2.9.2 - Recommendations)
  * **Relationship**: [is related to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#relatedto)
  * **Target Code**: Composition.section:clinicalCourseAndRecommendations
  * **Comment**: Composition.section:clinicalCourseAndRecommendations.entry.ofType(CZ_ProcedureEms)
* **Source Code**: recommendations.description (A.2.9.2.1 - Recommendation Description)
  * **Relationship**: [is equivalent to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#equivalent)
  * **Target Code**: CZ_ProcedureEms.code.text
  * **Comment**: 



## Resource Content

```json
{
  "resourceType" : "ConceptMap",
  "id" : "ClinicalCourseAndRecommendationsEMS2FHIR-cz",
  "url" : "https://hl7.cz/fhir/cz-ems/ConceptMap/ClinicalCourseAndRecommendationsEMS2FHIR-cz",
  "version" : "0.0.2",
  "name" : "A.2.1 ClinicalCourseAndRecommendations2FHIRcz",
  "title" : "CZ ClinicalCourseAndRecommendations Model to this guide Map",
  "status" : "draft",
  "experimental" : true,
  "date" : "2025-10-14T13:52:10+00:00",
  "publisher" : "HL7 Czech Republic",
  "contact" : [
    {
      "name" : "HL7 Czech Republic",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.hl7.cz/"
        }
      ]
    }
  ],
  "description" : "CZ Emergency Medical Service Report ClinicalCourseAndRecommendations Model to this guide mapping",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "CZ",
          "display" : "Czechia"
        }
      ]
    }
  ],
  "group" : [
    {
      "source" : "https://hl7.cz/fhir/cz-ems/StructureDefinition/LogRecommendations",
      "target" : "https://hl7.cz/fhir/cz-ems/StructureDefinition/cz-procedure-ems",
      "element" : [
        {
          "code" : "LogRecommendations.courseOfTreatment",
          "display" : "A.2.9.1 - Course of Treatment",
          "target" : [
            {
              "code" : "Composition.section:clinicalCourseAndRecommendations",
              "equivalence" : "relatedto",
              "comment" : "Composition.section:clinicalCourseAndRecommendations.entry.ofType(CZ_ProcedureEms)"
            }
          ]
        },
        {
          "code" : "courseOfTreatment.description",
          "display" : "A.2.9.1.1 - Course Description",
          "target" : [
            {
              "code" : "CZ_ProcedureEms.code.text",
              "equivalence" : "equivalent"
            }
          ]
        },
        {
          "code" : "courseOfTreatment.timestamp",
          "display" : "A.2.9.1.2 - Timestamp",
          "target" : [
            {
              "code" : "CZ_ProcedureEms.performedDateTime",
              "equivalence" : "equivalent"
            }
          ]
        },
        {
          "code" : "LogRecommendations.recommendations",
          "display" : "A.2.9.2 - Recommendations",
          "target" : [
            {
              "code" : "Composition.section:clinicalCourseAndRecommendations",
              "equivalence" : "relatedto",
              "comment" : "Composition.section:clinicalCourseAndRecommendations.entry.ofType(CZ_ProcedureEms)"
            }
          ]
        },
        {
          "code" : "recommendations.description",
          "display" : "A.2.9.2.1 - Recommendation Description",
          "target" : [
            {
              "code" : "CZ_ProcedureEms.code.text",
              "equivalence" : "equivalent"
            }
          ]
        }
      ]
    }
  ]
}

```
