# Bundle: EMS report - HL7 Czech EMS Implementation Guide v0.0.2

* [**Table of Contents**](toc.md)
* [**Artifacts**](artifacts.md)
* **Bundle: EMS report**

## Example Bundle: Bundle: EMS report

**Document Details**

Profile: [Bundle: EMS Report (CZ)](StructureDefinition-cz-bundle-ems.md)

Final Document at 2025-05-20 12:02:00+0100 by [Practitioner Blažejovský Jan](Bundle-cz-example-bundle.md#urn-uuid-2e877c76-633d-479b-a6d4-c6d95942de3f) for [Mračena Mrakomorová Female, DoB: 1971-11-26 ( https://ncez.mzcr.cz/fhir/sid/rcis#2716126452 (use: official, ))](Bundle-cz-example-bundle.md#urn-uuid-3b46c18c-7e07-4232-af3e-f710dec8e766) in encounter [Encounter: identifier = http://example.org/hospital#ku-123456789; status = in-progress; class = ambulatory (ActCode#AMB); type =](Bundle-cz-example-bundle.md#urn-uuid-cd343afa-039d-4576-b5e4-e89598aeb628)

-------

**Document Subject**

Profile: [Patient (CZ core)](https://build.fhir.org/ig/HL7-cz/cz-core/StructureDefinition-cz-patient-core.html)

Mračena Mrakomorová Female, DoB: 1971-11-26 ( https://ncez.mzcr.cz/fhir/sid/rcis#2716126452 (use: official, ))

-------

-------

**Document Content**

## Procedure

Mediální kyslík NEPODÁN.

## Presenting Illness

Bolesti na hrudi

-------

## Additional Resources Included in Document

-------

Entry 2 - fullUrl = urn:uuid:cd343afa-039d-4576-b5e4-e89598aeb628

Resource Encounter:

> 

Profile: [Encounter (CZ)](https://build.fhir.org/ig/HL7-cz/cz-core/StructureDefinition-cz-encounter.html)

**identifier**:`http://example.org/hospital`/ku-123456789**status**: In Progress**class**:ambulatory**type**:EMS pacientky Mrakomorové**serviceProvider**:[Organization Fakultní nemocnice Motol](Bundle-cz-example-bundle.md#urn-uuid-821077d6-ce17-4602-b3ad-d4bef845a950)

-------

Entry 3 - fullUrl = urn:uuid:040eb849-a513-4d74-b3f3-d2f246a26877

Resource DocumentReference:

> 

Profile: [DocumentReference containing logo (CZ)](https://build.fhir.org/ig/HL7-cz/cz-core/StructureDefinition-cz-logo.html)

**status**: Current
> **content**

### Attachments

| | | | |
| :--- | :--- | :--- | :--- |
| - | **ContentType** | **Data** | **Title** |
| * | image/svg+xml | (base64 data - 2,804 base64 chars) | Organization logo |



-------

Entry 4 - fullUrl = urn:uuid:821077d6-ce17-4602-b3ad-d4bef845a950

Resource Organization:

> 

Profile: [Organization (CZ core)](https://build.fhir.org/ig/HL7-cz/cz-core/StructureDefinition-cz-organization-core.html)

**Organization Logo**:[DocumentReference: status = current](Bundle-cz-example-bundle.md#urn-uuid-040eb849-a513-4d74-b3f3-d2f246a26877)**identifier**:`https://ncez.mzcr.cz/fhir/sid/ico`/456789655**type**:Fakultní nemocnice**name**: Fakultní nemocnice Motol
> **contact****telecom**:[+420257216007](tel:+420257216007), fax: +420257216007(Work)**address**: Plzeňská 951/125, 150 00 Praha 5(work)

-------

Entry 5 - fullUrl = urn:uuid:2e877c76-633d-479b-a6d4-c6d95942de3f

Resource Practitioner:

> 

Profile: [Practitioner (CZ core)](https://build.fhir.org/ig/HL7-cz/cz-core/StructureDefinition-cz-practitioner-core.html)

**identifier**:`https://ncez.mzcr.cz/fhir/sid/krzp`/123456789**name**: Blažejovský Jan**gender**: Male

-------

Entry 6 - fullUrl = urn:uuid:3b46c18c-7e07-4232-af3e-f710dec8e766

Resource Patient:

> 

Profile: [Patient (CZ core)](https://build.fhir.org/ig/HL7-cz/cz-core/StructureDefinition-cz-patient-core.html)

Mračena Mrakomorová Female, DoB: 1971-11-26 ( https://ncez.mzcr.cz/fhir/sid/rcis#2716126452 (use: official, ))
-------

-------

Entry 7 - fullUrl = urn:uuid:3af2e7a6-c16e-4b80-a173-ca2c8aa081b6

Resource Procedure:

> 

Profile: [Procedure: EMS Report (CZ)](StructureDefinition-cz-procedure-ems.md)

**status**: Completed**code**:Mediální kyslík NEPODÁN.**subject**:[Mračena Mrakomorová Female, DoB: 1971-11-26 ( https://ncez.mzcr.cz/fhir/sid/rcis#2716126452 (use: official, ))](Bundle-cz-example-bundle.md#urn-uuid-3b46c18c-7e07-4232-af3e-f710dec8e766)



## Resource Content

```json
{
  "resourceType" : "Bundle",
  "id" : "cz-example-bundle",
  "meta" : {
    "profile" : [
      "https://hl7.cz/fhir/cz-ems/StructureDefinition/cz-bundle-ems"
    ]
  },
  "identifier" : {
    "system" : "urn:ietf:rfc:3986",
    "value" : "urn:uuid:5fe6446e-be70-4afb-a904-ee9d3d28a8c3"
  },
  "type" : "document",
  "timestamp" : "2022-10-07T08:15:00+01:00",
  "entry" : [
    {
      "fullUrl" : "urn:uuid:da3f987f-2a08-431a-92e3-129d7689e465",
      "resource" : {
        "resourceType" : "Composition",
        "id" : "da3f987f-2a08-431a-92e3-129d7689e465",
        "meta" : {
          "profile" : [
            "https://hl7.cz/fhir/cz-ems/StructureDefinition/cz-composition-ems"
          ]
        },
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Composition_da3f987f-2a08-431a-92e3-129d7689e465\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Composition da3f987f-2a08-431a-92e3-129d7689e465</b></p><a name=\"da3f987f-2a08-431a-92e3-129d7689e465\"> </a><a name=\"hcda3f987f-2a08-431a-92e3-129d7689e465\"> </a><div style=\"display: inline-block; background-color: #d9e0e7; padding: 6px; margin: 4px; border: 1px solid #8da1b4; border-radius: 5px; line-height: 60%\"><p style=\"margin-bottom: 0px\"/><p style=\"margin-bottom: 0px\">Profile: <a href=\"StructureDefinition-cz-composition-ems.html\">Composition (EMS CZ)</a></p></div><p><b>status</b>: Final</p><p><b>type</b>: <span title=\"Codes:{http://loinc.org 67796-3}\">EMS patient care report - version 3 Document NEMSIS</span></p><p><b>encounter</b>: <a href=\"Bundle-cz-example-bundle.html#urn-uuid-cd343afa-039d-4576-b5e4-e89598aeb628\">Encounter: identifier = http://example.org/hospital#ku-123456789; status = in-progress; class = ambulatory (ActCode#AMB); type = </a></p><p><b>date</b>: 2025-05-20 12:02:00+0100</p><p><b>author</b>: <a href=\"Bundle-cz-example-bundle.html#urn-uuid-2e877c76-633d-479b-a6d4-c6d95942de3f\">Practitioner Blažejovský Jan </a></p><p><b>title</b>: EMS Pacientky Mračeny Mrakomorové</p><p><b>confidentiality</b>: normal</p></div>"
        },
        "status" : "final",
        "type" : {
          "coding" : [
            {
              "system" : "http://loinc.org",
              "code" : "67796-3",
              "display" : "EMS patient care report - version 3 Document NEMSIS"
            }
          ]
        },
        "subject" : {
          "reference" : "urn:uuid:3b46c18c-7e07-4232-af3e-f710dec8e766"
        },
        "encounter" : {
          "reference" : "urn:uuid:cd343afa-039d-4576-b5e4-e89598aeb628"
        },
        "date" : "2025-05-20T12:02:00+01:00",
        "author" : [
          {
            "reference" : "urn:uuid:2e877c76-633d-479b-a6d4-c6d95942de3f"
          }
        ],
        "title" : "EMS Pacientky Mračeny Mrakomorové",
        "confidentiality" : "N",
        "section" : [
          {
            "title" : "Procedure",
            "code" : {
              "coding" : [
                {
                  "system" : "http://loinc.org",
                  "code" : "29554-3",
                  "display" : "Procedure Narrative"
                }
              ]
            },
            "text" : {
              "status" : "additional",
              "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\">Mediální kyslík NEPODÁN.</div>"
            },
            "entry" : [
              {
                "reference" : "urn:uuid:3af2e7a6-c16e-4b80-a173-ca2c8aa081b6"
              }
            ]
          },
          {
            "title" : "Presenting Illness",
            "code" : {
              "coding" : [
                {
                  "system" : "http://loinc.org",
                  "code" : "67658-5",
                  "display" : "EMS exposures or injuries of EMS personnel Provider Narrative NEMSIS"
                }
              ]
            },
            "text" : {
              "status" : "additional",
              "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\">Bolesti na hrudi</div>"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "urn:uuid:cd343afa-039d-4576-b5e4-e89598aeb628",
      "resource" : {
        "resourceType" : "Encounter",
        "id" : "cd343afa-039d-4576-b5e4-e89598aeb628",
        "meta" : {
          "profile" : [
            "https://fhir.hl7cr.eu/core/StructureDefinition/cz-encounter"
          ]
        },
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Encounter_cd343afa-039d-4576-b5e4-e89598aeb628\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Encounter cd343afa-039d-4576-b5e4-e89598aeb628</b></p><a name=\"cd343afa-039d-4576-b5e4-e89598aeb628\"> </a><a name=\"hccd343afa-039d-4576-b5e4-e89598aeb628\"> </a><div style=\"display: inline-block; background-color: #d9e0e7; padding: 6px; margin: 4px; border: 1px solid #8da1b4; border-radius: 5px; line-height: 60%\"><p style=\"margin-bottom: 0px\"/><p style=\"margin-bottom: 0px\">Profile: <a href=\"https://build.fhir.org/ig/HL7-cz/cz-core/StructureDefinition-cz-encounter.html\">Encounter (CZ)</a></p></div><p><b>identifier</b>: <code>http://example.org/hospital</code>/ku-123456789</p><p><b>status</b>: In Progress</p><p><b>class</b>: <a href=\"http://terminology.hl7.org/6.5.0/CodeSystem-v3-ActCode.html#v3-ActCode-AMB\">ActCode AMB</a>: ambulatory</p><p><b>type</b>: <span title=\"Codes:\">EMS pacientky Mrakomorové</span></p><p><b>serviceProvider</b>: <a href=\"Bundle-cz-example-bundle.html#urn-uuid-821077d6-ce17-4602-b3ad-d4bef845a950\">Organization Fakultní nemocnice Motol</a></p></div>"
        },
        "identifier" : [
          {
            "system" : "http://example.org/hospital",
            "value" : "ku-123456789"
          }
        ],
        "status" : "in-progress",
        "class" : {
          "system" : "http://terminology.hl7.org/CodeSystem/v3-ActCode",
          "code" : "AMB"
        },
        "type" : [
          {
            "text" : "EMS pacientky Mrakomorové"
          }
        ],
        "serviceProvider" : {
          "reference" : "urn:uuid:821077d6-ce17-4602-b3ad-d4bef845a950"
        }
      }
    },
    {
      "fullUrl" : "urn:uuid:040eb849-a513-4d74-b3f3-d2f246a26877",
      "resource" : {
        "resourceType" : "DocumentReference",
        "id" : "040eb849-a513-4d74-b3f3-d2f246a26877",
        "meta" : {
          "profile" : ["https://fhir.hl7cr.eu/core/StructureDefinition/cz-logo"]
        },
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"DocumentReference_040eb849-a513-4d74-b3f3-d2f246a26877\"> </a><p class=\"res-header-id\"><b>Generated Narrative: DocumentReference 040eb849-a513-4d74-b3f3-d2f246a26877</b></p><a name=\"040eb849-a513-4d74-b3f3-d2f246a26877\"> </a><a name=\"hc040eb849-a513-4d74-b3f3-d2f246a26877\"> </a><div style=\"display: inline-block; background-color: #d9e0e7; padding: 6px; margin: 4px; border: 1px solid #8da1b4; border-radius: 5px; line-height: 60%\"><p style=\"margin-bottom: 0px\"/><p style=\"margin-bottom: 0px\">Profile: <a href=\"https://build.fhir.org/ig/HL7-cz/cz-core/StructureDefinition-cz-logo.html\">DocumentReference containing logo (CZ)</a></p></div><p><b>status</b>: Current</p><blockquote><p><b>content</b></p><h3>Attachments</h3><table class=\"grid\"><tr><td style=\"display: none\">-</td><td><b>ContentType</b></td><td><b>Data</b></td><td><b>Title</b></td></tr><tr><td style=\"display: none\">*</td><td>image/svg+xml</td><td>(base64 data - 2,804 base64 chars)</td><td>Organization logo</td></tr></table></blockquote></div>"
        },
        "status" : "current",
        "content" : [
          {
            "attachment" : {
              "contentType" : "image/svg+xml",
              "data" : "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",
              "title" : "Organization logo"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "urn:uuid:821077d6-ce17-4602-b3ad-d4bef845a950",
      "resource" : {
        "resourceType" : "Organization",
        "id" : "821077d6-ce17-4602-b3ad-d4bef845a950",
        "meta" : {
          "profile" : [
            "https://fhir.hl7cr.eu/core/StructureDefinition/cz-organization-core"
          ]
        },
        "text" : {
          "status" : "extensions",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Organization_821077d6-ce17-4602-b3ad-d4bef845a950\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Organization 821077d6-ce17-4602-b3ad-d4bef845a950</b></p><a name=\"821077d6-ce17-4602-b3ad-d4bef845a950\"> </a><a name=\"hc821077d6-ce17-4602-b3ad-d4bef845a950\"> </a><div style=\"display: inline-block; background-color: #d9e0e7; padding: 6px; margin: 4px; border: 1px solid #8da1b4; border-radius: 5px; line-height: 60%\"><p style=\"margin-bottom: 0px\"/><p style=\"margin-bottom: 0px\">Profile: <a href=\"https://build.fhir.org/ig/HL7-cz/cz-core/StructureDefinition-cz-organization-core.html\">Organization (CZ core)</a></p></div><p><b>Organization Logo</b>: <a href=\"Bundle-cz-example-bundle.html#urn-uuid-040eb849-a513-4d74-b3f3-d2f246a26877\">DocumentReference: status = current</a></p><p><b>identifier</b>: <code>https://ncez.mzcr.cz/fhir/sid/ico</code>/456789655</p><p><b>type</b>: <span title=\"Codes:{https://ncez.mzcr.cz/fhir/CodeSystem/cz-drzar 101}\">Fakultní nemocnice</span></p><p><b>name</b>: Fakultní nemocnice Motol</p><p><b>telecom</b>: <a href=\"tel:+420257216007\">+420257216007</a>, fax: +420257216007(Work)</p><p><b>address</b>: Plzeňská 951/125, 150 00 Praha 5(work)</p></div>"
        },
        "extension" : [
          {
            "url" : "https://fhir.hl7cr.eu/core/StructureDefinition/cz-organization-logo",
            "valueReference" : {
              "reference" : "urn:uuid:040eb849-a513-4d74-b3f3-d2f246a26877"
            }
          }
        ],
        "identifier" : [
          {
            "system" : "https://ncez.mzcr.cz/fhir/sid/ico",
            "value" : "456789655"
          }
        ],
        "type" : [
          {
            "coding" : [
              {
                "system" : "https://ncez.mzcr.cz/fhir/CodeSystem/cz-drzar",
                "code" : "101",
                "display" : "Fakultní nemocnice"
              }
            ]
          }
        ],
        "name" : "Fakultní nemocnice Motol",
        "telecom" : [
          {
            "system" : "phone",
            "value" : "+420257216007",
            "use" : "work"
          },
          {
            "system" : "fax",
            "value" : "+420257216007",
            "use" : "work"
          }
        ],
        "address" : [
          {
            "use" : "work",
            "type" : "both",
            "text" : "Plzeňská 951/125, 150 00 Praha 5",
            "line" : ["Plzeňská 951/125"],
            "_line" : [
              {
                "extension" : [
                  {
                    "url" : "http://hl7.org/fhir/StructureDefinition/iso21090-ADXP-streetName",
                    "valueString" : "Plzeňská"
                  },
                  {
                    "url" : "http://hl7.org/fhir/StructureDefinition/iso21090-ADXP-houseNumber",
                    "valueString" : "951/125"
                  }
                ]
              }
            ],
            "city" : "Praha",
            "postalCode" : "15000",
            "country" : "Česko",
            "_country" : {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/iso21090-SC-coding",
                  "valueCoding" : {
                    "system" : "urn:iso:std:iso:3166",
                    "code" : "CZ",
                    "display" : "Czechia"
                  }
                }
              ]
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "urn:uuid:2e877c76-633d-479b-a6d4-c6d95942de3f",
      "resource" : {
        "resourceType" : "Practitioner",
        "id" : "2e877c76-633d-479b-a6d4-c6d95942de3f",
        "meta" : {
          "profile" : [
            "https://fhir.hl7cr.eu/core/StructureDefinition/cz-practitioner-core"
          ]
        },
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Practitioner_2e877c76-633d-479b-a6d4-c6d95942de3f\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Practitioner 2e877c76-633d-479b-a6d4-c6d95942de3f</b></p><a name=\"2e877c76-633d-479b-a6d4-c6d95942de3f\"> </a><a name=\"hc2e877c76-633d-479b-a6d4-c6d95942de3f\"> </a><div style=\"display: inline-block; background-color: #d9e0e7; padding: 6px; margin: 4px; border: 1px solid #8da1b4; border-radius: 5px; line-height: 60%\"><p style=\"margin-bottom: 0px\"/><p style=\"margin-bottom: 0px\">Profile: <a href=\"https://build.fhir.org/ig/HL7-cz/cz-core/StructureDefinition-cz-practitioner-core.html\">Practitioner (CZ core)</a></p></div><p><b>identifier</b>: <code>https://ncez.mzcr.cz/fhir/sid/krzp</code>/123456789</p><p><b>name</b>: Blažejovský Jan </p><p><b>gender</b>: Male</p></div>"
        },
        "identifier" : [
          {
            "system" : "https://ncez.mzcr.cz/fhir/sid/krzp",
            "value" : "123456789"
          }
        ],
        "name" : [
          {
            "use" : "usual",
            "family" : "Jan",
            "given" : ["Blažejovský"],
            "prefix" : ["MUDr."]
          }
        ],
        "gender" : "male"
      }
    },
    {
      "fullUrl" : "urn:uuid:3b46c18c-7e07-4232-af3e-f710dec8e766",
      "resource" : {
        "resourceType" : "Patient",
        "id" : "3b46c18c-7e07-4232-af3e-f710dec8e766",
        "meta" : {
          "profile" : [
            "https://fhir.hl7cr.eu/core/StructureDefinition/cz-patient-core"
          ]
        },
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Patient_3b46c18c-7e07-4232-af3e-f710dec8e766\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Patient 3b46c18c-7e07-4232-af3e-f710dec8e766</b></p><a name=\"3b46c18c-7e07-4232-af3e-f710dec8e766\"> </a><a name=\"hc3b46c18c-7e07-4232-af3e-f710dec8e766\"> </a><div style=\"display: inline-block; background-color: #d9e0e7; padding: 6px; margin: 4px; border: 1px solid #8da1b4; border-radius: 5px; line-height: 60%\"><p style=\"margin-bottom: 0px\"/><p style=\"margin-bottom: 0px\">Profile: <a href=\"https://build.fhir.org/ig/HL7-cz/cz-core/StructureDefinition-cz-patient-core.html\">Patient (CZ core)</a></p></div><p style=\"border: 1px #661aff solid; background-color: #e6e6ff; padding: 10px;\">Mračena Mrakomorová  Female, DoB: 1971-11-26 ( https://ncez.mzcr.cz/fhir/sid/rcis#2716126452 (use: official, ))</p><hr/><table class=\"grid\"><tr><td style=\"background-color: #f3f5da\" title=\"Other Id (see the one above)\">Other Id:</td><td colspan=\"3\"><code>https://ncez.mzcr.cz/fhir/sid/rid</code>/2066425387</td></tr><tr><td style=\"background-color: #f3f5da\" title=\"Ways to contact the Patient\">Contact Detail</td><td colspan=\"3\"><ul><li><a href=\"tel:+420603853227\">+420 603 853 227</a></li><li>Malé náměstí 13a, 150 00, Praha 5(home)</li></ul></td></tr><tr><td style=\"background-color: #f3f5da\" title=\"Languages spoken\">Languages:</td><td colspan=\"3\"><ul><li><span title=\"Codes:{urn:ietf:bcp:47 cs}\">Czech</span> (preferred)</li><li><span title=\"Codes:{urn:ietf:bcp:47 en}\">English</span></li><li><span title=\"Codes:{urn:ietf:bcp:47 de}\">German</span></li></ul></td></tr><tr><td style=\"background-color: #f3f5da\" title=\"Patient Links\">Links:</td><td colspan=\"3\"><ul><li>General Practitioner: MUDr. Josef Švejk (Identifier: <code>https://ncez.mzcr.cz/fhir/sid/krzp</code>/123456789)</li></ul></td></tr></table></div>"
        },
        "identifier" : [
          {
            "system" : "https://ncez.mzcr.cz/fhir/sid/rid",
            "value" : "2066425387"
          },
          {
            "use" : "official",
            "system" : "https://ncez.mzcr.cz/fhir/sid/rcis",
            "value" : "2716126452"
          }
        ],
        "name" : [
          {
            "use" : "usual",
            "family" : "Mrakomorová",
            "given" : ["Mračena"]
          }
        ],
        "telecom" : [
          {
            "system" : "phone",
            "value" : "+420 603 853 227",
            "use" : "home"
          }
        ],
        "gender" : "female",
        "birthDate" : "1971-11-26",
        "address" : [
          {
            "use" : "home",
            "type" : "physical",
            "text" : "Malé náměstí 13a, 150 00, Praha 5",
            "line" : ["Malé náměstí 13a"],
            "_line" : [
              {
                "extension" : [
                  {
                    "url" : "http://hl7.org/fhir/StructureDefinition/iso21090-ADXP-streetName",
                    "valueString" : "Malé náměstí"
                  },
                  {
                    "url" : "http://hl7.org/fhir/StructureDefinition/iso21090-ADXP-houseNumber",
                    "valueString" : "13a"
                  }
                ]
              }
            ],
            "city" : "Praha",
            "postalCode" : "15000",
            "country" : "Česko",
            "_country" : {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/iso21090-SC-coding",
                  "valueCoding" : {
                    "system" : "urn:iso:std:iso:3166",
                    "code" : "CZ",
                    "display" : "Czechia"
                  }
                }
              ]
            }
          }
        ],
        "communication" : [
          {
            "language" : {
              "coding" : [
                {
                  "system" : "urn:ietf:bcp:47",
                  "code" : "cs"
                }
              ]
            },
            "preferred" : true
          },
          {
            "language" : {
              "coding" : [
                {
                  "system" : "urn:ietf:bcp:47",
                  "code" : "en"
                }
              ]
            }
          },
          {
            "language" : {
              "coding" : [
                {
                  "system" : "urn:ietf:bcp:47",
                  "code" : "de"
                }
              ]
            }
          }
        ],
        "generalPractitioner" : [
          {
            "identifier" : {
              "system" : "https://ncez.mzcr.cz/fhir/sid/krzp",
              "value" : "123456789"
            },
            "display" : "MUDr. Josef Švejk"
          }
        ]
      }
    },
    {
      "fullUrl" : "urn:uuid:3af2e7a6-c16e-4b80-a173-ca2c8aa081b6",
      "resource" : {
        "resourceType" : "Procedure",
        "id" : "3af2e7a6-c16e-4b80-a173-ca2c8aa081b6",
        "meta" : {
          "profile" : [
            "https://hl7.cz/fhir/cz-ems/StructureDefinition/cz-procedure-ems"
          ]
        },
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Procedure_3af2e7a6-c16e-4b80-a173-ca2c8aa081b6\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Procedure 3af2e7a6-c16e-4b80-a173-ca2c8aa081b6</b></p><a name=\"3af2e7a6-c16e-4b80-a173-ca2c8aa081b6\"> </a><a name=\"hc3af2e7a6-c16e-4b80-a173-ca2c8aa081b6\"> </a><div style=\"display: inline-block; background-color: #d9e0e7; padding: 6px; margin: 4px; border: 1px solid #8da1b4; border-radius: 5px; line-height: 60%\"><p style=\"margin-bottom: 0px\"/><p style=\"margin-bottom: 0px\">Profile: <a href=\"StructureDefinition-cz-procedure-ems.html\">Procedure: EMS Report (CZ)</a></p></div><p><b>status</b>: Completed</p><p><b>code</b>: <span title=\"Codes:\">Mediální kyslík NEPODÁN.</span></p><p><b>subject</b>: <a href=\"Bundle-cz-example-bundle.html#urn-uuid-3b46c18c-7e07-4232-af3e-f710dec8e766\">Mračena Mrakomorová  Female, DoB: 1971-11-26 ( https://ncez.mzcr.cz/fhir/sid/rcis#2716126452 (use: official, ))</a></p><p><b>performed</b>: 2022-10-07 09:10:00+0100</p></div>"
        },
        "status" : "completed",
        "code" : {
          "text" : "Mediální kyslík NEPODÁN."
        },
        "subject" : {
          "reference" : "urn:uuid:3b46c18c-7e07-4232-af3e-f710dec8e766"
        },
        "performedDateTime" : "2022-10-07T09:10:00+01:00"
      }
    }
  ]
}

```
