# hl7.fhir.cz.core#0.3.0-ballot: HL7 Czech Base and Core Implementation Guide

## Pages

* [Home](index.md)
* [Actor Consumer L2 - XML Representation](ActorDefinition-actor-consumer-L2.xml.md)
* [Actor Consumer L1 - TTL Representation](ActorDefinition-actor-consumer-L1.ttl.md)
* [Actor Creator L3 - JSON Representation](ActorDefinition-actor-creator-L3.json.md)
* [Actor Consumer L1 - Testing](ActorDefinition-actor-consumer-L1-testing.md)
* [Actor Creator L3](ActorDefinition-actor-creator-L3.md)
* [Subjects in English](subjects-en.md)
* [Actor Creator L1 - TTL Representation](ActorDefinition-actor-creator-L1.ttl.md)
* [Subjects in Czech](subjects-cs.md)
* [Objects in English](objects-en.md)
* [Actor Consumer L1 - JSON Representation](ActorDefinition-actor-consumer-L1.json.md)
* [Basic FHIR elements in Czech](elements-FHIR-cs.md)
* [Actor Creator L3 - TTL Representation](ActorDefinition-actor-creator-L3.ttl.md)
* [Závislosti](dependencies-cs.md)
* [](ActorDefinition-actor-creator-L3.change.history.md)
* [Actor Creator L2 - Testing](ActorDefinition-actor-creator-L2-testing.md)
* [Actor Consumer L1 - XML Representation](ActorDefinition-actor-consumer-L1.xml.md)
* [Actor Creator L2 - JSON Representation](ActorDefinition-actor-creator-L2.json.md)
* [Actor Creator L2 - TTL Representation](ActorDefinition-actor-creator-L2.ttl.md)
* [Actor Consumer L2](ActorDefinition-actor-consumer-L2.md)
* [Dependencies](dependencies.md)
* [Actor Consumer L3 - TTL Representation](ActorDefinition-actor-consumer-L3.ttl.md)
* [Identifiers in Czech](identifiers-cs.md)
* [Actor Creator L1](ActorDefinition-actor-creator-L1.md)
* [Copyright](copyright.md)
* [Actor Consumer L3 - XML Representation](ActorDefinition-actor-consumer-L3.xml.md)
* [](ActorDefinition-actor-creator-L2.change.history.md)
* [](ActorDefinition-actor-consumer-L3.change.history.md)
* [Objects in Czech](objects-cs.md)
* [Actor Consumer L2 - TTL Representation](ActorDefinition-actor-consumer-L2.ttl.md)
* [Actor Consumer L2 - Testing](ActorDefinition-actor-consumer-L2-testing.md)
* [Autorská práva](copyright-cs.md)
* [Actor Consumer L3](ActorDefinition-actor-consumer-L3.md)
* [Actor Creator L2 - XML Representation](ActorDefinition-actor-creator-L2.xml.md)
* [Actor Creator L1 - JSON Representation](ActorDefinition-actor-creator-L1.json.md)
* [Authors](authors.md)
* [](ActorDefinition-actor-consumer-L2.change.history.md)
* [Actor Creator L2](ActorDefinition-actor-creator-L2.md)
* [Basic FHIR elements in English](elements-FHIR-en.md)
* [Download](downloads-cs.md)
* [Actor Consumer L3 - Testing](ActorDefinition-actor-consumer-L3-testing.md)
* [Actor Creator L1 - Testing](ActorDefinition-actor-creator-L1-testing.md)
* [Actor Creator L1 - XML Representation](ActorDefinition-actor-creator-L1.xml.md)
* [](ActorDefinition-actor-consumer-L1.change.history.md)
* [Actor Creator L3 - Testing](ActorDefinition-actor-creator-L3-testing.md)
* [Actor Creator L3 - XML Representation](ActorDefinition-actor-creator-L3.xml.md)
* [](ActorDefinition-actor-creator-L1.change.history.md)
* [Actor Consumer L3 - JSON Representation](ActorDefinition-actor-consumer-L3.json.md)
* [Autoři](authors-cs.md)
* [Summary artifacts](artifacts.md)
* [Download](downloads.md)
* [Actor Consumer L2 - JSON Representation](ActorDefinition-actor-consumer-L2.json.md)
* [Actor Consumer L1](ActorDefinition-actor-consumer-L1.md)
* [Identifiers in English](identifiers-en.md)

## Resources

### Complex-type Profiles

* [Oid Identifier](StructureDefinition-OidIdentifier.md)
* [Address (CZ)](StructureDefinition-cz-address.md)
* [Passport identifier](StructureDefinition-cz-passport-identifier.md)
* [National health sector identifier (CZ)](StructureDefinition-cz-rid-identifier.md)
* [National birth number (CZ)](StructureDefinition-cz-rodcis-identifier.md)
* [Signature (CZ)](StructureDefinition-cz-signature.md)
* [National ID card identifier](StructureDefinition-id-card-identifier.md)

### Resource Profiles

* [Body Structure (CZ)](StructureDefinition-BodyStructure-cz.md)
* [Substance: Specimen Additive Substance (CZ)](StructureDefinition-Substance-additive-cz.md)
* [Medication (CZ)](StructureDefinition-cz-Medication.md)
* [Medication Statement (CZ)](StructureDefinition-cz-MedicationStatement.md)
* [Allergy Intolerance (CZ)](StructureDefinition-cz-allergyIntolerance.md)
* [Attachment (CZ)](StructureDefinition-cz-attachment.md)
* [Coverage (CZ)](StructureDefinition-cz-coverage.md)
* [Device: Performer/Observer (CZ)](StructureDefinition-cz-device-observer.md)
* [Encounter (CZ)](StructureDefinition-cz-encounter.md)
* [Location (CZ base)](StructureDefinition-cz-location-base.md)
* [Location (CZ core)](StructureDefinition-cz-location-core.md)
* [DocumentReference containing logo (CZ)](StructureDefinition-cz-logo.md)
* [Medical Device (CZ)](StructureDefinition-cz-medical-device.md)
* [Organization (CZ base)](StructureDefinition-cz-organization-base.md)
* [Organization (CZ core)](StructureDefinition-cz-organization-core.md)
* [Patient: Animal (CZ)](StructureDefinition-cz-patient-animal.md)
* [Patient (CZ base)](StructureDefinition-cz-patient-base.md)
* [Patient (CZ core)](StructureDefinition-cz-patient-core.md)
* [Practitioner (CZ base)](StructureDefinition-cz-practitioner-base.md)
* [Practitioner (CZ core)](StructureDefinition-cz-practitioner-core.md)
* [Practitioner Role (CZ base)](StructureDefinition-cz-practitionerrole-base.md)
* [Practitioner Role (CZ core)](StructureDefinition-cz-practitionerrole-core.md)
* [Presented Form (CZ)](StructureDefinition-cz-presented-form.md)
* [Provenance (CZ)](StructureDefinition-cz-provenance.md)
* [Related Person (CZ base)](StructureDefinition-cz-relatedPerson-base.md)
* [Related Person (CZ core)](StructureDefinition-cz-relatedPerson-core.md)
* [Specimen (CZ)](StructureDefinition-cz-specimen.md)

### Extensions

* [Accreditation Requirement](StructureDefinition-accreditation-cz.md)
* [Address location code according to the system RÚIAN (ČÚZK)](StructureDefinition-address-point-cz.md)
* [Organization Logo](StructureDefinition-cz-organization-logo.md)
* [Refund indicator code (VZP)](StructureDefinition-cz-refund-indicator-code.md)
* [Address permanent residence](StructureDefinition-permanent-residencer-address-cz.md)
* [Composition: Presented Form](StructureDefinition-presentedForm.md)
* [Registering provider](StructureDefinition-registering-provider-cz.md)

### ImplementationGuides

* [HL7 Czech Base and Core Implementation Guide](index.md)

### Examples

* [AllergyToCatDander (AllergyIntolerance)](AllergyIntolerance-AllergyToCatDander.md)
* [allergy-1 (AllergyIntolerance)](AllergyIntolerance-allergy-1.md)
* [actor-consumer-L1 (Basic)](Basic-actor-consumer-L1.md)
* [actor-consumer-L2 (Basic)](Basic-actor-consumer-L2.md)
* [actor-consumer-L3 (Basic)](Basic-actor-consumer-L3.md)
* [actor-creator-L1 (Basic)](Basic-actor-creator-L1.md)
* [actor-creator-L2 (Basic)](Basic-actor-creator-L2.md)
* [actor-creator-L3 (Basic)](Basic-actor-creator-L3.md)
* [BodyStructure01 (BodyStructure)](BodyStructure-BodyStructure01.md)
* [Coverage01 (Coverage)](Coverage-Coverage01.md)
* [AbsentDevice (Device)](Device-AbsentDevice.md)
* [LabAnalyzer (Device)](Device-LabAnalyzer.md)
* [NoInformationAboutDevice (Device)](Device-NoInformationAboutDevice.md)
* [Pacemaker (Device)](Device-Pacemaker.md)
* [attachment-logo-FN-Motol (DocumentReference)](DocumentReference-attachment-logo-FN-Motol.md)
* [cz-attachment-example (DocumentReference)](DocumentReference-cz-attachment-example.md)
* [cz-presentedform-example (DocumentReference)](DocumentReference-cz-presentedform-example.md)
* [cz-encounter-example (Encounter)](Encounter-cz-encounter-example.md)
* [Nádražní 1, Praha 5 (Location)](Location-Location-Praha5.md)
* [Laboratoř Praha, Jankovcova 2 (Location)](Location-location-laboratory.md)
* [med-1 (Medication)](Medication-med-1.md)
* [Medication (MedicationStatement)](MedicationStatement-Medication.md)
* [Nemocnice Chrudim (Organization)](Organization-Organization-1.md)
* [MUDr. Hana Doktorová (Organization)](Organization-Organization-2.md)
* [Všeobecná zdravotní pojišťovna ČR (Organization)](Organization-Organization-3.md)
* [MUDr. Hana Doktorová (Organization)](Organization-RegisteringProviderExample.md)
* [Synlab czech s.r.o. (Organization)](Organization-Synlab.md)
* [Kocka (Patient)](Patient-Kocka.md)
* [Mracena (Patient)](Patient-Mracena.md)
* [cz-patient-addr-example-1 (Patient)](Patient-cz-patient-addr-example-1.md)
* [cz-patient-addr-example-2 (Patient)](Patient-cz-patient-addr-example-2.md)
* [cz-patient-addr-example-3 (Patient)](Patient-cz-patient-addr-example-3.md)
* [cz-patient-addr-example-4 (Patient)](Patient-cz-patient-addr-example-4.md)
* [cz-patient-addr-example-5 (Patient)](Patient-cz-patient-addr-example-5.md)
* [Practitioner-123456789 (Practitioner)](Practitioner-Practitioner-123456789.md)
* [Practitioner-2 (Practitioner)](Practitioner-Practitioner-2.md)
* [practitionerrole1 (PractitionerRole)](PractitionerRole-practitionerrole1.md)
* [signature-rentgen (Provenance)](Provenance-signature-rentgen.md)
* [RelatedPerson01 (RelatedPerson)](RelatedPerson-RelatedPerson01.md)
* [Specimen-example-animal (Specimen)](Specimen-Specimen-example-animal.md)
* [Specimen-example-environment (Specimen)](Specimen-Specimen-example-environment.md)
