# Home - HL7 Czech Base and Core Implementation Guide v0.3.0-ballot

* [**Table of Contents**](toc.md)
* **Home**

## Home

| | |
| :--- | :--- |
| *Official URL*:https://hl7.cz/fhir/core/ImplementationGuide/hl7.fhir.cz.core | *Version*:0.3.0-ballot |
| Draft as of 2025-12-19 | *Computable Name*:HL7CzCoreImplementationGuide |

### Introduction

The CZ Base and Core implementation guide is based on [FHIR version R4](https://hl7.org/fhir/R4/). It defines the minimum rules for interoperability and national customization of FHIR resources, which is applied when creating national profiles for specific use cases. The establishment of standards to support interoperability and their implementation in information systems creates a common basis for the interoperable exchange of health data.

In this implementation guide, you will find the rules for creating national profiles, the use of identifiers and basic information components.

### Scope

This document presents Czech use concepts defined via FHIR processable artefacts; these are collaborative outputs with agreed approaches to varied kinds of healthcare related information based on the core FHIR R4 specification.

This guide is divided into several pages which are listed at the top of each page in the menu bar.

* Home: This page provides the introduction and scope for this guide.
* Introduction: 
* [Basic FHIR elements (EN)](elements-FHIR-en.md): This page describes the basic FHIR elements in english.
* [Basic FHIR elements (CS)](elements-FHIR-cs.md): This page describes the basic FHIR elements in czech.
 
* Function view: 
* [Subjects (EN)](subjects-en.md): This page describes the basic components in the position of subjects in english.
* [Subjects (CS)](subjects-cs.md): This page describes the basic components in the position of subjects in czech.
* [Objects (EN)](objects-en.md): This page describes the basic components in the position of objects in english.
* [Objects (CS)](objects-cs.md): This page describes the basic components in the position of objects in czech.
* [Identifiers (EN)](identifiers-en.md): This page describes the identifiers that are used in the components in english.
* [Identifiers (CS)](identifiers-cs.md): This page describes the identifiers that are used in the components in czech.
 
* Artifacts: 
* [Artifacts Summary](artifacts.md): These page lists detailed descriptions and formal definitions for all the Czech artifacts defined in this guide.
 
* About: 
* [Downloads](downloads.md): This page provides links to downloadable artefacts.
 

### References

* Related Specifications: 
* [EHDS Logical Information Models](http://build.fhir.org/ig/Xt-EHR/xt-ehr-common/index.html) 
* This specification inspired many of the design patterns defined in this IG.
 
* [HL7 Europe Base and core](https://build.fhir.org/ig/hl7-eu/base/index.html) 
* This specification is based on the design patterns defined in this IG.
 
 

### Dependencies







### Cross Version Analysis

This is an R4 IG. None of the features it uses are changed in R4B, so it can be used as is with R4B systems. Packages for both [R4 (hl7.fhir.cz.core.r4)](package.r4.tgz) and [R4B (hl7.fhir.cz.core.r4b)](package.r4b.tgz) are available.

### IP statements

This publication includes IP covered under the following statements.

* ISO maintains the copyright on the country codes, and controls its use carefully. For further details see the ISO 3166 web page: [https://www.iso.org/iso-3166-country-codes.html](https://www.iso.org/iso-3166-country-codes.html)

* [ISO 3166-1 Codes for the representation of names of countries and their subdivisions — Part 1: Country code](http://terminology.hl7.org/6.3.0/CodeSystem-ISO3166Part1.html): [AccreditationCz](StructureDefinition-accreditation-cz.md), [AddressPointCz](StructureDefinition-address-point-cz.md)...Show 52 more,[BodyStructureCz](StructureDefinition-BodyStructure-cz.md),[CZ_Address](StructureDefinition-cz-address.md),[CZ_AllergyIntolerance](StructureDefinition-cz-allergyIntolerance.md),[CZ_Attachment](StructureDefinition-cz-attachment.md),[CZ_Coverage](StructureDefinition-cz-coverage.md),[CZ_DeviceObserver](StructureDefinition-cz-device-observer.md),[CZ_Encounter](StructureDefinition-cz-encounter.md),[CZ_LocationBase](StructureDefinition-cz-location-base.md),[CZ_LocationCore](StructureDefinition-cz-location-core.md),[CZ_Logo](StructureDefinition-cz-logo.md),[CZ_MedicalDevice](StructureDefinition-cz-medical-device.md),[CZ_Medication](StructureDefinition-cz-Medication.md),[CZ_MedicationStatement](StructureDefinition-cz-MedicationStatement.md),[CZ_OrganizationBase](StructureDefinition-cz-organization-base.md),[CZ_OrganizationCore](StructureDefinition-cz-organization-core.md),[CZ_OrganizationLogo](StructureDefinition-cz-organization-logo.md),[CZ_Passport_Identifier](StructureDefinition-cz-passport-identifier.md),[CZ_PatientAnimal](StructureDefinition-cz-patient-animal.md),[CZ_PatientBase](StructureDefinition-cz-patient-base.md),[CZ_PatientCore](StructureDefinition-cz-patient-core.md),[CZ_PractitionerBase](StructureDefinition-cz-practitioner-base.md),[CZ_PractitionerCore](StructureDefinition-cz-practitioner-core.md),[CZ_PractitionerRoleBase](StructureDefinition-cz-practitionerrole-base.md),[CZ_PractitionerRoleCore](StructureDefinition-cz-practitionerrole-core.md),[CZ_Presented_Form](StructureDefinition-cz-presented-form.md),[CZ_Provenance](StructureDefinition-cz-provenance.md),[CZ_RID_Identifier](StructureDefinition-cz-rid-identifier.md),[CZ_RefundIndicatorCode](StructureDefinition-cz-refund-indicator-code.md),[CZ_RelatedPersonBase](StructureDefinition-cz-relatedPerson-base.md),[CZ_RelatedPersonCore](StructureDefinition-cz-relatedPerson-core.md),[CZ_Rodcis_Identifier](StructureDefinition-cz-rodcis-identifier.md),[CZ_Signature](StructureDefinition-cz-signature.md),[CZ_Specimen](StructureDefinition-cz-specimen.md),[CZ_SpecimenAdditiveSubstance](StructureDefinition-Substance-additive-cz.md),[Consumer_L1](ActorDefinition-actor-consumer-L1.md),[Consumer_L2](ActorDefinition-actor-consumer-L2.md),[Consumer_L3](ActorDefinition-actor-consumer-L3.md),[Creator_L1](ActorDefinition-actor-creator-L1.md),[Creator_L2](ActorDefinition-actor-creator-L2.md),[Creator_L3](ActorDefinition-actor-creator-L3.md),[DocumentPresentedForm](StructureDefinition-presentedForm.md),[HL7CzCoreImplementationGuide](index.md),[Id_Card_Identifier](StructureDefinition-id-card-identifier.md),[OidIdentifier](StructureDefinition-OidIdentifier.md),[Patient/Mracena](Patient-Mracena.md),[Patient/cz-patient-addr-example-1](Patient-cz-patient-addr-example-1.md),[Patient/cz-patient-addr-example-2](Patient-cz-patient-addr-example-2.md),[Patient/cz-patient-addr-example-3](Patient-cz-patient-addr-example-3.md),[Patient/cz-patient-addr-example-4](Patient-cz-patient-addr-example-4.md),[Patient/cz-patient-addr-example-5](Patient-cz-patient-addr-example-5.md),[PermanentResidenceAddressCz](StructureDefinition-permanent-residencer-address-cz.md)and[RegisteringProviderCz](StructureDefinition-registering-provider-cz.md)


* Produced by HL7 under the terms of HL7® Governance and Operations Manual relating to Intellectual Property (Section 16), specifically its copyright, trademark and patent provisions. This document is licensed under Creative Commons "No Rights Reserved" (CC0).

* [Absent and Unknown Data - IPS](http://hl7.org/fhir/uv/ips/STU1.1/CodeSystem-absent-unknown-uv-ips.html): [AllergyIntolerance/allergy-1](AllergyIntolerance-allergy-1.md), [Device/AbsentDevice](Device-AbsentDevice.md) and [Device/NoInformationAboutDevice](Device-NoInformationAboutDevice.md)


* The UCUM codes, UCUM table (regardless of format), and UCUM Specification are copyright 1999-2009, Regenstrief Institute, Inc. and the Unified Codes for Units of Measures (UCUM) Organization. All rights reserved. [https://ucum.org/trac/wiki/TermsOfUse](https://ucum.org/trac/wiki/TermsOfUse)

* [Unified Code for Units of Measure (UCUM)](http://terminology.hl7.org/6.3.0/CodeSystem-v3-ucum.html): [Medication/med-1](Medication-med-1.md) and [MedicationStatement/Medication](MedicationStatement-Medication.md)


* These codes are excerpted from ASTM Standard, E1762-95(2013) - Standard Guide for Electronic Authentication of Health Care Information, Copyright by ASTM International, 100 Barr Harbor Drive, West Conshohocken, PA 19428. Copies of this standard are available through the ASTM Web Site at www.astm.org.

* [Signature Type Codes](http://hl7.org/fhir/R4/codesystem-signature-type.html): [Provenance/signature-rentgen](Provenance-signature-rentgen.md)


* This material contains content that is copyright of SNOMED International. Implementers of these specifications must have the appropriate SNOMED CT Affiliate license - for more information contact [https://www.snomed.org/get-snomed](https://www.snomed.org/get-snomed) or [info@snomed.org](mailto:info@snomed.org).

* [SNOMED Clinical Terms&reg; (SNOMED CT&reg;)](http://hl7.org/fhir/R4/codesystem-snomedct.html): [AllergyIntolerance/AllergyToCatDander](AllergyIntolerance-AllergyToCatDander.md), [BodyStructure/BodyStructure01](BodyStructure-BodyStructure01.md)...Show 11 more,[BodyStructureCz](StructureDefinition-BodyStructure-cz.md),[CZ_Specimen](StructureDefinition-cz-specimen.md),[CZ_SpecimenAdditiveSubstance](StructureDefinition-Substance-additive-cz.md),[Device/LabAnalyzer](Device-LabAnalyzer.md),[Device/Pacemaker](Device-Pacemaker.md),[Patient/Kocka](Patient-Kocka.md),[Patient/Mracena](Patient-Mracena.md),[PractitionerRole/practitionerrole1](PractitionerRole-practitionerrole1.md),[RegisteringProviderCz](StructureDefinition-registering-provider-cz.md),[Specimen/Specimen-example-animal](Specimen-Specimen-example-animal.md)and[Specimen/Specimen-example-environment](Specimen-Specimen-example-environment.md)


* This material derives from the HL7 Terminology (THO). THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: [https://terminology.hl7.org/license.html](https://terminology.hl7.org/license.html)

* [AllergyIntolerance Clinical Status Codes](http://terminology.hl7.org/7.0.1/CodeSystem-allergyintolerance-clinical.html): [AllergyIntolerance/AllergyToCatDander](AllergyIntolerance-AllergyToCatDander.md), [AllergyIntolerance/allergy-1](AllergyIntolerance-allergy-1.md) and [CZ_AllergyIntolerance](StructureDefinition-cz-allergyIntolerance.md)
* [AllergyIntolerance Verification Status](http://terminology.hl7.org/7.0.1/CodeSystem-allergyintolerance-verification.html): [AllergyIntolerance/AllergyToCatDander](AllergyIntolerance-AllergyToCatDander.md) and [AllergyIntolerance/allergy-1](AllergyIntolerance-allergy-1.md)
* [Coverage SelfPay Codes](http://terminology.hl7.org/7.0.1/CodeSystem-coverage-selfpay.html): [CZ_Coverage](StructureDefinition-cz-coverage.md)
* [AllergyIntoleranceCertainty](http://terminology.hl7.org/7.0.1/CodeSystem-reaction-event-certainty.html): [AllergyIntolerance/AllergyToCatDander](AllergyIntolerance-AllergyToCatDander.md)
* [contactRole2](http://terminology.hl7.org/7.0.1/CodeSystem-v2-0131.html): [Patient/Mracena](Patient-Mracena.md) and [RelatedPerson/RelatedPerson01](RelatedPerson-RelatedPerson01.md)
* [identifierType](http://terminology.hl7.org/7.0.1/CodeSystem-v2-0203.html): [CZ_Passport_Identifier](StructureDefinition-cz-passport-identifier.md), [CZ_PatientBase](StructureDefinition-cz-patient-base.md)...Show 6 more,[CZ_PatientCore](StructureDefinition-cz-patient-core.md),[CZ_RelatedPersonBase](StructureDefinition-cz-relatedPerson-base.md),[CZ_RelatedPersonCore](StructureDefinition-cz-relatedPerson-core.md),[Id_Card_Identifier](StructureDefinition-id-card-identifier.md),[Patient/Mracena](Patient-Mracena.md)and[RelatedPerson/RelatedPerson01](RelatedPerson-RelatedPerson01.md)
* [ActCode](http://terminology.hl7.org/7.0.1/CodeSystem-v3-ActCode.html): [CZ_Coverage](StructureDefinition-cz-coverage.md), [Coverage/Coverage01](Coverage-Coverage01.md) and [Encounter/cz-encounter-example](Encounter-cz-encounter-example.md)
* [ParticipationType](http://terminology.hl7.org/7.0.1/CodeSystem-v3-ParticipationType.html): [Provenance/signature-rentgen](Provenance-signature-rentgen.md)
* [RoleCode](http://terminology.hl7.org/7.0.1/CodeSystem-v3-RoleCode.html): [Patient/Mracena](Patient-Mracena.md) and [RelatedPerson/RelatedPerson01](RelatedPerson-RelatedPerson01.md)


* Unless otherwise indicated, reproduction of material posted on Council of Europe websites, and reproduction of photographs for which the Council of Europe holds copyright – see legal notice \“photo credits\” – is authorised for private use and for informational and educational uses relating to the Council of Europe’s work. This authorisation is subject to the condition that the source be indicated and no charge made for reproduction. Persons wishing to make some other use than those specified above, including commercial use, of information and text posted on these sites are asked to apply for prior written authorisation to the Council of Europe, Directorate of Communication.

* [EDQM Standard Terms](http://tx.fhir.org/r4/ValueSet/edqm): [Medication/med-1](Medication-med-1.md) and [MedicationStatement/Medication](MedicationStatement-Medication.md)


