# Summary artifacts - HL7 Czech Base and Core Implementation Guide v0.3.0-ballot

* [**Table of Contents**](toc.md)
* **Summary artifacts**

## Summary artifacts

This page provides a list of the FHIR artifacts defined as part of this implementation guide.

### Actors 

Actors used to describe the Document functional requirements for the specified data elements.

| | |
| :--- | :--- |
| [Actor Consumer L1](ActorDefinition-actor-consumer-L1.md) | A system receiving/querying and using a L1 document. |
| [Actor Consumer L2](ActorDefinition-actor-consumer-L2.md) | S system receiving/querying and using a L2 document. |
| [Actor Consumer L3](ActorDefinition-actor-consumer-L3.md) | A system receiving/querying and using a L3 document. |
| [Actor Creator L1](ActorDefinition-actor-creator-L1.md) | A system generating and sending/providing a L1 document to a Consumer for report storage and sharing. |
| [Actor Creator L2](ActorDefinition-actor-creator-L2.md) | A system generating and sending/providing a L2 document to a Consumer for report storage and sharing. |
| [Actor Creator L3](ActorDefinition-actor-creator-L3.md) | A system generating and sending/providing a L3 document to a Consumer for report storage and sharing. |

### Structures: Resource Profiles 

These define constraints on FHIR resources for systems conforming to this implementation guide.

| | |
| :--- | :--- |
| [Allergy Intolerance (CZ)](StructureDefinition-cz-allergyIntolerance.md) | Czech national profile for an Allergy Intolerance |
| [Attachment (CZ)](StructureDefinition-cz-attachment.md) | Czech national profile for attachment. |
| [Body Structure (CZ)](StructureDefinition-BodyStructure-cz.md) | This profile represents the Body Structure resource by the Czech national interoperability project. |
| [Coverage (CZ)](StructureDefinition-cz-coverage.md) | Czech national profile for a coverage. |
| [Device: Performer/Observer (CZ)](StructureDefinition-cz-device-observer.md) | Czech profile represents the constraints applied to the Device resource by the Czech national interoperability project.This profile describes a device that plays the role of observer or performer. |
| [DocumentReference containing logo (CZ)](StructureDefinition-cz-logo.md) | Czech national profile for document reference containing logo. |
| [Encounter (CZ)](StructureDefinition-cz-encounter.md) | Czech profile for encounter. |
| [Location (CZ base)](StructureDefinition-cz-location-base.md) | Czech national base profile for location resource. This profile implies use of the Czech standard address in the location resource. |
| [Location (CZ core)](StructureDefinition-cz-location-core.md) | Czech national core profile for location resource.This profile implies use of the Czech standard organization in the managingOrganization element. |
| [Medical Device (CZ)](StructureDefinition-cz-medical-device.md) | Czech profile represents the constraints applied to the Device resource by the Czech national interoperability project.This profile constrains the representation of a medical device used by or implanted on the patient. |
| [Medication (CZ)](StructureDefinition-cz-Medication.md) | Czech national profile for a medication. |
| [Medication Statement (CZ)](StructureDefinition-cz-MedicationStatement.md) | Czech national profile for a medication statement. |
| [Organization (CZ base)](StructureDefinition-cz-organization-base.md) | Czech national profile defines the way the organization is represented in the context of the Czech national interoperability project. |
| [Organization (CZ core)](StructureDefinition-cz-organization-core.md) | Czech national profile sets minimum expectations for the Organization resource common to most of the use cases. |
| [Patient (CZ base)](StructureDefinition-cz-patient-base.md) | This profile defines how to represent Patient in FHIR for the purpose of the Czech national interoperability standards. |
| [Patient (CZ core)](StructureDefinition-cz-patient-core.md) | This profile sets minimum expectations for the Patient resource common to most of the use cases. It is based on EU Patient Core. |
| [Patient: Animal (CZ)](StructureDefinition-cz-patient-animal.md) | This profile defines how to represent an Animal as subject of care in FHIR for the purpose of this guide. This is used to identify the species when a specimen is collected from an animal |
| [Practitioner (CZ base)](StructureDefinition-cz-practitioner-base.md) | Czech national profile for practitioner.Contains information about a person who provides healthcare or is a participant in the creation of a medical document. |
| [Practitioner (CZ core)](StructureDefinition-cz-practitioner-core.md) | Czech national profile for practitioner. Contains information about a person who provides healthcare or is a participant in the creation of a medical document. |
| [Practitioner Role (CZ base)](StructureDefinition-cz-practitionerrole-base.md) | Czech national profile for an practitioner role.It enables the identification of healthcare and non-healthcare workers, their expertise, workplaces and contact details. |
| [Practitioner Role (CZ core)](StructureDefinition-cz-practitionerrole-core.md) | Czech national profile for an practitioner role.It enables the identification of healthcare and non-healthcare workers, their expertise, workplaces and contact details. |
| [Presented Form (CZ)](StructureDefinition-cz-presented-form.md) | Czech national profile for presented form. |
| [Provenance (CZ)](StructureDefinition-cz-provenance.md) | Czech national profile on Provenance tracks information about the activity that created, revised, deleted, or signed a version of a resource, describing the entities and agents involved. |
| [Related Person (CZ base)](StructureDefinition-cz-relatedPerson-base.md) | Czech national profile for a related person. Contains an information about a person that is involved in the care for a patient, but who is not the target of healthcare, nor has a formal responsibility in the care process. |
| [Related Person (CZ core)](StructureDefinition-cz-relatedPerson-core.md) | Czech national profile for a related person.This profile sets minimum expectations for the Related Person resource common to most of the use cases. |
| [Specimen (CZ)](StructureDefinition-cz-specimen.md) | Czech national profile defines how to represent Specimens in HL7 FHIR for the purpose of this guide. |
| [Substance: Specimen Additive Substance (CZ)](StructureDefinition-Substance-additive-cz.md) | This profile defines how to represent Specimen Additive Substances in HL7 FHIR for the purpose of this guide. |

### Structures: Data Type Profiles 

These define constraints on FHIR data types for systems conforming to this implementation guide.

| | |
| :--- | :--- |
| [Address (CZ)](StructureDefinition-cz-address.md) | Czech national profile on address, to provide the possibility in the 'line' element to provide a seperate streetname, housenumber and postal box. It is always RECOMMENDED to give these elements separately. The national specification also includes the option of entering the address location according to the RUIAN register and marking the address as the permanent residence address. |
| [National ID card identifier](StructureDefinition-id-card-identifier.md) | This structure specifies the national personal ID card identifier. |
| [National birth number (CZ)](StructureDefinition-cz-rodcis-identifier.md) | This structure contains the Czech identifier of a person (personal identification number) |
| [National health sector identifier (CZ)](StructureDefinition-cz-rid-identifier.md) | This structure contains the Czech identifier of a person (personal identification number) in healthcare sector |
| [Oid Identifier](StructureDefinition-OidIdentifier.md) | Identifier with an oid |
| [Passport identifier](StructureDefinition-cz-passport-identifier.md) | This structure specifies the passport identifier. |
| [Signature (CZ)](StructureDefinition-cz-signature.md) | Czech national profile on Signature holds an electronic representation of a signature or timestamp and its supporting context in a FHIR accessible form. |

### Structures: Extension Definitions 

These define constraints on FHIR data types for systems conforming to this implementation guide.

| | |
| :--- | :--- |
| [Accreditation Requirement](StructureDefinition-accreditation-cz.md) | Indicates whether the examination must be performed only by a laboratory accredited for the specific test, or whether the result originates from such a laboratory. |
| [Address location code according to the system RÚIAN (ČÚZK)](StructureDefinition-address-point-cz.md) | This extension allows the entry of an address point according to the RÚIAN registry. |
| [Address permanent residence](StructureDefinition-permanent-residencer-address-cz.md) | This extension provides a link to the order [(Reference(ServiceRequest)] or requisition [ServiceRequest.requisition (i.e., 'Request.groupIdentifier')] that this report document is based on and fulfills. |
| [Composition: Presented Form](StructureDefinition-presentedForm.md) | Human readable representation of the entire document. Multiple formats are allowed but they SHALL be semantically equivalent. |
| [Organization Logo](StructureDefinition-cz-organization-logo.md) | An extension to associate a logo (e.g., image or icon) with an Organization, using a reference to a profile Attachment resource. |
| [Refund indicator code (VZP)](StructureDefinition-cz-refund-indicator-code.md) | Refund indicator according to the VZP catalogue 'Náhrady za zdravotní péči'. Used to indicate that the injury/health damage may have been caused by a third party. |
| [Registering provider](StructureDefinition-registering-provider-cz.md) | This extension allows the registration of the registering healthcare provider and its category/specialty (general practitioner for children and youth, general practitioner for adults, dentist, gynecologist). |

### Example: Example Instances 

These are example instances that show what data produced and consumed by systems conforming with this implementation guide might look like.

| | |
| :--- | :--- |
| [AbsentDevice](Device-AbsentDevice.md) | Patient without medical device |
| [Allergy to cat dander](AllergyIntolerance-AllergyToCatDander.md) | Example for AllergyIntolerance |
| [AllergyIntolerance - No Known Allergies](AllergyIntolerance-allergy-1.md) | AllergyIntolerance - No known allergies |
| [Body structure Example](BodyStructure-BodyStructure01.md) | Specific and identified anatomical structure |
| [Coverage Example](Coverage-Coverage01.md) | Insurance or medical plan or a payment agreement |
| [Kocka](Patient-Kocka.md) | Pacient animal - Domestic cat |
| [LabAnalyzer](Device-LabAnalyzer.md) | Clinical analyzer Beckman |
| [Location of laboratory](Location-location-laboratory.md) | Czech national core profile for location resource.This profile implies use of the Czech standard organization in the managingOrganization element. |
| [Location-Praha5](Location-Location-Praha5.md) | Example of a location. |
| [Medication - Simvastatin 40 MG Disintegrating Oral Tablet](Medication-med-1.md) | Medication - Simvastatin 40 MG Disintegrating Oral Tablet |
| [MedicationStatement - Ongoing Simvastatin Treatment](MedicationStatement-Medication.md) | Czech national profile for a medication statement. |
| [Mracena](Patient-Mracena.md) | Patient, contact information and practitioner |
| [NoInformationAboutDevice](Device-NoInformationAboutDevice.md) | Patient with unknown presence or use of medical device |
| [Organization of laboratory](Organization-Synlab.md) | Czech national core profile for organization resource. This example represents separate professional laboratory |
| [Organization-1](Organization-Organization-1.md) | An example of the organization of a provider |
| [Organization-2](Organization-Organization-2.md) | An example of the organization with logo extension |
| [Organization-3](Organization-Organization-3.md) | An example of the organization of a health insurance |
| [Organization: Registering healthcare provider example](Organization-RegisteringProviderExample.md) | Example of registering healthcare provider |
| [Pacemaker](Device-Pacemaker.md) | Heart pacemaker Medtronic W1DR01 |
| [Practitioner-123456789](Practitioner-Practitioner-123456789.md) | Practitioner id(KRZP)=123456789 |
| [Practitioner-2](Practitioner-Practitioner-2.md) | Practitioner id(KRZP)=987654321 |
| [Related person Example](RelatedPerson-RelatedPerson01.md) | A person that is related to a patient, but who is not a direct target of care |
| [Signature of image order](Provenance-signature-rentgen.md) | Czech national profile on Signature holds an electronic representation of a signature or timestamp and its supporting context in a FHIR accessible form. |
| [Specimen-example-animal](Specimen-Specimen-example-animal.md) | Example of a specimen taken from animal. |
| [Specimen-example-environment](Specimen-Specimen-example-environment.md) | Example of a specimen taken from environment. |
| [cz-attachment-example](DocumentReference-cz-attachment-example.md) | Example of attachment for DICOM file |
| [cz-encounter-example](Encounter-cz-encounter-example.md) | Encounter |
| [cz-patient-addr-example-1](Patient-cz-patient-addr-example-1.md) | Address of both types (physical and delivery) |
| [cz-patient-addr-example-2](Patient-cz-patient-addr-example-2.md) | Address with P.O.Box |
| [cz-patient-addr-example-3](Patient-cz-patient-addr-example-3.md) | Permanent residence address |
| [cz-patient-addr-example-4](Patient-cz-patient-addr-example-4.md) | Permanent residence address outside of the Czech Republic |
| [cz-patient-addr-example-5](Patient-cz-patient-addr-example-5.md) | Address identified by RUIAN system |
| [cz-presentedform-example](DocumentReference-cz-presentedform-example.md) | Presented form of Imaging order for Plain X-ray |
| [logoFNMotol](DocumentReference-attachment-logo-FN-Motol.md) | Example of logo as document reference for Nemocnice Obláčkov. |
| [practitionerrole1](PractitionerRole-practitionerrole1.md) | General practitioner's office |

