# Specimen (CZ) - HL7 Czech Base and Core Implementation Guide v0.3.0-ballot

* [**Table of Contents**](toc.md)
* [**Summary artifacts**](artifacts.md)
* **Specimen (CZ)**

## Resource Profile: Specimen (CZ) 

| | |
| :--- | :--- |
| *Official URL*:https://hl7.cz/fhir/core/StructureDefinition/cz-specimen | *Version*:0.3.0-ballot |
| Draft as of 2025-12-19 | *Computable Name*:CZ_Specimen |

 
Czech national profile defines how to represent Specimens in HL7 FHIR for the purpose of this guide. 

 
Specimens are samples of material that may be: 
• taken from a biological entity, living or dead 
• taken from a physical object or environment 
Some samples are biological and may contain one or more components including, but not limited to, cellular molecules, cells, tissues, organs, body fluids, embryos, and body excretions. The source of samples includes substances used for diagnostic and environmental testing. The focus of sample sources is on the process of collecting, maintaining, and processing the sample, as well as where the sample came from. 

**Usages:**

* Refer to this Profile: [Specimen (CZ)](StructureDefinition-cz-specimen.md)
* Examples for this Profile: [Specimen/Specimen-example-animal](Specimen-Specimen-example-animal.md) and [Specimen/Specimen-example-environment](Specimen-Specimen-example-environment.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.fhir.cz.core|current/StructureDefinition/cz-specimen)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-cz-specimen.csv), [Excel](StructureDefinition-cz-specimen.xlsx), [Schematron](StructureDefinition-cz-specimen.sch) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "cz-specimen",
  "url" : "https://hl7.cz/fhir/core/StructureDefinition/cz-specimen",
  "version" : "0.3.0-ballot",
  "name" : "CZ_Specimen",
  "title" : "Specimen (CZ)",
  "status" : "draft",
  "experimental" : false,
  "date" : "2025-12-19T09:24:48+00:00",
  "publisher" : "HL7 Czech Republic",
  "contact" : [
    {
      "name" : "HL7 Czech Republic",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.hl7.cz/"
        }
      ]
    }
  ],
  "description" : "Czech national profile defines how to represent Specimens in HL7 FHIR for the purpose of this guide.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "CZ",
          "display" : "Czechia"
        }
      ]
    }
  ],
  "purpose" : "Specimens are samples of material that may be:\r\n\r\n• taken from a biological entity, living or dead\r\n\r\n• taken from a physical object or environment\r\n\r\nSome samples are biological and may contain one or more components including, but not limited to, cellular molecules, cells, tissues, organs, body fluids, embryos, and body excretions. The source of samples includes substances used for diagnostic and environmental testing. The focus of sample sources is on the process of collecting, maintaining, and processing the sample, as well as where the sample came from.",
  "fhirVersion" : "4.0.1",
  "mapping" : [
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    },
    {
      "identity" : "w5",
      "uri" : "http://hl7.org/fhir/fivews",
      "name" : "FiveWs Pattern Mapping"
    },
    {
      "identity" : "v2",
      "uri" : "http://hl7.org/v2",
      "name" : "HL7 v2 Mapping"
    }
  ],
  "kind" : "resource",
  "abstract" : false,
  "type" : "Specimen",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/Specimen",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "Specimen",
        "path" : "Specimen",
        "short" : "Czech Specimen",
        "definition" : "Czech national profile defines how to represent Specimens in HL7 FHIR."
      },
      {
        "id" : "Specimen.identifier",
        "path" : "Specimen.identifier",
        "definition" : "Business identifier for specimen is RECOMMENDED to include when available.",
        "mustSupport" : true
      },
      {
        "id" : "Specimen.status",
        "path" : "Specimen.status",
        "mustSupport" : true
      },
      {
        "id" : "Specimen.type",
        "path" : "Specimen.type",
        "definition" : "The kind of material that forms the specimen. RECOMMENDED to include.",
        "binding" : {
          "strength" : "preferred",
          "valueSet" : "https://ncez.mzcr.cz/terminology/ValueSet/cz-specimen-type-vs"
        }
      },
      {
        "id" : "Specimen.subject",
        "path" : "Specimen.subject",
        "short" : "In the initial iteration of the Czech interoperability project, this is CZ_PatientCore.",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.org/fhir/StructureDefinition/Group",
              "https://hl7.cz/fhir/core/StructureDefinition/cz-device-observer",
              "https://hl7.cz/fhir/core/StructureDefinition/cz-medical-device",
              "http://hl7.org/fhir/StructureDefinition/Substance",
              "https://hl7.cz/fhir/core/StructureDefinition/cz-location-core",
              "https://hl7.cz/fhir/core/StructureDefinition/cz-patient-core"
            ]
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "Specimen.receivedTime",
        "path" : "Specimen.receivedTime",
        "mustSupport" : true
      },
      {
        "id" : "Specimen.parent",
        "path" : "Specimen.parent",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : ["https://hl7.cz/fhir/core/StructureDefinition/cz-specimen"]
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "Specimen.request",
        "path" : "Specimen.request",
        "mustSupport" : true
      },
      {
        "id" : "Specimen.collection.extension",
        "path" : "Specimen.collection.extension",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "value",
              "path" : "url"
            }
          ],
          "ordered" : false,
          "rules" : "open"
        }
      },
      {
        "id" : "Specimen.collection.extension:bodySite",
        "path" : "Specimen.collection.extension",
        "sliceName" : "bodySite",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Extension",
            "profile" : ["http://hl7.org/fhir/StructureDefinition/bodySite|5.2.0"]
          }
        ]
      },
      {
        "id" : "Specimen.collection.extension:bodySite.value[x]",
        "path" : "Specimen.collection.extension.value[x]",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "https://hl7.cz/fhir/core/StructureDefinition/BodyStructure-cz"
            ]
          }
        ]
      },
      {
        "id" : "Specimen.collection.collector",
        "path" : "Specimen.collection.collector",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "https://hl7.cz/fhir/core/StructureDefinition/cz-practitioner-core",
              "https://hl7.cz/fhir/core/StructureDefinition/cz-practitionerrole-core"
            ]
          }
        ]
      },
      {
        "id" : "Specimen.collection.bodySite",
        "path" : "Specimen.collection.bodySite",
        "comment" : "If the specimen.type conveys information about the site the specimen has been collected from, then, if the bodySite is present, it shall be coherent with the type",
        "binding" : {
          "strength" : "preferred",
          "valueSet" : "http://hl7.org/fhir/ValueSet/body-site"
        }
      },
      {
        "id" : "Specimen.processing",
        "path" : "Specimen.processing",
        "short" : "Processing and processing step details to include when not implicit from specimen."
      },
      {
        "id" : "Specimen.processing.additive",
        "path" : "Specimen.processing.additive",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.org/fhir/StructureDefinition/Substance",
              "https://hl7.cz/fhir/core/StructureDefinition/Substance-additive-cz"
            ]
          }
        ]
      },
      {
        "id" : "Specimen.container.extension",
        "path" : "Specimen.container.extension",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "value",
              "path" : "url"
            }
          ],
          "ordered" : false,
          "rules" : "open"
        }
      },
      {
        "id" : "Specimen.container.extension:device",
        "path" : "Specimen.container.extension",
        "sliceName" : "device",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Extension",
            "profile" : [
              "http://hl7.org/fhir/5.0/StructureDefinition/extension-Specimen.container.device"
            ]
          }
        ]
      },
      {
        "id" : "Specimen.container.extension:device.value[x]",
        "path" : "Specimen.container.extension.value[x]",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "https://hl7.cz/fhir/core/StructureDefinition/cz-medical-device"
            ]
          }
        ]
      },
      {
        "id" : "Specimen.container.type",
        "path" : "Specimen.container.type",
        "binding" : {
          "strength" : "preferred",
          "valueSet" : "https://ncez.mzcr.cz/terminology/ValueSet/cz-specimen-container"
        }
      },
      {
        "id" : "Specimen.container.additive[x]",
        "path" : "Specimen.container.additive[x]",
        "max" : "0"
      },
      {
        "id" : "Specimen.condition",
        "path" : "Specimen.condition",
        "mustSupport" : true
      },
      {
        "id" : "Specimen.note",
        "path" : "Specimen.note",
        "mustSupport" : true
      }
    ]
  }
}

```
