# National birth number (CZ) - HL7 Czech Base and Core Implementation Guide v0.3.0-ballot

* [**Table of Contents**](toc.md)
* [**Summary artifacts**](artifacts.md)
* **National birth number (CZ)**

## Data Type Profile: National birth number (CZ) 

| | | |
| :--- | :--- | :--- |
| *Official URL*:https://hl7.cz/fhir/core/StructureDefinition/cz-rodcis-identifier | *Version*:0.3.0-ballot | |
| *Standards status:*[Draft](http://hl7.org/fhir/R4/versions.html#std-process) | [Maturity Level](http://hl7.org/fhir/versions.html#maturity): 1 | *Computable Name*:CZ_Rodcis_Identifier |

 
This structure contains the Czech identifier of a person (personal identification number) 

 
Czech national birth number. National birth number are assigned to: 
• a natural person at birth or adoption of a minor natural person 
• a citizen who has not yet had a personal identification number, a foreigner with a residence permit in the Czech Republic 
• a foreigner who has been granted international protection in the Czech Republic in the form of asylum or subsidiary protection 
• foreigner who has requested the fulfillment of conditions under a special legal regulation for the assignment of a personal identification number, e.g. studying at a university, employment, etc. 
• a natural person for whom the Czech Social Security Administration or the District Social Security Administration requests the assignment of a personal identification number under a special legal regulation. 

**Usages:**

* Use this DataType Profile: [Patient (CZ base)](StructureDefinition-cz-patient-base.md) and [Related Person (CZ base)](StructureDefinition-cz-relatedPerson-base.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.fhir.cz.core|current/StructureDefinition/cz-rodcis-identifier)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-cz-rodcis-identifier.csv), [Excel](StructureDefinition-cz-rodcis-identifier.xlsx), [Schematron](StructureDefinition-cz-rodcis-identifier.sch) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "cz-rodcis-identifier",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-fmm",
      "valueInteger" : 1
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
      "valueCode" : "draft"
    }
  ],
  "url" : "https://hl7.cz/fhir/core/StructureDefinition/cz-rodcis-identifier",
  "version" : "0.3.0-ballot",
  "name" : "CZ_Rodcis_Identifier",
  "title" : "National birth number (CZ)",
  "status" : "draft",
  "experimental" : false,
  "date" : "2025-12-19T09:24:48+00:00",
  "publisher" : "HL7 Czech Republic",
  "contact" : [
    {
      "name" : "HL7 Czech Republic",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.hl7.cz/"
        }
      ]
    }
  ],
  "description" : "This structure contains the Czech identifier of a person (personal identification number)",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "CZ",
          "display" : "Czechia"
        }
      ]
    }
  ],
  "purpose" : "Czech national birth number. National birth number are assigned to:\n\r\n• a natural person at birth or adoption of a minor natural person\n\r\n• a citizen who has not yet had a personal identification number, a foreigner with a residence permit in the Czech Republic\n\r\n• a foreigner who has been granted international protection in the Czech Republic in the form of asylum or subsidiary protection\n\r\n• foreigner who has requested the fulfillment of conditions under a special legal regulation for the assignment of a personal identification number, e.g. studying at a university, employment, etc.\n\r\n• a natural person for whom the Czech Social Security Administration or the District Social Security Administration requests the assignment of a personal identification number under a special legal regulation.",
  "fhirVersion" : "4.0.1",
  "mapping" : [
    {
      "identity" : "v2",
      "uri" : "http://hl7.org/v2",
      "name" : "HL7 v2 Mapping"
    },
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    },
    {
      "identity" : "servd",
      "uri" : "http://www.omg.org/spec/ServD/1.0/",
      "name" : "ServD"
    }
  ],
  "kind" : "complex-type",
  "abstract" : false,
  "type" : "Identifier",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/Identifier",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "Identifier",
        "path" : "Identifier",
        "short" : "Czech national birth number",
        "definition" : "Czech national identifier defines how to representNational birth number in HL7 FHIR."
      },
      {
        "id" : "Identifier.use",
        "path" : "Identifier.use",
        "fixedCode" : "official"
      },
      {
        "id" : "Identifier.system",
        "path" : "Identifier.system",
        "min" : 1,
        "fixedUri" : "https://ncez.mzcr.cz/fhir/sid/rcis"
      },
      {
        "id" : "Identifier.value",
        "path" : "Identifier.value",
        "min" : 1,
        "maxLength" : 10,
        "constraint" : [
          {
            "key" : "rc",
            "requirements" : "Czech national personal ID rules.",
            "severity" : "error",
            "human" : "Czech national personal ID rule",
            "expression" : "matches('[0-9]{2}(?:[0257][1-9]|[1368][0-2])(?:0[1-9]|[12][0-9]|3[01])[0-9]{3,4}')",
            "source" : "https://hl7.cz/fhir/core/StructureDefinition/cz-rodcis-identifier"
          }
        ],
        "mustSupport" : false
      },
      {
        "id" : "Identifier.assigner",
        "path" : "Identifier.assigner",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "https://hl7.cz/fhir/core/StructureDefinition/cz-organization-core"
            ]
          }
        ]
      }
    ]
  }
}

```
