# Related Person (CZ core) - HL7 Czech Base and Core Implementation Guide v0.3.0-ballot

* [**Table of Contents**](toc.md)
* [**Summary artifacts**](artifacts.md)
* **Related Person (CZ core)**

## Resource Profile: Related Person (CZ core) 

| | | |
| :--- | :--- | :--- |
| *Official URL*:https://hl7.cz/fhir/core/StructureDefinition/cz-relatedPerson-core | *Version*:0.3.0-ballot | |
| *Standards status:*[Draft](http://hl7.org/fhir/R4/versions.html#std-process) | [Maturity Level](http://hl7.org/fhir/versions.html#maturity): 1 | *Computable Name*:CZ_RelatedPersonCore |

 
Czech national profile for a related person.This profile sets minimum expectations for the Related Person resource common to most of the use cases. 

**Usages:**

* Refer to this Profile: [Medication Statement (CZ)](StructureDefinition-cz-MedicationStatement.md), [Allergy Intolerance (CZ)](StructureDefinition-cz-allergyIntolerance.md), [Coverage (CZ)](StructureDefinition-cz-coverage.md), [Patient: Animal (CZ)](StructureDefinition-cz-patient-animal.md)...Show 3 more,[Patient (CZ core)](StructureDefinition-cz-patient-core.md),[Provenance (CZ)](StructureDefinition-cz-provenance.md)and[Signature (CZ)](StructureDefinition-cz-signature.md)
* Examples for this Profile: [RelatedPerson/RelatedPerson01](RelatedPerson-RelatedPerson01.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.fhir.cz.core|current/StructureDefinition/cz-relatedPerson-core)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-cz-relatedPerson-core.csv), [Excel](StructureDefinition-cz-relatedPerson-core.xlsx), [Schematron](StructureDefinition-cz-relatedPerson-core.sch) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "cz-relatedPerson-core",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-fmm",
      "valueInteger" : 1
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
      "valueCode" : "draft"
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-imposeProfile",
      "valueCanonical" : "http://hl7.org/fhir/StructureDefinition/RelatedPerson"
    }
  ],
  "url" : "https://hl7.cz/fhir/core/StructureDefinition/cz-relatedPerson-core",
  "version" : "0.3.0-ballot",
  "name" : "CZ_RelatedPersonCore",
  "title" : "Related Person (CZ core)",
  "status" : "draft",
  "experimental" : false,
  "date" : "2025-12-19T09:24:48+00:00",
  "publisher" : "HL7 Czech Republic",
  "contact" : [
    {
      "name" : "HL7 Czech Republic",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.hl7.cz/"
        }
      ]
    }
  ],
  "description" : "Czech national profile for a related person.This profile sets minimum expectations for the Related Person resource common to most of the use cases.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "CZ",
          "display" : "Czechia"
        }
      ]
    }
  ],
  "fhirVersion" : "4.0.1",
  "mapping" : [
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    },
    {
      "identity" : "w5",
      "uri" : "http://hl7.org/fhir/fivews",
      "name" : "FiveWs Pattern Mapping"
    },
    {
      "identity" : "v2",
      "uri" : "http://hl7.org/v2",
      "name" : "HL7 v2 Mapping"
    }
  ],
  "kind" : "resource",
  "abstract" : false,
  "type" : "RelatedPerson",
  "baseDefinition" : "https://hl7.cz/fhir/core/StructureDefinition/cz-relatedPerson-base",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "RelatedPerson",
        "path" : "RelatedPerson",
        "short" : "Czech Related person (core profile)",
        "definition" : "Czech national core profile defines how to represent Related Person in HL7 FHIR.",
        "comment" : "The source is primarily used for attribution of information, as individuals are often the source of information about the patient."
      },
      {
        "id" : "RelatedPerson.patient",
        "path" : "RelatedPerson.patient",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "https://hl7.cz/fhir/core/StructureDefinition/cz-patient-core"
            ]
          }
        ]
      },
      {
        "id" : "RelatedPerson.name",
        "path" : "RelatedPerson.name",
        "constraint" : [
          {
            "key" : "cz-relPer-1",
            "severity" : "error",
            "human" : "RelatedPerson.name.given, RelatedPerson.name.family, RelatedPerson.name.text or data-absent-reason MUST be filled",
            "expression" : "family.exists() or given.exists() or text.exists() or extension('http://hl7.org/fhir/StructureDefinition/data-absent-reason').exists()",
            "source" : "https://hl7.cz/fhir/core/StructureDefinition/cz-relatedPerson-core"
          }
        ]
      },
      {
        "id" : "RelatedPerson.name.given",
        "path" : "RelatedPerson.name.given",
        "min" : 1
      }
    ]
  }
}

```
