# Related Person (CZ base) - HL7 Czech Base and Core Implementation Guide v0.3.0-ballot

* [**Table of Contents**](toc.md)
* [**Summary artifacts**](artifacts.md)
* **Related Person (CZ base)**

## Resource Profile: Related Person (CZ base) 

| | |
| :--- | :--- |
| *Official URL*:https://hl7.cz/fhir/core/StructureDefinition/cz-relatedPerson-base | *Version*:0.3.0-ballot |
| Draft as of 2025-12-19 | *Computable Name*:CZ_RelatedPersonBase |

 
Czech national profile for a related person. Contains an information about a person that is involved in the care for a patient, but who is not the target of healthcare, nor has a formal responsibility in the care process. 

 
Related persons typically have a personal or non-healthcare professional relationship with the patient. The source is primarily used for attribution of information, as individuals are often the source of information about the patient. 

**Usages:**

* Derived from this Profile: [Related Person (CZ core)](StructureDefinition-cz-relatedPerson-core.md)
* Refer to this Profile: [Patient (CZ base)](StructureDefinition-cz-patient-base.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.fhir.cz.core|current/StructureDefinition/cz-relatedPerson-base)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-cz-relatedPerson-base.csv), [Excel](StructureDefinition-cz-relatedPerson-base.xlsx), [Schematron](StructureDefinition-cz-relatedPerson-base.sch) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "cz-relatedPerson-base",
  "url" : "https://hl7.cz/fhir/core/StructureDefinition/cz-relatedPerson-base",
  "version" : "0.3.0-ballot",
  "name" : "CZ_RelatedPersonBase",
  "title" : "Related Person (CZ base)",
  "status" : "draft",
  "experimental" : false,
  "date" : "2025-12-19T09:24:48+00:00",
  "publisher" : "HL7 Czech Republic",
  "contact" : [
    {
      "name" : "HL7 Czech Republic",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.hl7.cz/"
        }
      ]
    }
  ],
  "description" : "Czech national profile for a related person. Contains an information about a person that is involved in the care for a patient,\r\nbut who is not the target of healthcare, nor has a formal responsibility in the care process.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "CZ",
          "display" : "Czechia"
        }
      ]
    }
  ],
  "purpose" : "Related persons typically have a personal or non-healthcare professional relationship with the patient. The source is primarily used for attribution of information, as individuals are often the source of information about the patient.",
  "fhirVersion" : "4.0.1",
  "mapping" : [
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    },
    {
      "identity" : "w5",
      "uri" : "http://hl7.org/fhir/fivews",
      "name" : "FiveWs Pattern Mapping"
    },
    {
      "identity" : "v2",
      "uri" : "http://hl7.org/v2",
      "name" : "HL7 v2 Mapping"
    }
  ],
  "kind" : "resource",
  "abstract" : false,
  "type" : "RelatedPerson",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/RelatedPerson",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "RelatedPerson",
        "path" : "RelatedPerson",
        "short" : "Czech Related person (base profile)",
        "definition" : "Czech national base profile defines how to represent Related Person in HL7 FHIR."
      },
      {
        "id" : "RelatedPerson.identifier",
        "path" : "RelatedPerson.identifier",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "value",
              "path" : "system"
            }
          ],
          "rules" : "open"
        },
        "definition" : "Patient identifier.\r\n\r\nWhen available, one of the national identifiers (patient number from the national patient register, birth number (RC), insurance number) is usually used. Organisations may also provide a local identifier using their own identification system. If necessary, the type of identifier can also be added."
      },
      {
        "id" : "RelatedPerson.identifier:RC",
        "path" : "RelatedPerson.identifier",
        "sliceName" : "RC",
        "short" : "Personal Number",
        "definition" : "Patient identifier assigned under the Czech Population Registration Act.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Identifier",
            "profile" : [
              "https://hl7.cz/fhir/core/StructureDefinition/cz-rodcis-identifier"
            ]
          }
        ]
      },
      {
        "id" : "RelatedPerson.identifier:CPOJ",
        "path" : "RelatedPerson.identifier",
        "sliceName" : "CPOJ",
        "short" : "Health Insurance Number",
        "definition" : "An unique patient identifier (číslo pojištěnce) according to the National Health Insurance Register",
        "min" : 0,
        "max" : "1"
      },
      {
        "id" : "RelatedPerson.identifier:CPOJ.system",
        "path" : "RelatedPerson.identifier.system",
        "min" : 1,
        "fixedUri" : "https://ncez.mzcr.cz/fhir/sid/cpoj"
      },
      {
        "id" : "RelatedPerson.identifier:CPOJ.value",
        "path" : "RelatedPerson.identifier.value",
        "min" : 1
      },
      {
        "id" : "RelatedPerson.identifier:CPOJ.assigner",
        "path" : "RelatedPerson.identifier.assigner",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "https://hl7.cz/fhir/core/StructureDefinition/cz-organization-core"
            ]
          }
        ]
      },
      {
        "id" : "RelatedPerson.identifier:PAS",
        "path" : "RelatedPerson.identifier",
        "sliceName" : "PAS",
        "short" : "Passport Number",
        "definition" : "An unique patient identifier (Passport Number)",
        "min" : 0,
        "max" : "*"
      },
      {
        "id" : "RelatedPerson.identifier:PAS.use",
        "path" : "RelatedPerson.identifier.use",
        "patternCode" : "official"
      },
      {
        "id" : "RelatedPerson.identifier:PAS.type",
        "path" : "RelatedPerson.identifier.type",
        "patternCodeableConcept" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v2-0203",
              "code" : "PPN"
            }
          ]
        }
      },
      {
        "id" : "RelatedPerson.identifier:PAS.system",
        "path" : "RelatedPerson.identifier.system",
        "short" : "Name space according to the passport issuer. FHIR records namespaces for passports in the format - https://ncez.mzcr.cz/fhir/sid/IdCardNumNS-XXX, where XXX is the three-letter country code according to ISO 3166",
        "binding" : {
          "strength" : "required",
          "valueSet" : "https://ncez.mzcr.cz/terminology/ValueSet/PassportNS-vs"
        }
      },
      {
        "id" : "RelatedPerson.identifier:PAS.value",
        "path" : "RelatedPerson.identifier.value",
        "min" : 1
      },
      {
        "id" : "RelatedPerson.identifier:PAS.assigner",
        "path" : "RelatedPerson.identifier.assigner",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "https://hl7.cz/fhir/core/StructureDefinition/cz-organization-core"
            ]
          }
        ]
      },
      {
        "id" : "RelatedPerson.identifier:RID",
        "path" : "RelatedPerson.identifier",
        "sliceName" : "RID",
        "short" : "National Health Sector Identifier",
        "definition" : "An unique patient identifier (resortní identifikátor RID) or temporary patient identifier (DRID) according to the National Patient Register (KRP)",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Identifier",
            "profile" : [
              "https://hl7.cz/fhir/core/StructureDefinition/cz-rid-identifier"
            ]
          }
        ]
      },
      {
        "id" : "RelatedPerson.identifier:OP",
        "path" : "RelatedPerson.identifier",
        "sliceName" : "OP",
        "short" : "National Identity Card Number",
        "definition" : "An unique person identifier (National ID Card Number) issued by the ministry of interior",
        "min" : 0,
        "max" : "*"
      },
      {
        "id" : "RelatedPerson.identifier:OP.system",
        "path" : "RelatedPerson.identifier.system",
        "binding" : {
          "strength" : "required",
          "valueSet" : "https://hl7.cz/terminology/ValueSet/OP-NS"
        }
      },
      {
        "id" : "RelatedPerson.identifier:OP.value",
        "path" : "RelatedPerson.identifier.value",
        "min" : 1
      },
      {
        "id" : "RelatedPerson.identifier:OP.assigner",
        "path" : "RelatedPerson.identifier.assigner",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "https://hl7.cz/fhir/core/StructureDefinition/cz-organization-core"
            ]
          }
        ]
      },
      {
        "id" : "RelatedPerson.patient",
        "path" : "RelatedPerson.patient",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "https://hl7.cz/fhir/core/StructureDefinition/cz-patient-base"
            ]
          }
        ]
      },
      {
        "id" : "RelatedPerson.name",
        "path" : "RelatedPerson.name",
        "max" : "1"
      },
      {
        "id" : "RelatedPerson.gender",
        "path" : "RelatedPerson.gender",
        "binding" : {
          "strength" : "required",
          "valueSet" : "https://hl7.cz/terminology/ValueSet/administrative-gender-cz"
        }
      },
      {
        "id" : "RelatedPerson.birthDate",
        "path" : "RelatedPerson.birthDate",
        "definition" : "The date of birth for the related person.It is RECOMMENDED to give the birthdate when available."
      },
      {
        "id" : "RelatedPerson.address",
        "path" : "RelatedPerson.address",
        "type" : [
          {
            "code" : "Address",
            "profile" : ["https://hl7.cz/fhir/core/StructureDefinition/cz-address"]
          }
        ]
      }
    ]
  }
}

```
