# Refund indicator code (VZP) - HL7 Czech Base and Core Implementation Guide v0.3.0-ballot

* [**Table of Contents**](toc.md)
* [**Summary artifacts**](artifacts.md)
* **Refund indicator code (VZP)**

## Extension: Refund indicator code (VZP) 

| | |
| :--- | :--- |
| *Official URL*:https://hl7.cz/fhir/core/StructureDefinition/cz-refund-indicator-code | *Version*:0.3.0-ballot |
| Draft as of 2025-12-19 | *Computable Name*:CZ_RefundIndicatorCode |

Refund indicator according to the VZP catalogue 'Náhrady za zdravotní péči'. Used to indicate that the injury/health damage may have been caused by a third party.

**Context of Use**

**Usage info**

**Usages:**

* Use this Extension: [Coverage (CZ)](StructureDefinition-cz-coverage.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.fhir.cz.core|current/StructureDefinition/cz-refund-indicator-code)

### Formal Views of Extension Content

 [Description of Profiles, Differentials, Snapshots, and how the XML and JSON presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-cz-refund-indicator-code.csv), [Excel](StructureDefinition-cz-refund-indicator-code.xlsx), [Schematron](StructureDefinition-cz-refund-indicator-code.sch) 

#### Constraints



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "cz-refund-indicator-code",
  "url" : "https://hl7.cz/fhir/core/StructureDefinition/cz-refund-indicator-code",
  "version" : "0.3.0-ballot",
  "name" : "CZ_RefundIndicatorCode",
  "title" : "Refund indicator code (VZP)",
  "status" : "draft",
  "date" : "2025-12-19T09:24:48+00:00",
  "publisher" : "HL7 Czech Republic",
  "contact" : [
    {
      "name" : "HL7 Czech Republic",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.hl7.cz/"
        }
      ]
    }
  ],
  "description" : "Refund indicator according to the VZP catalogue 'Náhrady za zdravotní péči'.\nUsed to indicate that the injury/health damage may have been caused by a third party.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "CZ",
          "display" : "Czechia"
        }
      ]
    }
  ],
  "fhirVersion" : "4.0.1",
  "mapping" : [
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    }
  ],
  "kind" : "complex-type",
  "abstract" : false,
  "context" : [
    {
      "type" : "element",
      "expression" : "Coverage"
    }
  ],
  "type" : "Extension",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/Extension",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "Extension",
        "path" : "Extension",
        "short" : "Refund indicator code (VZP)",
        "definition" : "Refund indicator according to the VZP catalogue 'Náhrady za zdravotní péči'.\nUsed to indicate that the injury/health damage may have been caused by a third party."
      },
      {
        "id" : "Extension.extension",
        "path" : "Extension.extension",
        "max" : "0"
      },
      {
        "id" : "Extension.url",
        "path" : "Extension.url",
        "fixedUri" : "https://hl7.cz/fhir/core/StructureDefinition/cz-refund-indicator-code"
      },
      {
        "id" : "Extension.value[x]",
        "path" : "Extension.value[x]",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ]
      }
    ]
  }
}

```
