# Patient (CZ core) - HL7 Czech Base and Core Implementation Guide v0.3.0-ballot

* [**Table of Contents**](toc.md)
* [**Summary artifacts**](artifacts.md)
* **Patient (CZ core)**

## Resource Profile: Patient (CZ core) 

| | | |
| :--- | :--- | :--- |
| *Official URL*:https://hl7.cz/fhir/core/StructureDefinition/cz-patient-core | *Version*:0.3.0-ballot | |
| *Standards status:*[Draft](http://hl7.org/fhir/R4/versions.html#std-process) | [Maturity Level](http://hl7.org/fhir/versions.html#maturity): 1 | *Computable Name*:CZ_PatientCore |

 
This profile sets minimum expectations for the Patient resource common to most of the use cases. It is based on EU Patient Core. 

**Usages:**

* Refer to this Profile: [Body Structure (CZ)](StructureDefinition-BodyStructure-cz.md), [Medication Statement (CZ)](StructureDefinition-cz-MedicationStatement.md), [Allergy Intolerance (CZ)](StructureDefinition-cz-allergyIntolerance.md), [Coverage (CZ)](StructureDefinition-cz-coverage.md)...Show 8 more,[Device: Performer/Observer (CZ)](StructureDefinition-cz-device-observer.md),[Medical Device (CZ)](StructureDefinition-cz-medical-device.md),[Patient: Animal (CZ)](StructureDefinition-cz-patient-animal.md),[Patient (CZ core)](StructureDefinition-cz-patient-core.md),[Provenance (CZ)](StructureDefinition-cz-provenance.md),[Related Person (CZ core)](StructureDefinition-cz-relatedPerson-core.md),[Signature (CZ)](StructureDefinition-cz-signature.md)and[Specimen (CZ)](StructureDefinition-cz-specimen.md)
* Examples for this Profile: [Patient/Mracena](Patient-Mracena.md), [Patient/cz-patient-addr-example-1](Patient-cz-patient-addr-example-1.md), [Patient/cz-patient-addr-example-2](Patient-cz-patient-addr-example-2.md), [Patient/cz-patient-addr-example-3](Patient-cz-patient-addr-example-3.md)...Show 2 more,[Patient/cz-patient-addr-example-4](Patient-cz-patient-addr-example-4.md)and[Patient/cz-patient-addr-example-5](Patient-cz-patient-addr-example-5.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.fhir.cz.core|current/StructureDefinition/cz-patient-core)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-cz-patient-core.csv), [Excel](StructureDefinition-cz-patient-core.xlsx), [Schematron](StructureDefinition-cz-patient-core.sch) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "cz-patient-core",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-fmm",
      "valueInteger" : 1
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
      "valueCode" : "draft"
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-imposeProfile",
      "valueCanonical" : "http://hl7.eu/fhir/base/StructureDefinition/patient-eu-core"
    }
  ],
  "url" : "https://hl7.cz/fhir/core/StructureDefinition/cz-patient-core",
  "version" : "0.3.0-ballot",
  "name" : "CZ_PatientCore",
  "title" : "Patient (CZ core)",
  "status" : "draft",
  "experimental" : false,
  "date" : "2025-12-19T09:24:48+00:00",
  "publisher" : "HL7 Czech Republic",
  "contact" : [
    {
      "name" : "HL7 Czech Republic",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.hl7.cz/"
        }
      ]
    }
  ],
  "description" : "This profile sets minimum expectations for the Patient resource common to most of the use cases. It is based on EU Patient Core.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "CZ",
          "display" : "Czechia"
        }
      ]
    }
  ],
  "fhirVersion" : "4.0.1",
  "mapping" : [
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    },
    {
      "identity" : "cda",
      "uri" : "http://hl7.org/v3/cda",
      "name" : "CDA (R2)"
    },
    {
      "identity" : "w5",
      "uri" : "http://hl7.org/fhir/fivews",
      "name" : "FiveWs Pattern Mapping"
    },
    {
      "identity" : "v2",
      "uri" : "http://hl7.org/v2",
      "name" : "HL7 v2 Mapping"
    },
    {
      "identity" : "loinc",
      "uri" : "http://loinc.org",
      "name" : "LOINC code for the element"
    }
  ],
  "kind" : "resource",
  "abstract" : false,
  "type" : "Patient",
  "baseDefinition" : "https://hl7.cz/fhir/core/StructureDefinition/cz-patient-base",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "Patient",
        "path" : "Patient",
        "definition" : "This profile sets minimum expectations for represention of Patient in FHIR for the purpose of the Czech national interoperability standards.",
        "constraint" : [
          {
            "key" : "cz-pat-2",
            "severity" : "error",
            "human" : "A patient can have only one registering physician of a given type",
            "expression" : "extension('https://hl7.cz/fhir/core/StructureDefinition/registering-provider-cz').extension('category').isDistinct()",
            "source" : "https://hl7.cz/fhir/core/StructureDefinition/cz-patient-core"
          }
        ]
      },
      {
        "id" : "Patient.extension:registeringProvider",
        "path" : "Patient.extension",
        "sliceName" : "registeringProvider",
        "short" : "Registering primary outpatient healthcare provider",
        "definition" : "A registering provider means an ambulatory care provider in the field of general practice medicine, in the field of practice medicine for children and adolescents, in the field of dentistry or in the field of gynecology and obstetrics, who accepted a patient for the purpose of providing primary ambulatory care.",
        "comment" : "At any one time, a patient may have no more than one general practitioner or paediatric and adolescent practitioner and one dental registrar. Female patients may also have no more than one registered provider in gynaecology and obstetrics.",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "Extension",
            "profile" : [
              "https://hl7.cz/fhir/core/StructureDefinition/registering-provider-cz"
            ]
          }
        ]
      },
      {
        "id" : "Patient.identifier",
        "path" : "Patient.identifier",
        "min" : 1,
        "constraint" : [
          {
            "key" : "cz-pat-3",
            "severity" : "error",
            "human" : "Patient.identifier[OP] MUST has only one with use=official",
            "expression" : "where($this is OP and use='official').count() <= 1",
            "source" : "https://hl7.cz/fhir/core/StructureDefinition/cz-patient-core"
          }
        ]
      },
      {
        "id" : "Patient.identifier:RID",
        "path" : "Patient.identifier",
        "sliceName" : "RID",
        "min" : 1
      },
      {
        "id" : "Patient.name",
        "path" : "Patient.name",
        "constraint" : [
          {
            "key" : "cz-pat-1",
            "severity" : "error",
            "human" : "Patient.name.given, Patient.name.family, Patient.name.text or data-absent-reason MUST be filled",
            "expression" : "family.exists() or given.exists() or text.exists() or extension('http://hl7.org/fhir/StructureDefinition/data-absent-reason').exists()",
            "source" : "https://hl7.cz/fhir/core/StructureDefinition/cz-patient-core"
          }
        ]
      },
      {
        "id" : "Patient.birthDate.extension:dob-absent-reason",
        "path" : "Patient.birthDate.extension",
        "sliceName" : "dob-absent-reason",
        "short" : "Reason for not providing the Date of Birth.",
        "definition" : "Reason for not providing the Date of Birth.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Extension",
            "profile" : [
              "http://hl7.org/fhir/StructureDefinition/data-absent-reason|5.2.0"
            ]
          }
        ]
      },
      {
        "id" : "Patient.contact.organization",
        "path" : "Patient.contact.organization",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "https://hl7.cz/fhir/core/StructureDefinition/cz-organization-core"
            ]
          }
        ]
      },
      {
        "id" : "Patient.generalPractitioner",
        "path" : "Patient.generalPractitioner",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "https://hl7.cz/fhir/core/StructureDefinition/cz-organization-core",
              "https://hl7.cz/fhir/core/StructureDefinition/cz-practitioner-core",
              "https://hl7.cz/fhir/core/StructureDefinition/cz-practitionerrole-core"
            ]
          }
        ]
      },
      {
        "id" : "Patient.managingOrganization",
        "path" : "Patient.managingOrganization",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "https://hl7.cz/fhir/core/StructureDefinition/cz-organization-core"
            ]
          }
        ]
      },
      {
        "id" : "Patient.link.other",
        "path" : "Patient.link.other",
        "type" : [
          {
            "extension" : [
              {
                "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-hierarchy",
                "valueBoolean" : false
              }
            ],
            "code" : "Reference",
            "targetProfile" : [
              "https://hl7.cz/fhir/core/StructureDefinition/cz-patient-core",
              "https://hl7.cz/fhir/core/StructureDefinition/cz-relatedPerson-core"
            ]
          }
        ]
      }
    ]
  }
}

```
