# Patient (CZ base) - HL7 Czech Base and Core Implementation Guide v0.3.0-ballot

* [**Table of Contents**](toc.md)
* [**Summary artifacts**](artifacts.md)
* **Patient (CZ base)**

## Resource Profile: Patient (CZ base) 

| | | |
| :--- | :--- | :--- |
| *Official URL*:https://hl7.cz/fhir/core/StructureDefinition/cz-patient-base | *Version*:0.3.0-ballot | |
| *Standards status:*[Draft](http://hl7.org/fhir/R4/versions.html#std-process) | [Maturity Level](http://hl7.org/fhir/versions.html#maturity): 1 | *Computable Name*:CZ_PatientBase |

 
This profile defines how to represent Patient in FHIR for the purpose of the Czech national interoperability standards. 

**Usages:**

* Derived from this Profile: [Patient (CZ core)](StructureDefinition-cz-patient-core.md)
* Refer to this Profile: [Patient (CZ base)](StructureDefinition-cz-patient-base.md) and [Related Person (CZ base)](StructureDefinition-cz-relatedPerson-base.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.fhir.cz.core|current/StructureDefinition/cz-patient-base)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-cz-patient-base.csv), [Excel](StructureDefinition-cz-patient-base.xlsx), [Schematron](StructureDefinition-cz-patient-base.sch) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "cz-patient-base",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-fmm",
      "valueInteger" : 1
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
      "valueCode" : "draft"
    }
  ],
  "url" : "https://hl7.cz/fhir/core/StructureDefinition/cz-patient-base",
  "version" : "0.3.0-ballot",
  "name" : "CZ_PatientBase",
  "title" : "Patient (CZ base)",
  "status" : "draft",
  "experimental" : false,
  "date" : "2025-12-19T09:24:48+00:00",
  "publisher" : "HL7 Czech Republic",
  "contact" : [
    {
      "name" : "HL7 Czech Republic",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.hl7.cz/"
        }
      ]
    }
  ],
  "description" : "This profile defines how to represent Patient in FHIR for the purpose of the Czech national interoperability standards.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "CZ",
          "display" : "Czechia"
        }
      ]
    }
  ],
  "fhirVersion" : "4.0.1",
  "mapping" : [
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    },
    {
      "identity" : "cda",
      "uri" : "http://hl7.org/v3/cda",
      "name" : "CDA (R2)"
    },
    {
      "identity" : "w5",
      "uri" : "http://hl7.org/fhir/fivews",
      "name" : "FiveWs Pattern Mapping"
    },
    {
      "identity" : "v2",
      "uri" : "http://hl7.org/v2",
      "name" : "HL7 v2 Mapping"
    },
    {
      "identity" : "loinc",
      "uri" : "http://loinc.org",
      "name" : "LOINC code for the element"
    }
  ],
  "kind" : "resource",
  "abstract" : false,
  "type" : "Patient",
  "baseDefinition" : "http://hl7.eu/fhir/base/StructureDefinition/patient-eu",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "Patient",
        "path" : "Patient",
        "short" : "Czech Patient (base)",
        "definition" : "This profile defines how to represent Patient in FHIR for the purpose of the Czech national interoperability standards."
      },
      {
        "id" : "Patient.extension:birthPlace",
        "path" : "Patient.extension",
        "sliceName" : "birthPlace"
      },
      {
        "id" : "Patient.extension:birthPlace.value[x]",
        "path" : "Patient.extension.value[x]",
        "type" : [
          {
            "code" : "Address",
            "profile" : ["https://hl7.cz/fhir/core/StructureDefinition/cz-address"]
          }
        ]
      },
      {
        "id" : "Patient.identifier",
        "path" : "Patient.identifier",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "value",
              "path" : "system"
            }
          ],
          "rules" : "open"
        },
        "definition" : "Patient identifier.\r\n\r\nWhen available, one of the national identifiers (patient number from the national patient register, birth number (RC), insurance number) is usually used. Organisations may also provide a local identifier using their own identification system. If necessary, the type of identifier can also be added."
      },
      {
        "id" : "Patient.identifier:RC",
        "path" : "Patient.identifier",
        "sliceName" : "RC",
        "short" : "Personal Number",
        "definition" : "Patient identifier assigned under the Czech Population Registration Act.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Identifier",
            "profile" : [
              "https://hl7.cz/fhir/core/StructureDefinition/cz-rodcis-identifier"
            ]
          }
        ]
      },
      {
        "id" : "Patient.identifier:RID",
        "path" : "Patient.identifier",
        "sliceName" : "RID",
        "short" : "National Health Sector Identifier",
        "definition" : "An unique patient identifier (resortní identifikátor RID) or temporary patient identifier (DRID) according to the National Patient Register (KRP)",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Identifier",
            "profile" : [
              "https://hl7.cz/fhir/core/StructureDefinition/cz-rid-identifier"
            ]
          }
        ]
      },
      {
        "id" : "Patient.identifier:CPOJ",
        "path" : "Patient.identifier",
        "sliceName" : "CPOJ",
        "short" : "Health Insurance Number",
        "definition" : "An unique patient identifier (číslo pojištěnce) according to the National Health Insurance Register",
        "min" : 0,
        "max" : "1"
      },
      {
        "id" : "Patient.identifier:CPOJ.system",
        "path" : "Patient.identifier.system",
        "min" : 1,
        "fixedUri" : "https://ncez.mzcr.cz/fhir/sid/cpoj"
      },
      {
        "id" : "Patient.identifier:CPOJ.value",
        "path" : "Patient.identifier.value",
        "min" : 1,
        "example" : [
          {
            "label" : "CPOJ Example",
            "valueString" : "6309211234"
          }
        ]
      },
      {
        "id" : "Patient.identifier:CPOJ.assigner",
        "path" : "Patient.identifier.assigner",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "https://hl7.cz/fhir/core/StructureDefinition/cz-organization-core"
            ]
          }
        ]
      },
      {
        "id" : "Patient.identifier:OP",
        "path" : "Patient.identifier",
        "sliceName" : "OP",
        "short" : "National Identity Card Number",
        "definition" : "An unique person identifier (National ID Card Number) issued by the ministry of interior",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "Identifier",
            "profile" : [
              "https://hl7.cz/fhir/core/StructureDefinition/id-card-identifier"
            ]
          }
        ]
      },
      {
        "id" : "Patient.identifier:OP.system",
        "path" : "Patient.identifier.system",
        "short" : "Name space according to the National ID card issuer. FHIR records namespaces for ID cards in the format - https://ncez.mzcr.cz/fhir/sid/IdCardNumNS-XXX, where XXX is the three-letter country code according to ISO 3166"
      },
      {
        "id" : "Patient.identifier:PAS",
        "path" : "Patient.identifier",
        "sliceName" : "PAS",
        "short" : "Passport Number",
        "definition" : "A temporary patient identifier (Passport Number)",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "Identifier",
            "profile" : [
              "https://hl7.cz/fhir/core/StructureDefinition/cz-passport-identifier"
            ]
          }
        ]
      },
      {
        "id" : "Patient.name",
        "path" : "Patient.name",
        "definition" : "A name associated with the individual. \n\nIt is RECOMMENDED to give at least one family name and at least one given name when possible and define an 'official' use. When names are given, a consumer SHALL NOT ignore it.",
        "requirements" : "A patient may be known by several different names. An example is an official name and a nickname or pseudonym.\r\nIn all cases, the alphabetical representation of the name is always used.",
        "min" : 1,
        "constraint" : [
          {
            "key" : "cz-pat-1",
            "severity" : "error",
            "human" : "Patient.name.given, Patient.name.family, Patient.name.text or data-absent-reason MUST be filled",
            "expression" : "family.exists() or given.exists() or text.exists() or extension('http://hl7.org/fhir/StructureDefinition/data-absent-reason').exists()",
            "source" : "https://hl7.cz/fhir/core/StructureDefinition/cz-patient-base"
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "Patient.name.text",
        "path" : "Patient.name.text",
        "definition" : "Text representation of the full name. Due to the cultural variance around the world a consuming system may not know how to present the name correctly; moreover not all the parts of the name go in given or family. Creators are therefore strongly encouraged to provide through this element a presented version of the name. Future versions of this guide may require this element",
        "mustSupport" : true
      },
      {
        "id" : "Patient.name.family",
        "path" : "Patient.name.family",
        "mustSupport" : true
      },
      {
        "id" : "Patient.name.given",
        "path" : "Patient.name.given",
        "min" : 1,
        "mustSupport" : true
      },
      {
        "id" : "Patient.telecom",
        "path" : "Patient.telecom",
        "short" : "A contact detail for the individual",
        "definition" : "A contact detail (e.g. a telephone number or an email address) by which the individual may be contacted.\n\nIt is RECOMMENDED to at least add one phone or email address with clear indication using the .use element whether it is home use, work use, etc.",
        "mustSupport" : true
      },
      {
        "id" : "Patient.gender",
        "path" : "Patient.gender",
        "definition" : "Gender for official purposes",
        "mustSupport" : true,
        "binding" : {
          "strength" : "required",
          "valueSet" : "https://hl7.cz/terminology/ValueSet/administrative-gender-cz"
        }
      },
      {
        "id" : "Patient.birthDate",
        "path" : "Patient.birthDate",
        "definition" : "The date of birth for the patient.\n\nIt is RECOMMENDED to give the birthdate when available.",
        "min" : 1
      },
      {
        "id" : "Patient.birthDate.extension",
        "path" : "Patient.birthDate.extension",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "value",
              "path" : "url"
            }
          ],
          "rules" : "open"
        }
      },
      {
        "id" : "Patient.birthDate.extension:birthTime",
        "path" : "Patient.birthDate.extension",
        "sliceName" : "birthTime",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Extension",
            "profile" : [
              "http://hl7.org/fhir/StructureDefinition/patient-birthTime|5.2.0"
            ]
          }
        ]
      },
      {
        "id" : "Patient.deceased[x]",
        "path" : "Patient.deceased[x]",
        "short" : "Death information either by symptom or date of death",
        "definition" : "Death information either by symptom or date of death \n\nIt is RECOMMENDED to include death information in all relevant cases."
      },
      {
        "id" : "Patient.address",
        "path" : "Patient.address",
        "definition" : "An address for the individual. \n\nIt is RECOMMENDED to include an address when available.",
        "type" : [
          {
            "code" : "Address",
            "profile" : ["https://hl7.cz/fhir/core/StructureDefinition/cz-address"]
          }
        ]
      },
      {
        "id" : "Patient.contact",
        "path" : "Patient.contact",
        "definition" : "A contact party (e.g. guardian, partner, friend) for the patient.\n\nIt is RECOMMENDED to include this when available and considered relevant for the patientcare. (e.g. a parent of a young patient)"
      },
      {
        "id" : "Patient.contact.relationship",
        "path" : "Patient.contact.relationship",
        "binding" : {
          "strength" : "required",
          "valueSet" : "https://hl7.cz/terminology/ValueSet/contact-and-relationship-cz"
        }
      },
      {
        "id" : "Patient.contact.address",
        "path" : "Patient.contact.address",
        "type" : [
          {
            "code" : "Address",
            "profile" : ["https://hl7.cz/fhir/core/StructureDefinition/cz-address"]
          }
        ]
      },
      {
        "id" : "Patient.contact.gender",
        "path" : "Patient.contact.gender",
        "binding" : {
          "strength" : "required",
          "valueSet" : "https://hl7.cz/terminology/ValueSet/administrative-gender-cz"
        }
      },
      {
        "id" : "Patient.contact.organization",
        "path" : "Patient.contact.organization",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "https://hl7.cz/fhir/core/StructureDefinition/cz-organization-base"
            ]
          }
        ]
      },
      {
        "id" : "Patient.generalPractitioner",
        "path" : "Patient.generalPractitioner",
        "short" : "A physician or provider nominated by the patient",
        "definition" : "Patient's nominated care provider.\n\nTake note this does not automatically imply any legal form of therapeutic link or consent relationship with this GP. It is RECOMMENDED to include this when available if the flow is in any way medical. Please note this is an element of the Reference datatype. This means when it is available it will contain either a relative or absolute URL where this GP can be found. Alternatively, there is only an internal reference and the GP is included as a ‘contained resource’ (cfr. the HL7 FHIR specifications in what cases this applies).",
        "comment" : "This may be a primary or specialist outpatient care provider, or it may be a patient-designated carer in a community or disability setting, or an organisation that provides people to act as care providers. If it is a registering provider, the reference will also be included in the \"registeringProvider\" extension. This element should not be used to register care teams, these should be in the CareTeam resource, which can be linked to the CarePlan or EpisodeOfCare resources. \n Multiple providers may be recorded for a patient for different reasons, for example a student who has their GP listed alongside their GP at the university, or a worker who has a GP listed alongside their GP at the workplace to keep them informed of health issues.",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "https://hl7.cz/fhir/core/StructureDefinition/cz-organization-base",
              "https://hl7.cz/fhir/core/StructureDefinition/cz-practitioner-base",
              "https://hl7.cz/fhir/core/StructureDefinition/cz-practitionerrole-base"
            ]
          }
        ]
      },
      {
        "id" : "Patient.managingOrganization",
        "path" : "Patient.managingOrganization",
        "definition" : "Organization that is the custodian of the patient record.\n\nThis SHOULD be included when available. Please note this is an element of the Reference datatype. This means when it is available it will contain either a relative or absolute URL where this Organization can be found. Alternatively, there is only an internal reference and the Organization is included as a ‘contained resource’ (cfr. the HL7 FHIR specifications in what cases this applies).",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "https://hl7.cz/fhir/core/StructureDefinition/cz-organization-base"
            ]
          }
        ]
      },
      {
        "id" : "Patient.link.other",
        "path" : "Patient.link.other",
        "type" : [
          {
            "extension" : [
              {
                "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-hierarchy",
                "valueBoolean" : false
              }
            ],
            "code" : "Reference",
            "targetProfile" : [
              "https://hl7.cz/fhir/core/StructureDefinition/cz-patient-base",
              "https://hl7.cz/fhir/core/StructureDefinition/cz-relatedPerson-base"
            ]
          }
        ]
      }
    ]
  }
}

```
