# Patient: Animal (CZ) - HL7 Czech Base and Core Implementation Guide v0.3.0-ballot

* [**Table of Contents**](toc.md)
* [**Summary artifacts**](artifacts.md)
* **Patient: Animal (CZ)**

## Resource Profile: Patient: Animal (CZ) 

| | | |
| :--- | :--- | :--- |
| *Official URL*:https://hl7.cz/fhir/core/StructureDefinition/cz-patient-animal | *Version*:0.3.0-ballot | |
| *Standards status:*[Draft](http://hl7.org/fhir/R4/versions.html#std-process) | [Maturity Level](http://hl7.org/fhir/versions.html#maturity): 1 | *Computable Name*:CZ_PatientAnimal |

 
This profile defines how to represent an Animal as subject of care in FHIR for the purpose of this guide. This is used to identify the species when a specimen is collected from an animal 

**Usages:**

* Examples for this Profile: [Patient/Kocka](Patient-Kocka.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.fhir.cz.core|current/StructureDefinition/cz-patient-animal)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-cz-patient-animal.csv), [Excel](StructureDefinition-cz-patient-animal.xlsx), [Schematron](StructureDefinition-cz-patient-animal.sch) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "cz-patient-animal",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-fmm",
      "valueInteger" : 1
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
      "valueCode" : "draft"
    }
  ],
  "url" : "https://hl7.cz/fhir/core/StructureDefinition/cz-patient-animal",
  "version" : "0.3.0-ballot",
  "name" : "CZ_PatientAnimal",
  "title" : "Patient: Animal (CZ)",
  "status" : "draft",
  "experimental" : false,
  "date" : "2025-12-19T09:24:48+00:00",
  "publisher" : "HL7 Czech Republic",
  "contact" : [
    {
      "name" : "HL7 Czech Republic",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.hl7.cz/"
        }
      ]
    }
  ],
  "description" : "This profile defines how to represent an Animal as subject of care in FHIR for the purpose of this guide.\nThis is used to identify the species when a specimen is collected from an animal",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "CZ",
          "display" : "Czechia"
        }
      ]
    }
  ],
  "fhirVersion" : "4.0.1",
  "mapping" : [
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    },
    {
      "identity" : "cda",
      "uri" : "http://hl7.org/v3/cda",
      "name" : "CDA (R2)"
    },
    {
      "identity" : "w5",
      "uri" : "http://hl7.org/fhir/fivews",
      "name" : "FiveWs Pattern Mapping"
    },
    {
      "identity" : "v2",
      "uri" : "http://hl7.org/v2",
      "name" : "HL7 v2 Mapping"
    },
    {
      "identity" : "loinc",
      "uri" : "http://loinc.org",
      "name" : "LOINC code for the element"
    }
  ],
  "kind" : "resource",
  "abstract" : false,
  "type" : "Patient",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/Patient",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "Patient",
        "path" : "Patient",
        "short" : "Czech Animal Patient",
        "definition" : "This profile defines how to represent Animal Patient in FHIR for the purpose of the Czech national interoperability standards."
      },
      {
        "id" : "Patient.extension",
        "path" : "Patient.extension",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "value",
              "path" : "url"
            }
          ],
          "ordered" : false,
          "rules" : "open"
        },
        "min" : 1
      },
      {
        "id" : "Patient.extension:patient-animal",
        "path" : "Patient.extension",
        "sliceName" : "patient-animal",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "Extension",
            "profile" : [
              "http://hl7.org/fhir/StructureDefinition/patient-animal|5.2.0"
            ]
          }
        ]
      },
      {
        "id" : "Patient.extension:recordedSexOrGender",
        "path" : "Patient.extension",
        "sliceName" : "recordedSexOrGender",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Extension",
            "profile" : [
              "http://hl7.org/fhir/StructureDefinition/individual-recordedSexOrGender"
            ]
          }
        ]
      },
      {
        "id" : "Patient.telecom",
        "path" : "Patient.telecom",
        "short" : "Usage: contact.telecom",
        "comment" : "Animals do not have phones, their contacts do. Contact.telecom should be used.",
        "max" : "0"
      },
      {
        "id" : "Patient.maritalStatus",
        "path" : "Patient.maritalStatus",
        "max" : "0"
      },
      {
        "id" : "Patient.contact.organization",
        "path" : "Patient.contact.organization",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "https://hl7.cz/fhir/core/StructureDefinition/cz-organization-core"
            ]
          }
        ]
      },
      {
        "id" : "Patient.generalPractitioner",
        "path" : "Patient.generalPractitioner",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "https://hl7.cz/fhir/core/StructureDefinition/cz-organization-core",
              "https://hl7.cz/fhir/core/StructureDefinition/cz-practitioner-core",
              "https://hl7.cz/fhir/core/StructureDefinition/cz-practitionerrole-core"
            ]
          }
        ]
      },
      {
        "id" : "Patient.managingOrganization",
        "path" : "Patient.managingOrganization",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "https://hl7.cz/fhir/core/StructureDefinition/cz-organization-core"
            ]
          }
        ]
      },
      {
        "id" : "Patient.link.other",
        "path" : "Patient.link.other",
        "type" : [
          {
            "extension" : [
              {
                "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-hierarchy",
                "valueBoolean" : false
              }
            ],
            "code" : "Reference",
            "targetProfile" : [
              "https://hl7.cz/fhir/core/StructureDefinition/cz-patient-core",
              "https://hl7.cz/fhir/core/StructureDefinition/cz-relatedPerson-core"
            ]
          }
        ]
      }
    ]
  }
}

```
