# Organization (CZ core) - HL7 Czech Base and Core Implementation Guide v0.3.0-ballot

* [**Table of Contents**](toc.md)
* [**Summary artifacts**](artifacts.md)
* **Organization (CZ core)**

## Resource Profile: Organization (CZ core) 

| | | |
| :--- | :--- | :--- |
| *Official URL*:https://hl7.cz/fhir/core/StructureDefinition/cz-organization-core | *Version*:0.3.0-ballot | |
| *Standards status:*[Draft](http://hl7.org/fhir/R4/versions.html#std-process) | [Maturity Level](http://hl7.org/fhir/versions.html#maturity): 1 | *Computable Name*:CZ_OrganizationCore |

 
Czech national profile sets minimum expectations for the Organization resource common to most of the use cases. 

**Usages:**

* Refer to this Profile: [Medication (CZ)](StructureDefinition-cz-Medication.md), [Medication Statement (CZ)](StructureDefinition-cz-MedicationStatement.md), [Coverage (CZ)](StructureDefinition-cz-coverage.md), [Device: Performer/Observer (CZ)](StructureDefinition-cz-device-observer.md)...Show 18 more,[Encounter (CZ)](StructureDefinition-cz-encounter.md),[Location (CZ core)](StructureDefinition-cz-location-core.md),[Medical Device (CZ)](StructureDefinition-cz-medical-device.md),[Organization (CZ base)](StructureDefinition-cz-organization-base.md),[Passport identifier](StructureDefinition-cz-passport-identifier.md),[Patient: Animal (CZ)](StructureDefinition-cz-patient-animal.md),[Patient (CZ base)](StructureDefinition-cz-patient-base.md),[Patient (CZ core)](StructureDefinition-cz-patient-core.md),[Practitioner (CZ base)](StructureDefinition-cz-practitioner-base.md),[Practitioner (CZ core)](StructureDefinition-cz-practitioner-core.md),[Practitioner Role (CZ core)](StructureDefinition-cz-practitionerrole-core.md),[Provenance (CZ)](StructureDefinition-cz-provenance.md),[Related Person (CZ base)](StructureDefinition-cz-relatedPerson-base.md),[National health sector identifier (CZ)](StructureDefinition-cz-rid-identifier.md),[National birth number (CZ)](StructureDefinition-cz-rodcis-identifier.md),[Signature (CZ)](StructureDefinition-cz-signature.md),[National ID card identifier](StructureDefinition-id-card-identifier.md)and[Registering provider](StructureDefinition-registering-provider-cz.md)
* Examples for this Profile: [Nemocnice Chrudim](Organization-Organization-1.md), [MUDr. Hana Doktorová](Organization-Organization-2.md), [Všeobecná zdravotní pojišťovna ČR](Organization-Organization-3.md), [MUDr. Hana Doktorová](Organization-RegisteringProviderExample.md) and [Synlab czech s.r.o.](Organization-Synlab.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.fhir.cz.core|current/StructureDefinition/cz-organization-core)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-cz-organization-core.csv), [Excel](StructureDefinition-cz-organization-core.xlsx), [Schematron](StructureDefinition-cz-organization-core.sch) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "cz-organization-core",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-fmm",
      "valueInteger" : 1
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
      "valueCode" : "draft"
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-imposeProfile",
      "valueCanonical" : "http://hl7.eu/fhir/base/StructureDefinition/organization-eu-core"
    }
  ],
  "url" : "https://hl7.cz/fhir/core/StructureDefinition/cz-organization-core",
  "version" : "0.3.0-ballot",
  "name" : "CZ_OrganizationCore",
  "title" : "Organization (CZ core)",
  "status" : "draft",
  "experimental" : false,
  "date" : "2025-12-19T09:24:48+00:00",
  "publisher" : "HL7 Czech Republic",
  "contact" : [
    {
      "name" : "HL7 Czech Republic",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.hl7.cz/"
        }
      ]
    }
  ],
  "description" : "Czech national profile sets minimum expectations for the Organization resource common to most of the use cases.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "CZ",
          "display" : "Czechia"
        }
      ]
    }
  ],
  "fhirVersion" : "4.0.1",
  "mapping" : [
    {
      "identity" : "v2",
      "uri" : "http://hl7.org/v2",
      "name" : "HL7 v2 Mapping"
    },
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    },
    {
      "identity" : "servd",
      "uri" : "http://www.omg.org/spec/ServD/1.0/",
      "name" : "ServD"
    },
    {
      "identity" : "w5",
      "uri" : "http://hl7.org/fhir/fivews",
      "name" : "FiveWs Pattern Mapping"
    }
  ],
  "kind" : "resource",
  "abstract" : false,
  "type" : "Organization",
  "baseDefinition" : "https://hl7.cz/fhir/core/StructureDefinition/cz-organization-base",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "Organization",
        "path" : "Organization",
        "short" : "Czech Organization (core)",
        "definition" : "Czech national profile sets minimum expectations for represention of organization in HL7 FHIR.",
        "constraint" : [
          {
            "key" : "cz-org-1",
            "severity" : "error",
            "human" : "Organization.name or Identifier.value MUST be filled.",
            "expression" : "name.exists() or identifier.value.exists()",
            "source" : "https://hl7.cz/fhir/core/StructureDefinition/cz-organization-core"
          }
        ]
      },
      {
        "id" : "Organization.extension",
        "path" : "Organization.extension",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "value",
              "path" : "url"
            }
          ],
          "ordered" : false,
          "rules" : "open"
        }
      },
      {
        "id" : "Organization.extension:logo",
        "path" : "Organization.extension",
        "sliceName" : "logo",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Extension",
            "profile" : [
              "https://hl7.cz/fhir/core/StructureDefinition/cz-organization-logo"
            ]
          }
        ]
      }
    ]
  }
}

```
