# Organization (CZ base) - HL7 Czech Base and Core Implementation Guide v0.3.0-ballot

* [**Table of Contents**](toc.md)
* [**Summary artifacts**](artifacts.md)
* **Organization (CZ base)**

## Resource Profile: Organization (CZ base) 

| | | |
| :--- | :--- | :--- |
| *Official URL*:https://hl7.cz/fhir/core/StructureDefinition/cz-organization-base | *Version*:0.3.0-ballot | |
| *Standards status:*[Draft](http://hl7.org/fhir/R4/versions.html#std-process) | [Maturity Level](http://hl7.org/fhir/versions.html#maturity): 1 | *Computable Name*:CZ_OrganizationBase |

 
Czech national profile defines the way the organization is represented in the context of the Czech national interoperability project. 

**Usages:**

* Derived from this Profile: [Organization (CZ core)](StructureDefinition-cz-organization-core.md)
* Refer to this Profile: [Location (CZ base)](StructureDefinition-cz-location-base.md), [Patient (CZ base)](StructureDefinition-cz-patient-base.md), [Practitioner (CZ base)](StructureDefinition-cz-practitioner-base.md) and [Practitioner Role (CZ base)](StructureDefinition-cz-practitionerrole-base.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.fhir.cz.core|current/StructureDefinition/cz-organization-base)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-cz-organization-base.csv), [Excel](StructureDefinition-cz-organization-base.xlsx), [Schematron](StructureDefinition-cz-organization-base.sch) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "cz-organization-base",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-fmm",
      "valueInteger" : 1
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
      "valueCode" : "draft"
    }
  ],
  "url" : "https://hl7.cz/fhir/core/StructureDefinition/cz-organization-base",
  "version" : "0.3.0-ballot",
  "name" : "CZ_OrganizationBase",
  "title" : "Organization (CZ base)",
  "status" : "draft",
  "experimental" : false,
  "date" : "2025-12-19T09:24:48+00:00",
  "publisher" : "HL7 Czech Republic",
  "contact" : [
    {
      "name" : "HL7 Czech Republic",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.hl7.cz/"
        }
      ]
    }
  ],
  "description" : "Czech national profile defines the way the organization is represented in the context of the Czech national interoperability project.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "CZ",
          "display" : "Czechia"
        }
      ]
    }
  ],
  "fhirVersion" : "4.0.1",
  "mapping" : [
    {
      "identity" : "v2",
      "uri" : "http://hl7.org/v2",
      "name" : "HL7 v2 Mapping"
    },
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    },
    {
      "identity" : "servd",
      "uri" : "http://www.omg.org/spec/ServD/1.0/",
      "name" : "ServD"
    },
    {
      "identity" : "w5",
      "uri" : "http://hl7.org/fhir/fivews",
      "name" : "FiveWs Pattern Mapping"
    }
  ],
  "kind" : "resource",
  "abstract" : false,
  "type" : "Organization",
  "baseDefinition" : "http://hl7.eu/fhir/base/StructureDefinition/organization-eu",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "Organization",
        "path" : "Organization",
        "short" : "Czech Organization (base)",
        "definition" : "Czech national profile defines how to represent an organization in HL7 FHIR."
      },
      {
        "id" : "Organization.identifier",
        "path" : "Organization.identifier",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "value",
              "path" : "system"
            }
          ],
          "rules" : "open"
        },
        "definition" : "Identifier for the organization that is used to identify the organization across multiple disparate systems. \r\nTypically, an KRPZS value and/or IČO or IČZ/IČP value are given. Other systems are allowed, however use of KRPZS Id is preferred. Flows in organizations will most likely want to also include a local identifier, using its own identification system. A type can be added if needed. When it is given, a consumer SHALL NOT ignore it. In the case of health insurance organizations, the insurance company code is given (KP)."
      },
      {
        "id" : "Organization.identifier:KRPZS",
        "path" : "Organization.identifier",
        "sliceName" : "KRPZS",
        "short" : "This identification is according to the National Register of Health Service Providers.",
        "min" : 0,
        "max" : "1"
      },
      {
        "id" : "Organization.identifier:KRPZS.system",
        "path" : "Organization.identifier.system",
        "min" : 1,
        "fixedUri" : "https://ncez.mzcr.cz/fhir/sid/krpzs"
      },
      {
        "id" : "Organization.identifier:KRPZS.value",
        "path" : "Organization.identifier.value",
        "min" : 1
      },
      {
        "id" : "Organization.identifier:KRPZS.assigner",
        "path" : "Organization.identifier.assigner",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "https://hl7.cz/fhir/core/StructureDefinition/cz-organization-core"
            ]
          }
        ]
      },
      {
        "id" : "Organization.identifier:ICO",
        "path" : "Organization.identifier",
        "sliceName" : "ICO",
        "min" : 0,
        "max" : "1"
      },
      {
        "id" : "Organization.identifier:ICO.system",
        "path" : "Organization.identifier.system",
        "min" : 1,
        "fixedUri" : "https://ncez.mzcr.cz/fhir/sid/ico"
      },
      {
        "id" : "Organization.identifier:ICO.value",
        "path" : "Organization.identifier.value",
        "min" : 1
      },
      {
        "id" : "Organization.identifier:ICO.assigner",
        "path" : "Organization.identifier.assigner",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "https://hl7.cz/fhir/core/StructureDefinition/cz-organization-core"
            ]
          }
        ]
      },
      {
        "id" : "Organization.identifier:ICZ",
        "path" : "Organization.identifier",
        "sliceName" : "ICZ",
        "min" : 0,
        "max" : "1"
      },
      {
        "id" : "Organization.identifier:ICZ.system",
        "path" : "Organization.identifier.system",
        "min" : 1,
        "fixedUri" : "https://ncez.mzcr.cz/fhir/sid/icz"
      },
      {
        "id" : "Organization.identifier:ICZ.value",
        "path" : "Organization.identifier.value",
        "min" : 1
      },
      {
        "id" : "Organization.identifier:ICZ.assigner",
        "path" : "Organization.identifier.assigner",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "https://hl7.cz/fhir/core/StructureDefinition/cz-organization-core"
            ]
          }
        ]
      },
      {
        "id" : "Organization.identifier:ICP",
        "path" : "Organization.identifier",
        "sliceName" : "ICP",
        "min" : 0,
        "max" : "1"
      },
      {
        "id" : "Organization.identifier:ICP.system",
        "path" : "Organization.identifier.system",
        "min" : 1,
        "fixedUri" : "https://ncez.mzcr.cz/fhir/sid/icp"
      },
      {
        "id" : "Organization.identifier:ICP.value",
        "path" : "Organization.identifier.value",
        "min" : 1
      },
      {
        "id" : "Organization.identifier:ICP.assigner",
        "path" : "Organization.identifier.assigner",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "https://hl7.cz/fhir/core/StructureDefinition/cz-organization-core"
            ]
          }
        ]
      },
      {
        "id" : "Organization.identifier:KP",
        "path" : "Organization.identifier",
        "sliceName" : "KP",
        "min" : 0,
        "max" : "1"
      },
      {
        "id" : "Organization.identifier:KP.system",
        "path" : "Organization.identifier.system",
        "min" : 1,
        "fixedUri" : "https://ncez.mzcr.cz/fhir/sid/kp"
      },
      {
        "id" : "Organization.identifier:KP.value",
        "path" : "Organization.identifier.value",
        "min" : 1,
        "binding" : {
          "strength" : "required",
          "valueSet" : "https://ncez.mzcr.cz/terminology/ValueSet/healthInsuranceCompanyCode"
        }
      },
      {
        "id" : "Organization.identifier:KP.assigner",
        "path" : "Organization.identifier.assigner",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "https://hl7.cz/fhir/core/StructureDefinition/cz-organization-core"
            ]
          }
        ]
      },
      {
        "id" : "Organization.type",
        "path" : "Organization.type",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "value",
              "path" : "coding.system"
            }
          ],
          "rules" : "open"
        },
        "definition" : "The kind(s) of organization that this is.\r\n\r\n. Type should be taken from DRZAR value set."
      },
      {
        "id" : "Organization.type:DRZAR",
        "path" : "Organization.type",
        "sliceName" : "DRZAR",
        "min" : 0,
        "max" : "*",
        "binding" : {
          "strength" : "required",
          "valueSet" : "https://ncez.mzcr.cz/terminology/ValueSet/cz-drzar-vs"
        }
      },
      {
        "id" : "Organization.type:DRZAR.coding.system",
        "path" : "Organization.type.coding.system",
        "min" : 1,
        "fixedUri" : "https://ncez.mzcr.cz/terminology/CodeSystem/cz-drzar"
      },
      {
        "id" : "Organization.type:DRZAR.coding.code",
        "path" : "Organization.type.coding.code",
        "min" : 1
      },
      {
        "id" : "Organization.address",
        "path" : "Organization.address",
        "type" : [
          {
            "code" : "Address",
            "profile" : ["https://hl7.cz/fhir/core/StructureDefinition/cz-address"]
          }
        ]
      },
      {
        "id" : "Organization.partOf",
        "path" : "Organization.partOf",
        "type" : [
          {
            "extension" : [
              {
                "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-hierarchy",
                "valueBoolean" : true
              }
            ],
            "code" : "Reference",
            "targetProfile" : [
              "https://hl7.cz/fhir/core/StructureDefinition/cz-organization-core"
            ]
          }
        ]
      }
    ]
  }
}

```
