# Location (CZ core) - HL7 Czech Base and Core Implementation Guide v0.3.0-ballot

* [**Table of Contents**](toc.md)
* [**Summary artifacts**](artifacts.md)
* **Location (CZ core)**

## Resource Profile: Location (CZ core) 

| | | |
| :--- | :--- | :--- |
| *Official URL*:https://hl7.cz/fhir/core/StructureDefinition/cz-location-core | *Version*:0.3.0-ballot | |
| *Standards status:*[Draft](http://hl7.org/fhir/R4/versions.html#std-process) | [Maturity Level](http://hl7.org/fhir/versions.html#maturity): 1 | *Computable Name*:CZ_LocationCore |

 
Czech national core profile for location resource.This profile implies use of the Czech standard organization in the managingOrganization element. 

**Usages:**

* Refer to this Profile: [Device: Performer/Observer (CZ)](StructureDefinition-cz-device-observer.md), [Location (CZ base)](StructureDefinition-cz-location-base.md), [Medical Device (CZ)](StructureDefinition-cz-medical-device.md), [Practitioner Role (CZ core)](StructureDefinition-cz-practitionerrole-core.md)...Show 2 more,[Provenance (CZ)](StructureDefinition-cz-provenance.md)and[Specimen (CZ)](StructureDefinition-cz-specimen.md)
* Examples for this Profile: [Nádražní 1, Praha 5](Location-Location-Praha5.md) and [Laboratoř Praha, Jankovcova 2](Location-location-laboratory.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.fhir.cz.core|current/StructureDefinition/cz-location-core)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-cz-location-core.csv), [Excel](StructureDefinition-cz-location-core.xlsx), [Schematron](StructureDefinition-cz-location-core.sch) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "cz-location-core",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-fmm",
      "valueInteger" : 1
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
      "valueCode" : "draft"
    }
  ],
  "url" : "https://hl7.cz/fhir/core/StructureDefinition/cz-location-core",
  "version" : "0.3.0-ballot",
  "name" : "CZ_LocationCore",
  "title" : "Location (CZ core)",
  "status" : "draft",
  "experimental" : false,
  "date" : "2025-12-19T09:24:48+00:00",
  "publisher" : "HL7 Czech Republic",
  "contact" : [
    {
      "name" : "HL7 Czech Republic",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.hl7.cz/"
        }
      ]
    }
  ],
  "description" : "Czech national core profile for location resource.This profile implies use of the Czech standard organization in the managingOrganization element.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "CZ",
          "display" : "Czechia"
        }
      ]
    }
  ],
  "fhirVersion" : "4.0.1",
  "mapping" : [
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    },
    {
      "identity" : "w5",
      "uri" : "http://hl7.org/fhir/fivews",
      "name" : "FiveWs Pattern Mapping"
    }
  ],
  "kind" : "resource",
  "abstract" : false,
  "type" : "Location",
  "baseDefinition" : "https://hl7.cz/fhir/core/StructureDefinition/cz-location-base",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "Location",
        "path" : "Location",
        "definition" : "Czech national core profile for location resource."
      },
      {
        "id" : "Location.managingOrganization",
        "path" : "Location.managingOrganization",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "https://hl7.cz/fhir/core/StructureDefinition/cz-organization-core"
            ]
          }
        ]
      }
    ]
  }
}

```
