# Address (CZ) - HL7 Czech Base and Core Implementation Guide v0.3.0-ballot

* [**Table of Contents**](toc.md)
* [**Summary artifacts**](artifacts.md)
* **Address (CZ)**

## Data Type Profile: Address (CZ) 

| | | |
| :--- | :--- | :--- |
| *Official URL*:https://hl7.cz/fhir/core/StructureDefinition/cz-address | *Version*:0.3.0-ballot | |
| *Standards status:*[Draft](http://hl7.org/fhir/R4/versions.html#std-process) | [Maturity Level](http://hl7.org/fhir/versions.html#maturity): 1 | *Computable Name*:CZ_Address |

 
Czech national profile on address, to provide the possibility in the 'line' element to provide a seperate streetname, housenumber and postal box. It is always RECOMMENDED to give these elements separately. The national specification also includes the option of entering the address location according to the RUIAN register and marking the address as the permanent residence address. 

**Usages:**

* Use this DataType Profile: [Location (CZ base)](StructureDefinition-cz-location-base.md), [Organization (CZ base)](StructureDefinition-cz-organization-base.md), [Patient (CZ base)](StructureDefinition-cz-patient-base.md), [Practitioner (CZ base)](StructureDefinition-cz-practitioner-base.md) and [Related Person (CZ base)](StructureDefinition-cz-relatedPerson-base.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.fhir.cz.core|current/StructureDefinition/cz-address)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-cz-address.csv), [Excel](StructureDefinition-cz-address.xlsx), [Schematron](StructureDefinition-cz-address.sch) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "cz-address",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-fmm",
      "valueInteger" : 1
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
      "valueCode" : "draft"
    }
  ],
  "url" : "https://hl7.cz/fhir/core/StructureDefinition/cz-address",
  "version" : "0.3.0-ballot",
  "name" : "CZ_Address",
  "title" : "Address (CZ)",
  "status" : "draft",
  "experimental" : false,
  "date" : "2025-12-19T09:24:48+00:00",
  "publisher" : "HL7 Czech Republic",
  "contact" : [
    {
      "name" : "HL7 Czech Republic",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.hl7.cz/"
        }
      ]
    }
  ],
  "description" : "Czech national profile on address, to provide the possibility in the 'line' element to provide a seperate streetname, housenumber and postal box.\nIt is always RECOMMENDED to give these elements separately. The national specification also includes the option of entering the address location according to the RUIAN register and marking the address as the permanent residence address.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "CZ",
          "display" : "Czechia"
        }
      ]
    }
  ],
  "fhirVersion" : "4.0.1",
  "mapping" : [
    {
      "identity" : "v2",
      "uri" : "http://hl7.org/v2",
      "name" : "HL7 v2 Mapping"
    },
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    },
    {
      "identity" : "servd",
      "uri" : "http://www.omg.org/spec/ServD/1.0/",
      "name" : "ServD"
    },
    {
      "identity" : "vcard",
      "uri" : "http://w3.org/vcard",
      "name" : "vCard Mapping"
    }
  ],
  "kind" : "complex-type",
  "abstract" : false,
  "type" : "Address",
  "baseDefinition" : "http://hl7.eu/fhir/base/StructureDefinition/Address-eu",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "Address",
        "path" : "Address",
        "short" : "Address according to Czech postal conventions",
        "definition" : "Address according to Czech postal conventions. The address can be used both for delivering mail and for locating locations that do not have a valid mailing address. The use of extensions is not mandatory.",
        "comment" : "Note: address is intended to describe postal addresses for administrative purposes, not to describe absolute geographical coordinates.  Postal addresses are often used as proxies for physical locations (also see the [Location](location.html#) resource).",
        "constraint" : [
          {
            "key" : "text-or-ctry",
            "severity" : "error",
            "human" : "Address must contain at least text or country element",
            "expression" : "( line.all($this.empty()) and city.empty() ) implies (text.exists() or country.exists())",
            "source" : "https://hl7.cz/fhir/core/StructureDefinition/cz-address"
          },
          {
            "key" : "POB-and-PCS",
            "severity" : "error",
            "human" : "If P.O.Box extension is present, Postal code must be present too",
            "expression" : "line.all($this.extension('http://hl7.org/fhir/StructureDefinition/iso21090-ADXP-postBox').empty()) or (postalCode.exists())",
            "source" : "https://hl7.cz/fhir/core/StructureDefinition/cz-address"
          },
          {
            "key" : "street-and-city",
            "severity" : "error",
            "human" : "If streetName extension is present, Postal code or city must be present too",
            "expression" : "line.all($this.extension('http://hl7.org/fhir/StructureDefinition/iso21090-ADXP-streetName').empty()) or postalCode.exists() or city.exists()",
            "source" : "https://hl7.cz/fhir/core/StructureDefinition/cz-address"
          },
          {
            "key" : "POB-only-postal",
            "severity" : "warning",
            "human" : "Address with P.O.Box cannot be \"physical\" or \"both\"",
            "expression" : "line.all($this.extension('http://hl7.org/fhir/StructureDefinition/iso21090-ADXP-postBox').empty()) or type='postal' or type.empty()",
            "source" : "https://hl7.cz/fhir/core/StructureDefinition/cz-address"
          },
          {
            "key" : "POB-ext-only",
            "severity" : "warning",
            "human" : "If the extension 'P.O.Box' is used, the extensions 'Street' and 'House number' must not be used.",
            "expression" : "line.all($this.extension('http://hl7.org/fhir/StructureDefinition/iso21090-ADXP-postBox').empty() or ($this.extension('http://hl7.org/fhir/StructureDefinition/iso21090-ADXP-streetName').empty() and $this.extension('http://hl7.org/fhir/StructureDefinition/iso21090-ADXP-houseNumber').empty()))",
            "source" : "https://hl7.cz/fhir/core/StructureDefinition/cz-address"
          }
        ]
      },
      {
        "id" : "Address.extension:addressPoint",
        "path" : "Address.extension",
        "sliceName" : "addressPoint",
        "definition" : "If both the RUIAN code and the address are given, both must match.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Extension",
            "profile" : [
              "https://hl7.cz/fhir/core/StructureDefinition/address-point-cz"
            ]
          }
        ]
      },
      {
        "id" : "Address.extension:permanentResidence",
        "path" : "Address.extension",
        "sliceName" : "permanentResidence",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Extension",
            "profile" : [
              "https://hl7.cz/fhir/core/StructureDefinition/permanent-residencer-address-cz"
            ]
          }
        ]
      },
      {
        "id" : "Address.use",
        "path" : "Address.use",
        "definition" : "Address use"
      },
      {
        "id" : "Address.country",
        "path" : "Address.country",
        "short" : "Country (e.g. can be ISO 3166 2 letter code)"
      },
      {
        "id" : "Address.country.extension:countryCode",
        "path" : "Address.country.extension",
        "sliceName" : "countryCode"
      },
      {
        "id" : "Address.country.extension:countryCode.value[x]",
        "path" : "Address.country.extension.value[x]",
        "binding" : {
          "strength" : "required",
          "valueSet" : "http://hl7.org/fhir/ValueSet/iso3166-1-2"
        }
      }
    ]
  }
}

```
