# Medication Statement (CZ) - HL7 Czech Base and Core Implementation Guide v0.3.0-ballot

* [**Table of Contents**](toc.md)
* [**Summary artifacts**](artifacts.md)
* **Medication Statement (CZ)**

## Resource Profile: Medication Statement (CZ) 

| | |
| :--- | :--- |
| *Official URL*:https://hl7.cz/fhir/core/StructureDefinition/cz-MedicationStatement | *Version*:0.3.0-ballot |
| Draft as of 2025-12-19 | *Computable Name*:CZ_MedicationStatement |

 
Czech national profile for a medication statement. 

 
A medication declaration may indicate that a patient may be taking medications now, has taken medications in the past, or will take medications in the future. The source of this information may be the patient, a significant other (such as a family member or spouse), or the physician. A common scenario in which this information is captured is during the history taking process during a patient visit or stay. Medication information may come from sources such as the patient’s memory, the prescription bottle, or a medication list maintained by the patient, physician, or other party. 

**Usages:**

* Examples for this Profile: [MedicationStatement/Medication](MedicationStatement-Medication.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.fhir.cz.core|current/StructureDefinition/cz-MedicationStatement)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-cz-MedicationStatement.csv), [Excel](StructureDefinition-cz-MedicationStatement.xlsx), [Schematron](StructureDefinition-cz-MedicationStatement.sch) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "cz-MedicationStatement",
  "url" : "https://hl7.cz/fhir/core/StructureDefinition/cz-MedicationStatement",
  "version" : "0.3.0-ballot",
  "name" : "CZ_MedicationStatement",
  "title" : "Medication Statement (CZ)",
  "status" : "draft",
  "experimental" : false,
  "date" : "2025-12-19T09:24:48+00:00",
  "publisher" : "HL7 Czech Republic",
  "contact" : [
    {
      "name" : "HL7 Czech Republic",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.hl7.cz/"
        }
      ]
    }
  ],
  "description" : "Czech national profile for a medication statement.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "CZ",
          "display" : "Czechia"
        }
      ]
    }
  ],
  "purpose" : "A medication declaration may indicate that a patient may be taking medications now, has taken medications in the past, or will take medications in the future. The source of this information may be the patient, a significant other (such as a family member or spouse), or the physician. A common scenario in which this information is captured is during the history taking process during a patient visit or stay. Medication information may come from sources such as the patient’s memory, the prescription bottle, or a medication list maintained by the patient, physician, or other party.",
  "fhirVersion" : "4.0.1",
  "mapping" : [
    {
      "identity" : "workflow",
      "uri" : "http://hl7.org/fhir/workflow",
      "name" : "Workflow Pattern"
    },
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    },
    {
      "identity" : "w5",
      "uri" : "http://hl7.org/fhir/fivews",
      "name" : "FiveWs Pattern Mapping"
    },
    {
      "identity" : "v2",
      "uri" : "http://hl7.org/v2",
      "name" : "HL7 v2 Mapping"
    }
  ],
  "kind" : "resource",
  "abstract" : false,
  "type" : "MedicationStatement",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/MedicationStatement",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "MedicationStatement",
        "path" : "MedicationStatement",
        "short" : "Czech Medication Statement",
        "definition" : "This profile is derived from the Medication Statement in FHIR, which is a record of the medication the patient is taking."
      },
      {
        "id" : "MedicationStatement.identifier",
        "path" : "MedicationStatement.identifier",
        "min" : 1
      },
      {
        "id" : "MedicationStatement.status",
        "path" : "MedicationStatement.status",
        "mustSupport" : true,
        "binding" : {
          "strength" : "required",
          "valueSet" : "http://hl7.org/fhir/ValueSet/medication-statement-status"
        }
      },
      {
        "id" : "MedicationStatement.medication[x]",
        "path" : "MedicationStatement.medication[x]",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "type",
              "path" : "$this"
            }
          ],
          "ordered" : false,
          "rules" : "open"
        },
        "type" : [
          {
            "code" : "CodeableConcept"
          },
          {
            "code" : "Reference",
            "targetProfile" : ["https://hl7.cz/fhir/core/StructureDefinition/cz-Medication"]
          }
        ]
      },
      {
        "id" : "MedicationStatement.medication[x]:medicationCodeableConcept",
        "path" : "MedicationStatement.medication[x]",
        "sliceName" : "medicationCodeableConcept",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ],
        "binding" : {
          "strength" : "required",
          "valueSet" : "https://sukl.cz/terminology/ValueSet/dlp-lecive-pripravky"
        }
      },
      {
        "id" : "MedicationStatement.subject",
        "path" : "MedicationStatement.subject",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "https://hl7.cz/fhir/core/StructureDefinition/cz-patient-core",
              "http://hl7.org/fhir/StructureDefinition/Group"
            ]
          }
        ]
      },
      {
        "id" : "MedicationStatement.informationSource",
        "path" : "MedicationStatement.informationSource",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "https://hl7.cz/fhir/core/StructureDefinition/cz-patient-core",
              "https://hl7.cz/fhir/core/StructureDefinition/cz-practitioner-core",
              "https://hl7.cz/fhir/core/StructureDefinition/cz-practitionerrole-core",
              "https://hl7.cz/fhir/core/StructureDefinition/cz-relatedPerson-core",
              "https://hl7.cz/fhir/core/StructureDefinition/cz-organization-core"
            ]
          }
        ]
      }
    ]
  }
}

```
