# Medication (CZ) - HL7 Czech Base and Core Implementation Guide v0.3.0-ballot

* [**Table of Contents**](toc.md)
* [**Summary artifacts**](artifacts.md)
* **Medication (CZ)**

## Resource Profile: Medication (CZ) 

| | |
| :--- | :--- |
| *Official URL*:https://hl7.cz/fhir/core/StructureDefinition/cz-Medication | *Version*:0.3.0-ballot |
| Draft as of 2025-12-19 | *Computable Name*:CZ_Medication |

 
Czech national profile for a medication. 

 
A medication for the identification and definition of a medication for the purposes of prescribing, dispensing, and administering a medication as well as for making statements about medication use. 

**Usages:**

* Refer to this Profile: [Medication (CZ)](StructureDefinition-cz-Medication.md) and [Medication Statement (CZ)](StructureDefinition-cz-MedicationStatement.md)
* Examples for this Profile: [Medication/med-1](Medication-med-1.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.fhir.cz.core|current/StructureDefinition/cz-Medication)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-cz-Medication.csv), [Excel](StructureDefinition-cz-Medication.xlsx), [Schematron](StructureDefinition-cz-Medication.sch) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "cz-Medication",
  "url" : "https://hl7.cz/fhir/core/StructureDefinition/cz-Medication",
  "version" : "0.3.0-ballot",
  "name" : "CZ_Medication",
  "title" : "Medication (CZ)",
  "status" : "draft",
  "experimental" : false,
  "date" : "2025-12-19T09:24:48+00:00",
  "publisher" : "HL7 Czech Republic",
  "contact" : [
    {
      "name" : "HL7 Czech Republic",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.hl7.cz/"
        }
      ]
    }
  ],
  "description" : "Czech national profile for a medication.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "CZ",
          "display" : "Czechia"
        }
      ]
    }
  ],
  "purpose" : "A medication for the identification and definition of a medication for the purposes of prescribing, dispensing, and administering a medication as well as for making statements about medication use.",
  "fhirVersion" : "4.0.1",
  "mapping" : [
    {
      "identity" : "script10.6",
      "uri" : "http://ncpdp.org/SCRIPT10_6",
      "name" : "Mapping to NCPDP SCRIPT 10.6"
    },
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    },
    {
      "identity" : "w5",
      "uri" : "http://hl7.org/fhir/fivews",
      "name" : "FiveWs Pattern Mapping"
    },
    {
      "identity" : "v2",
      "uri" : "http://hl7.org/v2",
      "name" : "HL7 v2 Mapping"
    }
  ],
  "kind" : "resource",
  "abstract" : false,
  "type" : "Medication",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/Medication",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "Medication",
        "path" : "Medication",
        "short" : "Czech Medication",
        "definition" : "This profile is derived from the Medication in FHIR, which is a record of the medication."
      },
      {
        "id" : "Medication.identifier",
        "path" : "Medication.identifier",
        "min" : 1
      },
      {
        "id" : "Medication.code",
        "path" : "Medication.code",
        "binding" : {
          "extension" : [
            {
              "extension" : [
                {
                  "url" : "key",
                  "valueId" : "dlp-atc"
                },
                {
                  "url" : "purpose",
                  "valueCode" : "candidate"
                },
                {
                  "url" : "valueSet",
                  "valueCanonical" : "https://sukl.cz/terminology/ValueSet/dlp-atc"
                },
                {
                  "url" : "documentation",
                  "valueMarkdown" : "Additional conformance binding to a ATC value set."
                }
              ],
              "url" : "http://hl7.org/fhir/tools/StructureDefinition/additional-binding"
            }
          ],
          "strength" : "required",
          "valueSet" : "https://sukl.cz/terminology/ValueSet/dlp-lecive-pripravky"
        }
      },
      {
        "id" : "Medication.manufacturer",
        "path" : "Medication.manufacturer",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "https://hl7.cz/fhir/core/StructureDefinition/cz-organization-core"
            ]
          }
        ]
      },
      {
        "id" : "Medication.form",
        "path" : "Medication.form",
        "binding" : {
          "strength" : "preferred",
          "valueSet" : "https://sukl.cz/terminology/ValueSet/dlp-formy"
        }
      },
      {
        "id" : "Medication.ingredient",
        "path" : "Medication.ingredient",
        "definition" : "Identifies a particular constituent in the product."
      },
      {
        "id" : "Medication.ingredient.item[x]",
        "path" : "Medication.ingredient.item[x]",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "type",
              "path" : "$this"
            }
          ],
          "ordered" : false,
          "rules" : "open"
        }
      },
      {
        "id" : "Medication.ingredient.item[x]:itemReference",
        "path" : "Medication.ingredient.item[x]",
        "sliceName" : "itemReference",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : ["https://hl7.cz/fhir/core/StructureDefinition/cz-Medication"]
          }
        ]
      },
      {
        "id" : "Medication.ingredient.item[x]:itemCodeableConcept",
        "path" : "Medication.ingredient.item[x]",
        "sliceName" : "itemCodeableConcept",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ],
        "binding" : {
          "strength" : "preferred",
          "valueSet" : "https://sukl.cz/terminology/ValueSet/dlp-lecive-latky"
        }
      }
    ]
  }
}

```
