# Accreditation Requirement - HL7 Czech Base and Core Implementation Guide v0.3.0-ballot

* [**Table of Contents**](toc.md)
* [**Summary artifacts**](artifacts.md)
* **Accreditation Requirement**

## Extension: Accreditation Requirement 

| | |
| :--- | :--- |
| *Official URL*:https://hl7.cz/fhir/core/StructureDefinition/accreditation-cz | *Version*:0.3.0-ballot |
| Draft as of 2025-12-19 | *Computable Name*:AccreditationCz |

Indicates whether the examination must be performed only by a laboratory accredited for the specific test, or whether the result originates from such a laboratory.

This extension is used to specify or confirm that a laboratory test is required to be, or was, performed by an accredited laboratory.

**Context of Use**

**Usage info**

**Usages:**

* This Extension is not used by any profiles in this Implementation Guide

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.fhir.cz.core|current/StructureDefinition/accreditation-cz)

### Formal Views of Extension Content

 [Description of Profiles, Differentials, Snapshots, and how the XML and JSON presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-accreditation-cz.csv), [Excel](StructureDefinition-accreditation-cz.xlsx), [Schematron](StructureDefinition-accreditation-cz.sch) 

#### Constraints



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "accreditation-cz",
  "url" : "https://hl7.cz/fhir/core/StructureDefinition/accreditation-cz",
  "version" : "0.3.0-ballot",
  "name" : "AccreditationCz",
  "title" : "Accreditation Requirement",
  "status" : "draft",
  "date" : "2025-12-19T09:24:48+00:00",
  "publisher" : "HL7 Czech Republic",
  "contact" : [
    {
      "name" : "HL7 Czech Republic",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.hl7.cz/"
        }
      ]
    }
  ],
  "description" : "Indicates whether the examination must be performed only by a laboratory accredited for the specific test, or whether the result originates from such a laboratory.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "CZ",
          "display" : "Czechia"
        }
      ]
    }
  ],
  "purpose" : "This extension is used to specify or confirm that a laboratory test is required to be, or was, performed by an accredited laboratory.",
  "fhirVersion" : "4.0.1",
  "mapping" : [
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    }
  ],
  "kind" : "complex-type",
  "abstract" : false,
  "context" : [
    {
      "type" : "element",
      "expression" : "ServiceRequest"
    },
    {
      "type" : "element",
      "expression" : "Observation"
    }
  ],
  "type" : "Extension",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/Extension",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "Extension",
        "path" : "Extension",
        "short" : "Accreditation Requirement",
        "definition" : "Indicates whether the examination must be performed only by a laboratory accredited for the specific test, or whether the result originates from such a laboratory."
      },
      {
        "id" : "Extension.extension",
        "path" : "Extension.extension",
        "max" : "0"
      },
      {
        "id" : "Extension.url",
        "path" : "Extension.url",
        "fixedUri" : "https://hl7.cz/fhir/core/StructureDefinition/accreditation-cz"
      },
      {
        "id" : "Extension.value[x]",
        "path" : "Extension.value[x]",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "type",
              "path" : "$this"
            }
          ],
          "ordered" : false,
          "rules" : "open"
        },
        "min" : 1
      },
      {
        "id" : "Extension.value[x]:valueBoolean",
        "path" : "Extension.value[x]",
        "sliceName" : "valueBoolean",
        "short" : "Accreditation required or confirmed",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "boolean"
          }
        ]
      }
    ]
  }
}

```
