# practitionerrole1 - HL7 Czech Base and Core Implementation Guide v0.3.0-ballot

* [**Table of Contents**](toc.md)
* [**Summary artifacts**](artifacts.md)
* **practitionerrole1**

## Example PractitionerRole: practitionerrole1

version: 1; Last updated: 2019-07-01 13:30:55+0000

Profile: [Practitioner Role (CZ core)](StructureDefinition-cz-practitionerrole-core.md)

**identifier**: `http://www.acme.org/practitioners`/23

**active**: true

**period**: 2022-08-01 00:00:00+0000 --> 2022-12-31 00:00:00+0000

**practitioner**: [MUDr. Hana Doktorová](Practitioner-Practitioner-2.md)

**organization**: [Ordinace praktického lékaře, MUDr. Hana Doktorová](Organization-Organization-2.md)

**code**: Lékař

**specialty**: Family practice

> **availableTime****daysOfWeek**: Tuesday, Wednesday**availableStartTime**: 12:30:00**availableEndTime**: 18:30:00

> **availableTime****daysOfWeek**: Thursday, Friday**availableStartTime**: 07:00:00**availableEndTime**: 13:00:00

### NotAvailables

| | | |
| :--- | :--- | :--- |
| - | **Description** | **During** |
| * | Plánovaná dovolená | 2023-08-01 00:00:00+0000 --> 2023-08-20 00:00:00+0000 |

**availabilityExceptions**: Státní svátky



## Resource Content

```json
{
  "resourceType" : "PractitionerRole",
  "id" : "practitionerrole1",
  "meta" : {
    "versionId" : "1",
    "lastUpdated" : "2019-07-01T13:30:55.864+00:00",
    "profile" : [
      "https://hl7.cz/fhir/core/StructureDefinition/cz-practitionerrole-core"
    ]
  },
  "identifier" : [
    {
      "system" : "http://www.acme.org/practitioners",
      "value" : "23"
    }
  ],
  "active" : true,
  "period" : {
    "start" : "2022-08-01T00:00:00.000Z",
    "end" : "2022-12-31T00:00:00.000Z"
  },
  "practitioner" : {
    "reference" : "Practitioner/Practitioner-2",
    "display" : "MUDr. Hana Doktorová"
  },
  "organization" : {
    "reference" : "Organization/Organization-2",
    "display" : "Ordinace praktického lékaře, MUDr. Hana Doktorová"
  },
  "code" : [
    {
      "coding" : [
        {
          "system" : "https://ncez.mzcr.cz/terminology/CodeSystem/nrzp-povolani",
          "code" : "L00",
          "display" : "Lékař"
        }
      ]
    }
  ],
  "specialty" : [
    {
      "coding" : [
        {
          "system" : "http://snomed.info/sct",
          "version" : "http://snomed.info/sct/11000279109",
          "code" : "419772000",
          "display" : "Family practice"
        }
      ]
    }
  ],
  "availableTime" : [
    {
      "daysOfWeek" : ["tue", "wed"],
      "availableStartTime" : "12:30:00",
      "availableEndTime" : "18:30:00"
    },
    {
      "daysOfWeek" : ["thu", "fri"],
      "availableStartTime" : "07:00:00",
      "availableEndTime" : "13:00:00"
    }
  ],
  "notAvailable" : [
    {
      "description" : "Plánovaná dovolená",
      "during" : {
        "start" : "2023-08-01T00:00:00.000Z",
        "end" : "2023-08-20T00:00:00.000Z"
      }
    }
  ],
  "availabilityExceptions" : "Státní svátky"
}

```
