# cz-patient-addr-example-4 - HL7 Czech Base and Core Implementation Guide v0.3.0-ballot

* [**Table of Contents**](toc.md)
* [**Summary artifacts**](artifacts.md)
* **cz-patient-addr-example-4**

## Example Patient: cz-patient-addr-example-4

Profile: [Patient (CZ core)](StructureDefinition-cz-patient-core.md)

Adam Příklad (no stated gender), DoB: 1971-11-26 ( https://ncez.mzcr.cz/fhir/sid/rid#4567891237)

-------

| | |
| :--- | :--- |
| Contact Detail | Malé námestie 13a, 150 00, Žilina(home) |



## Resource Content

```json
{
  "resourceType" : "Patient",
  "id" : "cz-patient-addr-example-4",
  "meta" : {
    "profile" : [
      "https://hl7.cz/fhir/core/StructureDefinition/cz-patient-core"
    ]
  },
  "identifier" : [
    {
      "system" : "https://ncez.mzcr.cz/fhir/sid/rid",
      "value" : "4567891237"
    }
  ],
  "name" : [
    {
      "family" : "Příklad",
      "given" : ["Adam"]
    }
  ],
  "birthDate" : "1971-11-26",
  "address" : [
    {
      "extension" : [
        {
          "url" : "https://hl7.cz/fhir/core/StructureDefinition/permanent-residencer-address-cz",
          "valueCodeableConcept" : {
            "coding" : [
              {
                "system" : "urn:iso:std:iso:3166",
                "code" : "SK",
                "display" : "Slovakia"
              }
            ]
          }
        }
      ],
      "use" : "home",
      "type" : "both",
      "text" : "Malé námestie 13a, 150 00, Žilina",
      "line" : ["Malé námestie 13a"],
      "_line" : [
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/iso21090-ADXP-streetName",
              "valueString" : "Malé námestie"
            },
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/iso21090-ADXP-houseNumber",
              "valueString" : "13a"
            }
          ]
        }
      ],
      "city" : "Žilina",
      "postalCode" : "15000",
      "country" : "Slovensko",
      "_country" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/iso21090-SC-coding",
            "valueCoding" : {
              "system" : "urn:iso:std:iso:3166",
              "code" : "SK",
              "display" : "Slovakia"
            }
          }
        ]
      }
    }
  ]
}

```
