# MedicationStatement - Ongoing Simvastatin Treatment - HL7 Czech Base and Core Implementation Guide v0.3.0-ballot

* [**Table of Contents**](toc.md)
* [**Summary artifacts**](artifacts.md)
* **MedicationStatement - Ongoing Simvastatin Treatment**

## Example MedicationStatement: MedicationStatement - Ongoing Simvastatin Treatment



## Resource Content

```json
{
  "resourceType" : "MedicationStatement",
  "id" : "Medication",
  "meta" : {
    "profile" : [
      "https://hl7.cz/fhir/core/StructureDefinition/cz-MedicationStatement"
    ]
  },
  "contained" : [
    {
      "resourceType" : "Medication",
      "id" : "med-1",
      "meta" : {
        "profile" : ["https://hl7.cz/fhir/core/StructureDefinition/cz-Medication"]
      },
      "identifier" : [
        {
          "system" : "http://example.org/exampleSystem",
          "value" : "med-1"
        }
      ],
      "code" : {
        "coding" : [
          {
            "system" : "https://sukl.cz/terminology/CodeSystem/dlp-lecive-pripravky",
            "code" : "0013831",
            "display" : "SIMVASTATIN RATIOPHARM 40MG TBL FLM 20"
          },
          {
            "system" : "https://sukl.cz/terminology/CodeSystem/dlp-atc",
            "code" : "C10AA01",
            "display" : "simvastatin"
          }
        ],
        "text" : "Simvastatin 40 MG TBL FLM 20"
      },
      "form" : {
        "coding" : [
          {
            "system" : "https://sukl.cz/terminology/CodeSystem/dlp-formy",
            "code" : "TBL_FLM",
            "display" : "Potahovaná tableta"
          },
          {
            "system" : "http://standardterms.edqm.eu",
            "code" : "10219000",
            "display" : "Tablet"
          }
        ]
      },
      "ingredient" : [
        {
          "itemCodeableConcept" : {
            "coding" : [
              {
                "system" : "https://sukl.cz/terminology/CodeSystem/dlp-lecivelatky",
                "code" : "10647",
                "display" : "Simvastatin"
              }
            ]
          },
          "strength" : {
            "numerator" : {
              "value" : 40,
              "unit" : "mcg",
              "system" : "http://unitsofmeasure.org",
              "code" : "mg"
            },
            "denominator" : {
              "value" : 1,
              "unit" : "tablet",
              "system" : "http://unitsofmeasure.org",
              "code" : "1"
            }
          }
        }
      ]
    }
  ],
  "identifier" : [
    {
      "system" : "http://example.org/exampleSystem",
      "value" : "medstat-1"
    }
  ],
  "status" : "active",
  "medicationReference" : {
    "reference" : "#med-1",
    "display" : "simvastatin"
  },
  "subject" : {
    "reference" : "Patient/Mracena",
    "display" : "Mračena Mraková"
  },
  "effectivePeriod" : {
    "start" : "2014"
  },
  "dosage" : [
    {
      "text" : "40 mg/day",
      "timing" : {
        "repeat" : {
          "frequency" : 1,
          "period" : 1,
          "periodUnit" : "d"
        }
      },
      "doseAndRate" : [
        {
          "doseQuantity" : {
            "value" : 40,
            "unit" : "mg",
            "system" : "http://unitsofmeasure.org",
            "code" : "mg"
          }
        }
      ]
    }
  ]
}

```
