# AllergyIntolerance - No Known Allergies - HL7 Czech Base and Core Implementation Guide v0.3.0-ballot

* [**Table of Contents**](toc.md)
* [**Summary artifacts**](artifacts.md)
* **AllergyIntolerance - No Known Allergies**

## Example AllergyIntolerance: AllergyIntolerance - No Known Allergies

Profile: [Allergy Intolerance (CZ)](StructureDefinition-cz-allergyIntolerance.md)

**identifier**: `http://example.org/hospital/allergy-intolerances`/allergy-1

**clinicalStatus**: Active

**verificationStatus**: Confirmed

**code**: žádné známé alergie

**patient**: [Mračena](Patient-Mracena.md)

**onset**: Absent because : unknown



## Resource Content

```json
{
  "resourceType" : "AllergyIntolerance",
  "id" : "allergy-1",
  "meta" : {
    "profile" : [
      "https://hl7.cz/fhir/core/StructureDefinition/cz-allergyIntolerance"
    ]
  },
  "identifier" : [
    {
      "system" : "http://example.org/hospital/allergy-intolerances",
      "value" : "allergy-1"
    }
  ],
  "clinicalStatus" : {
    "coding" : [
      {
        "system" : "http://terminology.hl7.org/CodeSystem/allergyintolerance-clinical",
        "code" : "active"
      }
    ]
  },
  "verificationStatus" : {
    "coding" : [
      {
        "system" : "http://terminology.hl7.org/CodeSystem/allergyintolerance-verification",
        "code" : "confirmed"
      }
    ]
  },
  "code" : {
    "coding" : [
      {
        "system" : "http://hl7.org/fhir/uv/ips/CodeSystem/absent-unknown-uv-ips",
        "code" : "no-known-allergies",
        "display" : "žádné známé alergie"
      }
    ]
  },
  "patient" : {
    "reference" : "Patient/Mracena",
    "display" : "Mračena"
  },
  "_onsetDateTime" : {
    "extension" : [
      {
        "url" : "http://hl7.org/fhir/StructureDefinition/data-absent-reason",
        "valueCode" : "unknown"
      }
    ]
  }
}

```
