# Allergy to cat dander - HL7 Czech Base and Core Implementation Guide v0.3.0-ballot

* [**Table of Contents**](toc.md)
* [**Summary artifacts**](artifacts.md)
* **Allergy to cat dander**

## Example AllergyIntolerance: Allergy to cat dander

Profile: [Allergy Intolerance (CZ)](StructureDefinition-cz-allergyIntolerance.md)

**identifier**: `http://example.org/hospital/allergy-intolerances`/allergy-2

**clinicalStatus**: Active

**verificationStatus**: Confirmed

**type**: Allergy

**category**: Biologic

**criticality**: Low Risk

**code**: Allergy to cat dander (finding)

**patient**: [Mračena](Patient-Mracena.md)

> **reaction****AllergyIntolerance Certainty**:Confirmed**AllergyIntolerance ExposureDescription**: Animal shelter**substance**:Cat dander (substance)**manifestation**:Eruption of skin (disorder)**severity**: Mild



## Resource Content

```json
{
  "resourceType" : "AllergyIntolerance",
  "id" : "AllergyToCatDander",
  "meta" : {
    "profile" : [
      "https://hl7.cz/fhir/core/StructureDefinition/cz-allergyIntolerance"
    ]
  },
  "identifier" : [
    {
      "system" : "http://example.org/hospital/allergy-intolerances",
      "value" : "allergy-2"
    }
  ],
  "clinicalStatus" : {
    "coding" : [
      {
        "system" : "http://terminology.hl7.org/CodeSystem/allergyintolerance-clinical",
        "code" : "active",
        "display" : "Active"
      }
    ]
  },
  "verificationStatus" : {
    "coding" : [
      {
        "system" : "http://terminology.hl7.org/CodeSystem/allergyintolerance-verification",
        "code" : "confirmed",
        "display" : "Confirmed"
      }
    ]
  },
  "type" : "allergy",
  "category" : ["biologic"],
  "criticality" : "low",
  "code" : {
    "coding" : [
      {
        "system" : "http://snomed.info/sct",
        "version" : "http://snomed.info/sct/11000279109",
        "code" : "232346004",
        "display" : "Allergy to cat dander (finding)"
      }
    ]
  },
  "patient" : {
    "reference" : "Patient/Mracena",
    "display" : "Mračena"
  },
  "reaction" : [
    {
      "extension" : [
        {
          "url" : "http://hl7.org/fhir/StructureDefinition/allergyintolerance-certainty",
          "valueCodeableConcept" : {
            "coding" : [
              {
                "system" : "http://terminology.hl7.org/CodeSystem/reaction-event-certainty",
                "code" : "confirmed",
                "display" : "Confirmed"
              }
            ]
          }
        },
        {
          "url" : "http://hl7.org/fhir/StructureDefinition/openEHR-exposureDescription",
          "valueString" : "Animal shelter"
        }
      ],
      "substance" : {
        "coding" : [
          {
            "system" : "http://snomed.info/sct",
            "version" : "http://snomed.info/sct/11000279109",
            "code" : "260152009",
            "display" : "Cat dander (substance)"
          }
        ]
      },
      "manifestation" : [
        {
          "coding" : [
            {
              "system" : "http://snomed.info/sct",
              "version" : "http://snomed.info/sct/11000279109",
              "code" : "271807003",
              "display" : "Eruption of skin (disorder)"
            }
          ]
        }
      ],
      "severity" : "mild"
    }
  ]
}

```
