# Home - HL7 Czech Base and Core Implementation Guide v0.3.0-ballot

* [**Table of Contents**](toc.md)
* **Home**

## Home

| | |
| :--- | :--- |
| *Official URL*:https://hl7.cz/fhir/core/ImplementationGuide/hl7.fhir.cz.core | *Version*:0.3.0-ballot |
| Draft as of 2025-12-19 | *Computable Name*:HL7CzCoreImplementationGuide |

### Introduction

The CZ Base and Core implementation guide is based on [FHIR version R4](https://hl7.org/fhir/R4/). It defines the minimum rules for interoperability and national customization of FHIR resources, which is applied when creating national profiles for specific use cases. The establishment of standards to support interoperability and their implementation in information systems creates a common basis for the interoperable exchange of health data.

In this implementation guide, you will find the rules for creating national profiles, the use of identifiers and basic information components.

### Scope

This document presents Czech use concepts defined via FHIR processable artefacts; these are collaborative outputs with agreed approaches to varied kinds of healthcare related information based on the core FHIR R4 specification.

This guide is divided into several pages which are listed at the top of each page in the menu bar.

* Home: This page provides the introduction and scope for this guide.
* Introduction: 
* [Basic FHIR elements (EN)](elements-FHIR-en.md): This page describes the basic FHIR elements in english.
* [Basic FHIR elements (CS)](elements-FHIR-cs.md): This page describes the basic FHIR elements in czech.
 
* Function view: 
* [Subjects (EN)](subjects-en.md): This page describes the basic components in the position of subjects in english.
* [Subjects (CS)](subjects-cs.md): This page describes the basic components in the position of subjects in czech.
* [Objects (EN)](objects-en.md): This page describes the basic components in the position of objects in english.
* [Objects (CS)](objects-cs.md): This page describes the basic components in the position of objects in czech.
* [Identifiers (EN)](identifiers-en.md): This page describes the identifiers that are used in the components in english.
* [Identifiers (CS)](identifiers-cs.md): This page describes the identifiers that are used in the components in czech.
 
* Artifacts: 
* [Artifacts Summary](artifacts.md): These page lists detailed descriptions and formal definitions for all the Czech artifacts defined in this guide.
 
* About: 
* [Downloads](downloads.md): This page provides links to downloadable artefacts.
 

### References

* Related Specifications: 
* [EHDS Logical Information Models](http://build.fhir.org/ig/Xt-EHR/xt-ehr-common/index.html) 
* This specification inspired many of the design patterns defined in this IG.
 
* [HL7 Europe Base and core](https://build.fhir.org/ig/hl7-eu/base/index.html) 
* This specification is based on the design patterns defined in this IG.
 
 

### Dependencies







### Cross Version Analysis

This is an R4 IG. None of the features it uses are changed in R4B, so it can be used as is with R4B systems. Packages for both [R4 (hl7.fhir.cz.core.r4)](package.r4.tgz) and [R4B (hl7.fhir.cz.core.r4b)](package.r4b.tgz) are available.

### IP statements

This publication includes IP covered under the following statements.

* ISO maintains the copyright on the country codes, and controls its use carefully. For further details see the ISO 3166 web page: [https://www.iso.org/iso-3166-country-codes.html](https://www.iso.org/iso-3166-country-codes.html)

* [ISO 3166-1 Codes for the representation of names of countries and their subdivisions — Part 1: Country code](http://terminology.hl7.org/6.3.0/CodeSystem-ISO3166Part1.html): [AccreditationCz](StructureDefinition-accreditation-cz.md), [AddressPointCz](StructureDefinition-address-point-cz.md)...Show 52 more,[BodyStructureCz](StructureDefinition-BodyStructure-cz.md),[CZ_Address](StructureDefinition-cz-address.md),[CZ_AllergyIntolerance](StructureDefinition-cz-allergyIntolerance.md),[CZ_Attachment](StructureDefinition-cz-attachment.md),[CZ_Coverage](StructureDefinition-cz-coverage.md),[CZ_DeviceObserver](StructureDefinition-cz-device-observer.md),[CZ_Encounter](StructureDefinition-cz-encounter.md),[CZ_LocationBase](StructureDefinition-cz-location-base.md),[CZ_LocationCore](StructureDefinition-cz-location-core.md),[CZ_Logo](StructureDefinition-cz-logo.md),[CZ_MedicalDevice](StructureDefinition-cz-medical-device.md),[CZ_Medication](StructureDefinition-cz-Medication.md),[CZ_MedicationStatement](StructureDefinition-cz-MedicationStatement.md),[CZ_OrganizationBase](StructureDefinition-cz-organization-base.md),[CZ_OrganizationCore](StructureDefinition-cz-organization-core.md),[CZ_OrganizationLogo](StructureDefinition-cz-organization-logo.md),[CZ_Passport_Identifier](StructureDefinition-cz-passport-identifier.md),[CZ_PatientAnimal](StructureDefinition-cz-patient-animal.md),[CZ_PatientBase](StructureDefinition-cz-patient-base.md),[CZ_PatientCore](StructureDefinition-cz-patient-core.md),[CZ_PractitionerBase](StructureDefinition-cz-practitioner-base.md),[CZ_PractitionerCore](StructureDefinition-cz-practitioner-core.md),[CZ_PractitionerRoleBase](StructureDefinition-cz-practitionerrole-base.md),[CZ_PractitionerRoleCore](StructureDefinition-cz-practitionerrole-core.md),[CZ_Presented_Form](StructureDefinition-cz-presented-form.md),[CZ_Provenance](StructureDefinition-cz-provenance.md),[CZ_RID_Identifier](StructureDefinition-cz-rid-identifier.md),[CZ_RefundIndicatorCode](StructureDefinition-cz-refund-indicator-code.md),[CZ_RelatedPersonBase](StructureDefinition-cz-relatedPerson-base.md),[CZ_RelatedPersonCore](StructureDefinition-cz-relatedPerson-core.md),[CZ_Rodcis_Identifier](StructureDefinition-cz-rodcis-identifier.md),[CZ_Signature](StructureDefinition-cz-signature.md),[CZ_Specimen](StructureDefinition-cz-specimen.md),[CZ_SpecimenAdditiveSubstance](StructureDefinition-Substance-additive-cz.md),[Consumer_L1](ActorDefinition-actor-consumer-L1.md),[Consumer_L2](ActorDefinition-actor-consumer-L2.md),[Consumer_L3](ActorDefinition-actor-consumer-L3.md),[Creator_L1](ActorDefinition-actor-creator-L1.md),[Creator_L2](ActorDefinition-actor-creator-L2.md),[Creator_L3](ActorDefinition-actor-creator-L3.md),[DocumentPresentedForm](StructureDefinition-presentedForm.md),[HL7CzCoreImplementationGuide](index.md),[Id_Card_Identifier](StructureDefinition-id-card-identifier.md),[OidIdentifier](StructureDefinition-OidIdentifier.md),[Patient/Mracena](Patient-Mracena.md),[Patient/cz-patient-addr-example-1](Patient-cz-patient-addr-example-1.md),[Patient/cz-patient-addr-example-2](Patient-cz-patient-addr-example-2.md),[Patient/cz-patient-addr-example-3](Patient-cz-patient-addr-example-3.md),[Patient/cz-patient-addr-example-4](Patient-cz-patient-addr-example-4.md),[Patient/cz-patient-addr-example-5](Patient-cz-patient-addr-example-5.md),[PermanentResidenceAddressCz](StructureDefinition-permanent-residencer-address-cz.md)and[RegisteringProviderCz](StructureDefinition-registering-provider-cz.md)


* Produced by HL7 under the terms of HL7® Governance and Operations Manual relating to Intellectual Property (Section 16), specifically its copyright, trademark and patent provisions. This document is licensed under Creative Commons "No Rights Reserved" (CC0).

* [Absent and Unknown Data - IPS](http://hl7.org/fhir/uv/ips/STU1.1/CodeSystem-absent-unknown-uv-ips.html): [AllergyIntolerance/allergy-1](AllergyIntolerance-allergy-1.md), [Device/AbsentDevice](Device-AbsentDevice.md) and [Device/NoInformationAboutDevice](Device-NoInformationAboutDevice.md)


* The UCUM codes, UCUM table (regardless of format), and UCUM Specification are copyright 1999-2009, Regenstrief Institute, Inc. and the Unified Codes for Units of Measures (UCUM) Organization. All rights reserved. [https://ucum.org/trac/wiki/TermsOfUse](https://ucum.org/trac/wiki/TermsOfUse)

* [Unified Code for Units of Measure (UCUM)](http://terminology.hl7.org/6.3.0/CodeSystem-v3-ucum.html): [Medication/med-1](Medication-med-1.md) and [MedicationStatement/Medication](MedicationStatement-Medication.md)


* These codes are excerpted from ASTM Standard, E1762-95(2013) - Standard Guide for Electronic Authentication of Health Care Information, Copyright by ASTM International, 100 Barr Harbor Drive, West Conshohocken, PA 19428. Copies of this standard are available through the ASTM Web Site at www.astm.org.

* [Signature Type Codes](http://hl7.org/fhir/R4/codesystem-signature-type.html): [Provenance/signature-rentgen](Provenance-signature-rentgen.md)


* This material contains content that is copyright of SNOMED International. Implementers of these specifications must have the appropriate SNOMED CT Affiliate license - for more information contact [https://www.snomed.org/get-snomed](https://www.snomed.org/get-snomed) or [info@snomed.org](mailto:info@snomed.org).

* [SNOMED Clinical Terms&reg; (SNOMED CT&reg;)](http://hl7.org/fhir/R4/codesystem-snomedct.html): [AllergyIntolerance/AllergyToCatDander](AllergyIntolerance-AllergyToCatDander.md), [BodyStructure/BodyStructure01](BodyStructure-BodyStructure01.md)...Show 11 more,[BodyStructureCz](StructureDefinition-BodyStructure-cz.md),[CZ_Specimen](StructureDefinition-cz-specimen.md),[CZ_SpecimenAdditiveSubstance](StructureDefinition-Substance-additive-cz.md),[Device/LabAnalyzer](Device-LabAnalyzer.md),[Device/Pacemaker](Device-Pacemaker.md),[Patient/Kocka](Patient-Kocka.md),[Patient/Mracena](Patient-Mracena.md),[PractitionerRole/practitionerrole1](PractitionerRole-practitionerrole1.md),[RegisteringProviderCz](StructureDefinition-registering-provider-cz.md),[Specimen/Specimen-example-animal](Specimen-Specimen-example-animal.md)and[Specimen/Specimen-example-environment](Specimen-Specimen-example-environment.md)


* This material derives from the HL7 Terminology (THO). THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: [https://terminology.hl7.org/license.html](https://terminology.hl7.org/license.html)

* [AllergyIntolerance Clinical Status Codes](http://terminology.hl7.org/7.0.1/CodeSystem-allergyintolerance-clinical.html): [AllergyIntolerance/AllergyToCatDander](AllergyIntolerance-AllergyToCatDander.md), [AllergyIntolerance/allergy-1](AllergyIntolerance-allergy-1.md) and [CZ_AllergyIntolerance](StructureDefinition-cz-allergyIntolerance.md)
* [AllergyIntolerance Verification Status](http://terminology.hl7.org/7.0.1/CodeSystem-allergyintolerance-verification.html): [AllergyIntolerance/AllergyToCatDander](AllergyIntolerance-AllergyToCatDander.md) and [AllergyIntolerance/allergy-1](AllergyIntolerance-allergy-1.md)
* [Coverage SelfPay Codes](http://terminology.hl7.org/7.0.1/CodeSystem-coverage-selfpay.html): [CZ_Coverage](StructureDefinition-cz-coverage.md)
* [AllergyIntoleranceCertainty](http://terminology.hl7.org/7.0.1/CodeSystem-reaction-event-certainty.html): [AllergyIntolerance/AllergyToCatDander](AllergyIntolerance-AllergyToCatDander.md)
* [contactRole2](http://terminology.hl7.org/7.0.1/CodeSystem-v2-0131.html): [Patient/Mracena](Patient-Mracena.md) and [RelatedPerson/RelatedPerson01](RelatedPerson-RelatedPerson01.md)
* [identifierType](http://terminology.hl7.org/7.0.1/CodeSystem-v2-0203.html): [CZ_Passport_Identifier](StructureDefinition-cz-passport-identifier.md), [CZ_PatientBase](StructureDefinition-cz-patient-base.md)...Show 6 more,[CZ_PatientCore](StructureDefinition-cz-patient-core.md),[CZ_RelatedPersonBase](StructureDefinition-cz-relatedPerson-base.md),[CZ_RelatedPersonCore](StructureDefinition-cz-relatedPerson-core.md),[Id_Card_Identifier](StructureDefinition-id-card-identifier.md),[Patient/Mracena](Patient-Mracena.md)and[RelatedPerson/RelatedPerson01](RelatedPerson-RelatedPerson01.md)
* [ActCode](http://terminology.hl7.org/7.0.1/CodeSystem-v3-ActCode.html): [CZ_Coverage](StructureDefinition-cz-coverage.md), [Coverage/Coverage01](Coverage-Coverage01.md) and [Encounter/cz-encounter-example](Encounter-cz-encounter-example.md)
* [ParticipationType](http://terminology.hl7.org/7.0.1/CodeSystem-v3-ParticipationType.html): [Provenance/signature-rentgen](Provenance-signature-rentgen.md)
* [RoleCode](http://terminology.hl7.org/7.0.1/CodeSystem-v3-RoleCode.html): [Patient/Mracena](Patient-Mracena.md) and [RelatedPerson/RelatedPerson01](RelatedPerson-RelatedPerson01.md)


* Unless otherwise indicated, reproduction of material posted on Council of Europe websites, and reproduction of photographs for which the Council of Europe holds copyright – see legal notice \“photo credits\” – is authorised for private use and for informational and educational uses relating to the Council of Europe’s work. This authorisation is subject to the condition that the source be indicated and no charge made for reproduction. Persons wishing to make some other use than those specified above, including commercial use, of information and text posted on these sites are asked to apply for prior written authorisation to the Council of Europe, Directorate of Communication.

* [EDQM Standard Terms](http://tx.fhir.org/r4/ValueSet/edqm): [Medication/med-1](Medication-med-1.md) and [MedicationStatement/Medication](MedicationStatement-Medication.md)




## Resource Content

```json
{
  "resourceType" : "ImplementationGuide",
  "id" : "hl7.fhir.cz.core",
  "url" : "https://hl7.cz/fhir/core/ImplementationGuide/hl7.fhir.cz.core",
  "version" : "0.3.0-ballot",
  "name" : "HL7CzCoreImplementationGuide",
  "title" : "HL7 Czech Base and Core Implementation Guide",
  "status" : "draft",
  "date" : "2025-12-19T09:24:48+00:00",
  "publisher" : "HL7 Czech Republic",
  "contact" : [
    {
      "name" : "HL7 Czech Republic",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.hl7.cz/"
        }
      ]
    }
  ],
  "description" : "HL7 Czech Base and Core Resources Implementation Guide",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "CZ",
          "display" : "Czechia"
        }
      ]
    }
  ],
  "packageId" : "hl7.fhir.cz.core",
  "license" : "CC0-1.0",
  "fhirVersion" : ["4.0.1"],
  "dependsOn" : [
    {
      "id" : "hl7tx",
      "extension" : [
        {
          "url" : "http://hl7.org/fhir/tools/StructureDefinition/implementationguide-dependency-comment",
          "valueMarkdown" : "Automatically added as a dependency - all IGs depend on HL7 Terminology"
        }
      ],
      "uri" : "http://terminology.hl7.org/ImplementationGuide/hl7.terminology",
      "packageId" : "hl7.terminology.r4",
      "version" : "7.0.1"
    },
    {
      "id" : "hl7ext",
      "extension" : [
        {
          "url" : "http://hl7.org/fhir/tools/StructureDefinition/implementationguide-dependency-comment",
          "valueMarkdown" : "Automatically added as a dependency - all IGs depend on the HL7 Extension Pack"
        }
      ],
      "uri" : "http://hl7.org/fhir/extensions/ImplementationGuide/hl7.fhir.uv.extensions",
      "packageId" : "hl7.fhir.uv.extensions.r4",
      "version" : "5.2.0"
    },
    {
      "id" : "hl7_fhir_uv_ips",
      "uri" : "http://hl7.org/fhir/uv/ips/ImplementationGuide/hl7.fhir.uv.ips",
      "packageId" : "hl7.fhir.uv.ips",
      "version" : "1.1.0"
    },
    {
      "id" : "hl7_fhir_eu_base",
      "uri" : "http://hl7.eu/fhir/base/ImplementationGuide/hl7.fhir.eu.base",
      "packageId" : "hl7.fhir.eu.base",
      "version" : "0.1.0-ballot"
    },
    {
      "id" : "hl7_fhir_cz_terminology",
      "uri" : "https://hl7.cz/terminology/ImplementationGuide/hl7.fhir.cz.terminology",
      "packageId" : "hl7.fhir.cz.terminology",
      "version" : "current"
    }
  ],
  "definition" : {
    "extension" : [
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "copyrightyear"
          },
          {
            "url" : "value",
            "valueString" : "2024+"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "releaselabel"
          },
          {
            "url" : "value",
            "valueString" : "ci-build"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "pin-canonicals"
          },
          {
            "url" : "value",
            "valueString" : "pin-multiples"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "path-expansion-params"
          },
          {
            "url" : "value",
            "valueString" : "../../expansion-params.json"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "apply-contact"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "apply-jurisdiction"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "apply-publisher"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "apply-version"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "show-inherited-invariants"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "usage-stats-opt-out"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "autoload-resources"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "path-liquid"
          },
          {
            "url" : "value",
            "valueString" : "template/liquid"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "path-liquid"
          },
          {
            "url" : "value",
            "valueString" : "input/liquid"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "path-qa"
          },
          {
            "url" : "value",
            "valueString" : "temp/qa"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "path-temp"
          },
          {
            "url" : "value",
            "valueString" : "temp/pages"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "path-output"
          },
          {
            "url" : "value",
            "valueString" : "output"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "path-suppressed-warnings"
          },
          {
            "url" : "value",
            "valueString" : "input/ignoreWarnings.txt"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "path-history"
          },
          {
            "url" : "value",
            "valueString" : "https://hl7.cz/fhir/core/history.html"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "template-html"
          },
          {
            "url" : "value",
            "valueString" : "template-page.html"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "template-md"
          },
          {
            "url" : "value",
            "valueString" : "template-page-md.html"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "apply-context"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "apply-copyright"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "apply-license"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "apply-wg"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "active-tables"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "fmm-definition"
          },
          {
            "url" : "value",
            "valueString" : "http://hl7.org/fhir/versions.html#maturity"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "propagate-status"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "excludelogbinaryformat"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "tabbed-snapshots"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/expansion-parameters",
        "valueReference" : {
          "reference" : "Parameters/expansion-parameters"
        }
      },
      {
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-internal-dependency",
        "valueCode" : "hl7.fhir.uv.tools.r4#0.9.0"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "copyrightyear"
          },
          {
            "url" : "value",
            "valueString" : "2024+"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "releaselabel"
          },
          {
            "url" : "value",
            "valueString" : "ci-build"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "pin-canonicals"
          },
          {
            "url" : "value",
            "valueString" : "pin-multiples"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "path-expansion-params"
          },
          {
            "url" : "value",
            "valueString" : "../../expansion-params.json"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "apply-contact"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "apply-jurisdiction"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "apply-publisher"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "apply-version"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "show-inherited-invariants"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "usage-stats-opt-out"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "autoload-resources"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "path-liquid"
          },
          {
            "url" : "value",
            "valueString" : "template/liquid"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "path-liquid"
          },
          {
            "url" : "value",
            "valueString" : "input/liquid"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "path-qa"
          },
          {
            "url" : "value",
            "valueString" : "temp/qa"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "path-temp"
          },
          {
            "url" : "value",
            "valueString" : "temp/pages"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "path-output"
          },
          {
            "url" : "value",
            "valueString" : "output"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "path-suppressed-warnings"
          },
          {
            "url" : "value",
            "valueString" : "input/ignoreWarnings.txt"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "path-history"
          },
          {
            "url" : "value",
            "valueString" : "https://hl7.cz/fhir/core/history.html"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "template-html"
          },
          {
            "url" : "value",
            "valueString" : "template-page.html"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "template-md"
          },
          {
            "url" : "value",
            "valueString" : "template-page-md.html"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "apply-context"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "apply-copyright"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "apply-license"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "apply-wg"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "active-tables"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "fmm-definition"
          },
          {
            "url" : "value",
            "valueString" : "http://hl7.org/fhir/versions.html#maturity"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "propagate-status"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "excludelogbinaryformat"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "tabbed-snapshots"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      }
    ],
    "grouping" : [
      {
        "id" : "actors",
        "name" : "Actors",
        "description" : "Actors used to describe the Document functional requirements for the specified data elements."
      }
    ],
    "resource" : [
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Device"
          }
        ],
        "reference" : {
          "reference" : "Device/AbsentDevice"
        },
        "name" : "AbsentDevice",
        "description" : "Patient without medical device",
        "exampleCanonical" : "https://hl7.cz/fhir/core/StructureDefinition/cz-medical-device"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:extension"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/accreditation-cz"
        },
        "name" : "Accreditation Requirement",
        "description" : "Indicates whether the examination must be performed only by a laboratory accredited for the specific test, or whether the result originates from such a laboratory.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ActorDefinition"
          }
        ],
        "reference" : {
          "reference" : "ActorDefinition/actor-consumer-L1"
        },
        "name" : "Actor Consumer L1",
        "description" : "A system receiving/querying and using a L1 document.",
        "exampleBoolean" : true,
        "groupingId" : "actors"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ActorDefinition"
          }
        ],
        "reference" : {
          "reference" : "ActorDefinition/actor-consumer-L2"
        },
        "name" : "Actor Consumer L2",
        "description" : "S system receiving/querying and using a L2 document.",
        "exampleBoolean" : true,
        "groupingId" : "actors"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ActorDefinition"
          }
        ],
        "reference" : {
          "reference" : "ActorDefinition/actor-consumer-L3"
        },
        "name" : "Actor Consumer L3",
        "description" : "A system receiving/querying and using a L3 document.",
        "exampleBoolean" : true,
        "groupingId" : "actors"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ActorDefinition"
          }
        ],
        "reference" : {
          "reference" : "ActorDefinition/actor-creator-L1"
        },
        "name" : "Actor Creator L1",
        "description" : "A system generating and sending/providing a L1 document to a Consumer for report storage and sharing.",
        "exampleBoolean" : true,
        "groupingId" : "actors"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ActorDefinition"
          }
        ],
        "reference" : {
          "reference" : "ActorDefinition/actor-creator-L2"
        },
        "name" : "Actor Creator L2",
        "description" : "A system generating and sending/providing a L2 document to a Consumer for report storage and sharing.",
        "exampleBoolean" : true,
        "groupingId" : "actors"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ActorDefinition"
          }
        ],
        "reference" : {
          "reference" : "ActorDefinition/actor-creator-L3"
        },
        "name" : "Actor Creator L3",
        "description" : "A system generating and sending/providing a L3 document to a Consumer for report storage and sharing.",
        "exampleBoolean" : true,
        "groupingId" : "actors"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:complex-type"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/cz-address"
        },
        "name" : "Address (CZ)",
        "description" : "Czech national profile on address, to provide the possibility in the 'line' element to provide a seperate streetname, housenumber and postal box.\nIt is always RECOMMENDED to give these elements separately. The national specification also includes the option of entering the address location according to the RUIAN register and marking the address as the permanent residence address.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:extension"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/address-point-cz"
        },
        "name" : "Address location code according to the system RÚIAN (ČÚZK)",
        "description" : "This extension allows the entry of an address point according to the RÚIAN registry.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:extension"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/permanent-residencer-address-cz"
        },
        "name" : "Address permanent residence",
        "description" : "This extension provides a link to the order [(Reference(ServiceRequest)] or requisition [ServiceRequest.requisition (i.e., 'Request.groupIdentifier')] that this report document is based on and fulfills.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/cz-allergyIntolerance"
        },
        "name" : "Allergy Intolerance (CZ)",
        "description" : "Czech national profile for an Allergy Intolerance",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "AllergyIntolerance"
          }
        ],
        "reference" : {
          "reference" : "AllergyIntolerance/AllergyToCatDander"
        },
        "name" : "Allergy to cat dander",
        "description" : "Example for AllergyIntolerance",
        "exampleCanonical" : "https://hl7.cz/fhir/core/StructureDefinition/cz-allergyIntolerance"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "AllergyIntolerance"
          }
        ],
        "reference" : {
          "reference" : "AllergyIntolerance/allergy-1"
        },
        "name" : "AllergyIntolerance - No Known Allergies",
        "description" : "AllergyIntolerance - No known allergies",
        "exampleCanonical" : "https://hl7.cz/fhir/core/StructureDefinition/cz-allergyIntolerance"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/cz-attachment"
        },
        "name" : "Attachment (CZ)",
        "description" : "Czech national profile for attachment.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/BodyStructure-cz"
        },
        "name" : "Body Structure (CZ)",
        "description" : "This profile represents the Body Structure resource by the Czech national interoperability project.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "BodyStructure"
          }
        ],
        "reference" : {
          "reference" : "BodyStructure/BodyStructure01"
        },
        "name" : "Body structure Example",
        "description" : "Specific and identified anatomical structure",
        "exampleCanonical" : "https://hl7.cz/fhir/core/StructureDefinition/BodyStructure-cz"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:extension"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/presentedForm"
        },
        "name" : "Composition: Presented Form",
        "description" : "Human readable representation of the entire document. Multiple formats are allowed but they SHALL be semantically equivalent.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/cz-coverage"
        },
        "name" : "Coverage (CZ)",
        "description" : "Czech national profile for a coverage.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Coverage"
          }
        ],
        "reference" : {
          "reference" : "Coverage/Coverage01"
        },
        "name" : "Coverage Example",
        "description" : "Insurance or medical plan or a payment agreement",
        "exampleCanonical" : "https://hl7.cz/fhir/core/StructureDefinition/cz-coverage"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "DocumentReference"
          }
        ],
        "reference" : {
          "reference" : "DocumentReference/cz-attachment-example"
        },
        "name" : "cz-attachment-example",
        "description" : "Example of attachment for DICOM file",
        "exampleCanonical" : "https://hl7.cz/fhir/core/StructureDefinition/cz-attachment"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Encounter"
          }
        ],
        "reference" : {
          "reference" : "Encounter/cz-encounter-example"
        },
        "name" : "cz-encounter-example",
        "description" : "Encounter",
        "exampleCanonical" : "https://hl7.cz/fhir/core/StructureDefinition/cz-encounter"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Patient"
          }
        ],
        "reference" : {
          "reference" : "Patient/cz-patient-addr-example-1"
        },
        "name" : "cz-patient-addr-example-1",
        "description" : "Address of both types (physical and delivery)",
        "exampleCanonical" : "https://hl7.cz/fhir/core/StructureDefinition/cz-patient-core"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Patient"
          }
        ],
        "reference" : {
          "reference" : "Patient/cz-patient-addr-example-2"
        },
        "name" : "cz-patient-addr-example-2",
        "description" : "Address with P.O.Box",
        "exampleCanonical" : "https://hl7.cz/fhir/core/StructureDefinition/cz-patient-core"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Patient"
          }
        ],
        "reference" : {
          "reference" : "Patient/cz-patient-addr-example-3"
        },
        "name" : "cz-patient-addr-example-3",
        "description" : "Permanent residence address",
        "exampleCanonical" : "https://hl7.cz/fhir/core/StructureDefinition/cz-patient-core"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Patient"
          }
        ],
        "reference" : {
          "reference" : "Patient/cz-patient-addr-example-4"
        },
        "name" : "cz-patient-addr-example-4",
        "description" : "Permanent residence address outside of the Czech Republic",
        "exampleCanonical" : "https://hl7.cz/fhir/core/StructureDefinition/cz-patient-core"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Patient"
          }
        ],
        "reference" : {
          "reference" : "Patient/cz-patient-addr-example-5"
        },
        "name" : "cz-patient-addr-example-5",
        "description" : "Address identified by RUIAN system",
        "exampleCanonical" : "https://hl7.cz/fhir/core/StructureDefinition/cz-patient-core"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "DocumentReference"
          }
        ],
        "reference" : {
          "reference" : "DocumentReference/cz-presentedform-example"
        },
        "name" : "cz-presentedform-example",
        "description" : "Presented form of Imaging order for Plain X-ray",
        "exampleCanonical" : "https://hl7.cz/fhir/core/StructureDefinition/cz-presented-form"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/cz-device-observer"
        },
        "name" : "Device: Performer/Observer (CZ)",
        "description" : "Czech profile represents the constraints applied to the Device resource by the Czech national interoperability project.This profile describes a device that plays the role of observer or performer.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/cz-logo"
        },
        "name" : "DocumentReference containing logo (CZ)",
        "description" : "Czech national profile for document reference containing logo.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/cz-encounter"
        },
        "name" : "Encounter (CZ)",
        "description" : "Czech profile for encounter.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Patient"
          }
        ],
        "reference" : {
          "reference" : "Patient/Kocka"
        },
        "name" : "Kocka",
        "description" : "Pacient animal - Domestic cat",
        "exampleCanonical" : "https://hl7.cz/fhir/core/StructureDefinition/cz-patient-animal"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Device"
          }
        ],
        "reference" : {
          "reference" : "Device/LabAnalyzer"
        },
        "name" : "LabAnalyzer",
        "description" : "Clinical analyzer Beckman",
        "exampleCanonical" : "https://hl7.cz/fhir/core/StructureDefinition/cz-device-observer"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/cz-location-base"
        },
        "name" : "Location (CZ base)",
        "description" : "Czech national base profile for location resource. This profile implies use of the Czech standard address in the location resource.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/cz-location-core"
        },
        "name" : "Location (CZ core)",
        "description" : "Czech national core profile for location resource.This profile implies use of the Czech standard organization in the managingOrganization element.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Location"
          }
        ],
        "reference" : {
          "reference" : "Location/location-laboratory"
        },
        "name" : "Location of laboratory",
        "description" : "Czech national core profile for location resource.This profile implies use of the Czech standard organization in the managingOrganization element.",
        "exampleCanonical" : "https://hl7.cz/fhir/core/StructureDefinition/cz-location-core"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Location"
          }
        ],
        "reference" : {
          "reference" : "Location/Location-Praha5"
        },
        "name" : "Location-Praha5",
        "description" : "Example of a location.",
        "exampleCanonical" : "https://hl7.cz/fhir/core/StructureDefinition/cz-location-core"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "DocumentReference"
          }
        ],
        "reference" : {
          "reference" : "DocumentReference/attachment-logo-FN-Motol"
        },
        "name" : "logoFNMotol",
        "description" : "Example of logo as document reference for Nemocnice Obláčkov.",
        "exampleCanonical" : "https://hl7.cz/fhir/core/StructureDefinition/cz-logo"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/cz-medical-device"
        },
        "name" : "Medical Device (CZ)",
        "description" : "Czech profile represents the constraints applied to the Device resource by the Czech national interoperability project.This profile constrains the representation of a medical device used by or implanted on the patient.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/cz-Medication"
        },
        "name" : "Medication (CZ)",
        "description" : "Czech national profile for a medication.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Medication"
          }
        ],
        "reference" : {
          "reference" : "Medication/med-1"
        },
        "name" : "Medication - Simvastatin 40 MG Disintegrating Oral Tablet",
        "description" : "Medication - Simvastatin 40 MG Disintegrating Oral Tablet",
        "exampleCanonical" : "https://hl7.cz/fhir/core/StructureDefinition/cz-Medication"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/cz-MedicationStatement"
        },
        "name" : "Medication Statement (CZ)",
        "description" : "Czech national profile for a medication statement.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "MedicationStatement"
          }
        ],
        "reference" : {
          "reference" : "MedicationStatement/Medication"
        },
        "name" : "MedicationStatement - Ongoing Simvastatin Treatment",
        "description" : "Czech national profile for a medication statement.",
        "exampleCanonical" : "https://hl7.cz/fhir/core/StructureDefinition/cz-MedicationStatement"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Patient"
          }
        ],
        "reference" : {
          "reference" : "Patient/Mracena"
        },
        "name" : "Mracena",
        "description" : "Patient, contact information and practitioner",
        "exampleCanonical" : "https://hl7.cz/fhir/core/StructureDefinition/cz-patient-core"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:complex-type"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/cz-rodcis-identifier"
        },
        "name" : "National birth number (CZ)",
        "description" : "This structure contains the Czech identifier of a person (personal identification number)",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:complex-type"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/cz-rid-identifier"
        },
        "name" : "National health sector identifier (CZ)",
        "description" : "This structure contains the Czech identifier of a person (personal identification number) in healthcare sector",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:complex-type"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/id-card-identifier"
        },
        "name" : "National ID card identifier",
        "description" : "This structure specifies the national personal ID card identifier.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Device"
          }
        ],
        "reference" : {
          "reference" : "Device/NoInformationAboutDevice"
        },
        "name" : "NoInformationAboutDevice",
        "description" : "Patient with unknown presence or use of medical device",
        "exampleCanonical" : "https://hl7.cz/fhir/core/StructureDefinition/cz-medical-device"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:complex-type"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/OidIdentifier"
        },
        "name" : "Oid Identifier",
        "description" : "Identifier with an oid",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/cz-organization-base"
        },
        "name" : "Organization (CZ base)",
        "description" : "Czech national profile defines the way the organization is represented in the context of the Czech national interoperability project.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/cz-organization-core"
        },
        "name" : "Organization (CZ core)",
        "description" : "Czech national profile sets minimum expectations for the Organization resource common to most of the use cases.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:extension"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/cz-organization-logo"
        },
        "name" : "Organization Logo",
        "description" : "An extension to associate a logo (e.g., image or icon) with an Organization, using a reference to a profile Attachment resource.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Organization"
          }
        ],
        "reference" : {
          "reference" : "Organization/Synlab"
        },
        "name" : "Organization of laboratory",
        "description" : "Czech national core profile for organization resource. This example represents separate professional laboratory",
        "exampleCanonical" : "https://hl7.cz/fhir/core/StructureDefinition/cz-organization-core"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Organization"
          }
        ],
        "reference" : {
          "reference" : "Organization/Organization-1"
        },
        "name" : "Organization-1",
        "description" : "An example of the organization of a provider",
        "exampleCanonical" : "https://hl7.cz/fhir/core/StructureDefinition/cz-organization-core"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Organization"
          }
        ],
        "reference" : {
          "reference" : "Organization/Organization-2"
        },
        "name" : "Organization-2",
        "description" : "An example of the organization with logo extension",
        "exampleCanonical" : "https://hl7.cz/fhir/core/StructureDefinition/cz-organization-core"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Organization"
          }
        ],
        "reference" : {
          "reference" : "Organization/Organization-3"
        },
        "name" : "Organization-3",
        "description" : "An example of the organization of a health insurance",
        "exampleCanonical" : "https://hl7.cz/fhir/core/StructureDefinition/cz-organization-core"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Organization"
          }
        ],
        "reference" : {
          "reference" : "Organization/RegisteringProviderExample"
        },
        "name" : "Organization: Registering healthcare provider example",
        "description" : "Example of registering healthcare provider",
        "exampleCanonical" : "https://hl7.cz/fhir/core/StructureDefinition/cz-organization-core"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Device"
          }
        ],
        "reference" : {
          "reference" : "Device/Pacemaker"
        },
        "name" : "Pacemaker",
        "description" : "Heart pacemaker Medtronic W1DR01",
        "exampleCanonical" : "https://hl7.cz/fhir/core/StructureDefinition/cz-medical-device"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:complex-type"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/cz-passport-identifier"
        },
        "name" : "Passport identifier",
        "description" : "This structure specifies the passport identifier.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/cz-patient-base"
        },
        "name" : "Patient (CZ base)",
        "description" : "This profile defines how to represent Patient in FHIR for the purpose of the Czech national interoperability standards.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/cz-patient-core"
        },
        "name" : "Patient (CZ core)",
        "description" : "This profile sets minimum expectations for the Patient resource common to most of the use cases. It is based on EU Patient Core.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/cz-patient-animal"
        },
        "name" : "Patient: Animal (CZ)",
        "description" : "This profile defines how to represent an Animal as subject of care in FHIR for the purpose of this guide.\nThis is used to identify the species when a specimen is collected from an animal",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/cz-practitioner-base"
        },
        "name" : "Practitioner (CZ base)",
        "description" : "Czech national profile for practitioner.Contains information about a person who provides healthcare or is a participant in the creation of a medical document.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/cz-practitioner-core"
        },
        "name" : "Practitioner (CZ core)",
        "description" : "Czech national profile for practitioner. Contains information about a person who provides healthcare or is a participant in the creation of a medical document.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/cz-practitionerrole-base"
        },
        "name" : "Practitioner Role (CZ base)",
        "description" : "Czech national profile for an practitioner role.It enables the identification of healthcare and non-healthcare workers, their expertise, workplaces and contact details.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/cz-practitionerrole-core"
        },
        "name" : "Practitioner Role (CZ core)",
        "description" : "Czech national profile for an practitioner role.It enables the identification of healthcare and non-healthcare workers, their expertise, workplaces and contact details.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Practitioner"
          }
        ],
        "reference" : {
          "reference" : "Practitioner/Practitioner-123456789"
        },
        "name" : "Practitioner-123456789",
        "description" : "Practitioner id(KRZP)=123456789",
        "exampleCanonical" : "https://hl7.cz/fhir/core/StructureDefinition/cz-practitioner-core"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Practitioner"
          }
        ],
        "reference" : {
          "reference" : "Practitioner/Practitioner-2"
        },
        "name" : "Practitioner-2",
        "description" : "Practitioner id(KRZP)=987654321",
        "exampleCanonical" : "https://hl7.cz/fhir/core/StructureDefinition/cz-practitioner-core"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "PractitionerRole"
          }
        ],
        "reference" : {
          "reference" : "PractitionerRole/practitionerrole1"
        },
        "name" : "practitionerrole1",
        "description" : "General practitioner's office",
        "exampleCanonical" : "https://hl7.cz/fhir/core/StructureDefinition/cz-practitionerrole-core"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/cz-presented-form"
        },
        "name" : "Presented Form (CZ)",
        "description" : "Czech national profile for presented form.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/cz-provenance"
        },
        "name" : "Provenance (CZ)",
        "description" : "Czech national profile on Provenance tracks information about the activity that created, revised, deleted, or signed a version of a resource, describing the entities and agents involved.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:extension"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/cz-refund-indicator-code"
        },
        "name" : "Refund indicator code (VZP)",
        "description" : "Refund indicator according to the VZP catalogue 'Náhrady za zdravotní péči'.\nUsed to indicate that the injury/health damage may have been caused by a third party.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:extension"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/registering-provider-cz"
        },
        "name" : "Registering provider",
        "description" : "This extension allows the registration of the registering healthcare provider and its category/specialty (general practitioner for children and youth, general practitioner for adults, dentist, gynecologist).",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/cz-relatedPerson-base"
        },
        "name" : "Related Person (CZ base)",
        "description" : "Czech national profile for a related person. Contains an information about a person that is involved in the care for a patient,\r\nbut who is not the target of healthcare, nor has a formal responsibility in the care process.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/cz-relatedPerson-core"
        },
        "name" : "Related Person (CZ core)",
        "description" : "Czech national profile for a related person.This profile sets minimum expectations for the Related Person resource common to most of the use cases.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "RelatedPerson"
          }
        ],
        "reference" : {
          "reference" : "RelatedPerson/RelatedPerson01"
        },
        "name" : "Related person Example",
        "description" : "A person that is related to a patient, but who is not a direct target of care",
        "exampleCanonical" : "https://hl7.cz/fhir/core/StructureDefinition/cz-relatedPerson-core"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:complex-type"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/cz-signature"
        },
        "name" : "Signature (CZ)",
        "description" : "Czech national profile on Signature holds an electronic representation of a signature or timestamp and its supporting context in a FHIR accessible form.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Provenance"
          }
        ],
        "reference" : {
          "reference" : "Provenance/signature-rentgen"
        },
        "name" : "Signature of image order",
        "description" : "Czech national profile on Signature holds an electronic representation of a signature or timestamp and its supporting context in a FHIR accessible form.",
        "exampleCanonical" : "https://hl7.cz/fhir/core/StructureDefinition/cz-provenance"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/cz-specimen"
        },
        "name" : "Specimen (CZ)",
        "description" : "Czech national profile defines how to represent Specimens in HL7 FHIR for the purpose of this guide.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Specimen"
          }
        ],
        "reference" : {
          "reference" : "Specimen/Specimen-example-animal"
        },
        "name" : "Specimen-example-animal",
        "description" : "Example of a specimen taken from animal.",
        "exampleCanonical" : "https://hl7.cz/fhir/core/StructureDefinition/cz-specimen"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Specimen"
          }
        ],
        "reference" : {
          "reference" : "Specimen/Specimen-example-environment"
        },
        "name" : "Specimen-example-environment",
        "description" : "Example of a specimen taken from environment.",
        "exampleCanonical" : "https://hl7.cz/fhir/core/StructureDefinition/cz-specimen"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/Substance-additive-cz"
        },
        "name" : "Substance: Specimen Additive Substance (CZ)",
        "description" : "This profile defines how to represent Specimen Additive Substances in HL7 FHIR for the purpose of this guide.",
        "exampleBoolean" : false
      }
    ],
    "page" : {
      "extension" : [
        {
          "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-page-name",
          "valueUrl" : "toc.html"
        }
      ],
      "nameUrl" : "toc.html",
      "title" : "Table of Contents",
      "generation" : "html",
      "page" : [
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-page-name",
              "valueUrl" : "index.html"
            }
          ],
          "nameUrl" : "index.html",
          "title" : "Home",
          "generation" : "markdown"
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-page-name",
              "valueUrl" : "index-cs.html"
            }
          ],
          "nameUrl" : "index-cs.html",
          "title" : "Domovská stránka",
          "generation" : "markdown"
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-page-name",
              "valueUrl" : "elements-FHIR-en.html"
            }
          ],
          "nameUrl" : "elements-FHIR-en.html",
          "title" : "Basic FHIR elements in English",
          "generation" : "markdown"
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-page-name",
              "valueUrl" : "elements-FHIR-cs.html"
            }
          ],
          "nameUrl" : "elements-FHIR-cs.html",
          "title" : "Basic FHIR elements in Czech",
          "generation" : "markdown"
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-page-name",
              "valueUrl" : "subjects-en.html"
            }
          ],
          "nameUrl" : "subjects-en.html",
          "title" : "Subjects in English",
          "generation" : "markdown"
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-page-name",
              "valueUrl" : "subjects-cs.html"
            }
          ],
          "nameUrl" : "subjects-cs.html",
          "title" : "Subjects in Czech",
          "generation" : "markdown"
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-page-name",
              "valueUrl" : "objects-en.html"
            }
          ],
          "nameUrl" : "objects-en.html",
          "title" : "Objects in English",
          "generation" : "markdown"
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-page-name",
              "valueUrl" : "objects-cs.html"
            }
          ],
          "nameUrl" : "objects-cs.html",
          "title" : "Objects in Czech",
          "generation" : "markdown"
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-page-name",
              "valueUrl" : "identifiers-en.html"
            }
          ],
          "nameUrl" : "identifiers-en.html",
          "title" : "Identifiers in English",
          "generation" : "markdown"
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-page-name",
              "valueUrl" : "identifiers-cs.html"
            }
          ],
          "nameUrl" : "identifiers-cs.html",
          "title" : "Identifiers in Czech",
          "generation" : "markdown"
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-page-name",
              "valueUrl" : "artifacts.html"
            }
          ],
          "nameUrl" : "artifacts.html",
          "title" : "Summary artifacts",
          "generation" : "html"
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-page-name",
              "valueUrl" : "downloads.html"
            }
          ],
          "nameUrl" : "downloads.html",
          "title" : "Download",
          "generation" : "markdown"
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-page-name",
              "valueUrl" : "downloads-cs.html"
            }
          ],
          "nameUrl" : "downloads-cs.html",
          "title" : "Download",
          "generation" : "markdown"
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-page-name",
              "valueUrl" : "authors.html"
            }
          ],
          "nameUrl" : "authors.html",
          "title" : "Authors",
          "generation" : "markdown"
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-page-name",
              "valueUrl" : "authors-cs.html"
            }
          ],
          "nameUrl" : "authors-cs.html",
          "title" : "Autoři",
          "generation" : "markdown"
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-page-name",
              "valueUrl" : "copyright.html"
            }
          ],
          "nameUrl" : "copyright.html",
          "title" : "Copyright",
          "generation" : "markdown"
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-page-name",
              "valueUrl" : "copyright-cs.html"
            }
          ],
          "nameUrl" : "copyright-cs.html",
          "title" : "Autorská práva",
          "generation" : "markdown"
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-page-name",
              "valueUrl" : "dependencies.html"
            }
          ],
          "nameUrl" : "dependencies.html",
          "title" : "Dependencies",
          "generation" : "markdown"
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-page-name",
              "valueUrl" : "dependencies-cs.html"
            }
          ],
          "nameUrl" : "dependencies-cs.html",
          "title" : "Závislosti",
          "generation" : "markdown"
        }
      ]
    },
    "parameter" : [
      {
        "code" : "path-resource",
        "value" : "input/capabilities"
      },
      {
        "code" : "path-resource",
        "value" : "input/examples"
      },
      {
        "code" : "path-resource",
        "value" : "input/extensions"
      },
      {
        "code" : "path-resource",
        "value" : "input/models"
      },
      {
        "code" : "path-resource",
        "value" : "input/operations"
      },
      {
        "code" : "path-resource",
        "value" : "input/profiles"
      },
      {
        "code" : "path-resource",
        "value" : "input/resources"
      },
      {
        "code" : "path-resource",
        "value" : "input/vocabulary"
      },
      {
        "code" : "path-resource",
        "value" : "input/maps"
      },
      {
        "code" : "path-resource",
        "value" : "input/testing"
      },
      {
        "code" : "path-resource",
        "value" : "input/history"
      },
      {
        "code" : "path-resource",
        "value" : "fsh-generated/resources"
      },
      {
        "code" : "path-pages",
        "value" : "template/config"
      },
      {
        "code" : "path-pages",
        "value" : "input/images"
      },
      {
        "code" : "path-tx-cache",
        "value" : "input-cache/txcache"
      }
    ]
  }
}

```
