# Composition: Presented Form - HL7 Czech Base and Core Implementation Guide v0.3.0-ballot

* [**Table of Contents**](toc.md)
* [**Summary artifacts**](artifacts.md)
* **Composition: Presented Form**

## Extension: Composition: Presented Form 

| | | |
| :--- | :--- | :--- |
| *Official URL*:https://hl7.cz/fhir/core/StructureDefinition/presentedForm | *Version*:0.3.0-ballot | |
| *Standards status:*[Trial-use](http://hl7.org/fhir/R4/versions.html#std-process) | [Maturity Level](http://hl7.org/fhir/versions.html#maturity): 2 | *Computable Name*:DocumentPresentedForm |

Human readable representation of the entire document. Multiple formats are allowed but they SHALL be semantically equivalent.

**Context of Use**

**Usage info**

**Usages:**

* This Extension is not used by any profiles in this Implementation Guide

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.fhir.cz.core|current/StructureDefinition/presentedForm)

### Formal Views of Extension Content

 [Description of Profiles, Differentials, Snapshots, and how the XML and JSON presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-presentedForm.csv), [Excel](StructureDefinition-presentedForm.xlsx), [Schematron](StructureDefinition-presentedForm.sch) 

#### Constraints



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "presentedForm",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-fmm",
      "valueInteger" : 2
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
      "valueCode" : "trial-use"
    }
  ],
  "url" : "https://hl7.cz/fhir/core/StructureDefinition/presentedForm",
  "version" : "0.3.0-ballot",
  "name" : "DocumentPresentedForm",
  "title" : "Composition: Presented Form",
  "status" : "draft",
  "date" : "2025-12-19T09:24:48+00:00",
  "publisher" : "HL7 Czech Republic",
  "contact" : [
    {
      "name" : "HL7 Czech Republic",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.hl7.cz/"
        }
      ]
    }
  ],
  "description" : "Human readable representation of the entire document. Multiple formats are allowed but they SHALL be semantically equivalent.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "CZ",
          "display" : "Czechia"
        }
      ]
    }
  ],
  "fhirVersion" : "4.0.1",
  "mapping" : [
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    }
  ],
  "kind" : "complex-type",
  "abstract" : false,
  "context" : [
    {
      "type" : "element",
      "expression" : "Composition"
    }
  ],
  "type" : "Extension",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/Extension",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "Extension",
        "path" : "Extension",
        "short" : "Composition: Presented Form",
        "definition" : "Human readable representation of the entire document. Multiple formats are allowed but they SHALL be semantically equivalent."
      },
      {
        "id" : "Extension.extension",
        "path" : "Extension.extension",
        "max" : "0"
      },
      {
        "id" : "Extension.url",
        "path" : "Extension.url",
        "fixedUri" : "https://hl7.cz/fhir/core/StructureDefinition/presentedForm"
      },
      {
        "id" : "Extension.value[x]",
        "path" : "Extension.value[x]",
        "type" : [
          {
            "code" : "Attachment"
          }
        ]
      }
    ]
  }
}

```
