# Signature (CZ) - HL7 Czech Base and Core Implementation Guide v0.3.0-ballot

* [**Table of Contents**](toc.md)
* [**Summary artifacts**](artifacts.md)
* **Signature (CZ)**

## Data Type Profile: Signature (CZ) 

| | | |
| :--- | :--- | :--- |
| *Official URL*:https://hl7.cz/fhir/core/StructureDefinition/cz-signature | *Version*:0.3.0-ballot | |
| *Standards status:*[Draft](http://hl7.org/fhir/R4/versions.html#std-process) | [Maturity Level](http://hl7.org/fhir/versions.html#maturity): 1 | *Computable Name*:CZ_Signature |

 
Czech national profile on Signature holds an electronic representation of a signature or timestamp and its supporting context in a FHIR accessible form. 

**Usages:**

* Use this DataType Profile: [Provenance (CZ)](StructureDefinition-cz-provenance.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.fhir.cz.core|current/StructureDefinition/cz-signature)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-cz-signature.csv), [Excel](StructureDefinition-cz-signature.xlsx), [Schematron](StructureDefinition-cz-signature.sch) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "cz-signature",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-fmm",
      "valueInteger" : 1
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
      "valueCode" : "draft"
    }
  ],
  "url" : "https://hl7.cz/fhir/core/StructureDefinition/cz-signature",
  "version" : "0.3.0-ballot",
  "name" : "CZ_Signature",
  "title" : "Signature (CZ)",
  "status" : "draft",
  "experimental" : false,
  "date" : "2025-12-19T09:24:48+00:00",
  "publisher" : "HL7 Czech Republic",
  "contact" : [
    {
      "name" : "HL7 Czech Republic",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.hl7.cz/"
        }
      ]
    }
  ],
  "description" : "Czech national profile on Signature holds an electronic representation of a signature or timestamp and its supporting context in a FHIR accessible form.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "CZ",
          "display" : "Czechia"
        }
      ]
    }
  ],
  "fhirVersion" : "4.0.1",
  "mapping" : [
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    }
  ],
  "kind" : "complex-type",
  "abstract" : false,
  "type" : "Signature",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/Signature",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "Signature",
        "path" : "Signature",
        "short" : "Signature according to Czech conventions",
        "definition" : "Signature according to Czech conventions. The type determines whether it is a signature or a timestamp.",
        "constraint" : [
          {
            "key" : "data-must-be",
            "severity" : "error",
            "human" : "Signature must contain data, author and date",
            "expression" : "data.exists() and who.exists() and when.exists()",
            "source" : "https://hl7.cz/fhir/core/StructureDefinition/cz-signature"
          }
        ]
      },
      {
        "id" : "Signature.type",
        "path" : "Signature.type",
        "definition" : "The kind of signature that determines whether it is a signature or a timestamp. RECOMMENDED to include.",
        "mustSupport" : true
      },
      {
        "id" : "Signature.when",
        "path" : "Signature.when",
        "mustSupport" : true
      },
      {
        "id" : "Signature.who",
        "path" : "Signature.who",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "https://hl7.cz/fhir/core/StructureDefinition/cz-practitioner-core",
              "https://hl7.cz/fhir/core/StructureDefinition/cz-practitionerrole-core",
              "https://hl7.cz/fhir/core/StructureDefinition/cz-relatedPerson-core",
              "https://hl7.cz/fhir/core/StructureDefinition/cz-device-observer",
              "https://hl7.cz/fhir/core/StructureDefinition/cz-medical-device",
              "https://hl7.cz/fhir/core/StructureDefinition/cz-organization-core",
              "https://hl7.cz/fhir/core/StructureDefinition/cz-patient-core"
            ]
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "Signature.onBehalfOf",
        "path" : "Signature.onBehalfOf",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "https://hl7.cz/fhir/core/StructureDefinition/cz-practitioner-core",
              "https://hl7.cz/fhir/core/StructureDefinition/cz-practitionerrole-core",
              "https://hl7.cz/fhir/core/StructureDefinition/cz-relatedPerson-core",
              "https://hl7.cz/fhir/core/StructureDefinition/cz-device-observer",
              "https://hl7.cz/fhir/core/StructureDefinition/cz-medical-device",
              "https://hl7.cz/fhir/core/StructureDefinition/cz-organization-core"
            ]
          }
        ]
      },
      {
        "id" : "Signature.data",
        "path" : "Signature.data",
        "mustSupport" : true
      }
    ]
  }
}

```
