# National health sector identifier (CZ) - HL7 Czech Base and Core Implementation Guide v0.3.0-ballot

* [**Table of Contents**](toc.md)
* [**Summary artifacts**](artifacts.md)
* **National health sector identifier (CZ)**

## Data Type Profile: National health sector identifier (CZ) 

| | | |
| :--- | :--- | :--- |
| *Official URL*:https://hl7.cz/fhir/core/StructureDefinition/cz-rid-identifier | *Version*:0.3.0-ballot | |
| *Standards status:*[Draft](http://hl7.org/fhir/R4/versions.html#std-process) | [Maturity Level](http://hl7.org/fhir/versions.html#maturity): 1 | *Computable Name*:CZ_RID_Identifier |

 
This structure contains the Czech identifier of a person (personal identification number) in healthcare sector 

 
This unique identifier is assigned by the Patient Master Register (KRP) to a given patient. The number is randomly assigned and may not be reused. 

**Usages:**

* Use this DataType Profile: [Patient (CZ base)](StructureDefinition-cz-patient-base.md) and [Related Person (CZ base)](StructureDefinition-cz-relatedPerson-base.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.fhir.cz.core|current/StructureDefinition/cz-rid-identifier)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-cz-rid-identifier.csv), [Excel](StructureDefinition-cz-rid-identifier.xlsx), [Schematron](StructureDefinition-cz-rid-identifier.sch) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "cz-rid-identifier",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-fmm",
      "valueInteger" : 1
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
      "valueCode" : "draft"
    }
  ],
  "url" : "https://hl7.cz/fhir/core/StructureDefinition/cz-rid-identifier",
  "version" : "0.3.0-ballot",
  "name" : "CZ_RID_Identifier",
  "title" : "National health sector identifier (CZ)",
  "status" : "draft",
  "experimental" : false,
  "date" : "2025-12-19T09:24:48+00:00",
  "publisher" : "HL7 Czech Republic",
  "contact" : [
    {
      "name" : "HL7 Czech Republic",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.hl7.cz/"
        }
      ]
    }
  ],
  "description" : "This structure contains the Czech identifier of a person (personal identification number) in healthcare sector",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "CZ",
          "display" : "Czechia"
        }
      ]
    }
  ],
  "purpose" : "This unique identifier is assigned by the Patient Master Register (KRP) to a given patient. The number is randomly assigned and may not be reused.",
  "fhirVersion" : "4.0.1",
  "mapping" : [
    {
      "identity" : "v2",
      "uri" : "http://hl7.org/v2",
      "name" : "HL7 v2 Mapping"
    },
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    },
    {
      "identity" : "servd",
      "uri" : "http://www.omg.org/spec/ServD/1.0/",
      "name" : "ServD"
    }
  ],
  "kind" : "complex-type",
  "abstract" : false,
  "type" : "Identifier",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/Identifier",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "Identifier",
        "path" : "Identifier",
        "short" : "Czech national health sector identifier",
        "definition" : "Czech national health sector identifier is a unique identifier that assigns the Patient Master Register (KRP) to a given patient.",
        "comment" : "Its format is a meaningless ten-digit number that cannot start with a zero. It is divisible by thirteen and not divisible by eleven."
      },
      {
        "id" : "Identifier.use",
        "path" : "Identifier.use",
        "fixedCode" : "official"
      },
      {
        "id" : "Identifier.system",
        "path" : "Identifier.system",
        "min" : 1,
        "fixedUri" : "https://ncez.mzcr.cz/fhir/sid/rid"
      },
      {
        "id" : "Identifier.value",
        "path" : "Identifier.value",
        "min" : 1,
        "maxLength" : 10,
        "constraint" : [
          {
            "key" : "rid-rule",
            "requirements" : "Czech national personal ID rules.",
            "severity" : "error",
            "human" : "Czech national personal ID rule",
            "expression" : "$this.toString().matches('(D\\\\d{9}|[1-9]\\\\d{9})')",
            "source" : "https://hl7.cz/fhir/core/StructureDefinition/cz-rid-identifier"
          }
        ]
      },
      {
        "id" : "Identifier.assigner",
        "path" : "Identifier.assigner",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "https://hl7.cz/fhir/core/StructureDefinition/cz-organization-core"
            ]
          }
        ]
      }
    ]
  }
}

```
