# Provenance (CZ) - HL7 Czech Base and Core Implementation Guide v0.3.0-ballot

* [**Table of Contents**](toc.md)
* [**Summary artifacts**](artifacts.md)
* **Provenance (CZ)**

## Resource Profile: Provenance (CZ) 

| | |
| :--- | :--- |
| *Official URL*:https://hl7.cz/fhir/core/StructureDefinition/cz-provenance | *Version*:0.3.0-ballot |
| Draft as of 2025-12-19 | *Computable Name*:CZ_Provenance |

 
Czech national profile on Provenance tracks information about the activity that created, revised, deleted, or signed a version of a resource, describing the entities and agents involved. 

**Usages:**

* Examples for this Profile: [Provenance/signature-rentgen](Provenance-signature-rentgen.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.fhir.cz.core|current/StructureDefinition/cz-provenance)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-cz-provenance.csv), [Excel](StructureDefinition-cz-provenance.xlsx), [Schematron](StructureDefinition-cz-provenance.sch) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "cz-provenance",
  "url" : "https://hl7.cz/fhir/core/StructureDefinition/cz-provenance",
  "version" : "0.3.0-ballot",
  "name" : "CZ_Provenance",
  "title" : "Provenance (CZ)",
  "status" : "draft",
  "date" : "2025-12-19T09:24:48+00:00",
  "publisher" : "HL7 Czech Republic",
  "contact" : [
    {
      "name" : "HL7 Czech Republic",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.hl7.cz/"
        }
      ]
    }
  ],
  "description" : "Czech national profile on Provenance tracks information about the activity that created, revised, deleted, or signed a version of a resource, describing the entities and agents involved.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "CZ",
          "display" : "Czechia"
        }
      ]
    }
  ],
  "fhirVersion" : "4.0.1",
  "mapping" : [
    {
      "identity" : "workflow",
      "uri" : "http://hl7.org/fhir/workflow",
      "name" : "Workflow Pattern"
    },
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    },
    {
      "identity" : "w3c.prov",
      "uri" : "http://www.w3.org/ns/prov",
      "name" : "W3C PROV"
    },
    {
      "identity" : "w5",
      "uri" : "http://hl7.org/fhir/fivews",
      "name" : "FiveWs Pattern Mapping"
    },
    {
      "identity" : "fhirauditevent",
      "uri" : "http://hl7.org/fhir/auditevent",
      "name" : "FHIR AuditEvent Mapping"
    }
  ],
  "kind" : "resource",
  "abstract" : false,
  "type" : "Provenance",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/Provenance",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "Provenance",
        "path" : "Provenance"
      },
      {
        "id" : "Provenance.target",
        "path" : "Provenance.target",
        "mustSupport" : true
      },
      {
        "id" : "Provenance.location",
        "path" : "Provenance.location",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "https://hl7.cz/fhir/core/StructureDefinition/cz-location-core"
            ]
          }
        ]
      },
      {
        "id" : "Provenance.agent",
        "path" : "Provenance.agent",
        "mustSupport" : true
      },
      {
        "id" : "Provenance.agent.who",
        "path" : "Provenance.agent.who",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "https://hl7.cz/fhir/core/StructureDefinition/cz-practitioner-core",
              "https://hl7.cz/fhir/core/StructureDefinition/cz-practitionerrole-core",
              "https://hl7.cz/fhir/core/StructureDefinition/cz-relatedPerson-core",
              "https://hl7.cz/fhir/core/StructureDefinition/cz-patient-core",
              "https://hl7.cz/fhir/core/StructureDefinition/cz-device-observer",
              "https://hl7.cz/fhir/core/StructureDefinition/cz-medical-device",
              "https://hl7.cz/fhir/core/StructureDefinition/cz-organization-core"
            ]
          }
        ]
      },
      {
        "id" : "Provenance.agent.onBehalfOf",
        "path" : "Provenance.agent.onBehalfOf",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "https://hl7.cz/fhir/core/StructureDefinition/cz-practitioner-core",
              "https://hl7.cz/fhir/core/StructureDefinition/cz-practitionerrole-core",
              "https://hl7.cz/fhir/core/StructureDefinition/cz-relatedPerson-core",
              "https://hl7.cz/fhir/core/StructureDefinition/cz-patient-core",
              "https://hl7.cz/fhir/core/StructureDefinition/cz-device-observer",
              "https://hl7.cz/fhir/core/StructureDefinition/cz-medical-device",
              "https://hl7.cz/fhir/core/StructureDefinition/cz-organization-core"
            ]
          }
        ]
      },
      {
        "id" : "Provenance.signature",
        "path" : "Provenance.signature",
        "max" : "1",
        "type" : [
          {
            "code" : "Signature",
            "profile" : ["https://hl7.cz/fhir/core/StructureDefinition/cz-signature"]
          }
        ],
        "mustSupport" : true
      }
    ]
  }
}

```
