# Practitioner Role (CZ base) - HL7 Czech Base and Core Implementation Guide v0.3.0-ballot

* [**Table of Contents**](toc.md)
* [**Summary artifacts**](artifacts.md)
* **Practitioner Role (CZ base)**

## Resource Profile: Practitioner Role (CZ base) 

| | | |
| :--- | :--- | :--- |
| *Official URL*:https://hl7.cz/fhir/core/StructureDefinition/cz-practitionerrole-base | *Version*:0.3.0-ballot | |
| *Standards status:*[Draft](http://hl7.org/fhir/R4/versions.html#std-process) | [Maturity Level](http://hl7.org/fhir/versions.html#maturity): 1 | *Computable Name*:CZ_PractitionerRoleBase |

 
Czech national profile for an practitioner role.It enables the identification of healthcare and non-healthcare workers, their expertise, workplaces and contact details. 

**Usages:**

* Derived from this Profile: [Practitioner Role (CZ core)](StructureDefinition-cz-practitionerrole-core.md)
* Refer to this Profile: [Patient (CZ base)](StructureDefinition-cz-patient-base.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.fhir.cz.core|current/StructureDefinition/cz-practitionerrole-base)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-cz-practitionerrole-base.csv), [Excel](StructureDefinition-cz-practitionerrole-base.xlsx), [Schematron](StructureDefinition-cz-practitionerrole-base.sch) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "cz-practitionerrole-base",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-fmm",
      "valueInteger" : 1
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
      "valueCode" : "draft"
    }
  ],
  "url" : "https://hl7.cz/fhir/core/StructureDefinition/cz-practitionerrole-base",
  "version" : "0.3.0-ballot",
  "name" : "CZ_PractitionerRoleBase",
  "title" : "Practitioner Role (CZ base)",
  "status" : "draft",
  "experimental" : false,
  "date" : "2025-12-19T09:24:48+00:00",
  "publisher" : "HL7 Czech Republic",
  "contact" : [
    {
      "name" : "HL7 Czech Republic",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.hl7.cz/"
        }
      ]
    }
  ],
  "description" : "Czech national profile for an practitioner role.It enables the identification of healthcare and non-healthcare workers, their expertise, workplaces and contact details.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "CZ",
          "display" : "Czechia"
        }
      ]
    }
  ],
  "fhirVersion" : "4.0.1",
  "mapping" : [
    {
      "identity" : "v2",
      "uri" : "http://hl7.org/v2",
      "name" : "HL7 v2 Mapping"
    },
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    },
    {
      "identity" : "servd",
      "uri" : "http://www.omg.org/spec/ServD/1.0/",
      "name" : "ServD"
    },
    {
      "identity" : "w5",
      "uri" : "http://hl7.org/fhir/fivews",
      "name" : "FiveWs Pattern Mapping"
    }
  ],
  "kind" : "resource",
  "abstract" : false,
  "type" : "PractitionerRole",
  "baseDefinition" : "http://hl7.eu/fhir/base/StructureDefinition/practitionerRole-eu",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "PractitionerRole",
        "path" : "PractitionerRole",
        "short" : "Czech Practitioner Role (base)",
        "definition" : "The profile defines the representation of a healthcare role in the Czech healthcare system based on the FHIR PractitionerRole.",
        "comment" : "Key elements include a reference to the healthcare worker (practitioner), institution (organization), role code according to the National Code of Healthcare Professions (NCZP), specialization according to the KRPZS, place of performance (location), contact details (telecom), role status (active) and validity period (period). A specific extension for the Czech Republic is the connection with the Master Register of Healthcare Workers (KRZP) and the KRPZS, which enables verification of expertise and valid registration."
      },
      {
        "id" : "PractitionerRole.practitioner",
        "path" : "PractitionerRole.practitioner",
        "min" : 1,
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "https://hl7.cz/fhir/core/StructureDefinition/cz-practitioner-base"
            ]
          }
        ]
      },
      {
        "id" : "PractitionerRole.organization",
        "path" : "PractitionerRole.organization",
        "min" : 1,
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "https://hl7.cz/fhir/core/StructureDefinition/cz-organization-base"
            ]
          }
        ]
      },
      {
        "id" : "PractitionerRole.code",
        "path" : "PractitionerRole.code",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "value",
              "path" : "coding.system"
            }
          ],
          "rules" : "open"
        },
        "definition" : "Roles which this practitioner is authorized to perform for the organization.\r\n\r\nFor compatibility reasons, CD-HCPARTY is described here to express the role of the practitioner. Other coding systems remain allowed.\r\nTowards the future, the use of SNOMED-CT codes is also RECOMMENDED here. In the future, other ways to codfy might however be also proposed.\r\n\r\nWhen available, a provider SHOULD include it. When given, a consumer SHALL record this in its consuming system."
      },
      {
        "id" : "PractitionerRole.code:NRZP_POVOLANI",
        "path" : "PractitionerRole.code",
        "sliceName" : "NRZP_POVOLANI",
        "definition" : "Roles which this practitioner is authorized to perform for the organization according to the National registry of healthcare practitioners.",
        "min" : 0,
        "max" : "*",
        "binding" : {
          "strength" : "required",
          "valueSet" : "https://ncez.mzcr.cz/terminology/ValueSet/nrzp-povolani-vs"
        }
      },
      {
        "id" : "PractitionerRole.code:NRZP_POVOLANI.coding.system",
        "path" : "PractitionerRole.code.coding.system",
        "min" : 1,
        "fixedUri" : "https://ncez.mzcr.cz/terminology/CodeSystem/nrzp-povolani"
      },
      {
        "id" : "PractitionerRole.code:NRZP_POVOLANI.coding.code",
        "path" : "PractitionerRole.code.coding.code",
        "min" : 1
      },
      {
        "id" : "PractitionerRole.location",
        "path" : "PractitionerRole.location",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "https://hl7.cz/fhir/core/StructureDefinition/cz-location-base"
            ]
          }
        ]
      }
    ]
  }
}

```
