# Practitioner (CZ core) - HL7 Czech Base and Core Implementation Guide v0.3.0-ballot

* [**Table of Contents**](toc.md)
* [**Summary artifacts**](artifacts.md)
* **Practitioner (CZ core)**

## Resource Profile: Practitioner (CZ core) 

| | | |
| :--- | :--- | :--- |
| *Official URL*:https://hl7.cz/fhir/core/StructureDefinition/cz-practitioner-core | *Version*:0.3.0-ballot | |
| *Standards status:*[Draft](http://hl7.org/fhir/R4/versions.html#std-process) | [Maturity Level](http://hl7.org/fhir/versions.html#maturity): 1 | *Computable Name*:CZ_PractitionerCore |

 
Czech national profile for practitioner. Contains information about a person who provides healthcare or is a participant in the creation of a medical document. 

**Usages:**

* Refer to this Profile: [Medication Statement (CZ)](StructureDefinition-cz-MedicationStatement.md), [Allergy Intolerance (CZ)](StructureDefinition-cz-allergyIntolerance.md), [Patient: Animal (CZ)](StructureDefinition-cz-patient-animal.md), [Patient (CZ core)](StructureDefinition-cz-patient-core.md)...Show 4 more,[Practitioner Role (CZ core)](StructureDefinition-cz-practitionerrole-core.md),[Provenance (CZ)](StructureDefinition-cz-provenance.md),[Signature (CZ)](StructureDefinition-cz-signature.md)and[Specimen (CZ)](StructureDefinition-cz-specimen.md)
* Examples for this Profile: [Practitioner/Practitioner-123456789](Practitioner-Practitioner-123456789.md) and [Practitioner/Practitioner-2](Practitioner-Practitioner-2.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.fhir.cz.core|current/StructureDefinition/cz-practitioner-core)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-cz-practitioner-core.csv), [Excel](StructureDefinition-cz-practitioner-core.xlsx), [Schematron](StructureDefinition-cz-practitioner-core.sch) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "cz-practitioner-core",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-fmm",
      "valueInteger" : 1
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
      "valueCode" : "draft"
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-imposeProfile",
      "valueCanonical" : "http://hl7.eu/fhir/base/StructureDefinition/practitioner-eu-core"
    }
  ],
  "url" : "https://hl7.cz/fhir/core/StructureDefinition/cz-practitioner-core",
  "version" : "0.3.0-ballot",
  "name" : "CZ_PractitionerCore",
  "title" : "Practitioner (CZ core)",
  "status" : "draft",
  "experimental" : false,
  "date" : "2025-12-19T09:24:48+00:00",
  "publisher" : "HL7 Czech Republic",
  "contact" : [
    {
      "name" : "HL7 Czech Republic",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.hl7.cz/"
        }
      ]
    }
  ],
  "description" : "Czech national profile for practitioner. Contains information about a person who provides healthcare or is a participant in the creation of a medical document.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "CZ",
          "display" : "Czechia"
        }
      ]
    }
  ],
  "fhirVersion" : "4.0.1",
  "mapping" : [
    {
      "identity" : "v2",
      "uri" : "http://hl7.org/v2",
      "name" : "HL7 v2 Mapping"
    },
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    },
    {
      "identity" : "servd",
      "uri" : "http://www.omg.org/spec/ServD/1.0/",
      "name" : "ServD"
    },
    {
      "identity" : "w5",
      "uri" : "http://hl7.org/fhir/fivews",
      "name" : "FiveWs Pattern Mapping"
    }
  ],
  "kind" : "resource",
  "abstract" : false,
  "type" : "Practitioner",
  "baseDefinition" : "https://hl7.cz/fhir/core/StructureDefinition/cz-practitioner-base",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "Practitioner",
        "path" : "Practitioner",
        "short" : "Czech Practitioner (core)",
        "definition" : "Czech national profile sets minimum expectations for represention of practitioner in HL7 FHIR."
      },
      {
        "id" : "Practitioner.name",
        "path" : "Practitioner.name",
        "definition" : "The name(s) associated with the practitioner.\r\n\r\nTypically RECOMMENDED to include one familyname and at least one given name and to define this use as ‘official’.",
        "min" : 1
      },
      {
        "id" : "Practitioner.telecom",
        "path" : "Practitioner.telecom",
        "definition" : "A contact detail for the practitioner, e.g. a telephone number or an email address.\r\n\r\nIt is RECOMMENDED to at least add one phone or email address."
      },
      {
        "id" : "Practitioner.qualification.issuer",
        "path" : "Practitioner.qualification.issuer",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "https://hl7.cz/fhir/core/StructureDefinition/cz-organization-core"
            ]
          }
        ]
      }
    ]
  }
}

```
