# Practitioner (CZ base) - HL7 Czech Base and Core Implementation Guide v0.3.0-ballot

* [**Table of Contents**](toc.md)
* [**Summary artifacts**](artifacts.md)
* **Practitioner (CZ base)**

## Resource Profile: Practitioner (CZ base) 

| | | |
| :--- | :--- | :--- |
| *Official URL*:https://hl7.cz/fhir/core/StructureDefinition/cz-practitioner-base | *Version*:0.3.0-ballot | |
| *Standards status:*[Draft](http://hl7.org/fhir/R4/versions.html#std-process) | [Maturity Level](http://hl7.org/fhir/versions.html#maturity): 1 | *Computable Name*:CZ_PractitionerBase |

 
Czech national profile for practitioner.Contains information about a person who provides healthcare or is a participant in the creation of a medical document. 

**Usages:**

* Derived from this Profile: [Practitioner (CZ core)](StructureDefinition-cz-practitioner-core.md)
* Refer to this Profile: [Patient (CZ base)](StructureDefinition-cz-patient-base.md) and [Practitioner Role (CZ base)](StructureDefinition-cz-practitionerrole-base.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.fhir.cz.core|current/StructureDefinition/cz-practitioner-base)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-cz-practitioner-base.csv), [Excel](StructureDefinition-cz-practitioner-base.xlsx), [Schematron](StructureDefinition-cz-practitioner-base.sch) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "cz-practitioner-base",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-fmm",
      "valueInteger" : 1
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
      "valueCode" : "draft"
    }
  ],
  "url" : "https://hl7.cz/fhir/core/StructureDefinition/cz-practitioner-base",
  "version" : "0.3.0-ballot",
  "name" : "CZ_PractitionerBase",
  "title" : "Practitioner (CZ base)",
  "status" : "draft",
  "experimental" : false,
  "date" : "2025-12-19T09:24:48+00:00",
  "publisher" : "HL7 Czech Republic",
  "contact" : [
    {
      "name" : "HL7 Czech Republic",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.hl7.cz/"
        }
      ]
    }
  ],
  "description" : "Czech national profile for practitioner.Contains information about a person who provides healthcare or is a participant in the creation of a medical document.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "CZ",
          "display" : "Czechia"
        }
      ]
    }
  ],
  "fhirVersion" : "4.0.1",
  "mapping" : [
    {
      "identity" : "v2",
      "uri" : "http://hl7.org/v2",
      "name" : "HL7 v2 Mapping"
    },
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    },
    {
      "identity" : "servd",
      "uri" : "http://www.omg.org/spec/ServD/1.0/",
      "name" : "ServD"
    },
    {
      "identity" : "w5",
      "uri" : "http://hl7.org/fhir/fivews",
      "name" : "FiveWs Pattern Mapping"
    }
  ],
  "kind" : "resource",
  "abstract" : false,
  "type" : "Practitioner",
  "baseDefinition" : "http://hl7.eu/fhir/base/StructureDefinition/practitioner-eu",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "Practitioner",
        "path" : "Practitioner",
        "short" : "Czech Practitioner (base)",
        "definition" : "Czech national profile defines how to represent a practitioner in HL7 FHIR."
      },
      {
        "id" : "Practitioner.identifier",
        "path" : "Practitioner.identifier",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "value",
              "path" : "system"
            }
          ],
          "rules" : "open"
        },
        "definition" : "An identifier that applies to this person in this role.\r\nTypically, a KRZP value is given and/or CLK identifier provided by the Czech Medical Chamber or identifier of Pharmacist (PharmID) provided by the Czech Chamber of Pharmacists, however use of KRZP Id is preferred. Other systems remain allowed. Flows in organizations will most likely want to also include a local identifier, using its own system. A type can be added if needed. When it is given, a consumer SHALL NOT ignore it."
      },
      {
        "id" : "Practitioner.identifier:KRZP",
        "path" : "Practitioner.identifier",
        "sliceName" : "KRZP",
        "min" : 0,
        "max" : "*"
      },
      {
        "id" : "Practitioner.identifier:KRZP.system",
        "path" : "Practitioner.identifier.system",
        "min" : 1,
        "fixedUri" : "https://ncez.mzcr.cz/fhir/sid/krzp"
      },
      {
        "id" : "Practitioner.identifier:KRZP.value",
        "path" : "Practitioner.identifier.value",
        "min" : 1
      },
      {
        "id" : "Practitioner.identifier:KRZP.assigner",
        "path" : "Practitioner.identifier.assigner",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "https://hl7.cz/fhir/core/StructureDefinition/cz-organization-core"
            ]
          }
        ]
      },
      {
        "id" : "Practitioner.identifier:CLK",
        "path" : "Practitioner.identifier",
        "sliceName" : "CLK",
        "min" : 0,
        "max" : "*"
      },
      {
        "id" : "Practitioner.identifier:CLK.system",
        "path" : "Practitioner.identifier.system",
        "min" : 1,
        "fixedUri" : "https://ncez.mzcr.cz/fhir/sid/clk"
      },
      {
        "id" : "Practitioner.identifier:CLK.value",
        "path" : "Practitioner.identifier.value",
        "min" : 1
      },
      {
        "id" : "Practitioner.identifier:CLK.assigner",
        "path" : "Practitioner.identifier.assigner",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "https://hl7.cz/fhir/core/StructureDefinition/cz-organization-core"
            ]
          }
        ]
      },
      {
        "id" : "Practitioner.identifier:CLeK",
        "path" : "Practitioner.identifier",
        "sliceName" : "CLeK",
        "min" : 0,
        "max" : "*"
      },
      {
        "id" : "Practitioner.identifier:CLeK.system",
        "path" : "Practitioner.identifier.system",
        "min" : 1,
        "fixedUri" : "https://ncez.mzcr.cz/fhir/sid/clek"
      },
      {
        "id" : "Practitioner.identifier:CLeK.value",
        "path" : "Practitioner.identifier.value",
        "min" : 1
      },
      {
        "id" : "Practitioner.identifier:CLeK.assigner",
        "path" : "Practitioner.identifier.assigner",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "https://hl7.cz/fhir/core/StructureDefinition/cz-organization-core"
            ]
          }
        ]
      },
      {
        "id" : "Practitioner.active",
        "path" : "Practitioner.active",
        "definition" : "Whether this practitioner's record is in active use. \r\n\r\nIt is RECOMMENDED to keep the value ‘true’ as long as the practitioner is still being treated by the provider of the data."
      },
      {
        "id" : "Practitioner.address",
        "path" : "Practitioner.address",
        "type" : [
          {
            "code" : "Address",
            "profile" : ["https://hl7.cz/fhir/core/StructureDefinition/cz-address"]
          }
        ]
      },
      {
        "id" : "Practitioner.qualification.issuer",
        "path" : "Practitioner.qualification.issuer",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "https://hl7.cz/fhir/core/StructureDefinition/cz-organization-base"
            ]
          }
        ]
      }
    ]
  }
}

```
