# Organization Logo - HL7 Czech Base and Core Implementation Guide v0.3.0-ballot

* [**Table of Contents**](toc.md)
* [**Summary artifacts**](artifacts.md)
* **Organization Logo**

## Extension: Organization Logo 

| | |
| :--- | :--- |
| *Official URL*:https://hl7.cz/fhir/core/StructureDefinition/cz-organization-logo | *Version*:0.3.0-ballot |
| Active as of 2025-12-19 | *Computable Name*:CZ_OrganizationLogo |

An extension to associate a logo (e.g., image or icon) with an Organization, using a reference to a profile Attachment resource.

**Context of Use**

**Usage info**

**Usages:**

* Use this Extension: [Organization (CZ core)](StructureDefinition-cz-organization-core.md)
* Examples for this Extension: [MUDr. Hana Doktorová](Organization-Organization-2.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.fhir.cz.core|current/StructureDefinition/cz-organization-logo)

### Formal Views of Extension Content

 [Description of Profiles, Differentials, Snapshots, and how the XML and JSON presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-cz-organization-logo.csv), [Excel](StructureDefinition-cz-organization-logo.xlsx), [Schematron](StructureDefinition-cz-organization-logo.sch) 

#### Constraints



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "cz-organization-logo",
  "url" : "https://hl7.cz/fhir/core/StructureDefinition/cz-organization-logo",
  "version" : "0.3.0-ballot",
  "name" : "CZ_OrganizationLogo",
  "title" : "Organization Logo",
  "status" : "active",
  "date" : "2025-12-19T09:24:48+00:00",
  "publisher" : "HL7 Czech Republic",
  "contact" : [
    {
      "name" : "HL7 Czech Republic",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.hl7.cz/"
        }
      ]
    }
  ],
  "description" : "An extension to associate a logo (e.g., image or icon) with an Organization, using a reference to a profile Attachment resource.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "CZ",
          "display" : "Czechia"
        }
      ]
    }
  ],
  "fhirVersion" : "4.0.1",
  "mapping" : [
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    }
  ],
  "kind" : "complex-type",
  "abstract" : false,
  "context" : [
    {
      "type" : "element",
      "expression" : "Organization"
    }
  ],
  "type" : "Extension",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/Extension",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "Extension",
        "path" : "Extension",
        "short" : "Organization Logo",
        "definition" : "An extension to associate a logo (e.g., image or icon) with an Organization, using a reference to a profile Attachment resource."
      },
      {
        "id" : "Extension.extension",
        "path" : "Extension.extension",
        "max" : "0"
      },
      {
        "id" : "Extension.url",
        "path" : "Extension.url",
        "fixedUri" : "https://hl7.cz/fhir/core/StructureDefinition/cz-organization-logo"
      },
      {
        "id" : "Extension.value[x]",
        "path" : "Extension.value[x]",
        "short" : "Reference to a Document reference containing the logo image",
        "min" : 1,
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : ["https://hl7.cz/fhir/core/StructureDefinition/cz-logo"]
          }
        ]
      }
    ]
  }
}

```
