# Coverage (CZ) - HL7 Czech Base and Core Implementation Guide v0.3.0-ballot

* [**Table of Contents**](toc.md)
* [**Summary artifacts**](artifacts.md)
* **Coverage (CZ)**

## Resource Profile: Coverage (CZ) 

| | | |
| :--- | :--- | :--- |
| *Official URL*:https://hl7.cz/fhir/core/StructureDefinition/cz-coverage | *Version*:0.3.0-ballot | |
| *Standards status:*[Draft](http://hl7.org/fhir/R4/versions.html#std-process) | [Maturity Level](http://hl7.org/fhir/versions.html#maturity): 0 | *Computable Name*:CZ_Coverage |

 
Czech national profile for a coverage. 

### Definice profilu

Tento profil specifikuje zdroj Coverage (dále Úhrada) v rámci českého národního projektu interoperability. Úhrada je určena k uložení informací souvisejících úhradou za poskytování produktů a služeb zdravotní péče. Zdroj lze použít, kromě záznamu informací o zdravotním pojitění také v případě samoplátců, tedy v případech kdy jednotlivec nebo organizace jsou jiní než pojistitel a přebírají odpovědnost za platbu části či celých nákladů na zdravotní péči.

### Důležité atributy

Následuje popis důležitých prvků profilu a jejich použití.

**Identifier (Identifikátor platby)**

Bussiness identifikátor v rámci pojistného krytí, v případě platby pojišťovnou vyplňte číslo pojistné smlouvy.

**Payor (Plátce)**

Informace o plátci léčby. Může se jednat o pojišťovnu, pacienta, osobu blízkou pacientovi nebo jinou organizaci.

**SubscriberID (Identifikátor předplatitele/pojištěnce)**

Identifikátor předplatitele (pacienta nebo příbuzné osoby), v případě platby pojišťovnou vyplňte číslo pojištěnce.

**CostToBeneficiary (Náklady plátce)**

Informace o krytí dodatečných nákladů plátcem (tzv. Samoplátce).

### Definition of profile

This profile presents the requirements for the Coverage resource within the Czech national interoperability project. Coverage is intended to provide identifiers for information that would appear on an insured person's card, which can be used for partial or full reimbursement for the provision of healthcare products and services. At the same time, this resource can also be used to register "self-payers," where the individual or organization are different from the insurer and assumes responsibility for paying some or all of the health care costs.

### Important elements

The following is a description of the most important profile elements and how they are used.

**Identifier**

Business identifier of the coverage. In the event of payment by an insurance company, enter the insurance assignment number (also known as Číslo pojistné smlouvy).

**Payor**

Information about the payor of the treatment. This could be an insurance company, a patient, a related person of patient or an another organisation.

**SubscriberID**

Identifier of the subscriber (patient or related person). In the event of payment by an insurance company, enter the insured person's number (also known as Číslo pojištěnce).

**CostToBeneficiary**

Information about the extra costs that are paid for by the payor (also known as Samoplátce).

**Usages:**

* Examples for this Profile: [Coverage/Coverage01](Coverage-Coverage01.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.fhir.cz.core|current/StructureDefinition/cz-coverage)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-cz-coverage.csv), [Excel](StructureDefinition-cz-coverage.xlsx), [Schematron](StructureDefinition-cz-coverage.sch) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "cz-coverage",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-fmm",
      "valueInteger" : 0
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
      "valueCode" : "draft"
    }
  ],
  "url" : "https://hl7.cz/fhir/core/StructureDefinition/cz-coverage",
  "version" : "0.3.0-ballot",
  "name" : "CZ_Coverage",
  "title" : "Coverage (CZ)",
  "status" : "draft",
  "experimental" : false,
  "date" : "2025-12-19T09:24:48+00:00",
  "publisher" : "HL7 Czech Republic",
  "contact" : [
    {
      "name" : "HL7 Czech Republic",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.hl7.cz/"
        }
      ]
    }
  ],
  "description" : "Czech national profile for a coverage.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "CZ",
          "display" : "Czechia"
        }
      ]
    }
  ],
  "fhirVersion" : "4.0.1",
  "mapping" : [
    {
      "identity" : "workflow",
      "uri" : "http://hl7.org/fhir/workflow",
      "name" : "Workflow Pattern"
    },
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    },
    {
      "identity" : "w5",
      "uri" : "http://hl7.org/fhir/fivews",
      "name" : "FiveWs Pattern Mapping"
    },
    {
      "identity" : "cdanetv4",
      "uri" : "http://www.cda-adc.ca/en/services/cdanet/",
      "name" : "Canadian Dental Association eclaims standard"
    },
    {
      "identity" : "v2",
      "uri" : "http://hl7.org/v2",
      "name" : "HL7 v2 Mapping"
    },
    {
      "identity" : "cpha3pharm",
      "uri" : "http://www.pharmacists.ca/",
      "name" : "Canadian Pharmacy Associaiton eclaims standard"
    }
  ],
  "kind" : "resource",
  "abstract" : false,
  "type" : "Coverage",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/Coverage",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "Coverage",
        "path" : "Coverage",
        "short" : "Czech coverage",
        "definition" : "This profile presents the requirements for the Coverage resource within the Czech national interoperability project. Coverage is intended to provide identifiers for information that would appear on an insured person's card, which can be used for partial or full reimbursement for the provision of healthcare products and services. At the same time, this resource can also be used to register \"self-payers,\" where the individual or organization are different from the insurer and assumes responsibility for paying some or all of the health care costs."
      },
      {
        "id" : "Coverage.extension",
        "path" : "Coverage.extension",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "value",
              "path" : "url"
            }
          ],
          "ordered" : false,
          "rules" : "open"
        }
      },
      {
        "id" : "Coverage.extension:kodNahrady",
        "path" : "Coverage.extension",
        "sliceName" : "kodNahrady",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Extension",
            "profile" : [
              "https://hl7.cz/fhir/core/StructureDefinition/cz-refund-indicator-code"
            ]
          }
        ]
      },
      {
        "id" : "Coverage.extension:kodNahrady.value[x]",
        "path" : "Coverage.extension.value[x]",
        "short" : "Allowance code (VZP – Náhrada za zdravotní péči)",
        "binding" : {
          "strength" : "required",
          "valueSet" : "https://uzis.cz/terminology/ValueSet/nzis-nahradyzazdravotnipeci"
        }
      },
      {
        "id" : "Coverage.identifier",
        "path" : "Coverage.identifier",
        "short" : "Business identifier of the coverage. In the event of payment by an insurance company, enter the insurance assignment number (also known as Číslo pojistné smlouvy)."
      },
      {
        "id" : "Coverage.type.coding",
        "path" : "Coverage.type.coding",
        "binding" : {
          "strength" : "required",
          "valueSet" : "https://ncez.mzcr.cz/terminology/ValueSet/cz-coverage-type"
        }
      },
      {
        "id" : "Coverage.policyHolder",
        "path" : "Coverage.policyHolder",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "https://hl7.cz/fhir/core/StructureDefinition/cz-patient-core",
              "https://hl7.cz/fhir/core/StructureDefinition/cz-relatedPerson-core",
              "https://hl7.cz/fhir/core/StructureDefinition/cz-organization-core"
            ]
          }
        ]
      },
      {
        "id" : "Coverage.subscriber",
        "path" : "Coverage.subscriber",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "https://hl7.cz/fhir/core/StructureDefinition/cz-patient-core",
              "https://hl7.cz/fhir/core/StructureDefinition/cz-relatedPerson-core"
            ]
          }
        ]
      },
      {
        "id" : "Coverage.subscriberId",
        "path" : "Coverage.subscriberId",
        "short" : "Identifier of the subscriber (patient or related person). In the event of payment by an insurance company, enter the insured person's number (also known as Číslo pojištěnce)."
      },
      {
        "id" : "Coverage.beneficiary",
        "path" : "Coverage.beneficiary",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "https://hl7.cz/fhir/core/StructureDefinition/cz-patient-core"
            ]
          }
        ]
      },
      {
        "id" : "Coverage.payor",
        "path" : "Coverage.payor",
        "short" : "Information about the payor of the treatment. This  could be an insurance company, a patient, a related person of patient or an another organisation.",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "https://hl7.cz/fhir/core/StructureDefinition/cz-patient-core",
              "https://hl7.cz/fhir/core/StructureDefinition/cz-organization-core",
              "https://hl7.cz/fhir/core/StructureDefinition/cz-relatedPerson-core"
            ]
          }
        ]
      },
      {
        "id" : "Coverage.costToBeneficiary",
        "path" : "Coverage.costToBeneficiary",
        "short" : "Information about the extra costs that are paid for by the payor (also known as Samoplátce)."
      }
    ]
  }
}

```
