# Substance: Specimen Additive Substance (CZ) - HL7 Czech Base and Core Implementation Guide v0.3.0-ballot

* [**Table of Contents**](toc.md)
* [**Summary artifacts**](artifacts.md)
* **Substance: Specimen Additive Substance (CZ)**

## Resource Profile: Substance: Specimen Additive Substance (CZ) 

| | |
| :--- | :--- |
| *Official URL*:https://hl7.cz/fhir/core/StructureDefinition/Substance-additive-cz | *Version*:0.3.0-ballot |
| Draft as of 2025-12-19 | *Computable Name*:CZ_SpecimenAdditiveSubstance |

 
This profile defines how to represent Specimen Additive Substances in HL7 FHIR for the purpose of this guide. 

**Usages:**

* Refer to this Profile: [Specimen (CZ)](StructureDefinition-cz-specimen.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.fhir.cz.core|current/StructureDefinition/Substance-additive-cz)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-Substance-additive-cz.csv), [Excel](StructureDefinition-Substance-additive-cz.xlsx), [Schematron](StructureDefinition-Substance-additive-cz.sch) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "Substance-additive-cz",
  "url" : "https://hl7.cz/fhir/core/StructureDefinition/Substance-additive-cz",
  "version" : "0.3.0-ballot",
  "name" : "CZ_SpecimenAdditiveSubstance",
  "title" : "Substance: Specimen Additive Substance (CZ)",
  "status" : "draft",
  "date" : "2025-12-19T09:24:48+00:00",
  "publisher" : "HL7 Czech Republic",
  "contact" : [
    {
      "name" : "HL7 Czech Republic",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.hl7.cz/"
        }
      ]
    }
  ],
  "description" : "This profile defines how to represent Specimen Additive Substances in HL7 FHIR for the purpose of this guide.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "CZ",
          "display" : "Czechia"
        }
      ]
    }
  ],
  "fhirVersion" : "4.0.1",
  "mapping" : [
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    },
    {
      "identity" : "orim",
      "uri" : "http://hl7.org/orim",
      "name" : "Ontological RIM Mapping"
    },
    {
      "identity" : "w5",
      "uri" : "http://hl7.org/fhir/fivews",
      "name" : "FiveWs Pattern Mapping"
    }
  ],
  "kind" : "resource",
  "abstract" : false,
  "type" : "Substance",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/Substance",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "Substance",
        "path" : "Substance"
      },
      {
        "id" : "Substance.code",
        "path" : "Substance.code",
        "binding" : {
          "strength" : "preferred",
          "valueSet" : "https://ncez.mzcr.cz/terminology/ValueSet/cz-specimenAdditive"
        }
      }
    ]
  }
}

```
