# Body Structure (CZ) - HL7 Czech Base and Core Implementation Guide v0.3.0-ballot

* [**Table of Contents**](toc.md)
* [**Summary artifacts**](artifacts.md)
* **Body Structure (CZ)**

## Resource Profile: Body Structure (CZ) 

| | |
| :--- | :--- |
| *Official URL*:https://hl7.cz/fhir/core/StructureDefinition/BodyStructure-cz | *Version*:0.3.0-ballot |
| Draft as of 2025-12-19 | *Computable Name*:BodyStructureCz |

 
This profile represents the Body Structure resource by the Czech national interoperability project. 

**Usages:**

* Refer to this Profile: [Specimen (CZ)](StructureDefinition-cz-specimen.md)
* Examples for this Profile: [BodyStructure/BodyStructure01](BodyStructure-BodyStructure01.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.fhir.cz.core|current/StructureDefinition/BodyStructure-cz)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-BodyStructure-cz.csv), [Excel](StructureDefinition-BodyStructure-cz.xlsx), [Schematron](StructureDefinition-BodyStructure-cz.sch) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "BodyStructure-cz",
  "url" : "https://hl7.cz/fhir/core/StructureDefinition/BodyStructure-cz",
  "version" : "0.3.0-ballot",
  "name" : "BodyStructureCz",
  "title" : "Body Structure (CZ)",
  "status" : "draft",
  "experimental" : false,
  "date" : "2025-12-19T09:24:48+00:00",
  "publisher" : "HL7 Czech Republic",
  "contact" : [
    {
      "name" : "HL7 Czech Republic",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.hl7.cz/"
        }
      ]
    }
  ],
  "description" : "This profile represents the Body Structure resource by the Czech national interoperability project.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "CZ",
          "display" : "Czechia"
        }
      ]
    }
  ],
  "fhirVersion" : "4.0.1",
  "mapping" : [
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    },
    {
      "identity" : "openehr",
      "uri" : "http://openehr.org",
      "name" : "Open EHR Archetype Mapping"
    },
    {
      "identity" : "w5",
      "uri" : "http://hl7.org/fhir/fivews",
      "name" : "FiveWs Pattern Mapping"
    },
    {
      "identity" : "v2",
      "uri" : "http://hl7.org/v2",
      "name" : "HL7 v2 Mapping"
    }
  ],
  "kind" : "resource",
  "abstract" : false,
  "type" : "BodyStructure",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/BodyStructure",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "BodyStructure",
        "path" : "BodyStructure",
        "short" : "Czech Body Structure",
        "definition" : "This profile represents the Body Structure resource by the Czech national interoperability project.The BodyStructure resource contains details about the anatomical location of a specimen or body part, including patient information, identifiers, as well as text descriptions and images. It provides for the addition of qualifiers such as laterality and directionality to the anatomic location for those use cases where precoordination of codes is not possible."
      },
      {
        "id" : "BodyStructure.extension",
        "path" : "BodyStructure.extension",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "value",
              "path" : "url"
            }
          ],
          "ordered" : false,
          "rules" : "open"
        }
      },
      {
        "id" : "BodyStructure.extension:laterality",
        "path" : "BodyStructure.extension",
        "sliceName" : "laterality",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Extension",
            "profile" : [
              "http://hl7.org/fhir/5.0/StructureDefinition/extension-BodyStructure.includedStructure.laterality"
            ]
          }
        ]
      },
      {
        "id" : "BodyStructure.extension:laterality.value[x]",
        "path" : "BodyStructure.extension.value[x]",
        "binding" : {
          "strength" : "preferred",
          "valueSet" : "https://ncez.mzcr.cz/terminology/ValueSet/cz-specimen-laterality"
        }
      },
      {
        "id" : "BodyStructure.morphology",
        "path" : "BodyStructure.morphology",
        "binding" : {
          "strength" : "preferred",
          "valueSet" : "http://hl7.org/fhir/ValueSet/bodystructure-code"
        }
      },
      {
        "id" : "BodyStructure.location",
        "path" : "BodyStructure.location",
        "binding" : {
          "strength" : "preferred",
          "valueSet" : "http://hl7.org/fhir/ValueSet/body-site"
        }
      },
      {
        "id" : "BodyStructure.locationQualifier",
        "path" : "BodyStructure.locationQualifier",
        "binding" : {
          "strength" : "preferred",
          "valueSet" : "https://ncez.mzcr.cz/terminology/ValueSet/cz-sitequalifier"
        }
      },
      {
        "id" : "BodyStructure.image",
        "path" : "BodyStructure.image",
        "max" : "0"
      },
      {
        "id" : "BodyStructure.patient",
        "path" : "BodyStructure.patient",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "https://hl7.cz/fhir/core/StructureDefinition/cz-patient-core"
            ]
          }
        ]
      }
    ]
  }
}

```
