# Related person Example - HL7 Czech Base and Core Implementation Guide v0.3.0-ballot

* [**Table of Contents**](toc.md)
* [**Summary artifacts**](artifacts.md)
* **Related person Example**

## Example RelatedPerson: Related person Example

Profile: [Related Person (CZ core)](StructureDefinition-cz-relatedPerson-core.md)

**identifier**: `https://ncez.mzcr.cz/fhir/sid/rcis`/5151264525, `https://ncez.mzcr.cz/fhir/sid/cpoj`/5151264525, Passport number/23476525 (use: official, ), Passport number/88476522 (use: official, )

**patient**: [Mračena Mrakomorová Female, DoB: 1971-11-26 ( Passport number (use: official, ))](Patient-Mracena.md)

**relationship**: matka

**name**: PraMračena Mrakomorová 

**telecom**: [+420 603 853 226](tel:+420603853226)

**gender**: Female

**birthDate**: 1951-01-26



## Resource Content

```json
{
  "resourceType" : "RelatedPerson",
  "id" : "RelatedPerson01",
  "meta" : {
    "profile" : [
      "https://hl7.cz/fhir/core/StructureDefinition/cz-relatedPerson-core"
    ]
  },
  "identifier" : [
    {
      "system" : "https://ncez.mzcr.cz/fhir/sid/rcis",
      "value" : "5151264525"
    },
    {
      "system" : "https://ncez.mzcr.cz/fhir/sid/cpoj",
      "value" : "5151264525"
    },
    {
      "use" : "official",
      "type" : {
        "coding" : [
          {
            "system" : "http://terminology.hl7.org/CodeSystem/v2-0203",
            "code" : "PPN"
          }
        ]
      },
      "system" : "http://hl7.org/fhir/sid/passport-CZE",
      "value" : "23476525"
    },
    {
      "use" : "official",
      "type" : {
        "coding" : [
          {
            "system" : "http://terminology.hl7.org/CodeSystem/v2-0203",
            "code" : "PPN"
          }
        ]
      },
      "system" : "http://hl7.org/fhir/sid/passport-SVK",
      "value" : "88476522"
    }
  ],
  "patient" : {
    "reference" : "Patient/Mracena"
  },
  "relationship" : [
    {
      "coding" : [
        {
          "system" : "http://terminology.hl7.org/CodeSystem/v3-RoleCode",
          "code" : "MTH",
          "display" : "matka"
        },
        {
          "system" : "http://terminology.hl7.org/CodeSystem/v2-0131",
          "code" : "N",
          "display" : "Příbuzný"
        }
      ]
    }
  ],
  "name" : [
    {
      "use" : "usual",
      "family" : "Mrakomorová",
      "given" : ["PraMračena"]
    }
  ],
  "telecom" : [
    {
      "system" : "phone",
      "value" : "+420 603 853 226",
      "use" : "home"
    }
  ],
  "gender" : "female",
  "birthDate" : "1951-01-26"
}

```
